/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedLong;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.BinaryCodecObjectMapperFactory;
import org.xrpl.xrpl4j.codec.binary.definitions.DefinitionsService;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInstance;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.types.AccountIdType;
import org.xrpl.xrpl4j.codec.binary.types.STObjectType;
import org.xrpl.xrpl4j.codec.binary.types.UInt64Type;

public class XrplBinaryCodec {
    public static final String TRX_SIGNATURE_PREFIX = "53545800";
    public static final String TRX_MULTI_SIGNATURE_PREFIX = "534D5400";
    public static final String PAYMENT_CHANNEL_CLAIM_SIGNATURE_PREFIX = "434C4D00";
    public static final String CHANNEL_FIELD_NAME = "Channel";
    public static final String AMOUNT_FIELD_NAME = "Amount";
    private static final DefinitionsService definitionsService = DefinitionsService.getInstance();
    private static final ObjectMapper objectMapper = BinaryCodecObjectMapperFactory.getObjectMapper();

    public String encode(String json) throws JsonProcessingException {
        Objects.requireNonNull(json);
        JsonNode node = BinaryCodecObjectMapperFactory.getObjectMapper().readTree(json);
        return this.encode(node);
    }

    private String encode(JsonNode jsonNode) {
        Objects.requireNonNull(jsonNode);
        UnsignedByteArray byteList = UnsignedByteArray.empty();
        new STObjectType().fromJson(jsonNode).toBytesSink(byteList);
        return byteList.hexValue();
    }

    public String encodeForSigning(String json) throws JsonProcessingException {
        JsonNode node = BinaryCodecObjectMapperFactory.getObjectMapper().readTree(json);
        return TRX_SIGNATURE_PREFIX + this.encode(this.removeNonSigningFields(node));
    }

    public String encodeForMultiSigning(String json, String xrpAccountId) throws JsonProcessingException {
        JsonNode node = BinaryCodecObjectMapperFactory.getObjectMapper().readTree(json);
        if (!node.isObject()) {
            throw new IllegalArgumentException("JSON object required for signing");
        }
        ((ObjectNode)node).set("SigningPubKey", (JsonNode)new TextNode(""));
        String suffix = new AccountIdType().fromJson((JsonNode)new TextNode(xrpAccountId)).toHex();
        return TRX_MULTI_SIGNATURE_PREFIX + this.encode(this.removeNonSigningFields(node)) + suffix;
    }

    public String encodeForSigningClaim(String json) throws JsonProcessingException {
        JsonNode node = BinaryCodecObjectMapperFactory.getObjectMapper().readTree(json);
        if (!node.isObject()) {
            throw new IllegalArgumentException("JSON object required for signing");
        }
        if (!node.has(CHANNEL_FIELD_NAME) || !node.has(AMOUNT_FIELD_NAME)) {
            throw new IllegalArgumentException("Unsigned claims must have Channel and Amount fields.");
        }
        UnsignedByteArray channel = UnsignedByteArray.fromHex((String)node.get(CHANNEL_FIELD_NAME).asText());
        UnsignedByteArray amount = UnsignedByteArray.of((byte[])new UInt64Type(UnsignedLong.valueOf((String)node.get(AMOUNT_FIELD_NAME).asText())).toBytes());
        UnsignedByteArray byteArray = UnsignedByteArray.empty();
        byteArray.append(channel);
        byteArray.append(amount);
        return PAYMENT_CHANNEL_CLAIM_SIGNATURE_PREFIX + byteArray.hexValue();
    }

    public String decode(String hex) {
        return new BinaryParser(hex).readType(STObjectType.class).toJson().toString();
    }

    private JsonNode removeNonSigningFields(JsonNode node) {
        if (!node.isObject()) {
            return node;
        }
        Map signingFields = Lists.newArrayList((Iterator)node.fieldNames()).stream().filter(this::isSigningField).collect(Collectors.toMap(Function.identity(), arg_0 -> ((JsonNode)node).get(arg_0)));
        return new ObjectNode(objectMapper.getNodeFactory(), signingFields);
    }

    private Boolean isSigningField(String fieldName) {
        return definitionsService.getFieldInstance(fieldName).map(FieldInstance::isSigningField).orElse(false);
    }
}

