/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.xrpl.xrpl4j.codec.addresses.ByteUtils;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.BinaryCodecObjectMapperFactory;
import org.xrpl.xrpl4j.codec.binary.math.MathUtils;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.types.AccountIdType;
import org.xrpl.xrpl4j.codec.binary.types.Amount;
import org.xrpl.xrpl4j.codec.binary.types.CurrencyType;
import org.xrpl.xrpl4j.codec.binary.types.ImmutableAmount;
import org.xrpl.xrpl4j.codec.binary.types.SerializedType;
import org.xrpl.xrpl4j.codec.binary.types.UInt64Type;

class AmountType
extends SerializedType<AmountType> {
    public static final BigDecimal MAX_DROPS = new BigDecimal("1e17");
    public static final BigDecimal MIN_XRP = new BigDecimal("1e-6");
    public static final String DEFAULT_AMOUNT_HEX = "4000000000000000";
    public static final String ZERO_CURRENCY_AMOUNT_HEX = "8000000000000000";
    public static final int NATIVE_AMOUNT_BYTE_LENGTH = 8;
    public static final int CURRENCY_AMOUNT_BYTE_LENGTH = 48;
    private static final int MAX_IOU_PRECISION = 16;
    private static final int MIN_IOU_EXPONENT = -96;
    private static final int MAX_IOU_EXPONENT = 80;
    private static final ObjectMapper objectMapper = BinaryCodecObjectMapperFactory.getObjectMapper();

    public AmountType() {
        this(UnsignedByteArray.fromHex((String)DEFAULT_AMOUNT_HEX));
    }

    public AmountType(UnsignedByteArray byteList) {
        super(byteList);
    }

    private static void assertXrpIsValid(String amount) {
        if (amount.contains(".")) {
            throw new IllegalArgumentException(amount + " is an illegal amount");
        }
        BigDecimal value = new BigDecimal(amount);
        if (!(value.equals(BigDecimal.ZERO) || value.compareTo(MIN_XRP) >= 0 && value.compareTo(MAX_DROPS) <= 0)) {
            throw new IllegalArgumentException(amount + " is an illegal amount");
        }
    }

    private static void assertIouIsValid(BigDecimal decimal) {
        if (!decimal.equals(BigDecimal.ZERO)) {
            int precision = decimal.precision();
            int exponent = MathUtils.getExponent(decimal);
            if (precision > 16 || exponent > 80 || exponent < -96) {
                throw new Error("Decimal precision out of range");
            }
            AmountType.verifyNoDecimal(decimal);
        }
    }

    private static void verifyNoDecimal(BigDecimal decimal) {
        BigDecimal exponent = new BigDecimal("1e" + -(MathUtils.getExponent(decimal) - 15));
        String integerNumberString = decimal.multiply(exponent).toPlainString();
        if (integerNumberString.indexOf(".") > 0) {
            throw new Error("Decimal place found in integerNumberString");
        }
    }

    @Override
    public AmountType fromParser(BinaryParser parser) {
        boolean isXrp = !parser.peek().isNthBitSet(1);
        int numBytes = isXrp ? 8 : 48;
        return new AmountType(parser.read(numBytes));
    }

    @Override
    public AmountType fromJson(JsonNode value) throws JsonProcessingException {
        if (value.isValueNode()) {
            AmountType.assertXrpIsValid(value.asText());
            UInt64Type number = (UInt64Type)new UInt64Type().fromJson(value.asText());
            byte[] rawBytes = number.toBytes();
            rawBytes[0] = (byte)(rawBytes[0] | 0x40);
            return new AmountType(UnsignedByteArray.of((byte[])rawBytes));
        }
        Amount amount = (Amount)objectMapper.treeToValue((TreeNode)value, Amount.class);
        BigDecimal number = new BigDecimal(amount.value());
        UnsignedByteArray result = number.unscaledValue().equals(BigInteger.ZERO) ? UnsignedByteArray.fromHex((String)ZERO_CURRENCY_AMOUNT_HEX) : this.getAmountBytes(number);
        UnsignedByteArray currency = new CurrencyType().fromJson(value.get("currency")).value();
        UnsignedByteArray issuer = new AccountIdType().fromJson(value.get("issuer")).value();
        result.append(currency);
        result.append(issuer);
        return new AmountType(result);
    }

    private UnsignedByteArray getAmountBytes(BigDecimal number) {
        int exponent;
        BigInteger paddedNumber = MathUtils.toPaddedBigInteger(number, 16);
        byte[] amountBytes = ByteUtils.toByteArray((BigInteger)paddedNumber, (int)8);
        amountBytes[0] = (byte)(amountBytes[0] | 0x80);
        if (number.compareTo(BigDecimal.ZERO) > 0) {
            amountBytes[0] = (byte)(amountBytes[0] | 0x40);
        }
        if ((exponent = MathUtils.getExponent(number)) > 80 || exponent < -96) {
            throw new IllegalArgumentException("exponent out of range");
        }
        UnsignedByte exponentByte = UnsignedByte.of((int)(97 + exponent - 15));
        amountBytes[0] = (byte)(amountBytes[0] | exponentByte.asInt() >>> 2);
        amountBytes[1] = (byte)(amountBytes[1] | (exponentByte.asInt() & 3) << 6);
        return UnsignedByteArray.of((byte[])amountBytes);
    }

    @Override
    public JsonNode toJson() {
        if (this.isNative()) {
            byte[] rawBytes = this.toBytes();
            rawBytes[0] = (byte)(rawBytes[0] & 0x3F);
            BigInteger value = new BigInteger(rawBytes);
            if (!this.isPositive()) {
                value = value.negate();
            }
            return new TextNode(value.toString());
        }
        BinaryParser parser = new BinaryParser(this.toHex());
        UnsignedByteArray mantissa = parser.read(8);
        CurrencyType currency = new CurrencyType().fromParser(parser);
        AccountIdType issuer = new AccountIdType().fromParser(parser);
        UnsignedByte b1 = mantissa.get(0);
        UnsignedByte b2 = mantissa.get(1);
        boolean isPositive = b1.isNthBitSet(2);
        String sign = isPositive ? "" : "-";
        int exponent = ((b1.asInt() & 0x3F) << 2) + ((b2.asInt() & 0xFF) >> 6) - 97;
        mantissa.set(0, UnsignedByte.of((int)0));
        mantissa.set(1, UnsignedByte.of((int)(b2.asInt() & 0x3F)));
        BigDecimal value = new BigDecimal(new BigInteger(sign + mantissa.hexValue(), 16)).multiply(new BigDecimal("1e" + exponent)).stripTrailingZeros();
        AmountType.assertIouIsValid(value);
        ImmutableAmount amount = Amount.builder().currency(((SerializedType)currency).toJson().asText()).issuer(((SerializedType)issuer).toJson().asText()).value(value.toPlainString()).build();
        return objectMapper.valueToTree((Object)amount);
    }

    private boolean isNative() {
        return (this.toBytes()[0] & 0x80) == 0;
    }

    private boolean isPositive() {
        return (this.toBytes()[0] & 0x40) > 0;
    }
}

