/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Optional;
import java.util.regex.Pattern;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.types.Hash160Type;

public class CurrencyType
extends Hash160Type {
    private static final Pattern ISO_REGEX = Pattern.compile("^[A-Z0-9]{3,4}$");
    private final Optional<String> iso;

    public CurrencyType() {
        this(UnsignedByteArray.ofSize((int)20), 4);
    }

    public CurrencyType(UnsignedByteArray list, int len) {
        super(list);
        boolean lossLessISO;
        if (len == 4 && list.get(15).asInt() == 0) {
            len = 3;
        }
        String rawISO = this.rawISO(list, len);
        boolean isNative = this.isNative(list);
        boolean bl = lossLessISO = this.onlyIso(list, len) && !rawISO.equals("KSW") && ISO_REGEX.matcher(rawISO).matches();
        this.iso = isNative ? Optional.of("KSW") : (lossLessISO ? Optional.of(rawISO) : Optional.empty());
    }

    @Override
    public CurrencyType fromParser(BinaryParser parser) {
        return new CurrencyType(parser.read(this.getWidth()), 4);
    }

    @Override
    public CurrencyType fromJson(JsonNode node) {
        String textValue = node.textValue();
        if (!this.isValidRepresentation(textValue)) {
            throw new IllegalArgumentException("Unsupported Currency representation: " + textValue);
        }
        UnsignedByteArray bytes = textValue.length() == 3 || textValue.length() == 4 ? this.isoToBytes(textValue) : UnsignedByteArray.fromHex((String)textValue);
        return new CurrencyType(bytes, textValue.length());
    }

    @Override
    public JsonNode toJson() {
        return (JsonNode)this.iso.map(TextNode::new).orElseGet(() -> new TextNode(this.toHex()));
    }

    private boolean isNative(UnsignedByteArray byteList) {
        String iso = byteList.slice(12, 15).hexValue();
        return this.onlyIso(byteList, 3) && iso.equals("000000");
    }

    private boolean onlyIso(UnsignedByteArray byteList, int len) {
        for (int i = byteList.length() - 1; i >= 0; --i) {
            if (byteList.get(i).asInt() == 0 || (len != 3 || i == 12 || i == 13 || i == 14) && (len != 4 || i == 12 || i == 13 || i == 14 || i == 15)) continue;
            return false;
        }
        return true;
    }

    private String rawISO(UnsignedByteArray list, int length) {
        return new String(list.slice(12, 12 + length).toByteArray());
    }

    boolean isValidRepresentation(String value) {
        return this.isStringRepresentation(value);
    }

    private boolean isIsoCode(String iso) {
        return ISO_REGEX.matcher(iso).matches();
    }

    private boolean isHex(String hex) {
        return HEX_REGEX.matcher(hex).matches();
    }

    boolean isStringRepresentation(String input) {
        return this.isIsoCode(input) || this.isHex(input);
    }

    private UnsignedByteArray isoToBytes(String iso) {
        UnsignedByteArray bytes = UnsignedByteArray.ofSize((int)20);
        if (!iso.equals("KSW")) {
            for (int i = 0; i < iso.length(); ++i) {
                bytes.set(12 + i, UnsignedByte.of((int)iso.charAt(i)));
            }
        }
        return bytes;
    }
}

