/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.BinaryCodecObjectMapperFactory;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.types.AccountIdType;
import org.xrpl.xrpl4j.codec.binary.types.CurrencyType;
import org.xrpl.xrpl4j.codec.binary.types.Hop;
import org.xrpl.xrpl4j.codec.binary.types.ImmutableHop;
import org.xrpl.xrpl4j.codec.binary.types.SerializedType;

public class HopType
extends SerializedType<HopType> {
    public static final byte TYPE_ACCOUNT = 1;
    public static final byte TYPE_CURRENCY = 16;
    public static final byte TYPE_ISSUER = 32;
    private static final ObjectMapper objectMapper = BinaryCodecObjectMapperFactory.getObjectMapper();

    public HopType() {
        this(UnsignedByteArray.empty());
    }

    public HopType(UnsignedByteArray list) {
        super(list);
    }

    @Override
    public HopType fromParser(BinaryParser parser) {
        int type = parser.readUInt8().intValue();
        UnsignedByteArray byteArray = UnsignedByteArray.of((UnsignedByte)UnsignedByte.of((int)type), (UnsignedByte[])new UnsignedByte[0]);
        if ((type & 1) > 0) {
            byteArray.append(parser.read(20));
        }
        if ((type & 0x10) > 0) {
            byteArray.append(parser.read(20));
        }
        if ((type & 0x20) > 0) {
            byteArray.append(parser.read(20));
        }
        return new HopType(byteArray);
    }

    @Override
    public HopType fromJson(JsonNode node) throws JsonProcessingException {
        if (!node.isObject()) {
            throw new IllegalArgumentException("node is not an object");
        }
        UnsignedByteArray byteArray = UnsignedByteArray.ofSize((int)1);
        Hop hop = (Hop)objectMapper.treeToValue((TreeNode)node, Hop.class);
        hop.account().ifPresent(account -> {
            byteArray.append(new AccountIdType().fromJson((JsonNode)account).value());
            byteArray.set(0, byteArray.get(0).or(UnsignedByte.of((byte)1)));
        });
        hop.currency().ifPresent(currency -> {
            byteArray.append(new CurrencyType().fromJson((JsonNode)currency).value());
            byteArray.set(0, byteArray.get(0).or(UnsignedByte.of((byte)16)));
        });
        hop.issuer().ifPresent(issuer -> {
            byteArray.append(new AccountIdType().fromJson((JsonNode)issuer).value());
            byteArray.set(0, byteArray.get(0).or(UnsignedByte.of((byte)32)));
        });
        return new HopType(byteArray);
    }

    @Override
    public JsonNode toJson() {
        BinaryParser parser = new BinaryParser(this.toHex());
        int type = parser.readUInt8().intValue();
        ImmutableHop.Builder builder = Hop.builder();
        if ((type & 1) > 0) {
            builder.account(new AccountIdType().fromParser(parser).toJson());
        }
        if ((type & 0x10) > 0) {
            builder.currency(new CurrencyType().fromParser(parser).toJson());
        }
        if ((type & 0x20) > 0) {
            builder.account(new AccountIdType().fromParser(parser).toJson());
        }
        return objectMapper.valueToTree((Object)builder.build());
    }
}

