/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.BinaryCodecObjectMapperFactory;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.types.AccountIdType;
import org.xrpl.xrpl4j.codec.binary.types.AmountType;
import org.xrpl.xrpl4j.codec.binary.types.BlobType;
import org.xrpl.xrpl4j.codec.binary.types.CurrencyType;
import org.xrpl.xrpl4j.codec.binary.types.Hash128Type;
import org.xrpl.xrpl4j.codec.binary.types.Hash160Type;
import org.xrpl.xrpl4j.codec.binary.types.Hash256Type;
import org.xrpl.xrpl4j.codec.binary.types.PathSetType;
import org.xrpl.xrpl4j.codec.binary.types.STArrayType;
import org.xrpl.xrpl4j.codec.binary.types.STObjectType;
import org.xrpl.xrpl4j.codec.binary.types.UInt16Type;
import org.xrpl.xrpl4j.codec.binary.types.UInt32Type;
import org.xrpl.xrpl4j.codec.binary.types.UInt8Type;
import org.xrpl.xrpl4j.codec.binary.types.Vector256Type;

public abstract class SerializedType<T extends SerializedType<T>> {
    private static final Map<String, Supplier<SerializedType<?>>> typeMap = new ImmutableMap.Builder().put((Object)"AccountID", () -> new AccountIdType()).put((Object)"Amount", () -> new AmountType()).put((Object)"Blob", () -> new BlobType()).put((Object)"Currency", () -> new CurrencyType()).put((Object)"Hash128", () -> new Hash128Type()).put((Object)"Hash160", () -> new Hash160Type()).put((Object)"Hash256", () -> new Hash256Type()).put((Object)"PathSet", () -> new PathSetType()).put((Object)"STArray", () -> new STArrayType()).put((Object)"STObject", () -> new STObjectType()).put((Object)"UInt8", () -> new UInt8Type()).put((Object)"UInt16", () -> new UInt16Type()).put((Object)"UInt32", () -> new UInt32Type()).put((Object)"Vector256", () -> new Vector256Type()).build();
    private final UnsignedByteArray bytes;

    public SerializedType(UnsignedByteArray bytes) {
        this.bytes = bytes;
    }

    public static SerializedType<?> getTypeByName(String name) {
        return typeMap.get(name).get();
    }

    public static String getNameByType(SerializedType<?> type) {
        return typeMap.entrySet().stream().filter(entry -> ((SerializedType)((Supplier)entry.getValue()).get()).getClass().equals(type.getClass())).map(Map.Entry::getKey).findAny().orElse(null);
    }

    public T fromParser(BinaryParser parser) {
        throw new UnsupportedOperationException("This operation is only supported by specific sub-classes.");
    }

    public T fromParser(BinaryParser parser, int lengthHint) {
        return this.fromParser(parser);
    }

    public abstract T fromJson(JsonNode var1) throws JsonProcessingException;

    public T fromJson(String json) {
        try {
            JsonNode node = BinaryCodecObjectMapperFactory.getObjectMapper().readTree(json);
            UnsignedByteArray byteList = UnsignedByteArray.empty();
            T newValue = this.fromJson(node);
            ((SerializedType)newValue).toBytesSink(byteList);
            return newValue;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public T fromHex(String hex) {
        return this.fromParser(new BinaryParser(hex));
    }

    public T fromHex(String hex, int lengthHint) {
        Objects.requireNonNull(hex);
        return this.fromParser(new BinaryParser(hex), lengthHint);
    }

    public void toBytesSink(UnsignedByteArray list) {
        Objects.requireNonNull(list);
        list.append(this.bytes);
    }

    public byte[] toBytes() {
        return this.bytes.toByteArray();
    }

    public JsonNode toJson() {
        return new TextNode(this.toHex());
    }

    public final String toHex() {
        return this.bytes.hexValue();
    }

    protected UnsignedByteArray value() {
        return this.bytes;
    }

    public String toString() {
        return this.toHex();
    }
}

