/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.keypairs;

import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.xrpl.xrpl4j.codec.addresses.AddressCodec;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.keypairs.KeyPairService;
import org.xrpl.xrpl4j.model.transactions.Address;

public abstract class AbstractKeyPairService
implements KeyPairService {
    protected Signer signer;
    protected AddressCodec addressCodec = AddressCodec.getInstance();

    @Override
    public String generateSeed() {
        return this.generateSeed(UnsignedByteArray.of((byte[])SecureRandom.getSeed(16)));
    }

    @Override
    public String sign(String message, String privateKey) {
        UnsignedByteArray messageBytes = UnsignedByteArray.fromHex((String)message);
        return this.sign(messageBytes, privateKey);
    }

    @Override
    public boolean verify(String message, String signature, String publicKey) {
        UnsignedByteArray messageBytes = UnsignedByteArray.fromHex((String)message);
        return this.verify(messageBytes, signature, publicKey);
    }

    @Override
    public Address deriveAddress(String publicKey) {
        UnsignedByteArray publicKeyBytes = UnsignedByteArray.of((byte[])BaseEncoding.base16().decode((CharSequence)publicKey));
        return this.deriveAddress(publicKeyBytes);
    }

    @Override
    public Address deriveAddress(UnsignedByteArray publicKey) {
        return this.addressCodec.encodeAccountId(this.computePublicKeyHash(publicKey));
    }

    private UnsignedByteArray computePublicKeyHash(UnsignedByteArray publicKey) {
        byte[] sha256 = Hashing.sha256().hashBytes(publicKey.toByteArray()).asBytes();
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(sha256, 0, sha256.length);
        byte[] ripemdSha256 = new byte[digest.getDigestSize()];
        digest.doFinal(ripemdSha256, 0);
        return UnsignedByteArray.of((byte[])ripemdSha256);
    }
}

