/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.wallet;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.wallet.SeedWalletGenerationResult;
import org.xrpl.xrpl4j.wallet.Wallet;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SeedWalletGenerationResult", generator="Immutables")
@Immutable
public final class ImmutableSeedWalletGenerationResult
implements SeedWalletGenerationResult {
    private final String seed;
    private final Wallet wallet;

    private ImmutableSeedWalletGenerationResult(String seed, Wallet wallet) {
        this.seed = seed;
        this.wallet = wallet;
    }

    @Override
    public String seed() {
        return this.seed;
    }

    @Override
    public Wallet wallet() {
        return this.wallet;
    }

    public final ImmutableSeedWalletGenerationResult withSeed(String value) {
        String newValue = Objects.requireNonNull(value, "seed");
        if (this.seed.equals(newValue)) {
            return this;
        }
        return new ImmutableSeedWalletGenerationResult(newValue, this.wallet);
    }

    public final ImmutableSeedWalletGenerationResult withWallet(Wallet value) {
        if (this.wallet == value) {
            return this;
        }
        Wallet newValue = Objects.requireNonNull(value, "wallet");
        return new ImmutableSeedWalletGenerationResult(this.seed, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSeedWalletGenerationResult && this.equalTo((ImmutableSeedWalletGenerationResult)another);
    }

    private boolean equalTo(ImmutableSeedWalletGenerationResult another) {
        return this.seed.equals(another.seed) && this.wallet.equals(another.wallet);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.seed.hashCode();
        h += (h << 5) + this.wallet.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SeedWalletGenerationResult").omitNullValues().add("seed", (Object)this.seed).add("wallet", (Object)this.wallet).toString();
    }

    public static ImmutableSeedWalletGenerationResult copyOf(SeedWalletGenerationResult instance) {
        if (instance instanceof ImmutableSeedWalletGenerationResult) {
            return (ImmutableSeedWalletGenerationResult)instance;
        }
        return ImmutableSeedWalletGenerationResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SeedWalletGenerationResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SEED = 1L;
        private static final long INIT_BIT_WALLET = 2L;
        private long initBits = 3L;
        @Nullable
        private String seed;
        @Nullable
        private Wallet wallet;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SeedWalletGenerationResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.seed(instance.seed());
            this.wallet(instance.wallet());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder seed(String seed) {
            this.seed = Objects.requireNonNull(seed, "seed");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wallet(Wallet wallet) {
            this.wallet = Objects.requireNonNull(wallet, "wallet");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSeedWalletGenerationResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSeedWalletGenerationResult(this.seed, this.wallet);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("seed");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("wallet");
            }
            return "Cannot build SeedWalletGenerationResult, some of required attributes are not set " + attributes;
        }
    }
}

