/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountInfoRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountInfoRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAccountInfoRequestParams
implements AccountInfoRequestParams {
    private final Address account;
    @Nullable
    private final Hash256 ledgerHash;
    private final LedgerIndex ledgerIndex;
    private final transient boolean strict;
    private final boolean queue;
    private final boolean signerLists;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAccountInfoRequestParams(Builder builder) {
        this.account = builder.account;
        this.ledgerHash = builder.ledgerHash;
        if (builder.ledgerIndex != null) {
            this.initShim.ledgerIndex(builder.ledgerIndex);
        }
        if (builder.queueIsSet()) {
            this.initShim.queue(builder.queue);
        }
        if (builder.signerListsIsSet()) {
            this.initShim.signerLists(builder.signerLists);
        }
        this.ledgerIndex = this.initShim.ledgerIndex();
        this.strict = this.initShim.strict();
        this.queue = this.initShim.queue();
        this.signerLists = this.initShim.signerLists();
        this.initShim = null;
    }

    private ImmutableAccountInfoRequestParams(Address account, @Nullable Hash256 ledgerHash, LedgerIndex ledgerIndex, boolean queue, boolean signerLists) {
        this.account = account;
        this.ledgerHash = ledgerHash;
        this.initShim.ledgerIndex(ledgerIndex);
        this.initShim.queue(queue);
        this.initShim.signerLists(signerLists);
        this.ledgerIndex = this.initShim.ledgerIndex();
        this.strict = this.initShim.strict();
        this.queue = this.initShim.queue();
        this.signerLists = this.initShim.signerLists();
        this.initShim = null;
    }

    private LedgerIndex ledgerIndexInitialize() {
        return AccountInfoRequestParams.super.ledgerIndex();
    }

    private boolean strictInitialize() {
        return AccountInfoRequestParams.super.strict();
    }

    private boolean queueInitialize() {
        return AccountInfoRequestParams.super.queue();
    }

    private boolean signerListsInitialize() {
        return AccountInfoRequestParams.super.signerLists();
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public LedgerIndex ledgerIndex() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerIndex() : this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="strict")
    public boolean strict() {
        InitShim shim = this.initShim;
        return shim != null ? shim.strict() : this.strict;
    }

    @Override
    @JsonProperty(value="queue")
    public boolean queue() {
        InitShim shim = this.initShim;
        return shim != null ? shim.queue() : this.queue;
    }

    @Override
    @JsonProperty(value="signer_lists")
    public boolean signerLists() {
        InitShim shim = this.initShim;
        return shim != null ? shim.signerLists() : this.signerLists;
    }

    public final ImmutableAccountInfoRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountInfoRequestParams(newValue, this.ledgerHash, this.ledgerIndex, this.queue, this.signerLists);
    }

    public final ImmutableAccountInfoRequestParams withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableAccountInfoRequestParams(this.account, newValue, this.ledgerIndex, this.queue, this.signerLists);
    }

    public final ImmutableAccountInfoRequestParams withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableAccountInfoRequestParams(this.account, value, this.ledgerIndex, this.queue, this.signerLists);
    }

    public final ImmutableAccountInfoRequestParams withLedgerIndex(LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        return new ImmutableAccountInfoRequestParams(this.account, this.ledgerHash, newValue, this.queue, this.signerLists);
    }

    public final ImmutableAccountInfoRequestParams withQueue(boolean value) {
        if (this.queue == value) {
            return this;
        }
        return new ImmutableAccountInfoRequestParams(this.account, this.ledgerHash, this.ledgerIndex, value, this.signerLists);
    }

    public final ImmutableAccountInfoRequestParams withSignerLists(boolean value) {
        if (this.signerLists == value) {
            return this;
        }
        return new ImmutableAccountInfoRequestParams(this.account, this.ledgerHash, this.ledgerIndex, this.queue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountInfoRequestParams && this.equalTo((ImmutableAccountInfoRequestParams)another);
    }

    private boolean equalTo(ImmutableAccountInfoRequestParams another) {
        return this.account.equals(another.account) && Objects.equals(this.ledgerHash, another.ledgerHash) && this.ledgerIndex.equals(another.ledgerIndex) && this.strict == another.strict && this.queue == another.queue && this.signerLists == another.signerLists;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + this.ledgerIndex.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.strict);
        h += (h << 5) + Booleans.hashCode((boolean)this.queue);
        h += (h << 5) + Booleans.hashCode((boolean)this.signerLists);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountInfoRequestParams").omitNullValues().add("account", (Object)this.account).add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).add("strict", this.strict).add("queue", this.queue).add("signerLists", this.signerLists).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountInfoRequestParams fromJson(Json json) {
        Builder builder = ImmutableAccountInfoRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.queueIsSet) {
            builder.queue(json.queue);
        }
        if (json.signerListsIsSet) {
            builder.signerLists(json.signerLists);
        }
        return builder.build();
    }

    public static ImmutableAccountInfoRequestParams copyOf(AccountInfoRequestParams instance) {
        if (instance instanceof ImmutableAccountInfoRequestParams) {
            return (ImmutableAccountInfoRequestParams)instance;
        }
        return ImmutableAccountInfoRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountInfoRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long OPT_BIT_QUEUE = 1L;
        private static final long OPT_BIT_SIGNER_LISTS = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private Address account;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        private boolean queue;
        private boolean signerLists;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountInfoRequestParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
            if (ledgerHashOptional.isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            this.ledgerIndex(instance.ledgerIndex());
            this.queue(instance.queue());
            this.signerLists(instance.signerLists());
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="queue")
        @CanIgnoreReturnValue
        public final Builder queue(boolean queue) {
            this.queue = queue;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="signer_lists")
        @CanIgnoreReturnValue
        public final Builder signerLists(boolean signerLists) {
            this.signerLists = signerLists;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableAccountInfoRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountInfoRequestParams(this);
        }

        private boolean queueIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean signerListsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build AccountInfoRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountInfoRequestParams", generator="Immutables")
    static final class Json
    implements AccountInfoRequestParams {
        @Nullable
        Address account;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        LedgerIndex ledgerIndex;
        boolean queue;
        boolean queueIsSet;
        boolean signerLists;
        boolean signerListsIsSet;

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="queue")
        public void setQueue(boolean queue) {
            this.queue = queue;
            this.queueIsSet = true;
        }

        @JsonProperty(value="signer_lists")
        public void setSignerLists(boolean signerLists) {
            this.signerLists = signerLists;
            this.signerListsIsSet = true;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean strict() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean queue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean signerLists() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AccountInfoRequestParams", generator="Immutables")
    private final class InitShim {
        private byte ledgerIndexBuildStage = 0;
        private LedgerIndex ledgerIndex;
        private byte strictBuildStage = 0;
        private boolean strict;
        private byte queueBuildStage = 0;
        private boolean queue;
        private byte signerListsBuildStage = 0;
        private boolean signerLists;

        private InitShim() {
        }

        LedgerIndex ledgerIndex() {
            if (this.ledgerIndexBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerIndexBuildStage == 0) {
                this.ledgerIndexBuildStage = (byte)-1;
                this.ledgerIndex = Objects.requireNonNull(ImmutableAccountInfoRequestParams.this.ledgerIndexInitialize(), "ledgerIndex");
                this.ledgerIndexBuildStage = 1;
            }
            return this.ledgerIndex;
        }

        void ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
            this.ledgerIndexBuildStage = 1;
        }

        boolean strict() {
            if (this.strictBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.strictBuildStage == 0) {
                this.strictBuildStage = (byte)-1;
                this.strict = ImmutableAccountInfoRequestParams.this.strictInitialize();
                this.strictBuildStage = 1;
            }
            return this.strict;
        }

        boolean queue() {
            if (this.queueBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.queueBuildStage == 0) {
                this.queueBuildStage = (byte)-1;
                this.queue = ImmutableAccountInfoRequestParams.this.queueInitialize();
                this.queueBuildStage = 1;
            }
            return this.queue;
        }

        void queue(boolean queue) {
            this.queue = queue;
            this.queueBuildStage = 1;
        }

        boolean signerLists() {
            if (this.signerListsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.signerListsBuildStage == 0) {
                this.signerListsBuildStage = (byte)-1;
                this.signerLists = ImmutableAccountInfoRequestParams.this.signerListsInitialize();
                this.signerListsBuildStage = 1;
            }
            return this.signerLists;
        }

        void signerLists(boolean signerLists) {
            this.signerLists = signerLists;
            this.signerListsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerIndexBuildStage == -1) {
                attributes.add("ledgerIndex");
            }
            if (this.strictBuildStage == -1) {
                attributes.add("strict");
            }
            if (this.queueBuildStage == -1) {
                attributes.add("queue");
            }
            if (this.signerListsBuildStage == -1) {
                attributes.add("signerLists");
            }
            return "Cannot build AccountInfoRequestParams, attribute initializers form cycle " + attributes;
        }
    }
}

