/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountLinesRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountLinesRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAccountLinesRequestParams
implements AccountLinesRequestParams {
    private final Address account;
    @Nullable
    private final Hash256 ledgerHash;
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final Address peer;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;

    private ImmutableAccountLinesRequestParams(Builder builder) {
        this.account = builder.account;
        this.ledgerHash = builder.ledgerHash;
        this.peer = builder.peer;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.ledgerIndex = builder.ledgerIndex != null ? builder.ledgerIndex : Objects.requireNonNull(AccountLinesRequestParams.super.ledgerIndex(), "ledgerIndex");
    }

    private ImmutableAccountLinesRequestParams(Address account, @Nullable Hash256 ledgerHash, LedgerIndex ledgerIndex, @Nullable Address peer, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.account = account;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.peer = peer;
        this.limit = limit;
        this.marker = marker;
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public LedgerIndex ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="peer")
    public Optional<Address> peer() {
        return Optional.ofNullable(this.peer);
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableAccountLinesRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountLinesRequestParams(newValue, this.ledgerHash, this.ledgerIndex, this.peer, this.limit, this.marker);
    }

    public final ImmutableAccountLinesRequestParams withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableAccountLinesRequestParams(this.account, newValue, this.ledgerIndex, this.peer, this.limit, this.marker);
    }

    public final ImmutableAccountLinesRequestParams withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableAccountLinesRequestParams(this.account, value, this.ledgerIndex, this.peer, this.limit, this.marker);
    }

    public final ImmutableAccountLinesRequestParams withLedgerIndex(LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        return new ImmutableAccountLinesRequestParams(this.account, this.ledgerHash, newValue, this.peer, this.limit, this.marker);
    }

    public final ImmutableAccountLinesRequestParams withPeer(Address value) {
        Address newValue = Objects.requireNonNull(value, "peer");
        if (this.peer == newValue) {
            return this;
        }
        return new ImmutableAccountLinesRequestParams(this.account, this.ledgerHash, this.ledgerIndex, newValue, this.limit, this.marker);
    }

    public final ImmutableAccountLinesRequestParams withPeer(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.peer == value) {
            return this;
        }
        return new ImmutableAccountLinesRequestParams(this.account, this.ledgerHash, this.ledgerIndex, value, this.limit, this.marker);
    }

    public final ImmutableAccountLinesRequestParams withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableAccountLinesRequestParams(this.account, this.ledgerHash, this.ledgerIndex, this.peer, newValue, this.marker);
    }

    public final ImmutableAccountLinesRequestParams withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableAccountLinesRequestParams(this.account, this.ledgerHash, this.ledgerIndex, this.peer, value, this.marker);
    }

    public final ImmutableAccountLinesRequestParams withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableAccountLinesRequestParams(this.account, this.ledgerHash, this.ledgerIndex, this.peer, this.limit, newValue);
    }

    public final ImmutableAccountLinesRequestParams withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableAccountLinesRequestParams(this.account, this.ledgerHash, this.ledgerIndex, this.peer, this.limit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountLinesRequestParams && this.equalTo((ImmutableAccountLinesRequestParams)another);
    }

    private boolean equalTo(ImmutableAccountLinesRequestParams another) {
        return this.account.equals(another.account) && Objects.equals(this.ledgerHash, another.ledgerHash) && this.ledgerIndex.equals(another.ledgerIndex) && Objects.equals(this.peer, another.peer) && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + this.ledgerIndex.hashCode();
        h += (h << 5) + Objects.hashCode(this.peer);
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountLinesRequestParams").omitNullValues().add("account", (Object)this.account).add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).add("peer", (Object)this.peer).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountLinesRequestParams fromJson(Json json) {
        Builder builder = ImmutableAccountLinesRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.peer != null) {
            builder.peer(json.peer);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    public static ImmutableAccountLinesRequestParams copyOf(AccountLinesRequestParams instance) {
        if (instance instanceof ImmutableAccountLinesRequestParams) {
            return (ImmutableAccountLinesRequestParams)instance;
        }
        return ImmutableAccountLinesRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountLinesRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private long initBits = 1L;
        @Nullable
        private Address account;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private Address peer;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountLinesRequestParams instance) {
            Optional<Marker> markerOptional;
            Optional<UnsignedInteger> limitOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
            if (ledgerHashOptional.isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            this.ledgerIndex(instance.ledgerIndex());
            Optional<Address> peerOptional = instance.peer();
            if (peerOptional.isPresent()) {
                this.peer(peerOptional);
            }
            if ((limitOptional = instance.limit()).isPresent()) {
                this.limit(limitOptional);
            }
            if ((markerOptional = instance.marker()).isPresent()) {
                this.marker(markerOptional);
            }
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder peer(Address peer) {
            this.peer = Objects.requireNonNull(peer, "peer");
            return this;
        }

        @JsonProperty(value="peer")
        @CanIgnoreReturnValue
        public final Builder peer(Optional<? extends Address> peer) {
            this.peer = peer.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableAccountLinesRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountLinesRequestParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build AccountLinesRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountLinesRequestParams", generator="Immutables")
    static final class Json
    implements AccountLinesRequestParams {
        @Nullable
        Address account;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        LedgerIndex ledgerIndex;
        @Nullable
        Optional<Address> peer = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="peer")
        public void setPeer(Optional<Address> peer) {
            this.peer = peer;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> peer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }
}

