/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountTransactionsTransactionResult;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.TransactionMetadata;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountTransactionsTransactionResult", generator="Immutables")
@Immutable
public final class ImmutableAccountTransactionsTransactionResult<T extends Transaction>
implements AccountTransactionsTransactionResult<T> {
    @Nullable
    private final String status;
    private final T transaction;
    @Nullable
    private final TransactionMetadata metadata;
    private final boolean validated;

    private ImmutableAccountTransactionsTransactionResult(Builder<T> builder) {
        this.status = ((Builder)builder).status;
        this.transaction = ((Builder)builder).transaction;
        this.metadata = ((Builder)builder).metadata;
        this.validated = ((Builder)builder).validatedIsSet() ? ((Builder)builder).validated : AccountTransactionsTransactionResult.super.validated();
    }

    private ImmutableAccountTransactionsTransactionResult(@Nullable String status, T transaction, @Nullable TransactionMetadata metadata, boolean validated) {
        this.status = status;
        this.transaction = transaction;
        this.metadata = metadata;
        this.validated = validated;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="tx")
    public T transaction() {
        return this.transaction;
    }

    @Override
    @JsonProperty(value="meta")
    public Optional<TransactionMetadata> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        return this.validated;
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableAccountTransactionsTransactionResult<T>(newValue, this.transaction, this.metadata, this.validated);
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableAccountTransactionsTransactionResult<T>(value, this.transaction, this.metadata, this.validated);
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withTransaction(T value) {
        if (this.transaction == value) {
            return this;
        }
        Transaction newValue = (Transaction)Objects.requireNonNull(value, "transaction");
        return new ImmutableAccountTransactionsTransactionResult<Transaction>(this.status, newValue, this.metadata, this.validated);
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withMetadata(TransactionMetadata value) {
        TransactionMetadata newValue = Objects.requireNonNull(value, "metadata");
        if (this.metadata == newValue) {
            return this;
        }
        return new ImmutableAccountTransactionsTransactionResult<T>(this.status, this.transaction, newValue, this.validated);
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withMetadata(Optional<? extends TransactionMetadata> optional) {
        TransactionMetadata value = optional.orElse(null);
        if (this.metadata == value) {
            return this;
        }
        return new ImmutableAccountTransactionsTransactionResult<T>(this.status, this.transaction, value, this.validated);
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableAccountTransactionsTransactionResult<T>(this.status, this.transaction, this.metadata, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountTransactionsTransactionResult && this.equalTo((ImmutableAccountTransactionsTransactionResult)another);
    }

    private boolean equalTo(ImmutableAccountTransactionsTransactionResult<?> another) {
        return Objects.equals(this.status, another.status) && this.transaction.equals(another.transaction) && Objects.equals(this.metadata, another.metadata) && this.validated == another.validated;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.transaction.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountTransactionsTransactionResult").omitNullValues().add("status", (Object)this.status).add("transaction", this.transaction).add("metadata", (Object)this.metadata).add("validated", this.validated).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends Transaction> ImmutableAccountTransactionsTransactionResult<T> fromJson(Json<T> json) {
        Builder builder = ImmutableAccountTransactionsTransactionResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.transaction != null) {
            builder.transaction(json.transaction);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        return builder.build();
    }

    public static <T extends Transaction> ImmutableAccountTransactionsTransactionResult<T> copyOf(AccountTransactionsTransactionResult<T> instance) {
        if (instance instanceof ImmutableAccountTransactionsTransactionResult) {
            return (ImmutableAccountTransactionsTransactionResult)instance;
        }
        return ImmutableAccountTransactionsTransactionResult.builder().from(instance).build();
    }

    public static <T extends Transaction> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="AccountTransactionsTransactionResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends Transaction> {
        private static final long INIT_BIT_TRANSACTION = 1L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private T transaction;
        @Nullable
        private TransactionMetadata metadata;
        private boolean validated;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(AccountTransactionsTransactionResult<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> statusOptional;
            XrplResult instance;
            if (object instanceof AccountTransactionsTransactionResult) {
                instance = (AccountTransactionsTransactionResult)object;
                this.validated(instance.validated());
                Optional<TransactionMetadata> metadataOptional = instance.metadata();
                if (metadataOptional.isPresent()) {
                    this.metadata(metadataOptional);
                }
                this.transaction(instance.transaction());
            }
            if (object instanceof XrplResult && (statusOptional = (instance = (XrplResult)object).status()).isPresent()) {
                this.status(statusOptional);
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder<T> status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="tx")
        @CanIgnoreReturnValue
        public final Builder<T> transaction(T transaction) {
            this.transaction = (Transaction)Objects.requireNonNull(transaction, "transaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> metadata(TransactionMetadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            return this;
        }

        @JsonProperty(value="meta")
        @CanIgnoreReturnValue
        public final Builder<T> metadata(Optional<? extends TransactionMetadata> metadata) {
            this.metadata = metadata.orElse(null);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder<T> validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableAccountTransactionsTransactionResult<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountTransactionsTransactionResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transaction");
            }
            return "Cannot build AccountTransactionsTransactionResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountTransactionsTransactionResult", generator="Immutables")
    static final class Json<T extends Transaction>
    implements AccountTransactionsTransactionResult<T> {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        T transaction;
        @Nullable
        Optional<TransactionMetadata> metadata = Optional.empty();
        boolean validated;
        boolean validatedIsSet;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="tx")
        public void setTransaction(T transaction) {
            this.transaction = transaction;
        }

        @JsonProperty(value="meta")
        public void setMetadata(Optional<TransactionMetadata> metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T transaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TransactionMetadata> metadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }
    }
}

