/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.PaymentChannelResultObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PaymentChannelResultObject", generator="Immutables")
@Immutable
public final class ImmutablePaymentChannelResultObject
implements PaymentChannelResultObject {
    private final Address account;
    private final XrpCurrencyAmount amount;
    private final XrpCurrencyAmount balance;
    private final Hash256 channelId;
    private final Address destinationAccount;
    private final UnsignedInteger settleDelay;
    @Nullable
    private final String publicKey;
    @Nullable
    private final String publicKeyHex;
    @Nullable
    private final UnsignedLong expiration;
    @Nullable
    private final UnsignedLong cancelAfter;
    @Nullable
    private final UnsignedInteger sourceTag;
    @Nullable
    private final UnsignedInteger destinationTag;

    private ImmutablePaymentChannelResultObject(Address account, XrpCurrencyAmount amount, XrpCurrencyAmount balance, Hash256 channelId, Address destinationAccount, UnsignedInteger settleDelay, @Nullable String publicKey, @Nullable String publicKeyHex, @Nullable UnsignedLong expiration, @Nullable UnsignedLong cancelAfter, @Nullable UnsignedInteger sourceTag, @Nullable UnsignedInteger destinationTag) {
        this.account = account;
        this.amount = amount;
        this.balance = balance;
        this.channelId = channelId;
        this.destinationAccount = destinationAccount;
        this.settleDelay = settleDelay;
        this.publicKey = publicKey;
        this.publicKeyHex = publicKeyHex;
        this.expiration = expiration;
        this.cancelAfter = cancelAfter;
        this.sourceTag = sourceTag;
        this.destinationTag = destinationTag;
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="amount")
    public XrpCurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="balance")
    public XrpCurrencyAmount balance() {
        return this.balance;
    }

    @Override
    @JsonProperty(value="channel_id")
    public Hash256 channelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="destination_account")
    public Address destinationAccount() {
        return this.destinationAccount;
    }

    @Override
    @JsonProperty(value="settle_delay")
    public UnsignedInteger settleDelay() {
        return this.settleDelay;
    }

    @Override
    @JsonProperty(value="public_key")
    public Optional<String> publicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    @Override
    @JsonProperty(value="public_key_hex")
    public Optional<String> publicKeyHex() {
        return Optional.ofNullable(this.publicKeyHex);
    }

    @Override
    @JsonProperty(value="expiration")
    public Optional<UnsignedLong> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    @Override
    @JsonProperty(value="cancel_after")
    public Optional<UnsignedLong> cancelAfter() {
        return Optional.ofNullable(this.cancelAfter);
    }

    @Override
    @JsonProperty(value="source_tag")
    public Optional<UnsignedInteger> sourceTag() {
        return Optional.ofNullable(this.sourceTag);
    }

    @Override
    @JsonProperty(value="destination_tag")
    public Optional<UnsignedInteger> destinationTag() {
        return Optional.ofNullable(this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutablePaymentChannelResultObject(newValue, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withAmount(XrpCurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutablePaymentChannelResultObject(this.account, newValue, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withBalance(XrpCurrencyAmount value) {
        if (this.balance == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "balance");
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, newValue, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withChannelId(Hash256 value) {
        if (this.channelId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "channelId");
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, newValue, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withDestinationAccount(Address value) {
        if (this.destinationAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destinationAccount");
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, newValue, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withSettleDelay(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "settleDelay");
        if (this.settleDelay.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, newValue, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "publicKey");
        if (Objects.equals(this.publicKey, newValue)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, newValue, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withPublicKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.publicKey, value)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, value, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withPublicKeyHex(String value) {
        String newValue = Objects.requireNonNull(value, "publicKeyHex");
        if (Objects.equals(this.publicKeyHex, newValue)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, newValue, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withPublicKeyHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.publicKeyHex, value)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, value, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withExpiration(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, newValue, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withExpiration(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, value, this.cancelAfter, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withCancelAfter(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "cancelAfter");
        if (Objects.equals(this.cancelAfter, newValue)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, newValue, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withCancelAfter(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.cancelAfter, value)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, value, this.sourceTag, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withSourceTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sourceTag");
        if (Objects.equals(this.sourceTag, newValue)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, newValue, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withSourceTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sourceTag, value)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, value, this.destinationTag);
    }

    public final ImmutablePaymentChannelResultObject withDestinationTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "destinationTag");
        if (Objects.equals(this.destinationTag, newValue)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, newValue);
    }

    public final ImmutablePaymentChannelResultObject withDestinationTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.destinationTag, value)) {
            return this;
        }
        return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePaymentChannelResultObject && this.equalTo((ImmutablePaymentChannelResultObject)another);
    }

    private boolean equalTo(ImmutablePaymentChannelResultObject another) {
        return this.account.equals(another.account) && this.amount.equals(another.amount) && this.balance.equals(another.balance) && this.channelId.equals(another.channelId) && this.destinationAccount.equals(another.destinationAccount) && this.settleDelay.equals((Object)another.settleDelay) && Objects.equals(this.publicKey, another.publicKey) && Objects.equals(this.publicKeyHex, another.publicKeyHex) && Objects.equals(this.expiration, another.expiration) && Objects.equals(this.cancelAfter, another.cancelAfter) && Objects.equals(this.sourceTag, another.sourceTag) && Objects.equals(this.destinationTag, another.destinationTag);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.balance.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.destinationAccount.hashCode();
        h += (h << 5) + this.settleDelay.hashCode();
        h += (h << 5) + Objects.hashCode(this.publicKey);
        h += (h << 5) + Objects.hashCode(this.publicKeyHex);
        h += (h << 5) + Objects.hashCode(this.expiration);
        h += (h << 5) + Objects.hashCode(this.cancelAfter);
        h += (h << 5) + Objects.hashCode(this.sourceTag);
        h += (h << 5) + Objects.hashCode(this.destinationTag);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PaymentChannelResultObject").omitNullValues().add("account", (Object)this.account).add("amount", (Object)this.amount).add("balance", (Object)this.balance).add("channelId", (Object)this.channelId).add("destinationAccount", (Object)this.destinationAccount).add("settleDelay", (Object)this.settleDelay).add("publicKey", (Object)this.publicKey).add("publicKeyHex", (Object)this.publicKeyHex).add("expiration", (Object)this.expiration).add("cancelAfter", (Object)this.cancelAfter).add("sourceTag", (Object)this.sourceTag).add("destinationTag", (Object)this.destinationTag).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePaymentChannelResultObject fromJson(Json json) {
        Builder builder = ImmutablePaymentChannelResultObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.balance != null) {
            builder.balance(json.balance);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.destinationAccount != null) {
            builder.destinationAccount(json.destinationAccount);
        }
        if (json.settleDelay != null) {
            builder.settleDelay(json.settleDelay);
        }
        if (json.publicKey != null) {
            builder.publicKey(json.publicKey);
        }
        if (json.publicKeyHex != null) {
            builder.publicKeyHex(json.publicKeyHex);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        if (json.cancelAfter != null) {
            builder.cancelAfter(json.cancelAfter);
        }
        if (json.sourceTag != null) {
            builder.sourceTag(json.sourceTag);
        }
        if (json.destinationTag != null) {
            builder.destinationTag(json.destinationTag);
        }
        return builder.build();
    }

    public static ImmutablePaymentChannelResultObject copyOf(PaymentChannelResultObject instance) {
        if (instance instanceof ImmutablePaymentChannelResultObject) {
            return (ImmutablePaymentChannelResultObject)instance;
        }
        return ImmutablePaymentChannelResultObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PaymentChannelResultObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_AMOUNT = 2L;
        private static final long INIT_BIT_BALANCE = 4L;
        private static final long INIT_BIT_CHANNEL_ID = 8L;
        private static final long INIT_BIT_DESTINATION_ACCOUNT = 16L;
        private static final long INIT_BIT_SETTLE_DELAY = 32L;
        private long initBits = 63L;
        @Nullable
        private Address account;
        @Nullable
        private XrpCurrencyAmount amount;
        @Nullable
        private XrpCurrencyAmount balance;
        @Nullable
        private Hash256 channelId;
        @Nullable
        private Address destinationAccount;
        @Nullable
        private UnsignedInteger settleDelay;
        @Nullable
        private String publicKey;
        @Nullable
        private String publicKeyHex;
        @Nullable
        private UnsignedLong expiration;
        @Nullable
        private UnsignedLong cancelAfter;
        @Nullable
        private UnsignedInteger sourceTag;
        @Nullable
        private UnsignedInteger destinationTag;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PaymentChannelResultObject instance) {
            Optional<UnsignedInteger> destinationTagOptional;
            Optional<UnsignedInteger> sourceTagOptional;
            Optional<UnsignedLong> cancelAfterOptional;
            Optional<UnsignedLong> expirationOptional;
            Optional<String> publicKeyHexOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.amount(instance.amount());
            this.balance(instance.balance());
            this.channelId(instance.channelId());
            this.destinationAccount(instance.destinationAccount());
            this.settleDelay(instance.settleDelay());
            Optional<String> publicKeyOptional = instance.publicKey();
            if (publicKeyOptional.isPresent()) {
                this.publicKey(publicKeyOptional);
            }
            if ((publicKeyHexOptional = instance.publicKeyHex()).isPresent()) {
                this.publicKeyHex(publicKeyHexOptional);
            }
            if ((expirationOptional = instance.expiration()).isPresent()) {
                this.expiration(expirationOptional);
            }
            if ((cancelAfterOptional = instance.cancelAfter()).isPresent()) {
                this.cancelAfter(cancelAfterOptional);
            }
            if ((sourceTagOptional = instance.sourceTag()).isPresent()) {
                this.sourceTag(sourceTagOptional);
            }
            if ((destinationTagOptional = instance.destinationTag()).isPresent()) {
                this.destinationTag(destinationTagOptional);
            }
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="amount")
        @CanIgnoreReturnValue
        public final Builder amount(XrpCurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="balance")
        @CanIgnoreReturnValue
        public final Builder balance(XrpCurrencyAmount balance) {
            this.balance = Objects.requireNonNull(balance, "balance");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="channel_id")
        @CanIgnoreReturnValue
        public final Builder channelId(Hash256 channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="destination_account")
        @CanIgnoreReturnValue
        public final Builder destinationAccount(Address destinationAccount) {
            this.destinationAccount = Objects.requireNonNull(destinationAccount, "destinationAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="settle_delay")
        @CanIgnoreReturnValue
        public final Builder settleDelay(UnsignedInteger settleDelay) {
            this.settleDelay = Objects.requireNonNull(settleDelay, "settleDelay");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKey(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            return this;
        }

        @JsonProperty(value="public_key")
        @CanIgnoreReturnValue
        public final Builder publicKey(Optional<String> publicKey) {
            this.publicKey = publicKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKeyHex(String publicKeyHex) {
            this.publicKeyHex = Objects.requireNonNull(publicKeyHex, "publicKeyHex");
            return this;
        }

        @JsonProperty(value="public_key_hex")
        @CanIgnoreReturnValue
        public final Builder publicKeyHex(Optional<String> publicKeyHex) {
            this.publicKeyHex = publicKeyHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedLong expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedLong> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cancelAfter(UnsignedLong cancelAfter) {
            this.cancelAfter = Objects.requireNonNull(cancelAfter, "cancelAfter");
            return this;
        }

        @JsonProperty(value="cancel_after")
        @CanIgnoreReturnValue
        public final Builder cancelAfter(Optional<? extends UnsignedLong> cancelAfter) {
            this.cancelAfter = cancelAfter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceTag(UnsignedInteger sourceTag) {
            this.sourceTag = Objects.requireNonNull(sourceTag, "sourceTag");
            return this;
        }

        @JsonProperty(value="source_tag")
        @CanIgnoreReturnValue
        public final Builder sourceTag(Optional<? extends UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationTag(UnsignedInteger destinationTag) {
            this.destinationTag = Objects.requireNonNull(destinationTag, "destinationTag");
            return this;
        }

        @JsonProperty(value="destination_tag")
        @CanIgnoreReturnValue
        public final Builder destinationTag(Optional<? extends UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag.orElse(null);
            return this;
        }

        public ImmutablePaymentChannelResultObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePaymentChannelResultObject(this.account, this.amount, this.balance, this.channelId, this.destinationAccount, this.settleDelay, this.publicKey, this.publicKeyHex, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("balance");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("destinationAccount");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("settleDelay");
            }
            return "Cannot build PaymentChannelResultObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PaymentChannelResultObject", generator="Immutables")
    static final class Json
    implements PaymentChannelResultObject {
        @Nullable
        Address account;
        @Nullable
        XrpCurrencyAmount amount;
        @Nullable
        XrpCurrencyAmount balance;
        @Nullable
        Hash256 channelId;
        @Nullable
        Address destinationAccount;
        @Nullable
        UnsignedInteger settleDelay;
        @Nullable
        Optional<String> publicKey = Optional.empty();
        @Nullable
        Optional<String> publicKeyHex = Optional.empty();
        @Nullable
        Optional<UnsignedLong> expiration = Optional.empty();
        @Nullable
        Optional<UnsignedLong> cancelAfter = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> sourceTag = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> destinationTag = Optional.empty();

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="amount")
        public void setAmount(XrpCurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="balance")
        public void setBalance(XrpCurrencyAmount balance) {
            this.balance = balance;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Hash256 channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="destination_account")
        public void setDestinationAccount(Address destinationAccount) {
            this.destinationAccount = destinationAccount;
        }

        @JsonProperty(value="settle_delay")
        public void setSettleDelay(UnsignedInteger settleDelay) {
            this.settleDelay = settleDelay;
        }

        @JsonProperty(value="public_key")
        public void setPublicKey(Optional<String> publicKey) {
            this.publicKey = publicKey;
        }

        @JsonProperty(value="public_key_hex")
        public void setPublicKeyHex(Optional<String> publicKeyHex) {
            this.publicKeyHex = publicKeyHex;
        }

        @JsonProperty(value="expiration")
        public void setExpiration(Optional<UnsignedLong> expiration) {
            this.expiration = expiration;
        }

        @JsonProperty(value="cancel_after")
        public void setCancelAfter(Optional<UnsignedLong> cancelAfter) {
            this.cancelAfter = cancelAfter;
        }

        @JsonProperty(value="source_tag")
        public void setSourceTag(Optional<UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag;
        }

        @JsonProperty(value="destination_tag")
        public void setDestinationTag(Optional<UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount balance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destinationAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger settleDelay() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> publicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> publicKeyHex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> expiration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> cancelAfter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sourceTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> destinationTag() {
            throw new UnsupportedOperationException();
        }
    }
}

