/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.common;

import com.google.common.primitives.UnsignedLong;
import java.util.Objects;

public class LedgerIndex {
    public static final LedgerIndex CURRENT = LedgerIndex.of("current");
    public static final LedgerIndex VALIDATED = LedgerIndex.of("validated");
    public static final LedgerIndex CLOSED = LedgerIndex.of("closed");
    private final String value;

    public LedgerIndex(String value) {
        this.value = value;
    }

    public static LedgerIndex of(String value) {
        return new LedgerIndex(value);
    }

    public static LedgerIndex of(UnsignedLong value) {
        return new LedgerIndex(value.toString());
    }

    public String value() {
        return this.value;
    }

    public UnsignedLong unsignedLongValue() {
        return UnsignedLong.valueOf((String)this.value);
    }

    public LedgerIndex plus(UnsignedLong other) {
        return LedgerIndex.of(this.unsignedLongValue().plus(other));
    }

    public LedgerIndex plus(LedgerIndex other) {
        return this.plus(other.unsignedLongValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LedgerIndex)) {
            return false;
        }
        LedgerIndex that = (LedgerIndex)obj;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value();
    }
}

