/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.ledger.LedgerRequestParams;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LedgerRequestParams", generator="Immutables")
@Immutable
public final class ImmutableLedgerRequestParams
implements LedgerRequestParams {
    @Nullable
    private final Hash256 ledgerHash;
    private final LedgerIndex ledgerIndex;
    private final boolean full;
    private final boolean accounts;
    private final boolean transactions;
    private final transient boolean expand;
    private final boolean ownerFunds;
    private final transient boolean binary;
    private final boolean queue;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLedgerRequestParams(Builder builder) {
        this.ledgerHash = builder.ledgerHash;
        if (builder.ledgerIndex != null) {
            this.initShim.ledgerIndex(builder.ledgerIndex);
        }
        if (builder.fullIsSet()) {
            this.initShim.full(builder.full);
        }
        if (builder.accountsIsSet()) {
            this.initShim.accounts(builder.accounts);
        }
        if (builder.transactionsIsSet()) {
            this.initShim.transactions(builder.transactions);
        }
        if (builder.ownerFundsIsSet()) {
            this.initShim.ownerFunds(builder.ownerFunds);
        }
        if (builder.queueIsSet()) {
            this.initShim.queue(builder.queue);
        }
        this.ledgerIndex = this.initShim.ledgerIndex();
        this.full = this.initShim.full();
        this.accounts = this.initShim.accounts();
        this.transactions = this.initShim.transactions();
        this.expand = this.initShim.expand();
        this.ownerFunds = this.initShim.ownerFunds();
        this.binary = this.initShim.binary();
        this.queue = this.initShim.queue();
        this.initShim = null;
    }

    private ImmutableLedgerRequestParams(@Nullable Hash256 ledgerHash, LedgerIndex ledgerIndex, boolean full, boolean accounts, boolean transactions, boolean ownerFunds, boolean queue) {
        this.ledgerHash = ledgerHash;
        this.initShim.ledgerIndex(ledgerIndex);
        this.initShim.full(full);
        this.initShim.accounts(accounts);
        this.initShim.transactions(transactions);
        this.initShim.ownerFunds(ownerFunds);
        this.initShim.queue(queue);
        this.ledgerIndex = this.initShim.ledgerIndex();
        this.full = this.initShim.full();
        this.accounts = this.initShim.accounts();
        this.transactions = this.initShim.transactions();
        this.expand = this.initShim.expand();
        this.ownerFunds = this.initShim.ownerFunds();
        this.binary = this.initShim.binary();
        this.queue = this.initShim.queue();
        this.initShim = null;
    }

    private LedgerIndex ledgerIndexInitialize() {
        return LedgerRequestParams.super.ledgerIndex();
    }

    private boolean fullInitialize() {
        return LedgerRequestParams.super.full();
    }

    private boolean accountsInitialize() {
        return LedgerRequestParams.super.accounts();
    }

    private boolean transactionsInitialize() {
        return LedgerRequestParams.super.transactions();
    }

    private boolean expandInitialize() {
        return LedgerRequestParams.super.expand();
    }

    private boolean ownerFundsInitialize() {
        return LedgerRequestParams.super.ownerFunds();
    }

    private boolean binaryInitialize() {
        return LedgerRequestParams.super.binary();
    }

    private boolean queueInitialize() {
        return LedgerRequestParams.super.queue();
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public LedgerIndex ledgerIndex() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerIndex() : this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="full")
    public boolean full() {
        InitShim shim = this.initShim;
        return shim != null ? shim.full() : this.full;
    }

    @Override
    @JsonProperty(value="accounts")
    public boolean accounts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.accounts() : this.accounts;
    }

    @Override
    @JsonProperty(value="transactions")
    public boolean transactions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transactions() : this.transactions;
    }

    @Override
    @JsonProperty(value="expand")
    public boolean expand() {
        InitShim shim = this.initShim;
        return shim != null ? shim.expand() : this.expand;
    }

    @Override
    @JsonProperty(value="owner_funds")
    public boolean ownerFunds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ownerFunds() : this.ownerFunds;
    }

    @Override
    @JsonProperty(value="binary")
    public boolean binary() {
        InitShim shim = this.initShim;
        return shim != null ? shim.binary() : this.binary;
    }

    @Override
    @JsonProperty(value="queue")
    public boolean queue() {
        InitShim shim = this.initShim;
        return shim != null ? shim.queue() : this.queue;
    }

    public final ImmutableLedgerRequestParams withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableLedgerRequestParams(newValue, this.ledgerIndex, this.full, this.accounts, this.transactions, this.ownerFunds, this.queue);
    }

    public final ImmutableLedgerRequestParams withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableLedgerRequestParams(value, this.ledgerIndex, this.full, this.accounts, this.transactions, this.ownerFunds, this.queue);
    }

    public final ImmutableLedgerRequestParams withLedgerIndex(LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        return new ImmutableLedgerRequestParams(this.ledgerHash, newValue, this.full, this.accounts, this.transactions, this.ownerFunds, this.queue);
    }

    public final ImmutableLedgerRequestParams withFull(boolean value) {
        if (this.full == value) {
            return this;
        }
        return new ImmutableLedgerRequestParams(this.ledgerHash, this.ledgerIndex, value, this.accounts, this.transactions, this.ownerFunds, this.queue);
    }

    public final ImmutableLedgerRequestParams withAccounts(boolean value) {
        if (this.accounts == value) {
            return this;
        }
        return new ImmutableLedgerRequestParams(this.ledgerHash, this.ledgerIndex, this.full, value, this.transactions, this.ownerFunds, this.queue);
    }

    public final ImmutableLedgerRequestParams withTransactions(boolean value) {
        if (this.transactions == value) {
            return this;
        }
        return new ImmutableLedgerRequestParams(this.ledgerHash, this.ledgerIndex, this.full, this.accounts, value, this.ownerFunds, this.queue);
    }

    public final ImmutableLedgerRequestParams withOwnerFunds(boolean value) {
        if (this.ownerFunds == value) {
            return this;
        }
        return new ImmutableLedgerRequestParams(this.ledgerHash, this.ledgerIndex, this.full, this.accounts, this.transactions, value, this.queue);
    }

    public final ImmutableLedgerRequestParams withQueue(boolean value) {
        if (this.queue == value) {
            return this;
        }
        return new ImmutableLedgerRequestParams(this.ledgerHash, this.ledgerIndex, this.full, this.accounts, this.transactions, this.ownerFunds, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLedgerRequestParams && this.equalTo((ImmutableLedgerRequestParams)another);
    }

    private boolean equalTo(ImmutableLedgerRequestParams another) {
        return Objects.equals(this.ledgerHash, another.ledgerHash) && this.ledgerIndex.equals(another.ledgerIndex) && this.full == another.full && this.accounts == another.accounts && this.transactions == another.transactions && this.expand == another.expand && this.ownerFunds == another.ownerFunds && this.binary == another.binary && this.queue == another.queue;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + this.ledgerIndex.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.full);
        h += (h << 5) + Booleans.hashCode((boolean)this.accounts);
        h += (h << 5) + Booleans.hashCode((boolean)this.transactions);
        h += (h << 5) + Booleans.hashCode((boolean)this.expand);
        h += (h << 5) + Booleans.hashCode((boolean)this.ownerFunds);
        h += (h << 5) + Booleans.hashCode((boolean)this.binary);
        h += (h << 5) + Booleans.hashCode((boolean)this.queue);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LedgerRequestParams").omitNullValues().add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).add("full", this.full).add("accounts", this.accounts).add("transactions", this.transactions).add("expand", this.expand).add("ownerFunds", this.ownerFunds).add("binary", this.binary).add("queue", this.queue).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLedgerRequestParams fromJson(Json json) {
        Builder builder = ImmutableLedgerRequestParams.builder();
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.fullIsSet) {
            builder.full(json.full);
        }
        if (json.accountsIsSet) {
            builder.accounts(json.accounts);
        }
        if (json.transactionsIsSet) {
            builder.transactions(json.transactions);
        }
        if (json.ownerFundsIsSet) {
            builder.ownerFunds(json.ownerFunds);
        }
        if (json.queueIsSet) {
            builder.queue(json.queue);
        }
        return builder.build();
    }

    public static ImmutableLedgerRequestParams copyOf(LedgerRequestParams instance) {
        if (instance instanceof ImmutableLedgerRequestParams) {
            return (ImmutableLedgerRequestParams)instance;
        }
        return ImmutableLedgerRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LedgerRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_FULL = 1L;
        private static final long OPT_BIT_ACCOUNTS = 2L;
        private static final long OPT_BIT_TRANSACTIONS = 4L;
        private static final long OPT_BIT_OWNER_FUNDS = 8L;
        private static final long OPT_BIT_QUEUE = 16L;
        private long optBits;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        private boolean full;
        private boolean accounts;
        private boolean transactions;
        private boolean ownerFunds;
        private boolean queue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LedgerRequestParams instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
            if (ledgerHashOptional.isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            this.ledgerIndex(instance.ledgerIndex());
            this.full(instance.full());
            this.accounts(instance.accounts());
            this.transactions(instance.transactions());
            this.ownerFunds(instance.ownerFunds());
            this.queue(instance.queue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="full")
        @CanIgnoreReturnValue
        public final Builder full(boolean full) {
            this.full = full;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="accounts")
        @CanIgnoreReturnValue
        public final Builder accounts(boolean accounts) {
            this.accounts = accounts;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="transactions")
        @CanIgnoreReturnValue
        public final Builder transactions(boolean transactions) {
            this.transactions = transactions;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="owner_funds")
        @CanIgnoreReturnValue
        public final Builder ownerFunds(boolean ownerFunds) {
            this.ownerFunds = ownerFunds;
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="queue")
        @CanIgnoreReturnValue
        public final Builder queue(boolean queue) {
            this.queue = queue;
            this.optBits |= 0x10L;
            return this;
        }

        public ImmutableLedgerRequestParams build() {
            return new ImmutableLedgerRequestParams(this);
        }

        private boolean fullIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean accountsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean transactionsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean ownerFundsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean queueIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LedgerRequestParams", generator="Immutables")
    static final class Json
    implements LedgerRequestParams {
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        LedgerIndex ledgerIndex;
        boolean full;
        boolean fullIsSet;
        boolean accounts;
        boolean accountsIsSet;
        boolean transactions;
        boolean transactionsIsSet;
        boolean ownerFunds;
        boolean ownerFundsIsSet;
        boolean queue;
        boolean queueIsSet;

        Json() {
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="full")
        public void setFull(boolean full) {
            this.full = full;
            this.fullIsSet = true;
        }

        @JsonProperty(value="accounts")
        public void setAccounts(boolean accounts) {
            this.accounts = accounts;
            this.accountsIsSet = true;
        }

        @JsonProperty(value="transactions")
        public void setTransactions(boolean transactions) {
            this.transactions = transactions;
            this.transactionsIsSet = true;
        }

        @JsonProperty(value="owner_funds")
        public void setOwnerFunds(boolean ownerFunds) {
            this.ownerFunds = ownerFunds;
            this.ownerFundsIsSet = true;
        }

        @JsonProperty(value="queue")
        public void setQueue(boolean queue) {
            this.queue = queue;
            this.queueIsSet = true;
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean full() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean accounts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean transactions() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean expand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean ownerFunds() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean binary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean queue() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="LedgerRequestParams", generator="Immutables")
    private final class InitShim {
        private byte ledgerIndexBuildStage = 0;
        private LedgerIndex ledgerIndex;
        private byte fullBuildStage = 0;
        private boolean full;
        private byte accountsBuildStage = 0;
        private boolean accounts;
        private byte transactionsBuildStage = 0;
        private boolean transactions;
        private byte expandBuildStage = 0;
        private boolean expand;
        private byte ownerFundsBuildStage = 0;
        private boolean ownerFunds;
        private byte binaryBuildStage = 0;
        private boolean binary;
        private byte queueBuildStage = 0;
        private boolean queue;

        private InitShim() {
        }

        LedgerIndex ledgerIndex() {
            if (this.ledgerIndexBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerIndexBuildStage == 0) {
                this.ledgerIndexBuildStage = (byte)-1;
                this.ledgerIndex = Objects.requireNonNull(ImmutableLedgerRequestParams.this.ledgerIndexInitialize(), "ledgerIndex");
                this.ledgerIndexBuildStage = 1;
            }
            return this.ledgerIndex;
        }

        void ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
            this.ledgerIndexBuildStage = 1;
        }

        boolean full() {
            if (this.fullBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fullBuildStage == 0) {
                this.fullBuildStage = (byte)-1;
                this.full = ImmutableLedgerRequestParams.this.fullInitialize();
                this.fullBuildStage = 1;
            }
            return this.full;
        }

        void full(boolean full) {
            this.full = full;
            this.fullBuildStage = 1;
        }

        boolean accounts() {
            if (this.accountsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.accountsBuildStage == 0) {
                this.accountsBuildStage = (byte)-1;
                this.accounts = ImmutableLedgerRequestParams.this.accountsInitialize();
                this.accountsBuildStage = 1;
            }
            return this.accounts;
        }

        void accounts(boolean accounts) {
            this.accounts = accounts;
            this.accountsBuildStage = 1;
        }

        boolean transactions() {
            if (this.transactionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transactionsBuildStage == 0) {
                this.transactionsBuildStage = (byte)-1;
                this.transactions = ImmutableLedgerRequestParams.this.transactionsInitialize();
                this.transactionsBuildStage = 1;
            }
            return this.transactions;
        }

        void transactions(boolean transactions) {
            this.transactions = transactions;
            this.transactionsBuildStage = 1;
        }

        boolean expand() {
            if (this.expandBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.expandBuildStage == 0) {
                this.expandBuildStage = (byte)-1;
                this.expand = ImmutableLedgerRequestParams.this.expandInitialize();
                this.expandBuildStage = 1;
            }
            return this.expand;
        }

        boolean ownerFunds() {
            if (this.ownerFundsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ownerFundsBuildStage == 0) {
                this.ownerFundsBuildStage = (byte)-1;
                this.ownerFunds = ImmutableLedgerRequestParams.this.ownerFundsInitialize();
                this.ownerFundsBuildStage = 1;
            }
            return this.ownerFunds;
        }

        void ownerFunds(boolean ownerFunds) {
            this.ownerFunds = ownerFunds;
            this.ownerFundsBuildStage = 1;
        }

        boolean binary() {
            if (this.binaryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.binaryBuildStage == 0) {
                this.binaryBuildStage = (byte)-1;
                this.binary = ImmutableLedgerRequestParams.this.binaryInitialize();
                this.binaryBuildStage = 1;
            }
            return this.binary;
        }

        boolean queue() {
            if (this.queueBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.queueBuildStage == 0) {
                this.queueBuildStage = (byte)-1;
                this.queue = ImmutableLedgerRequestParams.this.queueInitialize();
                this.queueBuildStage = 1;
            }
            return this.queue;
        }

        void queue(boolean queue) {
            this.queue = queue;
            this.queueBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerIndexBuildStage == -1) {
                attributes.add("ledgerIndex");
            }
            if (this.fullBuildStage == -1) {
                attributes.add("full");
            }
            if (this.accountsBuildStage == -1) {
                attributes.add("accounts");
            }
            if (this.transactionsBuildStage == -1) {
                attributes.add("transactions");
            }
            if (this.expandBuildStage == -1) {
                attributes.add("expand");
            }
            if (this.ownerFundsBuildStage == -1) {
                attributes.add("ownerFunds");
            }
            if (this.binaryBuildStage == -1) {
                attributes.add("binary");
            }
            if (this.queueBuildStage == -1) {
                attributes.add("queue");
            }
            return "Cannot build LedgerRequestParams, attribute initializers form cycle " + attributes;
        }
    }
}

