/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.path.PathAlternative;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.PathStep;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PathAlternative", generator="Immutables")
@Immutable
public final class ImmutablePathAlternative
implements PathAlternative {
    private final ImmutableList<List<PathStep>> pathsComputed;
    private final CurrencyAmount sourceAmount;

    private ImmutablePathAlternative(ImmutableList<List<PathStep>> pathsComputed, CurrencyAmount sourceAmount) {
        this.pathsComputed = pathsComputed;
        this.sourceAmount = sourceAmount;
    }

    @JsonProperty(value="paths_computed")
    public ImmutableList<List<PathStep>> pathsComputed() {
        return this.pathsComputed;
    }

    @Override
    @JsonProperty(value="source_amount")
    public CurrencyAmount sourceAmount() {
        return this.sourceAmount;
    }

    @SafeVarargs
    public final ImmutablePathAlternative withPathsComputed(List<PathStep> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePathAlternative((ImmutableList<List<PathStep>>)newValue, this.sourceAmount);
    }

    public final ImmutablePathAlternative withPathsComputed(Iterable<? extends List<PathStep>> elements) {
        if (this.pathsComputed == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePathAlternative((ImmutableList<List<PathStep>>)newValue, this.sourceAmount);
    }

    public final ImmutablePathAlternative withSourceAmount(CurrencyAmount value) {
        if (this.sourceAmount == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "sourceAmount");
        return new ImmutablePathAlternative(this.pathsComputed, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePathAlternative && this.equalTo((ImmutablePathAlternative)another);
    }

    private boolean equalTo(ImmutablePathAlternative another) {
        return this.pathsComputed.equals(another.pathsComputed) && this.sourceAmount.equals(another.sourceAmount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pathsComputed.hashCode();
        h += (h << 5) + this.sourceAmount.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PathAlternative").omitNullValues().add("pathsComputed", this.pathsComputed).add("sourceAmount", (Object)this.sourceAmount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePathAlternative fromJson(Json json) {
        Builder builder = ImmutablePathAlternative.builder();
        if (json.pathsComputed != null) {
            builder.addAllPathsComputed(json.pathsComputed);
        }
        if (json.sourceAmount != null) {
            builder.sourceAmount(json.sourceAmount);
        }
        return builder.build();
    }

    public static ImmutablePathAlternative copyOf(PathAlternative instance) {
        if (instance instanceof ImmutablePathAlternative) {
            return (ImmutablePathAlternative)instance;
        }
        return ImmutablePathAlternative.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PathAlternative", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_AMOUNT = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<List<PathStep>> pathsComputed = ImmutableList.builder();
        @Nullable
        private CurrencyAmount sourceAmount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PathAlternative instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllPathsComputed(instance.pathsComputed());
            this.sourceAmount(instance.sourceAmount());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPathsComputed(List<PathStep> element) {
            this.pathsComputed.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addPathsComputed(List<PathStep> ... elements) {
            this.pathsComputed.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="paths_computed")
        @CanIgnoreReturnValue
        public final Builder pathsComputed(Iterable<? extends List<PathStep>> elements) {
            this.pathsComputed = ImmutableList.builder();
            return this.addAllPathsComputed(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPathsComputed(Iterable<? extends List<PathStep>> elements) {
            this.pathsComputed.addAll(elements);
            return this;
        }

        @JsonProperty(value="source_amount")
        @CanIgnoreReturnValue
        public final Builder sourceAmount(CurrencyAmount sourceAmount) {
            this.sourceAmount = Objects.requireNonNull(sourceAmount, "sourceAmount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePathAlternative build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePathAlternative(this.pathsComputed.build(), this.sourceAmount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceAmount");
            }
            return "Cannot build PathAlternative, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PathAlternative", generator="Immutables")
    static final class Json
    implements PathAlternative {
        @Nullable
        List<List<PathStep>> pathsComputed = ImmutableList.of();
        @Nullable
        CurrencyAmount sourceAmount;

        Json() {
        }

        @JsonProperty(value="paths_computed")
        public void setPathsComputed(List<List<PathStep>> pathsComputed) {
            this.pathsComputed = pathsComputed;
        }

        @JsonProperty(value="source_amount")
        public void setSourceAmount(CurrencyAmount sourceAmount) {
            this.sourceAmount = sourceAmount;
        }

        @Override
        public List<List<PathStep>> pathsComputed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount sourceAmount() {
            throw new UnsupportedOperationException();
        }
    }
}

