/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.path.PathCurrency;
import org.xrpl.xrpl4j.model.client.path.RipplePathFindRequestParams;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RipplePathFindRequestParams", generator="Immutables")
@Immutable
public final class ImmutableRipplePathFindRequestParams
implements RipplePathFindRequestParams {
    private final Address sourceAccount;
    private final Address destinationAccount;
    private final CurrencyAmount destinationAmount;
    @Nullable
    private final CurrencyAmount sendMax;
    private final ImmutableList<PathCurrency> sourceCurrencies;
    @Nullable
    private final Hash256 ledgerHash;
    private final LedgerIndex ledgerIndex;

    private ImmutableRipplePathFindRequestParams(Builder builder) {
        this.sourceAccount = builder.sourceAccount;
        this.destinationAccount = builder.destinationAccount;
        this.destinationAmount = builder.destinationAmount;
        this.sendMax = builder.sendMax;
        this.sourceCurrencies = builder.sourceCurrencies.build();
        this.ledgerHash = builder.ledgerHash;
        this.ledgerIndex = builder.ledgerIndex != null ? builder.ledgerIndex : Objects.requireNonNull(RipplePathFindRequestParams.super.ledgerIndex(), "ledgerIndex");
    }

    private ImmutableRipplePathFindRequestParams(Address sourceAccount, Address destinationAccount, CurrencyAmount destinationAmount, @Nullable CurrencyAmount sendMax, ImmutableList<PathCurrency> sourceCurrencies, @Nullable Hash256 ledgerHash, LedgerIndex ledgerIndex) {
        this.sourceAccount = sourceAccount;
        this.destinationAccount = destinationAccount;
        this.destinationAmount = destinationAmount;
        this.sendMax = sendMax;
        this.sourceCurrencies = sourceCurrencies;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
    }

    @Override
    @JsonProperty(value="source_account")
    public Address sourceAccount() {
        return this.sourceAccount;
    }

    @Override
    @JsonProperty(value="destination_account")
    public Address destinationAccount() {
        return this.destinationAccount;
    }

    @Override
    @JsonProperty(value="destination_amount")
    public CurrencyAmount destinationAmount() {
        return this.destinationAmount;
    }

    @Override
    @JsonProperty(value="send_max")
    public Optional<CurrencyAmount> sendMax() {
        return Optional.ofNullable(this.sendMax);
    }

    @JsonProperty(value="source_currencies")
    public ImmutableList<PathCurrency> sourceCurrencies() {
        return this.sourceCurrencies;
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public LedgerIndex ledgerIndex() {
        return this.ledgerIndex;
    }

    public final ImmutableRipplePathFindRequestParams withSourceAccount(Address value) {
        if (this.sourceAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "sourceAccount");
        return new ImmutableRipplePathFindRequestParams(newValue, this.destinationAccount, this.destinationAmount, this.sendMax, this.sourceCurrencies, this.ledgerHash, this.ledgerIndex);
    }

    public final ImmutableRipplePathFindRequestParams withDestinationAccount(Address value) {
        if (this.destinationAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destinationAccount");
        return new ImmutableRipplePathFindRequestParams(this.sourceAccount, newValue, this.destinationAmount, this.sendMax, this.sourceCurrencies, this.ledgerHash, this.ledgerIndex);
    }

    public final ImmutableRipplePathFindRequestParams withDestinationAmount(CurrencyAmount value) {
        if (this.destinationAmount == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "destinationAmount");
        return new ImmutableRipplePathFindRequestParams(this.sourceAccount, this.destinationAccount, newValue, this.sendMax, this.sourceCurrencies, this.ledgerHash, this.ledgerIndex);
    }

    public final ImmutableRipplePathFindRequestParams withSendMax(CurrencyAmount value) {
        CurrencyAmount newValue = Objects.requireNonNull(value, "sendMax");
        if (this.sendMax == newValue) {
            return this;
        }
        return new ImmutableRipplePathFindRequestParams(this.sourceAccount, this.destinationAccount, this.destinationAmount, newValue, this.sourceCurrencies, this.ledgerHash, this.ledgerIndex);
    }

    public final ImmutableRipplePathFindRequestParams withSendMax(Optional<? extends CurrencyAmount> optional) {
        CurrencyAmount value = optional.orElse(null);
        if (this.sendMax == value) {
            return this;
        }
        return new ImmutableRipplePathFindRequestParams(this.sourceAccount, this.destinationAccount, this.destinationAmount, value, this.sourceCurrencies, this.ledgerHash, this.ledgerIndex);
    }

    public final ImmutableRipplePathFindRequestParams withSourceCurrencies(PathCurrency ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRipplePathFindRequestParams(this.sourceAccount, this.destinationAccount, this.destinationAmount, this.sendMax, (ImmutableList<PathCurrency>)newValue, this.ledgerHash, this.ledgerIndex);
    }

    public final ImmutableRipplePathFindRequestParams withSourceCurrencies(Iterable<? extends PathCurrency> elements) {
        if (this.sourceCurrencies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRipplePathFindRequestParams(this.sourceAccount, this.destinationAccount, this.destinationAmount, this.sendMax, (ImmutableList<PathCurrency>)newValue, this.ledgerHash, this.ledgerIndex);
    }

    public final ImmutableRipplePathFindRequestParams withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableRipplePathFindRequestParams(this.sourceAccount, this.destinationAccount, this.destinationAmount, this.sendMax, this.sourceCurrencies, newValue, this.ledgerIndex);
    }

    public final ImmutableRipplePathFindRequestParams withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableRipplePathFindRequestParams(this.sourceAccount, this.destinationAccount, this.destinationAmount, this.sendMax, this.sourceCurrencies, value, this.ledgerIndex);
    }

    public final ImmutableRipplePathFindRequestParams withLedgerIndex(LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        return new ImmutableRipplePathFindRequestParams(this.sourceAccount, this.destinationAccount, this.destinationAmount, this.sendMax, this.sourceCurrencies, this.ledgerHash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRipplePathFindRequestParams && this.equalTo((ImmutableRipplePathFindRequestParams)another);
    }

    private boolean equalTo(ImmutableRipplePathFindRequestParams another) {
        return this.sourceAccount.equals(another.sourceAccount) && this.destinationAccount.equals(another.destinationAccount) && this.destinationAmount.equals(another.destinationAmount) && Objects.equals(this.sendMax, another.sendMax) && this.sourceCurrencies.equals(another.sourceCurrencies) && Objects.equals(this.ledgerHash, another.ledgerHash) && this.ledgerIndex.equals(another.ledgerIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sourceAccount.hashCode();
        h += (h << 5) + this.destinationAccount.hashCode();
        h += (h << 5) + this.destinationAmount.hashCode();
        h += (h << 5) + Objects.hashCode(this.sendMax);
        h += (h << 5) + this.sourceCurrencies.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + this.ledgerIndex.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RipplePathFindRequestParams").omitNullValues().add("sourceAccount", (Object)this.sourceAccount).add("destinationAccount", (Object)this.destinationAccount).add("destinationAmount", (Object)this.destinationAmount).add("sendMax", (Object)this.sendMax).add("sourceCurrencies", this.sourceCurrencies).add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRipplePathFindRequestParams fromJson(Json json) {
        Builder builder = ImmutableRipplePathFindRequestParams.builder();
        if (json.sourceAccount != null) {
            builder.sourceAccount(json.sourceAccount);
        }
        if (json.destinationAccount != null) {
            builder.destinationAccount(json.destinationAccount);
        }
        if (json.destinationAmount != null) {
            builder.destinationAmount(json.destinationAmount);
        }
        if (json.sendMax != null) {
            builder.sendMax(json.sendMax);
        }
        if (json.sourceCurrencies != null) {
            builder.addAllSourceCurrencies(json.sourceCurrencies);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        return builder.build();
    }

    public static ImmutableRipplePathFindRequestParams copyOf(RipplePathFindRequestParams instance) {
        if (instance instanceof ImmutableRipplePathFindRequestParams) {
            return (ImmutableRipplePathFindRequestParams)instance;
        }
        return ImmutableRipplePathFindRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RipplePathFindRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOURCE_ACCOUNT = 1L;
        private static final long INIT_BIT_DESTINATION_ACCOUNT = 2L;
        private static final long INIT_BIT_DESTINATION_AMOUNT = 4L;
        private long initBits = 7L;
        @Nullable
        private Address sourceAccount;
        @Nullable
        private Address destinationAccount;
        @Nullable
        private CurrencyAmount destinationAmount;
        @Nullable
        private CurrencyAmount sendMax;
        private ImmutableList.Builder<PathCurrency> sourceCurrencies = ImmutableList.builder();
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RipplePathFindRequestParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.sourceAccount(instance.sourceAccount());
            this.destinationAccount(instance.destinationAccount());
            this.destinationAmount(instance.destinationAmount());
            Optional<CurrencyAmount> sendMaxOptional = instance.sendMax();
            if (sendMaxOptional.isPresent()) {
                this.sendMax(sendMaxOptional);
            }
            this.addAllSourceCurrencies(instance.sourceCurrencies());
            Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
            if (ledgerHashOptional.isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            this.ledgerIndex(instance.ledgerIndex());
            return this;
        }

        @JsonProperty(value="source_account")
        @CanIgnoreReturnValue
        public final Builder sourceAccount(Address sourceAccount) {
            this.sourceAccount = Objects.requireNonNull(sourceAccount, "sourceAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="destination_account")
        @CanIgnoreReturnValue
        public final Builder destinationAccount(Address destinationAccount) {
            this.destinationAccount = Objects.requireNonNull(destinationAccount, "destinationAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="destination_amount")
        @CanIgnoreReturnValue
        public final Builder destinationAmount(CurrencyAmount destinationAmount) {
            this.destinationAmount = Objects.requireNonNull(destinationAmount, "destinationAmount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sendMax(CurrencyAmount sendMax) {
            this.sendMax = Objects.requireNonNull(sendMax, "sendMax");
            return this;
        }

        @JsonProperty(value="send_max")
        @CanIgnoreReturnValue
        public final Builder sendMax(Optional<? extends CurrencyAmount> sendMax) {
            this.sendMax = sendMax.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSourceCurrencies(PathCurrency element) {
            this.sourceCurrencies.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSourceCurrencies(PathCurrency ... elements) {
            this.sourceCurrencies.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="source_currencies")
        @CanIgnoreReturnValue
        public final Builder sourceCurrencies(Iterable<? extends PathCurrency> elements) {
            this.sourceCurrencies = ImmutableList.builder();
            return this.addAllSourceCurrencies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSourceCurrencies(Iterable<? extends PathCurrency> elements) {
            this.sourceCurrencies.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        public ImmutableRipplePathFindRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRipplePathFindRequestParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceAccount");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destinationAccount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("destinationAmount");
            }
            return "Cannot build RipplePathFindRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RipplePathFindRequestParams", generator="Immutables")
    static final class Json
    implements RipplePathFindRequestParams {
        @Nullable
        Address sourceAccount;
        @Nullable
        Address destinationAccount;
        @Nullable
        CurrencyAmount destinationAmount;
        @Nullable
        Optional<CurrencyAmount> sendMax = Optional.empty();
        @Nullable
        List<PathCurrency> sourceCurrencies = ImmutableList.of();
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        LedgerIndex ledgerIndex;

        Json() {
        }

        @JsonProperty(value="source_account")
        public void setSourceAccount(Address sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        @JsonProperty(value="destination_account")
        public void setDestinationAccount(Address destinationAccount) {
            this.destinationAccount = destinationAccount;
        }

        @JsonProperty(value="destination_amount")
        public void setDestinationAmount(CurrencyAmount destinationAmount) {
            this.destinationAmount = destinationAmount;
        }

        @JsonProperty(value="send_max")
        public void setSendMax(Optional<CurrencyAmount> sendMax) {
            this.sendMax = sendMax;
        }

        @JsonProperty(value="source_currencies")
        public void setSourceCurrencies(List<PathCurrency> sourceCurrencies) {
            this.sourceCurrencies = sourceCurrencies;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @Override
        public Address sourceAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destinationAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount destinationAmount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CurrencyAmount> sendMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PathCurrency> sourceCurrencies() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

