/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.server;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.server.ServerInfo;
import org.xrpl.xrpl4j.model.client.server.ServerInfoLastClose;
import org.xrpl.xrpl4j.model.client.server.ServerInfoLedger;
import org.xrpl.xrpl4j.model.client.server.ServerInfoLoad;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ServerInfo", generator="Immutables")
@Immutable
public final class ImmutableServerInfo
implements ServerInfo {
    private final boolean amendmentBlocked;
    private final String buildVersion;
    @Nullable
    private final ServerInfoLedger closedLedger;
    private final String completeLedgers;
    private final transient List<Range<UnsignedLong>> completeLedgerRanges;
    private final String hostId;
    private final UnsignedLong ioLatencyMs;
    @Nullable
    private final String jqTransOverflow;
    private final ServerInfoLastClose lastClose;
    @Nullable
    private final ServerInfoLoad load;
    @Nullable
    private final BigDecimal loadFactor;
    @Nullable
    private final BigDecimal loadFactorLocal;
    @Nullable
    private final BigDecimal loadFactorNet;
    @Nullable
    private final BigDecimal loadFactorCluster;
    @Nullable
    private final BigDecimal loadFactorFeeEscalation;
    @Nullable
    private final BigDecimal loadFactorFeeQueue;
    @Nullable
    private final BigDecimal loadFactorServer;
    @Nullable
    private final UnsignedInteger peers;
    private final String publicKeyNode;
    @Nullable
    private final String publicKeyValidator;
    private final String serverState;
    private final String serverStateDurationUs;
    private final ZonedDateTime time;
    private final UnsignedLong upTime;
    @Nullable
    private final ServerInfoLedger validatedLedger;
    private final UnsignedInteger validationQuorum;
    @Nullable
    private final String validatorListExpires;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableServerInfo(Builder builder) {
        this.buildVersion = builder.buildVersion;
        this.closedLedger = builder.closedLedger;
        this.completeLedgers = builder.completeLedgers;
        this.hostId = builder.hostId;
        this.ioLatencyMs = builder.ioLatencyMs;
        this.jqTransOverflow = builder.jqTransOverflow;
        this.lastClose = builder.lastClose;
        this.load = builder.load;
        this.loadFactor = builder.loadFactor;
        this.loadFactorLocal = builder.loadFactorLocal;
        this.loadFactorNet = builder.loadFactorNet;
        this.loadFactorCluster = builder.loadFactorCluster;
        this.loadFactorFeeEscalation = builder.loadFactorFeeEscalation;
        this.loadFactorFeeQueue = builder.loadFactorFeeQueue;
        this.loadFactorServer = builder.loadFactorServer;
        this.peers = builder.peers;
        this.publicKeyNode = builder.publicKeyNode;
        this.publicKeyValidator = builder.publicKeyValidator;
        this.serverState = builder.serverState;
        this.serverStateDurationUs = builder.serverStateDurationUs;
        this.time = builder.time;
        this.upTime = builder.upTime;
        this.validatedLedger = builder.validatedLedger;
        this.validationQuorum = builder.validationQuorum;
        this.validatorListExpires = builder.validatorListExpires;
        if (builder.amendmentBlockedIsSet()) {
            this.initShim.amendmentBlocked(builder.amendmentBlocked);
        }
        this.amendmentBlocked = this.initShim.amendmentBlocked();
        this.completeLedgerRanges = this.initShim.completeLedgerRanges();
        this.initShim = null;
    }

    private ImmutableServerInfo(boolean amendmentBlocked, String buildVersion, @Nullable ServerInfoLedger closedLedger, String completeLedgers, String hostId, UnsignedLong ioLatencyMs, @Nullable String jqTransOverflow, ServerInfoLastClose lastClose, @Nullable ServerInfoLoad load, @Nullable BigDecimal loadFactor, @Nullable BigDecimal loadFactorLocal, @Nullable BigDecimal loadFactorNet, @Nullable BigDecimal loadFactorCluster, @Nullable BigDecimal loadFactorFeeEscalation, @Nullable BigDecimal loadFactorFeeQueue, @Nullable BigDecimal loadFactorServer, @Nullable UnsignedInteger peers, String publicKeyNode, @Nullable String publicKeyValidator, String serverState, String serverStateDurationUs, ZonedDateTime time, UnsignedLong upTime, @Nullable ServerInfoLedger validatedLedger, UnsignedInteger validationQuorum, @Nullable String validatorListExpires) {
        this.initShim.amendmentBlocked(amendmentBlocked);
        this.buildVersion = buildVersion;
        this.closedLedger = closedLedger;
        this.completeLedgers = completeLedgers;
        this.hostId = hostId;
        this.ioLatencyMs = ioLatencyMs;
        this.jqTransOverflow = jqTransOverflow;
        this.lastClose = lastClose;
        this.load = load;
        this.loadFactor = loadFactor;
        this.loadFactorLocal = loadFactorLocal;
        this.loadFactorNet = loadFactorNet;
        this.loadFactorCluster = loadFactorCluster;
        this.loadFactorFeeEscalation = loadFactorFeeEscalation;
        this.loadFactorFeeQueue = loadFactorFeeQueue;
        this.loadFactorServer = loadFactorServer;
        this.peers = peers;
        this.publicKeyNode = publicKeyNode;
        this.publicKeyValidator = publicKeyValidator;
        this.serverState = serverState;
        this.serverStateDurationUs = serverStateDurationUs;
        this.time = time;
        this.upTime = upTime;
        this.validatedLedger = validatedLedger;
        this.validationQuorum = validationQuorum;
        this.validatorListExpires = validatorListExpires;
        this.amendmentBlocked = this.initShim.amendmentBlocked();
        this.completeLedgerRanges = this.initShim.completeLedgerRanges();
        this.initShim = null;
    }

    private boolean amendmentBlockedInitialize() {
        return ServerInfo.super.amendmentBlocked();
    }

    private List<Range<UnsignedLong>> completeLedgerRangesInitialize() {
        return ServerInfo.super.completeLedgerRanges();
    }

    @Override
    @JsonProperty(value="amendment_blocked")
    public boolean amendmentBlocked() {
        InitShim shim = this.initShim;
        return shim != null ? shim.amendmentBlocked() : this.amendmentBlocked;
    }

    @Override
    @JsonProperty(value="build_version")
    public String buildVersion() {
        return this.buildVersion;
    }

    @Override
    @JsonProperty(value="closed_ledger")
    public Optional<ServerInfoLedger> closedLedger() {
        return Optional.ofNullable(this.closedLedger);
    }

    @Override
    @JsonProperty(value="complete_ledgers")
    public String completeLedgers() {
        return this.completeLedgers;
    }

    @Override
    @JsonProperty(value="completeLedgerRanges")
    @JsonIgnore
    public List<Range<UnsignedLong>> completeLedgerRanges() {
        InitShim shim = this.initShim;
        return shim != null ? shim.completeLedgerRanges() : this.completeLedgerRanges;
    }

    @Override
    @JsonProperty(value="hostid")
    public String hostId() {
        return this.hostId;
    }

    @Override
    @JsonProperty(value="io_latency_ms")
    public UnsignedLong ioLatencyMs() {
        return this.ioLatencyMs;
    }

    @Override
    @JsonProperty(value="jq_trans_overflow")
    public Optional<String> jqTransOverflow() {
        return Optional.ofNullable(this.jqTransOverflow);
    }

    @Override
    @JsonProperty(value="last_close")
    public ServerInfoLastClose lastClose() {
        return this.lastClose;
    }

    @Override
    @JsonProperty(value="load")
    public Optional<ServerInfoLoad> load() {
        return Optional.ofNullable(this.load);
    }

    @Override
    @JsonProperty(value="load_factor")
    public Optional<BigDecimal> loadFactor() {
        return Optional.ofNullable(this.loadFactor);
    }

    @Override
    @JsonProperty(value="load_factor_local")
    public Optional<BigDecimal> loadFactorLocal() {
        return Optional.ofNullable(this.loadFactorLocal);
    }

    @Override
    @JsonProperty(value="load_factor_net")
    public Optional<BigDecimal> loadFactorNet() {
        return Optional.ofNullable(this.loadFactorNet);
    }

    @Override
    @JsonProperty(value="load_factor_cluster")
    public Optional<BigDecimal> loadFactorCluster() {
        return Optional.ofNullable(this.loadFactorCluster);
    }

    @Override
    @JsonProperty(value="load_factor_fee_escalation")
    public Optional<BigDecimal> loadFactorFeeEscalation() {
        return Optional.ofNullable(this.loadFactorFeeEscalation);
    }

    @Override
    @JsonProperty(value="load_factor_fee_queue")
    public Optional<BigDecimal> loadFactorFeeQueue() {
        return Optional.ofNullable(this.loadFactorFeeQueue);
    }

    @Override
    @JsonProperty(value="load_factor_server")
    public Optional<BigDecimal> loadFactorServer() {
        return Optional.ofNullable(this.loadFactorServer);
    }

    @Override
    @JsonProperty(value="peers")
    public Optional<UnsignedInteger> peers() {
        return Optional.ofNullable(this.peers);
    }

    @Override
    @JsonProperty(value="pubkey_node")
    public String publicKeyNode() {
        return this.publicKeyNode;
    }

    @Override
    @JsonProperty(value="pubkey_validator")
    public Optional<String> publicKeyValidator() {
        return Optional.ofNullable(this.publicKeyValidator);
    }

    @Override
    @JsonProperty(value="server_state")
    public String serverState() {
        return this.serverState;
    }

    @Override
    @JsonProperty(value="server_state_duration_us")
    public String serverStateDurationUs() {
        return this.serverStateDurationUs;
    }

    @Override
    @JsonProperty(value="time")
    @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSS z")
    public ZonedDateTime time() {
        return this.time;
    }

    @Override
    @JsonProperty(value="uptime")
    public UnsignedLong upTime() {
        return this.upTime;
    }

    @Override
    @JsonProperty(value="validated_ledger")
    public Optional<ServerInfoLedger> validatedLedger() {
        return Optional.ofNullable(this.validatedLedger);
    }

    @Override
    @JsonProperty(value="validation_quorum")
    public UnsignedInteger validationQuorum() {
        return this.validationQuorum;
    }

    @Override
    @JsonProperty(value="validator_list_expires")
    public Optional<String> validatorListExpires() {
        return Optional.ofNullable(this.validatorListExpires);
    }

    public final ImmutableServerInfo withAmendmentBlocked(boolean value) {
        if (this.amendmentBlocked == value) {
            return this;
        }
        return new ImmutableServerInfo(value, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withBuildVersion(String value) {
        String newValue = Objects.requireNonNull(value, "buildVersion");
        if (this.buildVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, newValue, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withClosedLedger(ServerInfoLedger value) {
        ServerInfoLedger newValue = Objects.requireNonNull(value, "closedLedger");
        if (this.closedLedger == newValue) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, newValue, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withClosedLedger(Optional<? extends ServerInfoLedger> optional) {
        ServerInfoLedger value = optional.orElse(null);
        if (this.closedLedger == value) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, value, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withCompleteLedgers(String value) {
        String newValue = Objects.requireNonNull(value, "completeLedgers");
        if (this.completeLedgers.equals(newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, newValue, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withHostId(String value) {
        String newValue = Objects.requireNonNull(value, "hostId");
        if (this.hostId.equals(newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, newValue, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withIoLatencyMs(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "ioLatencyMs");
        if (this.ioLatencyMs.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, newValue, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withJqTransOverflow(String value) {
        String newValue = Objects.requireNonNull(value, "jqTransOverflow");
        if (Objects.equals(this.jqTransOverflow, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, newValue, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withJqTransOverflow(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.jqTransOverflow, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, value, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLastClose(ServerInfoLastClose value) {
        if (this.lastClose == value) {
            return this;
        }
        ServerInfoLastClose newValue = Objects.requireNonNull(value, "lastClose");
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, newValue, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoad(ServerInfoLoad value) {
        ServerInfoLoad newValue = Objects.requireNonNull(value, "load");
        if (this.load == newValue) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, newValue, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoad(Optional<? extends ServerInfoLoad> optional) {
        ServerInfoLoad value = optional.orElse(null);
        if (this.load == value) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, value, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactor(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactor");
        if (Objects.equals(this.loadFactor, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, newValue, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactor(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactor, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, value, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorLocal(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorLocal");
        if (Objects.equals(this.loadFactorLocal, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, newValue, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorLocal(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorLocal, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, value, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorNet(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorNet");
        if (Objects.equals(this.loadFactorNet, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, newValue, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorNet(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorNet, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, value, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorCluster(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorCluster");
        if (Objects.equals(this.loadFactorCluster, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, newValue, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorCluster(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorCluster, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, value, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorFeeEscalation(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorFeeEscalation");
        if (Objects.equals(this.loadFactorFeeEscalation, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, newValue, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorFeeEscalation(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorFeeEscalation, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, value, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorFeeQueue(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorFeeQueue");
        if (Objects.equals(this.loadFactorFeeQueue, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, newValue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorFeeQueue(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorFeeQueue, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, value, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorServer(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "loadFactorServer");
        if (Objects.equals(this.loadFactorServer, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, newValue, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withLoadFactorServer(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.loadFactorServer, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, value, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withPeers(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "peers");
        if (Objects.equals(this.peers, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, newValue, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withPeers(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.peers, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, value, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withPublicKeyNode(String value) {
        String newValue = Objects.requireNonNull(value, "publicKeyNode");
        if (this.publicKeyNode.equals(newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, newValue, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withPublicKeyValidator(String value) {
        String newValue = Objects.requireNonNull(value, "publicKeyValidator");
        if (Objects.equals(this.publicKeyValidator, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, newValue, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withPublicKeyValidator(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.publicKeyValidator, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, value, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withServerState(String value) {
        String newValue = Objects.requireNonNull(value, "serverState");
        if (this.serverState.equals(newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, newValue, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withServerStateDurationUs(String value) {
        String newValue = Objects.requireNonNull(value, "serverStateDurationUs");
        if (this.serverStateDurationUs.equals(newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, newValue, this.time, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withTime(ZonedDateTime value) {
        if (this.time == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "time");
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, newValue, this.upTime, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withUpTime(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "upTime");
        if (this.upTime.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, newValue, this.validatedLedger, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withValidatedLedger(ServerInfoLedger value) {
        ServerInfoLedger newValue = Objects.requireNonNull(value, "validatedLedger");
        if (this.validatedLedger == newValue) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, newValue, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withValidatedLedger(Optional<? extends ServerInfoLedger> optional) {
        ServerInfoLedger value = optional.orElse(null);
        if (this.validatedLedger == value) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, value, this.validationQuorum, this.validatorListExpires);
    }

    public final ImmutableServerInfo withValidationQuorum(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "validationQuorum");
        if (this.validationQuorum.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, newValue, this.validatorListExpires);
    }

    public final ImmutableServerInfo withValidatorListExpires(String value) {
        String newValue = Objects.requireNonNull(value, "validatorListExpires");
        if (Objects.equals(this.validatorListExpires, newValue)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, newValue);
    }

    public final ImmutableServerInfo withValidatorListExpires(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.validatorListExpires, value)) {
            return this;
        }
        return new ImmutableServerInfo(this.amendmentBlocked, this.buildVersion, this.closedLedger, this.completeLedgers, this.hostId, this.ioLatencyMs, this.jqTransOverflow, this.lastClose, this.load, this.loadFactor, this.loadFactorLocal, this.loadFactorNet, this.loadFactorCluster, this.loadFactorFeeEscalation, this.loadFactorFeeQueue, this.loadFactorServer, this.peers, this.publicKeyNode, this.publicKeyValidator, this.serverState, this.serverStateDurationUs, this.time, this.upTime, this.validatedLedger, this.validationQuorum, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServerInfo && this.equalTo((ImmutableServerInfo)another);
    }

    private boolean equalTo(ImmutableServerInfo another) {
        return this.amendmentBlocked == another.amendmentBlocked && this.buildVersion.equals(another.buildVersion) && Objects.equals(this.closedLedger, another.closedLedger) && this.completeLedgers.equals(another.completeLedgers) && this.completeLedgerRanges.equals(another.completeLedgerRanges) && this.hostId.equals(another.hostId) && this.ioLatencyMs.equals((Object)another.ioLatencyMs) && Objects.equals(this.jqTransOverflow, another.jqTransOverflow) && this.lastClose.equals(another.lastClose) && Objects.equals(this.load, another.load) && Objects.equals(this.loadFactor, another.loadFactor) && Objects.equals(this.loadFactorLocal, another.loadFactorLocal) && Objects.equals(this.loadFactorNet, another.loadFactorNet) && Objects.equals(this.loadFactorCluster, another.loadFactorCluster) && Objects.equals(this.loadFactorFeeEscalation, another.loadFactorFeeEscalation) && Objects.equals(this.loadFactorFeeQueue, another.loadFactorFeeQueue) && Objects.equals(this.loadFactorServer, another.loadFactorServer) && Objects.equals(this.peers, another.peers) && this.publicKeyNode.equals(another.publicKeyNode) && Objects.equals(this.publicKeyValidator, another.publicKeyValidator) && this.serverState.equals(another.serverState) && this.serverStateDurationUs.equals(another.serverStateDurationUs) && this.time.equals(another.time) && this.upTime.equals((Object)another.upTime) && Objects.equals(this.validatedLedger, another.validatedLedger) && this.validationQuorum.equals((Object)another.validationQuorum) && Objects.equals(this.validatorListExpires, another.validatorListExpires);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.amendmentBlocked);
        h += (h << 5) + this.buildVersion.hashCode();
        h += (h << 5) + Objects.hashCode(this.closedLedger);
        h += (h << 5) + this.completeLedgers.hashCode();
        h += (h << 5) + this.completeLedgerRanges.hashCode();
        h += (h << 5) + this.hostId.hashCode();
        h += (h << 5) + this.ioLatencyMs.hashCode();
        h += (h << 5) + Objects.hashCode(this.jqTransOverflow);
        h += (h << 5) + this.lastClose.hashCode();
        h += (h << 5) + Objects.hashCode(this.load);
        h += (h << 5) + Objects.hashCode(this.loadFactor);
        h += (h << 5) + Objects.hashCode(this.loadFactorLocal);
        h += (h << 5) + Objects.hashCode(this.loadFactorNet);
        h += (h << 5) + Objects.hashCode(this.loadFactorCluster);
        h += (h << 5) + Objects.hashCode(this.loadFactorFeeEscalation);
        h += (h << 5) + Objects.hashCode(this.loadFactorFeeQueue);
        h += (h << 5) + Objects.hashCode(this.loadFactorServer);
        h += (h << 5) + Objects.hashCode(this.peers);
        h += (h << 5) + this.publicKeyNode.hashCode();
        h += (h << 5) + Objects.hashCode(this.publicKeyValidator);
        h += (h << 5) + this.serverState.hashCode();
        h += (h << 5) + this.serverStateDurationUs.hashCode();
        h += (h << 5) + this.time.hashCode();
        h += (h << 5) + this.upTime.hashCode();
        h += (h << 5) + Objects.hashCode(this.validatedLedger);
        h += (h << 5) + this.validationQuorum.hashCode();
        h += (h << 5) + Objects.hashCode(this.validatorListExpires);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServerInfo").omitNullValues().add("amendmentBlocked", this.amendmentBlocked).add("buildVersion", (Object)this.buildVersion).add("closedLedger", (Object)this.closedLedger).add("completeLedgers", (Object)this.completeLedgers).add("completeLedgerRanges", this.completeLedgerRanges).add("hostId", (Object)this.hostId).add("ioLatencyMs", (Object)this.ioLatencyMs).add("jqTransOverflow", (Object)this.jqTransOverflow).add("lastClose", (Object)this.lastClose).add("load", (Object)this.load).add("loadFactor", (Object)this.loadFactor).add("loadFactorLocal", (Object)this.loadFactorLocal).add("loadFactorNet", (Object)this.loadFactorNet).add("loadFactorCluster", (Object)this.loadFactorCluster).add("loadFactorFeeEscalation", (Object)this.loadFactorFeeEscalation).add("loadFactorFeeQueue", (Object)this.loadFactorFeeQueue).add("loadFactorServer", (Object)this.loadFactorServer).add("peers", (Object)this.peers).add("publicKeyNode", (Object)this.publicKeyNode).add("publicKeyValidator", (Object)this.publicKeyValidator).add("serverState", (Object)this.serverState).add("serverStateDurationUs", (Object)this.serverStateDurationUs).add("time", (Object)this.time).add("upTime", (Object)this.upTime).add("validatedLedger", (Object)this.validatedLedger).add("validationQuorum", (Object)this.validationQuorum).add("validatorListExpires", (Object)this.validatorListExpires).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServerInfo fromJson(Json json) {
        Builder builder = ImmutableServerInfo.builder();
        if (json.amendmentBlockedIsSet) {
            builder.amendmentBlocked(json.amendmentBlocked);
        }
        if (json.buildVersion != null) {
            builder.buildVersion(json.buildVersion);
        }
        if (json.closedLedger != null) {
            builder.closedLedger(json.closedLedger);
        }
        if (json.completeLedgers != null) {
            builder.completeLedgers(json.completeLedgers);
        }
        if (json.hostId != null) {
            builder.hostId(json.hostId);
        }
        if (json.ioLatencyMs != null) {
            builder.ioLatencyMs(json.ioLatencyMs);
        }
        if (json.jqTransOverflow != null) {
            builder.jqTransOverflow(json.jqTransOverflow);
        }
        if (json.lastClose != null) {
            builder.lastClose(json.lastClose);
        }
        if (json.load != null) {
            builder.load(json.load);
        }
        if (json.loadFactor != null) {
            builder.loadFactor(json.loadFactor);
        }
        if (json.loadFactorLocal != null) {
            builder.loadFactorLocal(json.loadFactorLocal);
        }
        if (json.loadFactorNet != null) {
            builder.loadFactorNet(json.loadFactorNet);
        }
        if (json.loadFactorCluster != null) {
            builder.loadFactorCluster(json.loadFactorCluster);
        }
        if (json.loadFactorFeeEscalation != null) {
            builder.loadFactorFeeEscalation(json.loadFactorFeeEscalation);
        }
        if (json.loadFactorFeeQueue != null) {
            builder.loadFactorFeeQueue(json.loadFactorFeeQueue);
        }
        if (json.loadFactorServer != null) {
            builder.loadFactorServer(json.loadFactorServer);
        }
        if (json.peers != null) {
            builder.peers(json.peers);
        }
        if (json.publicKeyNode != null) {
            builder.publicKeyNode(json.publicKeyNode);
        }
        if (json.publicKeyValidator != null) {
            builder.publicKeyValidator(json.publicKeyValidator);
        }
        if (json.serverState != null) {
            builder.serverState(json.serverState);
        }
        if (json.serverStateDurationUs != null) {
            builder.serverStateDurationUs(json.serverStateDurationUs);
        }
        if (json.time != null) {
            builder.time(json.time);
        }
        if (json.upTime != null) {
            builder.upTime(json.upTime);
        }
        if (json.validatedLedger != null) {
            builder.validatedLedger(json.validatedLedger);
        }
        if (json.validationQuorum != null) {
            builder.validationQuorum(json.validationQuorum);
        }
        if (json.validatorListExpires != null) {
            builder.validatorListExpires(json.validatorListExpires);
        }
        return builder.build();
    }

    public static ImmutableServerInfo copyOf(ServerInfo instance) {
        if (instance instanceof ImmutableServerInfo) {
            return (ImmutableServerInfo)instance;
        }
        return ImmutableServerInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServerInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BUILD_VERSION = 1L;
        private static final long INIT_BIT_COMPLETE_LEDGERS = 2L;
        private static final long INIT_BIT_HOST_ID = 4L;
        private static final long INIT_BIT_IO_LATENCY_MS = 8L;
        private static final long INIT_BIT_LAST_CLOSE = 16L;
        private static final long INIT_BIT_PUBLIC_KEY_NODE = 32L;
        private static final long INIT_BIT_SERVER_STATE = 64L;
        private static final long INIT_BIT_SERVER_STATE_DURATION_US = 128L;
        private static final long INIT_BIT_TIME = 256L;
        private static final long INIT_BIT_UP_TIME = 512L;
        private static final long INIT_BIT_VALIDATION_QUORUM = 1024L;
        private static final long OPT_BIT_AMENDMENT_BLOCKED = 1L;
        private long initBits = 2047L;
        private long optBits;
        private boolean amendmentBlocked;
        @Nullable
        private String buildVersion;
        @Nullable
        private ServerInfoLedger closedLedger;
        @Nullable
        private String completeLedgers;
        @Nullable
        private String hostId;
        @Nullable
        private UnsignedLong ioLatencyMs;
        @Nullable
        private String jqTransOverflow;
        @Nullable
        private ServerInfoLastClose lastClose;
        @Nullable
        private ServerInfoLoad load;
        @Nullable
        private BigDecimal loadFactor;
        @Nullable
        private BigDecimal loadFactorLocal;
        @Nullable
        private BigDecimal loadFactorNet;
        @Nullable
        private BigDecimal loadFactorCluster;
        @Nullable
        private BigDecimal loadFactorFeeEscalation;
        @Nullable
        private BigDecimal loadFactorFeeQueue;
        @Nullable
        private BigDecimal loadFactorServer;
        @Nullable
        private UnsignedInteger peers;
        @Nullable
        private String publicKeyNode;
        @Nullable
        private String publicKeyValidator;
        @Nullable
        private String serverState;
        @Nullable
        private String serverStateDurationUs;
        @Nullable
        private ZonedDateTime time;
        @Nullable
        private UnsignedLong upTime;
        @Nullable
        private ServerInfoLedger validatedLedger;
        @Nullable
        private UnsignedInteger validationQuorum;
        @Nullable
        private String validatorListExpires;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerInfo instance) {
            Optional<UnsignedInteger> peersOptional;
            Optional<BigDecimal> loadFactorServerOptional;
            Optional<BigDecimal> loadFactorFeeQueueOptional;
            Optional<BigDecimal> loadFactorFeeEscalationOptional;
            Optional<BigDecimal> loadFactorClusterOptional;
            Optional<BigDecimal> loadFactorNetOptional;
            Optional<BigDecimal> loadFactorLocalOptional;
            Optional<BigDecimal> loadFactorOptional;
            Objects.requireNonNull(instance, "instance");
            this.amendmentBlocked(instance.amendmentBlocked());
            this.buildVersion(instance.buildVersion());
            Optional<ServerInfoLedger> closedLedgerOptional = instance.closedLedger();
            if (closedLedgerOptional.isPresent()) {
                this.closedLedger(closedLedgerOptional);
            }
            this.completeLedgers(instance.completeLedgers());
            this.hostId(instance.hostId());
            this.ioLatencyMs(instance.ioLatencyMs());
            Optional<String> jqTransOverflowOptional = instance.jqTransOverflow();
            if (jqTransOverflowOptional.isPresent()) {
                this.jqTransOverflow(jqTransOverflowOptional);
            }
            this.lastClose(instance.lastClose());
            Optional<ServerInfoLoad> loadOptional = instance.load();
            if (loadOptional.isPresent()) {
                this.load(loadOptional);
            }
            if ((loadFactorOptional = instance.loadFactor()).isPresent()) {
                this.loadFactor(loadFactorOptional);
            }
            if ((loadFactorLocalOptional = instance.loadFactorLocal()).isPresent()) {
                this.loadFactorLocal(loadFactorLocalOptional);
            }
            if ((loadFactorNetOptional = instance.loadFactorNet()).isPresent()) {
                this.loadFactorNet(loadFactorNetOptional);
            }
            if ((loadFactorClusterOptional = instance.loadFactorCluster()).isPresent()) {
                this.loadFactorCluster(loadFactorClusterOptional);
            }
            if ((loadFactorFeeEscalationOptional = instance.loadFactorFeeEscalation()).isPresent()) {
                this.loadFactorFeeEscalation(loadFactorFeeEscalationOptional);
            }
            if ((loadFactorFeeQueueOptional = instance.loadFactorFeeQueue()).isPresent()) {
                this.loadFactorFeeQueue(loadFactorFeeQueueOptional);
            }
            if ((loadFactorServerOptional = instance.loadFactorServer()).isPresent()) {
                this.loadFactorServer(loadFactorServerOptional);
            }
            if ((peersOptional = instance.peers()).isPresent()) {
                this.peers(peersOptional);
            }
            this.publicKeyNode(instance.publicKeyNode());
            Optional<String> publicKeyValidatorOptional = instance.publicKeyValidator();
            if (publicKeyValidatorOptional.isPresent()) {
                this.publicKeyValidator(publicKeyValidatorOptional);
            }
            this.serverState(instance.serverState());
            this.serverStateDurationUs(instance.serverStateDurationUs());
            this.time(instance.time());
            this.upTime(instance.upTime());
            Optional<ServerInfoLedger> validatedLedgerOptional = instance.validatedLedger();
            if (validatedLedgerOptional.isPresent()) {
                this.validatedLedger(validatedLedgerOptional);
            }
            this.validationQuorum(instance.validationQuorum());
            Optional<String> validatorListExpiresOptional = instance.validatorListExpires();
            if (validatorListExpiresOptional.isPresent()) {
                this.validatorListExpires(validatorListExpiresOptional);
            }
            return this;
        }

        @JsonProperty(value="amendment_blocked")
        @CanIgnoreReturnValue
        public final Builder amendmentBlocked(boolean amendmentBlocked) {
            this.amendmentBlocked = amendmentBlocked;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="build_version")
        @CanIgnoreReturnValue
        public final Builder buildVersion(String buildVersion) {
            this.buildVersion = Objects.requireNonNull(buildVersion, "buildVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closedLedger(ServerInfoLedger closedLedger) {
            this.closedLedger = Objects.requireNonNull(closedLedger, "closedLedger");
            return this;
        }

        @JsonProperty(value="closed_ledger")
        @CanIgnoreReturnValue
        public final Builder closedLedger(Optional<? extends ServerInfoLedger> closedLedger) {
            this.closedLedger = closedLedger.orElse(null);
            return this;
        }

        @JsonProperty(value="complete_ledgers")
        @CanIgnoreReturnValue
        public final Builder completeLedgers(String completeLedgers) {
            this.completeLedgers = Objects.requireNonNull(completeLedgers, "completeLedgers");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="hostid")
        @CanIgnoreReturnValue
        public final Builder hostId(String hostId) {
            this.hostId = Objects.requireNonNull(hostId, "hostId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="io_latency_ms")
        @CanIgnoreReturnValue
        public final Builder ioLatencyMs(UnsignedLong ioLatencyMs) {
            this.ioLatencyMs = Objects.requireNonNull(ioLatencyMs, "ioLatencyMs");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jqTransOverflow(String jqTransOverflow) {
            this.jqTransOverflow = Objects.requireNonNull(jqTransOverflow, "jqTransOverflow");
            return this;
        }

        @JsonProperty(value="jq_trans_overflow")
        @CanIgnoreReturnValue
        public final Builder jqTransOverflow(Optional<String> jqTransOverflow) {
            this.jqTransOverflow = jqTransOverflow.orElse(null);
            return this;
        }

        @JsonProperty(value="last_close")
        @CanIgnoreReturnValue
        public final Builder lastClose(ServerInfoLastClose lastClose) {
            this.lastClose = Objects.requireNonNull(lastClose, "lastClose");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder load(ServerInfoLoad load) {
            this.load = Objects.requireNonNull(load, "load");
            return this;
        }

        @JsonProperty(value="load")
        @CanIgnoreReturnValue
        public final Builder load(Optional<? extends ServerInfoLoad> load) {
            this.load = load.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactor(BigDecimal loadFactor) {
            this.loadFactor = Objects.requireNonNull(loadFactor, "loadFactor");
            return this;
        }

        @JsonProperty(value="load_factor")
        @CanIgnoreReturnValue
        public final Builder loadFactor(Optional<? extends BigDecimal> loadFactor) {
            this.loadFactor = loadFactor.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorLocal(BigDecimal loadFactorLocal) {
            this.loadFactorLocal = Objects.requireNonNull(loadFactorLocal, "loadFactorLocal");
            return this;
        }

        @JsonProperty(value="load_factor_local")
        @CanIgnoreReturnValue
        public final Builder loadFactorLocal(Optional<? extends BigDecimal> loadFactorLocal) {
            this.loadFactorLocal = loadFactorLocal.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorNet(BigDecimal loadFactorNet) {
            this.loadFactorNet = Objects.requireNonNull(loadFactorNet, "loadFactorNet");
            return this;
        }

        @JsonProperty(value="load_factor_net")
        @CanIgnoreReturnValue
        public final Builder loadFactorNet(Optional<? extends BigDecimal> loadFactorNet) {
            this.loadFactorNet = loadFactorNet.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorCluster(BigDecimal loadFactorCluster) {
            this.loadFactorCluster = Objects.requireNonNull(loadFactorCluster, "loadFactorCluster");
            return this;
        }

        @JsonProperty(value="load_factor_cluster")
        @CanIgnoreReturnValue
        public final Builder loadFactorCluster(Optional<? extends BigDecimal> loadFactorCluster) {
            this.loadFactorCluster = loadFactorCluster.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorFeeEscalation(BigDecimal loadFactorFeeEscalation) {
            this.loadFactorFeeEscalation = Objects.requireNonNull(loadFactorFeeEscalation, "loadFactorFeeEscalation");
            return this;
        }

        @JsonProperty(value="load_factor_fee_escalation")
        @CanIgnoreReturnValue
        public final Builder loadFactorFeeEscalation(Optional<? extends BigDecimal> loadFactorFeeEscalation) {
            this.loadFactorFeeEscalation = loadFactorFeeEscalation.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorFeeQueue(BigDecimal loadFactorFeeQueue) {
            this.loadFactorFeeQueue = Objects.requireNonNull(loadFactorFeeQueue, "loadFactorFeeQueue");
            return this;
        }

        @JsonProperty(value="load_factor_fee_queue")
        @CanIgnoreReturnValue
        public final Builder loadFactorFeeQueue(Optional<? extends BigDecimal> loadFactorFeeQueue) {
            this.loadFactorFeeQueue = loadFactorFeeQueue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder loadFactorServer(BigDecimal loadFactorServer) {
            this.loadFactorServer = Objects.requireNonNull(loadFactorServer, "loadFactorServer");
            return this;
        }

        @JsonProperty(value="load_factor_server")
        @CanIgnoreReturnValue
        public final Builder loadFactorServer(Optional<? extends BigDecimal> loadFactorServer) {
            this.loadFactorServer = loadFactorServer.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder peers(UnsignedInteger peers) {
            this.peers = Objects.requireNonNull(peers, "peers");
            return this;
        }

        @JsonProperty(value="peers")
        @CanIgnoreReturnValue
        public final Builder peers(Optional<? extends UnsignedInteger> peers) {
            this.peers = peers.orElse(null);
            return this;
        }

        @JsonProperty(value="pubkey_node")
        @CanIgnoreReturnValue
        public final Builder publicKeyNode(String publicKeyNode) {
            this.publicKeyNode = Objects.requireNonNull(publicKeyNode, "publicKeyNode");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKeyValidator(String publicKeyValidator) {
            this.publicKeyValidator = Objects.requireNonNull(publicKeyValidator, "publicKeyValidator");
            return this;
        }

        @JsonProperty(value="pubkey_validator")
        @CanIgnoreReturnValue
        public final Builder publicKeyValidator(Optional<String> publicKeyValidator) {
            this.publicKeyValidator = publicKeyValidator.orElse(null);
            return this;
        }

        @JsonProperty(value="server_state")
        @CanIgnoreReturnValue
        public final Builder serverState(String serverState) {
            this.serverState = Objects.requireNonNull(serverState, "serverState");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="server_state_duration_us")
        @CanIgnoreReturnValue
        public final Builder serverStateDurationUs(String serverStateDurationUs) {
            this.serverStateDurationUs = Objects.requireNonNull(serverStateDurationUs, "serverStateDurationUs");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="time")
        @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSS z")
        @CanIgnoreReturnValue
        public final Builder time(ZonedDateTime time) {
            this.time = Objects.requireNonNull(time, "time");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="uptime")
        @CanIgnoreReturnValue
        public final Builder upTime(UnsignedLong upTime) {
            this.upTime = Objects.requireNonNull(upTime, "upTime");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validatedLedger(ServerInfoLedger validatedLedger) {
            this.validatedLedger = Objects.requireNonNull(validatedLedger, "validatedLedger");
            return this;
        }

        @JsonProperty(value="validated_ledger")
        @CanIgnoreReturnValue
        public final Builder validatedLedger(Optional<? extends ServerInfoLedger> validatedLedger) {
            this.validatedLedger = validatedLedger.orElse(null);
            return this;
        }

        @JsonProperty(value="validation_quorum")
        @CanIgnoreReturnValue
        public final Builder validationQuorum(UnsignedInteger validationQuorum) {
            this.validationQuorum = Objects.requireNonNull(validationQuorum, "validationQuorum");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validatorListExpires(String validatorListExpires) {
            this.validatorListExpires = Objects.requireNonNull(validatorListExpires, "validatorListExpires");
            return this;
        }

        @JsonProperty(value="validator_list_expires")
        @CanIgnoreReturnValue
        public final Builder validatorListExpires(Optional<String> validatorListExpires) {
            this.validatorListExpires = validatorListExpires.orElse(null);
            return this;
        }

        public ImmutableServerInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServerInfo(this);
        }

        private boolean amendmentBlockedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("buildVersion");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("completeLedgers");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hostId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ioLatencyMs");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("lastClose");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("publicKeyNode");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("serverState");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("serverStateDurationUs");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("time");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("upTime");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("validationQuorum");
            }
            return "Cannot build ServerInfo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServerInfo", generator="Immutables")
    static final class Json
    implements ServerInfo {
        boolean amendmentBlocked;
        boolean amendmentBlockedIsSet;
        @Nullable
        String buildVersion;
        @Nullable
        Optional<ServerInfoLedger> closedLedger = Optional.empty();
        @Nullable
        String completeLedgers;
        @Nullable
        String hostId;
        @Nullable
        UnsignedLong ioLatencyMs;
        @Nullable
        Optional<String> jqTransOverflow = Optional.empty();
        @Nullable
        ServerInfoLastClose lastClose;
        @Nullable
        Optional<ServerInfoLoad> load = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactor = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorLocal = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorNet = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorCluster = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorFeeEscalation = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorFeeQueue = Optional.empty();
        @Nullable
        Optional<BigDecimal> loadFactorServer = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> peers = Optional.empty();
        @Nullable
        String publicKeyNode;
        @Nullable
        Optional<String> publicKeyValidator = Optional.empty();
        @Nullable
        String serverState;
        @Nullable
        String serverStateDurationUs;
        @Nullable
        ZonedDateTime time;
        @Nullable
        UnsignedLong upTime;
        @Nullable
        Optional<ServerInfoLedger> validatedLedger = Optional.empty();
        @Nullable
        UnsignedInteger validationQuorum;
        @Nullable
        Optional<String> validatorListExpires = Optional.empty();

        Json() {
        }

        @JsonProperty(value="amendment_blocked")
        public void setAmendmentBlocked(boolean amendmentBlocked) {
            this.amendmentBlocked = amendmentBlocked;
            this.amendmentBlockedIsSet = true;
        }

        @JsonProperty(value="build_version")
        public void setBuildVersion(String buildVersion) {
            this.buildVersion = buildVersion;
        }

        @JsonProperty(value="closed_ledger")
        public void setClosedLedger(Optional<ServerInfoLedger> closedLedger) {
            this.closedLedger = closedLedger;
        }

        @JsonProperty(value="complete_ledgers")
        public void setCompleteLedgers(String completeLedgers) {
            this.completeLedgers = completeLedgers;
        }

        @JsonProperty(value="hostid")
        public void setHostId(String hostId) {
            this.hostId = hostId;
        }

        @JsonProperty(value="io_latency_ms")
        public void setIoLatencyMs(UnsignedLong ioLatencyMs) {
            this.ioLatencyMs = ioLatencyMs;
        }

        @JsonProperty(value="jq_trans_overflow")
        public void setJqTransOverflow(Optional<String> jqTransOverflow) {
            this.jqTransOverflow = jqTransOverflow;
        }

        @JsonProperty(value="last_close")
        public void setLastClose(ServerInfoLastClose lastClose) {
            this.lastClose = lastClose;
        }

        @JsonProperty(value="load")
        public void setLoad(Optional<ServerInfoLoad> load) {
            this.load = load;
        }

        @JsonProperty(value="load_factor")
        public void setLoadFactor(Optional<BigDecimal> loadFactor) {
            this.loadFactor = loadFactor;
        }

        @JsonProperty(value="load_factor_local")
        public void setLoadFactorLocal(Optional<BigDecimal> loadFactorLocal) {
            this.loadFactorLocal = loadFactorLocal;
        }

        @JsonProperty(value="load_factor_net")
        public void setLoadFactorNet(Optional<BigDecimal> loadFactorNet) {
            this.loadFactorNet = loadFactorNet;
        }

        @JsonProperty(value="load_factor_cluster")
        public void setLoadFactorCluster(Optional<BigDecimal> loadFactorCluster) {
            this.loadFactorCluster = loadFactorCluster;
        }

        @JsonProperty(value="load_factor_fee_escalation")
        public void setLoadFactorFeeEscalation(Optional<BigDecimal> loadFactorFeeEscalation) {
            this.loadFactorFeeEscalation = loadFactorFeeEscalation;
        }

        @JsonProperty(value="load_factor_fee_queue")
        public void setLoadFactorFeeQueue(Optional<BigDecimal> loadFactorFeeQueue) {
            this.loadFactorFeeQueue = loadFactorFeeQueue;
        }

        @JsonProperty(value="load_factor_server")
        public void setLoadFactorServer(Optional<BigDecimal> loadFactorServer) {
            this.loadFactorServer = loadFactorServer;
        }

        @JsonProperty(value="peers")
        public void setPeers(Optional<UnsignedInteger> peers) {
            this.peers = peers;
        }

        @JsonProperty(value="pubkey_node")
        public void setPublicKeyNode(String publicKeyNode) {
            this.publicKeyNode = publicKeyNode;
        }

        @JsonProperty(value="pubkey_validator")
        public void setPublicKeyValidator(Optional<String> publicKeyValidator) {
            this.publicKeyValidator = publicKeyValidator;
        }

        @JsonProperty(value="server_state")
        public void setServerState(String serverState) {
            this.serverState = serverState;
        }

        @JsonProperty(value="server_state_duration_us")
        public void setServerStateDurationUs(String serverStateDurationUs) {
            this.serverStateDurationUs = serverStateDurationUs;
        }

        @JsonProperty(value="time")
        @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSS z")
        public void setTime(ZonedDateTime time) {
            this.time = time;
        }

        @JsonProperty(value="uptime")
        public void setUpTime(UnsignedLong upTime) {
            this.upTime = upTime;
        }

        @JsonProperty(value="validated_ledger")
        public void setValidatedLedger(Optional<ServerInfoLedger> validatedLedger) {
            this.validatedLedger = validatedLedger;
        }

        @JsonProperty(value="validation_quorum")
        public void setValidationQuorum(UnsignedInteger validationQuorum) {
            this.validationQuorum = validationQuorum;
        }

        @JsonProperty(value="validator_list_expires")
        public void setValidatorListExpires(Optional<String> validatorListExpires) {
            this.validatorListExpires = validatorListExpires;
        }

        @Override
        public boolean amendmentBlocked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String buildVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServerInfoLedger> closedLedger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String completeLedgers() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public List<Range<UnsignedLong>> completeLedgerRanges() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String hostId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedLong ioLatencyMs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> jqTransOverflow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServerInfoLastClose lastClose() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServerInfoLoad> load() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorLocal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorNet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorCluster() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorFeeEscalation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorFeeQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> loadFactorServer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> peers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String publicKeyNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> publicKeyValidator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String serverState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String serverStateDurationUs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime time() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedLong upTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ServerInfoLedger> validatedLedger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger validationQuorum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> validatorListExpires() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ServerInfo", generator="Immutables")
    private final class InitShim {
        private byte amendmentBlockedBuildStage = 0;
        private boolean amendmentBlocked;
        private byte completeLedgerRangesBuildStage = 0;
        private List<Range<UnsignedLong>> completeLedgerRanges;

        private InitShim() {
        }

        boolean amendmentBlocked() {
            if (this.amendmentBlockedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.amendmentBlockedBuildStage == 0) {
                this.amendmentBlockedBuildStage = (byte)-1;
                this.amendmentBlocked = ImmutableServerInfo.this.amendmentBlockedInitialize();
                this.amendmentBlockedBuildStage = 1;
            }
            return this.amendmentBlocked;
        }

        void amendmentBlocked(boolean amendmentBlocked) {
            this.amendmentBlocked = amendmentBlocked;
            this.amendmentBlockedBuildStage = 1;
        }

        List<Range<UnsignedLong>> completeLedgerRanges() {
            if (this.completeLedgerRangesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.completeLedgerRangesBuildStage == 0) {
                this.completeLedgerRangesBuildStage = (byte)-1;
                this.completeLedgerRanges = Objects.requireNonNull(ImmutableServerInfo.this.completeLedgerRangesInitialize(), "completeLedgerRanges");
                this.completeLedgerRangesBuildStage = 1;
            }
            return this.completeLedgerRanges;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.amendmentBlockedBuildStage == -1) {
                attributes.add("amendmentBlocked");
            }
            if (this.completeLedgerRangesBuildStage == -1) {
                attributes.add("completeLedgerRanges");
            }
            return "Cannot build ServerInfo, attribute initializers form cycle " + attributes;
        }
    }
}

