/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.server;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.server.JobType;
import org.xrpl.xrpl4j.model.client.server.ServerInfoLoad;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ServerInfoLoad", generator="Immutables")
@Immutable
public final class ImmutableServerInfoLoad
implements ServerInfoLoad {
    private final ImmutableList<JobType> jobTypes;
    private final UnsignedLong threads;

    private ImmutableServerInfoLoad(ImmutableList<JobType> jobTypes, UnsignedLong threads) {
        this.jobTypes = jobTypes;
        this.threads = threads;
    }

    @JsonProperty(value="job_types")
    public ImmutableList<JobType> jobTypes() {
        return this.jobTypes;
    }

    @Override
    @JsonProperty(value="threads")
    public UnsignedLong threads() {
        return this.threads;
    }

    public final ImmutableServerInfoLoad withJobTypes(JobType ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableServerInfoLoad((ImmutableList<JobType>)newValue, this.threads);
    }

    public final ImmutableServerInfoLoad withJobTypes(Iterable<? extends JobType> elements) {
        if (this.jobTypes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableServerInfoLoad((ImmutableList<JobType>)newValue, this.threads);
    }

    public final ImmutableServerInfoLoad withThreads(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "threads");
        if (this.threads.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerInfoLoad(this.jobTypes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServerInfoLoad && this.equalTo((ImmutableServerInfoLoad)another);
    }

    private boolean equalTo(ImmutableServerInfoLoad another) {
        return this.jobTypes.equals(another.jobTypes) && this.threads.equals((Object)another.threads);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.jobTypes.hashCode();
        h += (h << 5) + this.threads.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServerInfoLoad").omitNullValues().add("jobTypes", this.jobTypes).add("threads", (Object)this.threads).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServerInfoLoad fromJson(Json json) {
        Builder builder = ImmutableServerInfoLoad.builder();
        if (json.jobTypes != null) {
            builder.addAllJobTypes(json.jobTypes);
        }
        if (json.threads != null) {
            builder.threads(json.threads);
        }
        return builder.build();
    }

    public static ImmutableServerInfoLoad copyOf(ServerInfoLoad instance) {
        if (instance instanceof ImmutableServerInfoLoad) {
            return (ImmutableServerInfoLoad)instance;
        }
        return ImmutableServerInfoLoad.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServerInfoLoad", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_THREADS = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<JobType> jobTypes = ImmutableList.builder();
        @Nullable
        private UnsignedLong threads;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerInfoLoad instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllJobTypes(instance.jobTypes());
            this.threads(instance.threads());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addJobTypes(JobType element) {
            this.jobTypes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addJobTypes(JobType ... elements) {
            this.jobTypes.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="job_types")
        @CanIgnoreReturnValue
        public final Builder jobTypes(Iterable<? extends JobType> elements) {
            this.jobTypes = ImmutableList.builder();
            return this.addAllJobTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllJobTypes(Iterable<? extends JobType> elements) {
            this.jobTypes.addAll(elements);
            return this;
        }

        @JsonProperty(value="threads")
        @CanIgnoreReturnValue
        public final Builder threads(UnsignedLong threads) {
            this.threads = Objects.requireNonNull(threads, "threads");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableServerInfoLoad build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServerInfoLoad(this.jobTypes.build(), this.threads);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("threads");
            }
            return "Cannot build ServerInfoLoad, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServerInfoLoad", generator="Immutables")
    static final class Json
    implements ServerInfoLoad {
        @Nullable
        List<JobType> jobTypes = ImmutableList.of();
        @Nullable
        UnsignedLong threads;

        Json() {
        }

        @JsonProperty(value="job_types")
        public void setJobTypes(List<JobType> jobTypes) {
            this.jobTypes = jobTypes;
        }

        @JsonProperty(value="threads")
        public void setThreads(UnsignedLong threads) {
            this.threads = threads;
        }

        @Override
        public List<JobType> jobTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedLong threads() {
            throw new UnsupportedOperationException();
        }
    }
}

