/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.server;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xrpl.xrpl4j.model.client.server.ImmutableServerInfo;
import org.xrpl.xrpl4j.model.client.server.ServerInfoLastClose;
import org.xrpl.xrpl4j.model.client.server.ServerInfoLedger;
import org.xrpl.xrpl4j.model.client.server.ServerInfoLoad;

@JsonSerialize(as=ImmutableServerInfo.class)
@JsonDeserialize(as=ImmutableServerInfo.class)
@Value.Immutable
public interface ServerInfo {
    public static final Logger LOGGER = LoggerFactory.getLogger(ServerInfo.class);

    public static ImmutableServerInfo.Builder builder() {
        return ImmutableServerInfo.builder();
    }

    @JsonProperty(value="amendment_blocked")
    @Value.Default
    default public boolean amendmentBlocked() {
        return false;
    }

    @JsonProperty(value="build_version")
    public String buildVersion();

    @JsonProperty(value="closed_ledger")
    public Optional<ServerInfoLedger> closedLedger();

    @JsonProperty(value="complete_ledgers")
    public String completeLedgers();

    @JsonIgnore
    @Value.Derived
    default public List<Range<UnsignedLong>> completeLedgerRanges() {
        return Stream.of(this.completeLedgers().split(",")).map(String::trim).filter($ -> !$.equals("empty")).map(range -> {
            String[] parts = range.split("-");
            if (parts.length == 1) {
                try {
                    return Range.singleton((Comparable)UnsignedLong.valueOf((String)parts[0]));
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (parts.length == 2) {
                UnsignedLong upper;
                UnsignedLong lower;
                try {
                    lower = UnsignedLong.valueOf((String)parts[0]);
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to parse valid lower bound number (ignoring range).", (Throwable)e);
                    return null;
                }
                try {
                    upper = UnsignedLong.valueOf((String)parts[1]);
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to parse valid upper bound number (ignoring range).", (Throwable)e);
                    return null;
                }
                return Range.closed((Comparable)lower, (Comparable)upper);
            }
            LOGGER.warn("Range had too many dashes (ignoring range)");
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @JsonIgnore
    @Value.Derived
    default public boolean isLedgerInCompleteLedgers(UnsignedLong ledgerIndex) {
        return this.completeLedgerRanges().stream().anyMatch(range -> range.contains((Comparable)ledgerIndex));
    }

    @JsonProperty(value="hostid")
    public String hostId();

    @JsonProperty(value="io_latency_ms")
    public UnsignedLong ioLatencyMs();

    @JsonProperty(value="jq_trans_overflow")
    public Optional<String> jqTransOverflow();

    @JsonProperty(value="last_close")
    public ServerInfoLastClose lastClose();

    @JsonProperty(value="load")
    public Optional<ServerInfoLoad> load();

    @JsonProperty(value="load_factor")
    public Optional<BigDecimal> loadFactor();

    @JsonProperty(value="load_factor_local")
    public Optional<BigDecimal> loadFactorLocal();

    @JsonProperty(value="load_factor_net")
    public Optional<BigDecimal> loadFactorNet();

    @JsonProperty(value="load_factor_cluster")
    public Optional<BigDecimal> loadFactorCluster();

    @JsonProperty(value="load_factor_fee_escalation")
    public Optional<BigDecimal> loadFactorFeeEscalation();

    @JsonProperty(value="load_factor_fee_queue")
    public Optional<BigDecimal> loadFactorFeeQueue();

    @JsonProperty(value="load_factor_server")
    public Optional<BigDecimal> loadFactorServer();

    public Optional<UnsignedInteger> peers();

    @JsonProperty(value="pubkey_node")
    public String publicKeyNode();

    @JsonProperty(value="pubkey_validator")
    public Optional<String> publicKeyValidator();

    @JsonProperty(value="server_state")
    public String serverState();

    @JsonProperty(value="server_state_duration_us")
    public String serverStateDurationUs();

    @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSS z")
    public ZonedDateTime time();

    @JsonProperty(value="uptime")
    public UnsignedLong upTime();

    @JsonProperty(value="validated_ledger")
    public Optional<ServerInfoLedger> validatedLedger();

    @JsonProperty(value="validation_quorum")
    public UnsignedInteger validationQuorum();

    @JsonProperty(value="validator_list_expires")
    public Optional<String> validatorListExpires();
}

