/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.transactions.SubmitMultiSignedResult;
import org.xrpl.xrpl4j.model.client.transactions.TransactionResult;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SubmitMultiSignedResult", generator="Immutables")
@Immutable
public final class ImmutableSubmitMultiSignedResult<TxnType extends Transaction>
implements SubmitMultiSignedResult<TxnType> {
    @Nullable
    private final String status;
    @Nullable
    private final String engineResult;
    @Nullable
    private final String engineResultCode;
    @Nullable
    private final String engineResultMessage;
    private final String transactionBlob;
    private final TransactionResult<TxnType> transaction;

    private ImmutableSubmitMultiSignedResult(@Nullable String status, @Nullable String engineResult, @Nullable String engineResultCode, @Nullable String engineResultMessage, String transactionBlob, TransactionResult<TxnType> transaction) {
        this.status = status;
        this.engineResult = engineResult;
        this.engineResultCode = engineResultCode;
        this.engineResultMessage = engineResultMessage;
        this.transactionBlob = transactionBlob;
        this.transaction = transaction;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="engine_result")
    public Optional<String> engineResult() {
        return Optional.ofNullable(this.engineResult);
    }

    @Override
    @JsonProperty(value="engine_result_code")
    public Optional<String> engineResultCode() {
        return Optional.ofNullable(this.engineResultCode);
    }

    @Override
    @JsonProperty(value="engine_result_message")
    public Optional<String> engineResultMessage() {
        return Optional.ofNullable(this.engineResultMessage);
    }

    @Override
    @JsonProperty(value="tx_blob")
    public String transactionBlob() {
        return this.transactionBlob;
    }

    @Override
    @JsonProperty(value="tx_json")
    public TransactionResult<TxnType> transaction() {
        return this.transaction;
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(newValue, this.engineResult, this.engineResultCode, this.engineResultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(value, this.engineResult, this.engineResultCode, this.engineResultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withEngineResult(String value) {
        String newValue = Objects.requireNonNull(value, "engineResult");
        if (Objects.equals(this.engineResult, newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, newValue, this.engineResultCode, this.engineResultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withEngineResult(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.engineResult, value)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, value, this.engineResultCode, this.engineResultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withEngineResultCode(String value) {
        String newValue = Objects.requireNonNull(value, "engineResultCode");
        if (Objects.equals(this.engineResultCode, newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.engineResult, newValue, this.engineResultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withEngineResultCode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.engineResultCode, value)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.engineResult, value, this.engineResultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withEngineResultMessage(String value) {
        String newValue = Objects.requireNonNull(value, "engineResultMessage");
        if (Objects.equals(this.engineResultMessage, newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.engineResult, this.engineResultCode, newValue, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withEngineResultMessage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.engineResultMessage, value)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.engineResult, this.engineResultCode, value, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withTransactionBlob(String value) {
        String newValue = Objects.requireNonNull(value, "transactionBlob");
        if (this.transactionBlob.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.engineResult, this.engineResultCode, this.engineResultMessage, newValue, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withTransaction(TransactionResult<TxnType> value) {
        if (this.transaction == value) {
            return this;
        }
        TransactionResult<TxnType> newValue = Objects.requireNonNull(value, "transaction");
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.engineResult, this.engineResultCode, this.engineResultMessage, this.transactionBlob, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubmitMultiSignedResult && this.equalTo((ImmutableSubmitMultiSignedResult)another);
    }

    private boolean equalTo(ImmutableSubmitMultiSignedResult<?> another) {
        return Objects.equals(this.status, another.status) && Objects.equals(this.engineResult, another.engineResult) && Objects.equals(this.engineResultCode, another.engineResultCode) && Objects.equals(this.engineResultMessage, another.engineResultMessage) && this.transactionBlob.equals(another.transactionBlob) && this.transaction.equals(another.transaction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Objects.hashCode(this.engineResult);
        h += (h << 5) + Objects.hashCode(this.engineResultCode);
        h += (h << 5) + Objects.hashCode(this.engineResultMessage);
        h += (h << 5) + this.transactionBlob.hashCode();
        h += (h << 5) + this.transaction.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SubmitMultiSignedResult").omitNullValues().add("status", (Object)this.status).add("engineResult", (Object)this.engineResult).add("engineResultCode", (Object)this.engineResultCode).add("engineResultMessage", (Object)this.engineResultMessage).add("transactionBlob", (Object)this.transactionBlob).add("transaction", this.transaction).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <TxnType extends Transaction> ImmutableSubmitMultiSignedResult<TxnType> fromJson(Json<TxnType> json) {
        Builder builder = ImmutableSubmitMultiSignedResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.engineResult != null) {
            builder.engineResult(json.engineResult);
        }
        if (json.engineResultCode != null) {
            builder.engineResultCode(json.engineResultCode);
        }
        if (json.engineResultMessage != null) {
            builder.engineResultMessage(json.engineResultMessage);
        }
        if (json.transactionBlob != null) {
            builder.transactionBlob(json.transactionBlob);
        }
        if (json.transaction != null) {
            builder.transaction(json.transaction);
        }
        return builder.build();
    }

    public static <TxnType extends Transaction> ImmutableSubmitMultiSignedResult<TxnType> copyOf(SubmitMultiSignedResult<TxnType> instance) {
        if (instance instanceof ImmutableSubmitMultiSignedResult) {
            return (ImmutableSubmitMultiSignedResult)instance;
        }
        return ImmutableSubmitMultiSignedResult.builder().from(instance).build();
    }

    public static <TxnType extends Transaction> Builder<TxnType> builder() {
        return new Builder();
    }

    @Generated(from="SubmitMultiSignedResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<TxnType extends Transaction> {
        private static final long INIT_BIT_TRANSACTION_BLOB = 1L;
        private static final long INIT_BIT_TRANSACTION = 2L;
        private long initBits = 3L;
        @Nullable
        private String status;
        @Nullable
        private String engineResult;
        @Nullable
        private String engineResultCode;
        @Nullable
        private String engineResultMessage;
        @Nullable
        private String transactionBlob;
        @Nullable
        private TransactionResult<TxnType> transaction;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> from(SubmitMultiSignedResult<TxnType> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> statusOptional;
            XrplResult instance;
            if (object instanceof SubmitMultiSignedResult) {
                Optional<String> engineResultCodeOptional;
                instance = (SubmitMultiSignedResult)object;
                Optional<String> engineResultMessageOptional = instance.engineResultMessage();
                if (engineResultMessageOptional.isPresent()) {
                    this.engineResultMessage(engineResultMessageOptional);
                }
                this.transactionBlob(instance.transactionBlob());
                Optional<String> engineResultOptional = instance.engineResult();
                if (engineResultOptional.isPresent()) {
                    this.engineResult(engineResultOptional);
                }
                if ((engineResultCodeOptional = instance.engineResultCode()).isPresent()) {
                    this.engineResultCode(engineResultCodeOptional);
                }
                this.transaction(instance.transaction());
            }
            if (object instanceof XrplResult && (statusOptional = (instance = (XrplResult)object).status()).isPresent()) {
                this.status(statusOptional);
            }
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder<TxnType> status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResult(String engineResult) {
            this.engineResult = Objects.requireNonNull(engineResult, "engineResult");
            return this;
        }

        @JsonProperty(value="engine_result")
        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResult(Optional<String> engineResult) {
            this.engineResult = engineResult.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResultCode(String engineResultCode) {
            this.engineResultCode = Objects.requireNonNull(engineResultCode, "engineResultCode");
            return this;
        }

        @JsonProperty(value="engine_result_code")
        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResultCode(Optional<String> engineResultCode) {
            this.engineResultCode = engineResultCode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResultMessage(String engineResultMessage) {
            this.engineResultMessage = Objects.requireNonNull(engineResultMessage, "engineResultMessage");
            return this;
        }

        @JsonProperty(value="engine_result_message")
        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResultMessage(Optional<String> engineResultMessage) {
            this.engineResultMessage = engineResultMessage.orElse(null);
            return this;
        }

        @JsonProperty(value="tx_blob")
        @CanIgnoreReturnValue
        public final Builder<TxnType> transactionBlob(String transactionBlob) {
            this.transactionBlob = Objects.requireNonNull(transactionBlob, "transactionBlob");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="tx_json")
        @CanIgnoreReturnValue
        public final Builder<TxnType> transaction(TransactionResult<TxnType> transaction) {
            this.transaction = Objects.requireNonNull(transaction, "transaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSubmitMultiSignedResult<TxnType> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubmitMultiSignedResult(this.status, this.engineResult, this.engineResultCode, this.engineResultMessage, this.transactionBlob, this.transaction);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionBlob");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("transaction");
            }
            return "Cannot build SubmitMultiSignedResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SubmitMultiSignedResult", generator="Immutables")
    static final class Json<TxnType extends Transaction>
    implements SubmitMultiSignedResult<TxnType> {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        Optional<String> engineResult = Optional.empty();
        @Nullable
        Optional<String> engineResultCode = Optional.empty();
        @Nullable
        Optional<String> engineResultMessage = Optional.empty();
        @Nullable
        String transactionBlob;
        @Nullable
        TransactionResult<TxnType> transaction;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="engine_result")
        public void setEngineResult(Optional<String> engineResult) {
            this.engineResult = engineResult;
        }

        @JsonProperty(value="engine_result_code")
        public void setEngineResultCode(Optional<String> engineResultCode) {
            this.engineResultCode = engineResultCode;
        }

        @JsonProperty(value="engine_result_message")
        public void setEngineResultMessage(Optional<String> engineResultMessage) {
            this.engineResultMessage = engineResultMessage;
        }

        @JsonProperty(value="tx_blob")
        public void setTransactionBlob(String transactionBlob) {
            this.transactionBlob = transactionBlob;
        }

        @JsonProperty(value="tx_json")
        public void setTransaction(TransactionResult<TxnType> transaction) {
            this.transaction = transaction;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> engineResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> engineResultCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> engineResultMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String transactionBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TransactionResult<TxnType> transaction() {
            throw new UnsupportedOperationException();
        }
    }
}

