/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.transactions.SubmitResult;
import org.xrpl.xrpl4j.model.client.transactions.TransactionResult;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SubmitResult", generator="Immutables")
@Immutable
public final class ImmutableSubmitResult<TxnType extends Transaction>
implements SubmitResult<TxnType> {
    @Nullable
    private final String status;
    private final String result;
    @Nullable
    private final String engineResultMessage;
    private final String transactionBlob;
    private final TransactionResult<TxnType> transactionResult;
    private final boolean accepted;
    private final UnsignedInteger accountSequenceAvailable;
    private final UnsignedInteger accountSequenceNext;
    private final boolean applied;
    private final boolean broadcast;
    private final boolean kept;
    private final boolean queued;
    private final XrpCurrencyAmount openLedgerCost;
    private final LedgerIndex validatedLedgerIndex;

    private ImmutableSubmitResult(@Nullable String status, String result, @Nullable String engineResultMessage, String transactionBlob, TransactionResult<TxnType> transactionResult, boolean accepted, UnsignedInteger accountSequenceAvailable, UnsignedInteger accountSequenceNext, boolean applied, boolean broadcast, boolean kept, boolean queued, XrpCurrencyAmount openLedgerCost, LedgerIndex validatedLedgerIndex) {
        this.status = status;
        this.result = result;
        this.engineResultMessage = engineResultMessage;
        this.transactionBlob = transactionBlob;
        this.transactionResult = transactionResult;
        this.accepted = accepted;
        this.accountSequenceAvailable = accountSequenceAvailable;
        this.accountSequenceNext = accountSequenceNext;
        this.applied = applied;
        this.broadcast = broadcast;
        this.kept = kept;
        this.queued = queued;
        this.openLedgerCost = openLedgerCost;
        this.validatedLedgerIndex = validatedLedgerIndex;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="engine_result")
    public String result() {
        return this.result;
    }

    @Override
    @JsonProperty(value="engine_result_message")
    public Optional<String> engineResultMessage() {
        return Optional.ofNullable(this.engineResultMessage);
    }

    @Override
    @JsonProperty(value="tx_blob")
    public String transactionBlob() {
        return this.transactionBlob;
    }

    @Override
    @JsonProperty(value="tx_json")
    public TransactionResult<TxnType> transactionResult() {
        return this.transactionResult;
    }

    @Override
    @JsonProperty(value="accepted")
    public boolean accepted() {
        return this.accepted;
    }

    @Override
    @JsonProperty(value="account_sequence_available")
    public UnsignedInteger accountSequenceAvailable() {
        return this.accountSequenceAvailable;
    }

    @Override
    @JsonProperty(value="account_sequence_next")
    public UnsignedInteger accountSequenceNext() {
        return this.accountSequenceNext;
    }

    @Override
    @JsonProperty(value="applied")
    public boolean applied() {
        return this.applied;
    }

    @Override
    @JsonProperty(value="broadcast")
    public boolean broadcast() {
        return this.broadcast;
    }

    @Override
    @JsonProperty(value="kept")
    public boolean kept() {
        return this.kept;
    }

    @Override
    @JsonProperty(value="queued")
    public boolean queued() {
        return this.queued;
    }

    @Override
    @JsonProperty(value="open_ledger_cost")
    public XrpCurrencyAmount openLedgerCost() {
        return this.openLedgerCost;
    }

    @Override
    @JsonProperty(value="validated_ledger_index")
    public LedgerIndex validatedLedgerIndex() {
        return this.validatedLedgerIndex;
    }

    public final ImmutableSubmitResult<TxnType> withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(newValue, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(value, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withResult(String value) {
        String newValue = Objects.requireNonNull(value, "result");
        if (this.result.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, newValue, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withEngineResultMessage(String value) {
        String newValue = Objects.requireNonNull(value, "engineResultMessage");
        if (Objects.equals(this.engineResultMessage, newValue)) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, newValue, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withEngineResultMessage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.engineResultMessage, value)) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, value, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withTransactionBlob(String value) {
        String newValue = Objects.requireNonNull(value, "transactionBlob");
        if (this.transactionBlob.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, newValue, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withTransactionResult(TransactionResult<TxnType> value) {
        if (this.transactionResult == value) {
            return this;
        }
        TransactionResult<TxnType> newValue = Objects.requireNonNull(value, "transactionResult");
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, this.transactionBlob, newValue, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withAccepted(boolean value) {
        if (this.accepted == value) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, value, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withAccountSequenceAvailable(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "accountSequenceAvailable");
        if (this.accountSequenceAvailable.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, newValue, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withAccountSequenceNext(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "accountSequenceNext");
        if (this.accountSequenceNext.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, newValue, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withApplied(boolean value) {
        if (this.applied == value) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, value, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withBroadcast(boolean value) {
        if (this.broadcast == value) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, value, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withKept(boolean value) {
        if (this.kept == value) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, value, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withQueued(boolean value) {
        if (this.queued == value) {
            return this;
        }
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, value, this.openLedgerCost, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withOpenLedgerCost(XrpCurrencyAmount value) {
        if (this.openLedgerCost == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "openLedgerCost");
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, newValue, this.validatedLedgerIndex);
    }

    public final ImmutableSubmitResult<TxnType> withValidatedLedgerIndex(LedgerIndex value) {
        if (this.validatedLedgerIndex == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "validatedLedgerIndex");
        return new ImmutableSubmitResult<TxnType>(this.status, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubmitResult && this.equalTo((ImmutableSubmitResult)another);
    }

    private boolean equalTo(ImmutableSubmitResult<?> another) {
        return Objects.equals(this.status, another.status) && this.result.equals(another.result) && Objects.equals(this.engineResultMessage, another.engineResultMessage) && this.transactionBlob.equals(another.transactionBlob) && this.transactionResult.equals(another.transactionResult) && this.accepted == another.accepted && this.accountSequenceAvailable.equals((Object)another.accountSequenceAvailable) && this.accountSequenceNext.equals((Object)another.accountSequenceNext) && this.applied == another.applied && this.broadcast == another.broadcast && this.kept == another.kept && this.queued == another.queued && this.openLedgerCost.equals(another.openLedgerCost) && this.validatedLedgerIndex.equals(another.validatedLedgerIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + Objects.hashCode(this.engineResultMessage);
        h += (h << 5) + this.transactionBlob.hashCode();
        h += (h << 5) + this.transactionResult.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.accepted);
        h += (h << 5) + this.accountSequenceAvailable.hashCode();
        h += (h << 5) + this.accountSequenceNext.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.applied);
        h += (h << 5) + Booleans.hashCode((boolean)this.broadcast);
        h += (h << 5) + Booleans.hashCode((boolean)this.kept);
        h += (h << 5) + Booleans.hashCode((boolean)this.queued);
        h += (h << 5) + this.openLedgerCost.hashCode();
        h += (h << 5) + this.validatedLedgerIndex.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SubmitResult").omitNullValues().add("status", (Object)this.status).add("result", (Object)this.result).add("engineResultMessage", (Object)this.engineResultMessage).add("transactionBlob", (Object)this.transactionBlob).add("transactionResult", this.transactionResult).add("accepted", this.accepted).add("accountSequenceAvailable", (Object)this.accountSequenceAvailable).add("accountSequenceNext", (Object)this.accountSequenceNext).add("applied", this.applied).add("broadcast", this.broadcast).add("kept", this.kept).add("queued", this.queued).add("openLedgerCost", (Object)this.openLedgerCost).add("validatedLedgerIndex", (Object)this.validatedLedgerIndex).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <TxnType extends Transaction> ImmutableSubmitResult<TxnType> fromJson(Json<TxnType> json) {
        Builder builder = ImmutableSubmitResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.result != null) {
            builder.result(json.result);
        }
        if (json.engineResultMessage != null) {
            builder.engineResultMessage(json.engineResultMessage);
        }
        if (json.transactionBlob != null) {
            builder.transactionBlob(json.transactionBlob);
        }
        if (json.transactionResult != null) {
            builder.transactionResult(json.transactionResult);
        }
        if (json.acceptedIsSet) {
            builder.accepted(json.accepted);
        }
        if (json.accountSequenceAvailable != null) {
            builder.accountSequenceAvailable(json.accountSequenceAvailable);
        }
        if (json.accountSequenceNext != null) {
            builder.accountSequenceNext(json.accountSequenceNext);
        }
        if (json.appliedIsSet) {
            builder.applied(json.applied);
        }
        if (json.broadcastIsSet) {
            builder.broadcast(json.broadcast);
        }
        if (json.keptIsSet) {
            builder.kept(json.kept);
        }
        if (json.queuedIsSet) {
            builder.queued(json.queued);
        }
        if (json.openLedgerCost != null) {
            builder.openLedgerCost(json.openLedgerCost);
        }
        if (json.validatedLedgerIndex != null) {
            builder.validatedLedgerIndex(json.validatedLedgerIndex);
        }
        return builder.build();
    }

    public static <TxnType extends Transaction> ImmutableSubmitResult<TxnType> copyOf(SubmitResult<TxnType> instance) {
        if (instance instanceof ImmutableSubmitResult) {
            return (ImmutableSubmitResult)instance;
        }
        return ImmutableSubmitResult.builder().from(instance).build();
    }

    public static <TxnType extends Transaction> Builder<TxnType> builder() {
        return new Builder();
    }

    @Generated(from="SubmitResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<TxnType extends Transaction> {
        private static final long INIT_BIT_RESULT = 1L;
        private static final long INIT_BIT_TRANSACTION_BLOB = 2L;
        private static final long INIT_BIT_TRANSACTION_RESULT = 4L;
        private static final long INIT_BIT_ACCEPTED = 8L;
        private static final long INIT_BIT_ACCOUNT_SEQUENCE_AVAILABLE = 16L;
        private static final long INIT_BIT_ACCOUNT_SEQUENCE_NEXT = 32L;
        private static final long INIT_BIT_APPLIED = 64L;
        private static final long INIT_BIT_BROADCAST = 128L;
        private static final long INIT_BIT_KEPT = 256L;
        private static final long INIT_BIT_QUEUED = 512L;
        private static final long INIT_BIT_OPEN_LEDGER_COST = 1024L;
        private static final long INIT_BIT_VALIDATED_LEDGER_INDEX = 2048L;
        private long initBits = 4095L;
        @Nullable
        private String status;
        @Nullable
        private String result;
        @Nullable
        private String engineResultMessage;
        @Nullable
        private String transactionBlob;
        @Nullable
        private TransactionResult<TxnType> transactionResult;
        private boolean accepted;
        @Nullable
        private UnsignedInteger accountSequenceAvailable;
        @Nullable
        private UnsignedInteger accountSequenceNext;
        private boolean applied;
        private boolean broadcast;
        private boolean kept;
        private boolean queued;
        @Nullable
        private XrpCurrencyAmount openLedgerCost;
        @Nullable
        private LedgerIndex validatedLedgerIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> from(SubmitResult<TxnType> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            Optional<String> statusOptional;
            if (object instanceof XrplResult && (statusOptional = (instance = (XrplResult)object).status()).isPresent()) {
                this.status(statusOptional);
            }
            if (object instanceof SubmitResult) {
                instance = (SubmitResult)object;
                this.broadcast(instance.broadcast());
                this.validatedLedgerIndex(instance.validatedLedgerIndex());
                this.transactionBlob(instance.transactionBlob());
                this.applied(instance.applied());
                this.queued(instance.queued());
                this.accountSequenceNext(instance.accountSequenceNext());
                this.accepted(instance.accepted());
                this.accountSequenceAvailable(instance.accountSequenceAvailable());
                Optional<String> engineResultMessageOptional = instance.engineResultMessage();
                if (engineResultMessageOptional.isPresent()) {
                    this.engineResultMessage(engineResultMessageOptional);
                }
                this.kept(instance.kept());
                this.transactionResult(instance.transactionResult());
                this.result(instance.result());
                this.openLedgerCost(instance.openLedgerCost());
            }
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder<TxnType> status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="engine_result")
        @CanIgnoreReturnValue
        public final Builder<TxnType> result(String result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResultMessage(String engineResultMessage) {
            this.engineResultMessage = Objects.requireNonNull(engineResultMessage, "engineResultMessage");
            return this;
        }

        @JsonProperty(value="engine_result_message")
        @CanIgnoreReturnValue
        public final Builder<TxnType> engineResultMessage(Optional<String> engineResultMessage) {
            this.engineResultMessage = engineResultMessage.orElse(null);
            return this;
        }

        @JsonProperty(value="tx_blob")
        @CanIgnoreReturnValue
        public final Builder<TxnType> transactionBlob(String transactionBlob) {
            this.transactionBlob = Objects.requireNonNull(transactionBlob, "transactionBlob");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="tx_json")
        @CanIgnoreReturnValue
        public final Builder<TxnType> transactionResult(TransactionResult<TxnType> transactionResult) {
            this.transactionResult = Objects.requireNonNull(transactionResult, "transactionResult");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="accepted")
        @CanIgnoreReturnValue
        public final Builder<TxnType> accepted(boolean accepted) {
            this.accepted = accepted;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="account_sequence_available")
        @CanIgnoreReturnValue
        public final Builder<TxnType> accountSequenceAvailable(UnsignedInteger accountSequenceAvailable) {
            this.accountSequenceAvailable = Objects.requireNonNull(accountSequenceAvailable, "accountSequenceAvailable");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="account_sequence_next")
        @CanIgnoreReturnValue
        public final Builder<TxnType> accountSequenceNext(UnsignedInteger accountSequenceNext) {
            this.accountSequenceNext = Objects.requireNonNull(accountSequenceNext, "accountSequenceNext");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="applied")
        @CanIgnoreReturnValue
        public final Builder<TxnType> applied(boolean applied) {
            this.applied = applied;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="broadcast")
        @CanIgnoreReturnValue
        public final Builder<TxnType> broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="kept")
        @CanIgnoreReturnValue
        public final Builder<TxnType> kept(boolean kept) {
            this.kept = kept;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="queued")
        @CanIgnoreReturnValue
        public final Builder<TxnType> queued(boolean queued) {
            this.queued = queued;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="open_ledger_cost")
        @CanIgnoreReturnValue
        public final Builder<TxnType> openLedgerCost(XrpCurrencyAmount openLedgerCost) {
            this.openLedgerCost = Objects.requireNonNull(openLedgerCost, "openLedgerCost");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @JsonProperty(value="validated_ledger_index")
        @CanIgnoreReturnValue
        public final Builder<TxnType> validatedLedgerIndex(LedgerIndex validatedLedgerIndex) {
            this.validatedLedgerIndex = Objects.requireNonNull(validatedLedgerIndex, "validatedLedgerIndex");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public ImmutableSubmitResult<TxnType> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubmitResult(this.status, this.result, this.engineResultMessage, this.transactionBlob, this.transactionResult, this.accepted, this.accountSequenceAvailable, this.accountSequenceNext, this.applied, this.broadcast, this.kept, this.queued, this.openLedgerCost, this.validatedLedgerIndex);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("result");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("transactionBlob");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("transactionResult");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("accepted");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("accountSequenceAvailable");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("accountSequenceNext");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("applied");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("broadcast");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("kept");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("queued");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("openLedgerCost");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("validatedLedgerIndex");
            }
            return "Cannot build SubmitResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SubmitResult", generator="Immutables")
    static final class Json<TxnType extends Transaction>
    implements SubmitResult<TxnType> {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        String result;
        @Nullable
        Optional<String> engineResultMessage = Optional.empty();
        @Nullable
        String transactionBlob;
        @Nullable
        TransactionResult<TxnType> transactionResult;
        boolean accepted;
        boolean acceptedIsSet;
        @Nullable
        UnsignedInteger accountSequenceAvailable;
        @Nullable
        UnsignedInteger accountSequenceNext;
        boolean applied;
        boolean appliedIsSet;
        boolean broadcast;
        boolean broadcastIsSet;
        boolean kept;
        boolean keptIsSet;
        boolean queued;
        boolean queuedIsSet;
        @Nullable
        XrpCurrencyAmount openLedgerCost;
        @Nullable
        LedgerIndex validatedLedgerIndex;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="engine_result")
        public void setResult(String result) {
            this.result = result;
        }

        @JsonProperty(value="engine_result_message")
        public void setEngineResultMessage(Optional<String> engineResultMessage) {
            this.engineResultMessage = engineResultMessage;
        }

        @JsonProperty(value="tx_blob")
        public void setTransactionBlob(String transactionBlob) {
            this.transactionBlob = transactionBlob;
        }

        @JsonProperty(value="tx_json")
        public void setTransactionResult(TransactionResult<TxnType> transactionResult) {
            this.transactionResult = transactionResult;
        }

        @JsonProperty(value="accepted")
        public void setAccepted(boolean accepted) {
            this.accepted = accepted;
            this.acceptedIsSet = true;
        }

        @JsonProperty(value="account_sequence_available")
        public void setAccountSequenceAvailable(UnsignedInteger accountSequenceAvailable) {
            this.accountSequenceAvailable = accountSequenceAvailable;
        }

        @JsonProperty(value="account_sequence_next")
        public void setAccountSequenceNext(UnsignedInteger accountSequenceNext) {
            this.accountSequenceNext = accountSequenceNext;
        }

        @JsonProperty(value="applied")
        public void setApplied(boolean applied) {
            this.applied = applied;
            this.appliedIsSet = true;
        }

        @JsonProperty(value="broadcast")
        public void setBroadcast(boolean broadcast) {
            this.broadcast = broadcast;
            this.broadcastIsSet = true;
        }

        @JsonProperty(value="kept")
        public void setKept(boolean kept) {
            this.kept = kept;
            this.keptIsSet = true;
        }

        @JsonProperty(value="queued")
        public void setQueued(boolean queued) {
            this.queued = queued;
            this.queuedIsSet = true;
        }

        @JsonProperty(value="open_ledger_cost")
        public void setOpenLedgerCost(XrpCurrencyAmount openLedgerCost) {
            this.openLedgerCost = openLedgerCost;
        }

        @JsonProperty(value="validated_ledger_index")
        public void setValidatedLedgerIndex(LedgerIndex validatedLedgerIndex) {
            this.validatedLedgerIndex = validatedLedgerIndex;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String result() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> engineResultMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String transactionBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TransactionResult<TxnType> transactionResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean accepted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger accountSequenceAvailable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger accountSequenceNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean applied() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean broadcast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean kept() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean queued() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount openLedgerCost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex validatedLedgerIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

