/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.transactions.TransactionRequestParams;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionRequestParams", generator="Immutables")
@Immutable
public final class ImmutableTransactionRequestParams
implements TransactionRequestParams {
    private final Hash256 transaction;
    private final transient boolean binary;
    @Nullable
    private final UnsignedLong minLedger;
    @Nullable
    private final UnsignedLong maxLedger;

    private ImmutableTransactionRequestParams(Hash256 transaction, @Nullable UnsignedLong minLedger, @Nullable UnsignedLong maxLedger) {
        this.transaction = transaction;
        this.minLedger = minLedger;
        this.maxLedger = maxLedger;
        this.binary = TransactionRequestParams.super.binary();
    }

    @Override
    @JsonProperty(value="transaction")
    public Hash256 transaction() {
        return this.transaction;
    }

    @Override
    @JsonProperty(value="binary")
    public boolean binary() {
        return this.binary;
    }

    @Override
    @JsonProperty(value="min_ledger")
    public Optional<UnsignedLong> minLedger() {
        return Optional.ofNullable(this.minLedger);
    }

    @Override
    @JsonProperty(value="max_ledger")
    public Optional<UnsignedLong> maxLedger() {
        return Optional.ofNullable(this.maxLedger);
    }

    public final ImmutableTransactionRequestParams withTransaction(Hash256 value) {
        if (this.transaction == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "transaction");
        return new ImmutableTransactionRequestParams(newValue, this.minLedger, this.maxLedger);
    }

    public final ImmutableTransactionRequestParams withMinLedger(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "minLedger");
        if (Objects.equals(this.minLedger, newValue)) {
            return this;
        }
        return new ImmutableTransactionRequestParams(this.transaction, newValue, this.maxLedger);
    }

    public final ImmutableTransactionRequestParams withMinLedger(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.minLedger, value)) {
            return this;
        }
        return new ImmutableTransactionRequestParams(this.transaction, value, this.maxLedger);
    }

    public final ImmutableTransactionRequestParams withMaxLedger(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "maxLedger");
        if (Objects.equals(this.maxLedger, newValue)) {
            return this;
        }
        return new ImmutableTransactionRequestParams(this.transaction, this.minLedger, newValue);
    }

    public final ImmutableTransactionRequestParams withMaxLedger(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.maxLedger, value)) {
            return this;
        }
        return new ImmutableTransactionRequestParams(this.transaction, this.minLedger, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionRequestParams && this.equalTo((ImmutableTransactionRequestParams)another);
    }

    private boolean equalTo(ImmutableTransactionRequestParams another) {
        return this.transaction.equals(another.transaction) && this.binary == another.binary && Objects.equals(this.minLedger, another.minLedger) && Objects.equals(this.maxLedger, another.maxLedger);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transaction.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.binary);
        h += (h << 5) + Objects.hashCode(this.minLedger);
        h += (h << 5) + Objects.hashCode(this.maxLedger);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionRequestParams").omitNullValues().add("transaction", (Object)this.transaction).add("binary", this.binary).add("minLedger", (Object)this.minLedger).add("maxLedger", (Object)this.maxLedger).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionRequestParams fromJson(Json json) {
        Builder builder = ImmutableTransactionRequestParams.builder();
        if (json.transaction != null) {
            builder.transaction(json.transaction);
        }
        if (json.minLedger != null) {
            builder.minLedger(json.minLedger);
        }
        if (json.maxLedger != null) {
            builder.maxLedger(json.maxLedger);
        }
        return builder.build();
    }

    public static ImmutableTransactionRequestParams copyOf(TransactionRequestParams instance) {
        if (instance instanceof ImmutableTransactionRequestParams) {
            return (ImmutableTransactionRequestParams)instance;
        }
        return ImmutableTransactionRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION = 1L;
        private long initBits = 1L;
        @Nullable
        private Hash256 transaction;
        @Nullable
        private UnsignedLong minLedger;
        @Nullable
        private UnsignedLong maxLedger;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TransactionRequestParams instance) {
            Optional<UnsignedLong> maxLedgerOptional;
            Objects.requireNonNull(instance, "instance");
            this.transaction(instance.transaction());
            Optional<UnsignedLong> minLedgerOptional = instance.minLedger();
            if (minLedgerOptional.isPresent()) {
                this.minLedger(minLedgerOptional);
            }
            if ((maxLedgerOptional = instance.maxLedger()).isPresent()) {
                this.maxLedger(maxLedgerOptional);
            }
            return this;
        }

        @JsonProperty(value="transaction")
        @CanIgnoreReturnValue
        public final Builder transaction(Hash256 transaction) {
            this.transaction = Objects.requireNonNull(transaction, "transaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minLedger(UnsignedLong minLedger) {
            this.minLedger = Objects.requireNonNull(minLedger, "minLedger");
            return this;
        }

        @JsonProperty(value="min_ledger")
        @CanIgnoreReturnValue
        public final Builder minLedger(Optional<? extends UnsignedLong> minLedger) {
            this.minLedger = minLedger.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxLedger(UnsignedLong maxLedger) {
            this.maxLedger = Objects.requireNonNull(maxLedger, "maxLedger");
            return this;
        }

        @JsonProperty(value="max_ledger")
        @CanIgnoreReturnValue
        public final Builder maxLedger(Optional<? extends UnsignedLong> maxLedger) {
            this.maxLedger = maxLedger.orElse(null);
            return this;
        }

        public ImmutableTransactionRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionRequestParams(this.transaction, this.minLedger, this.maxLedger);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transaction");
            }
            return "Cannot build TransactionRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionRequestParams", generator="Immutables")
    static final class Json
    implements TransactionRequestParams {
        @Nullable
        Hash256 transaction;
        @Nullable
        Optional<UnsignedLong> minLedger = Optional.empty();
        @Nullable
        Optional<UnsignedLong> maxLedger = Optional.empty();

        Json() {
        }

        @JsonProperty(value="transaction")
        public void setTransaction(Hash256 transaction) {
            this.transaction = transaction;
        }

        @JsonProperty(value="min_ledger")
        public void setMinLedger(Optional<UnsignedLong> minLedger) {
            this.minLedger = minLedger;
        }

        @JsonProperty(value="max_ledger")
        public void setMaxLedger(Optional<UnsignedLong> maxLedger) {
            this.maxLedger = maxLedger;
        }

        @Override
        public Hash256 transaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean binary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> minLedger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> maxLedger() {
            throw new UnsupportedOperationException();
        }
    }
}

