/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.flags;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Objects;

public class Flags {
    public static final Flags UNSET = new Flags(0L);
    private final long value;

    private Flags(long value) {
        this.value = value;
    }

    public static Flags of(long value) {
        return new Flags(value);
    }

    public static Flags of(Flags flag, Flags ... others) {
        return flag.bitwiseOr(Arrays.stream(others).reduce(Flags::bitwiseOr).orElse(UNSET));
    }

    @JsonValue
    public long getValue() {
        return this.value;
    }

    Flags bitwiseOr(Flags other) {
        return Flags.of(this.value | other.value);
    }

    Flags bitwiseAnd(Flags other) {
        return Flags.of(this.value & other.value);
    }

    public boolean isSet(Flags flag) {
        return !flag.equals(UNSET) && this.bitwiseAnd(flag).equals(flag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Flags flags = (Flags)obj;
        return this.getValue() == flags.getValue();
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static class PaymentChannelClaimFlags
    extends TransactionFlags {
        protected static final PaymentChannelClaimFlags RENEW = new PaymentChannelClaimFlags(65536L);
        protected static final PaymentChannelClaimFlags CLOSE = new PaymentChannelClaimFlags(131072L);

        private PaymentChannelClaimFlags(long value) {
            super(value);
        }

        public static Builder builder() {
            return new Builder();
        }

        private static PaymentChannelClaimFlags of(boolean tfFullyCanonicalSig, boolean tfRenew, boolean tfClose) {
            return new PaymentChannelClaimFlags(TransactionFlags.of(tfFullyCanonicalSig ? TransactionFlags.FULLY_CANONICAL_SIG : UNSET, tfRenew ? RENEW : UNSET, tfClose ? CLOSE : UNSET).getValue());
        }

        public static PaymentChannelClaimFlags of(long value) {
            return new PaymentChannelClaimFlags(value);
        }

        @Override
        public boolean tfFullyCanonicalSig() {
            return this.isSet(TransactionFlags.FULLY_CANONICAL_SIG);
        }

        public boolean tfRenew() {
            return this.isSet(RENEW);
        }

        public boolean tfClose() {
            return this.isSet(CLOSE);
        }

        public static class Builder {
            boolean tfFullyCanonicalSig = true;
            boolean tfRenew = false;
            boolean tfClose = false;

            public Builder tfFullyCanonicalSig(boolean tfFullyCanonicalSig) {
                this.tfFullyCanonicalSig = tfFullyCanonicalSig;
                return this;
            }

            public Builder tfRenew(boolean tfRenew) {
                this.tfRenew = tfRenew;
                return this;
            }

            public Builder tfClose(boolean tfClose) {
                this.tfClose = tfClose;
                return this;
            }

            public PaymentChannelClaimFlags build() {
                return PaymentChannelClaimFlags.of(this.tfFullyCanonicalSig, this.tfRenew, this.tfClose);
            }
        }
    }

    public static class OfferFlags
    extends Flags {
        protected static final OfferFlags PASSIVE = new OfferFlags(65536L);
        protected static final OfferFlags SELL = new OfferFlags(131072L);

        private OfferFlags(long value) {
            super(value);
        }

        public static OfferFlags of(long value) {
            return new OfferFlags(value);
        }

        public boolean lsfPassive() {
            return this.isSet(PASSIVE);
        }

        public boolean lsfSell() {
            return this.isSet(SELL);
        }
    }

    public static class OfferCreateFlags
    extends TransactionFlags {
        protected static final OfferCreateFlags PASSIVE = new OfferCreateFlags(65536L);
        protected static final OfferCreateFlags IMMEDIATE_OR_CANCEL = new OfferCreateFlags(131072L);
        protected static final OfferCreateFlags FILL_OR_KILL = new OfferCreateFlags(262144L);
        protected static final OfferCreateFlags SELL = new OfferCreateFlags(524288L);

        private OfferCreateFlags(long value) {
            super(value);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static OfferCreateFlags of(long value) {
            return new OfferCreateFlags(value);
        }

        private static OfferCreateFlags of(boolean tfFullyCanonicalSig, boolean tfPassive, boolean tfImmediateOrCancel, boolean tfFillOrKill, boolean tfSell) {
            long value = Flags.of(tfFullyCanonicalSig ? TransactionFlags.FULLY_CANONICAL_SIG : UNSET, tfPassive ? PASSIVE : UNSET, tfImmediateOrCancel ? IMMEDIATE_OR_CANCEL : UNSET, tfFillOrKill ? FILL_OR_KILL : UNSET, tfSell ? SELL : UNSET).getValue();
            return new OfferCreateFlags(value);
        }

        public boolean tfPassive() {
            return this.isSet(PASSIVE);
        }

        public boolean tfImmediateOrCancel() {
            return this.isSet(IMMEDIATE_OR_CANCEL);
        }

        public boolean tfFillOrKill() {
            return this.isSet(FILL_OR_KILL);
        }

        public boolean tfSell() {
            return this.isSet(SELL);
        }

        public static class Builder {
            private boolean tfFullyCanonicalSig = true;
            private boolean tfPassive = false;
            private boolean tfImmediateOrCancel = false;
            private boolean tfFillOrKill = false;
            private boolean tfSell = false;

            public Builder tfFullyCanonicalSig(boolean tfFullyCanonicalSig) {
                this.tfFullyCanonicalSig = tfFullyCanonicalSig;
                return this;
            }

            public Builder tfPassive(boolean tfPassive) {
                this.tfPassive = tfPassive;
                return this;
            }

            public Builder tfImmediateOrCancel(boolean tfImmediateOrCancel) {
                this.tfImmediateOrCancel = tfImmediateOrCancel;
                return this;
            }

            public Builder tfFillOrKill(boolean tfFillOrKill) {
                this.tfFillOrKill = tfFillOrKill;
                return this;
            }

            public Builder tfSell(boolean tfSell) {
                this.tfSell = tfSell;
                return this;
            }

            public OfferCreateFlags build() {
                return OfferCreateFlags.of(this.tfFullyCanonicalSig, this.tfPassive, this.tfImmediateOrCancel, this.tfFillOrKill, this.tfSell);
            }
        }
    }

    public static class RippleStateFlags
    extends Flags {
        public static final RippleStateFlags LOW_RESERVE = new RippleStateFlags(65536L);
        public static final RippleStateFlags HIGH_RESERVE = new RippleStateFlags(131072L);
        public static final RippleStateFlags LOW_AUTH = new RippleStateFlags(262144L);
        public static final RippleStateFlags HIGH_AUTH = new RippleStateFlags(524288L);
        public static final RippleStateFlags LOW_NO_RIPPLE = new RippleStateFlags(0x100000L);
        public static final RippleStateFlags HIGH_NO_RIPPLE = new RippleStateFlags(0x200000L);
        public static final RippleStateFlags LOW_FREEZE = new RippleStateFlags(0x400000L);
        public static final RippleStateFlags HIGH_FREEZE = new RippleStateFlags(0x800000L);

        private RippleStateFlags(long value) {
            super(value);
        }

        public static RippleStateFlags of(long value) {
            return new RippleStateFlags(value);
        }

        public boolean lsfLowReserve() {
            return this.isSet(LOW_RESERVE);
        }

        public boolean lsfHighReserve() {
            return this.isSet(HIGH_RESERVE);
        }

        public boolean lsfLowAuth() {
            return this.isSet(LOW_AUTH);
        }

        public boolean lsfHighAuth() {
            return this.isSet(HIGH_AUTH);
        }

        public boolean lsfLowNoRipple() {
            return this.isSet(LOW_NO_RIPPLE);
        }

        public boolean lsfHighNoRipple() {
            return this.isSet(HIGH_NO_RIPPLE);
        }

        public boolean lsfLowFreeze() {
            return this.isSet(LOW_FREEZE);
        }

        public boolean lsfHighFreeze() {
            return this.isSet(HIGH_FREEZE);
        }
    }

    public static class TrustSetFlags
    extends TransactionFlags {
        protected static final TrustSetFlags UNSET = new TrustSetFlags(0L);
        protected static final TrustSetFlags SET_F_AUTH = new TrustSetFlags(65536L);
        protected static final TrustSetFlags SET_NO_RIPPLE = new TrustSetFlags(131072L);
        protected static final TrustSetFlags CLEAR_NO_RIPPLE = new TrustSetFlags(262144L);
        protected static final TrustSetFlags SET_FREEZE = new TrustSetFlags(0x100000L);
        protected static final TrustSetFlags CLEAR_FREEZE = new TrustSetFlags(0x200000L);

        private TrustSetFlags(long value) {
            super(value);
        }

        public static Builder builder() {
            return new Builder();
        }

        private static TrustSetFlags of(boolean tfFullyCanonicalSig, boolean tfSetfAuth, boolean tfSetNoRipple, boolean tfClearNoRipple, boolean tfSetFreeze, boolean tfClearFreeze) {
            return new TrustSetFlags(Flags.of(tfFullyCanonicalSig ? TransactionFlags.FULLY_CANONICAL_SIG : UNSET, tfSetfAuth ? SET_F_AUTH : UNSET, tfSetNoRipple ? SET_NO_RIPPLE : UNSET, tfClearNoRipple ? CLEAR_NO_RIPPLE : UNSET, tfSetFreeze ? SET_FREEZE : UNSET, tfClearFreeze ? CLEAR_FREEZE : UNSET).getValue());
        }

        public static TrustSetFlags of(long value) {
            return new TrustSetFlags(value);
        }

        @Override
        public boolean tfFullyCanonicalSig() {
            return this.isSet(TransactionFlags.FULLY_CANONICAL_SIG);
        }

        public boolean tfSetfAuth() {
            return this.isSet(SET_F_AUTH);
        }

        public boolean tfSetNoRipple() {
            return this.isSet(SET_NO_RIPPLE);
        }

        public boolean tfClearNoRipple() {
            return this.isSet(CLEAR_NO_RIPPLE);
        }

        public boolean tfSetFreeze() {
            return this.isSet(SET_FREEZE);
        }

        public boolean tfClearFreeze() {
            return this.isSet(CLEAR_FREEZE);
        }

        public static class Builder {
            private boolean tfFullyCanonicalSig = true;
            private boolean tfSetfAuth = false;
            private boolean tfSetNoRipple = false;
            private boolean tfClearNoRipple = false;
            private boolean tfSetFreeze = false;
            private boolean tfClearFreeze = false;

            public Builder tfFullyCanonicalSig(boolean tfFullyCanonicalSig) {
                this.tfFullyCanonicalSig = tfFullyCanonicalSig;
                return this;
            }

            public Builder tfSetfAuth(boolean tfSetfAuth) {
                this.tfSetfAuth = tfSetfAuth;
                return this;
            }

            public Builder tfSetNoRipple() {
                this.tfSetNoRipple = true;
                return this;
            }

            public Builder tfClearNoRipple() {
                this.tfClearNoRipple = true;
                return this;
            }

            public Builder tfSetFreeze() {
                this.tfSetFreeze = true;
                return this;
            }

            public Builder tfClearFreeze() {
                this.tfClearFreeze = true;
                return this;
            }

            public TrustSetFlags build() {
                return TrustSetFlags.of(this.tfFullyCanonicalSig, this.tfSetfAuth, this.tfSetNoRipple, this.tfClearNoRipple, this.tfSetFreeze, this.tfClearFreeze);
            }
        }
    }

    public static class SignerListFlags
    extends Flags {
        public static final SignerListFlags UNSET = new SignerListFlags(0L);
        public static final SignerListFlags ONE_OWNER_COUNT = new SignerListFlags(65536L);

        private SignerListFlags(long value) {
            super(value);
        }

        private static SignerListFlags of(boolean lsfOneOwnerCount) {
            return new SignerListFlags(Flags.of(lsfOneOwnerCount ? ONE_OWNER_COUNT : UNSET, new Flags[0]).getValue());
        }

        public static SignerListFlags of(long value) {
            return new SignerListFlags(value);
        }

        public boolean lsfOneOwnerCount() {
            return this.isSet(ONE_OWNER_COUNT);
        }
    }

    public static class AccountRootFlags
    extends Flags {
        public static final AccountRootFlags UNSET = new AccountRootFlags(0L);
        public static final AccountRootFlags DEFAULT_RIPPLE = new AccountRootFlags(0x800000L);
        public static final AccountRootFlags DEPOSIT_AUTH = new AccountRootFlags(0x1000000L);
        public static final AccountRootFlags DISABLE_MASTER = new AccountRootFlags(0x100000L);
        public static final AccountRootFlags DISALLOW_XRP = new AccountRootFlags(524288L);
        public static final AccountRootFlags GLOBAL_FREEZE = new AccountRootFlags(0x400000L);
        public static final AccountRootFlags NO_FREEZE = new AccountRootFlags(0x200000L);
        public static final AccountRootFlags PASSWORD_SPENT = new AccountRootFlags(65536L);
        public static final AccountRootFlags REQUIRE_AUTH = new AccountRootFlags(262144L);
        public static final AccountRootFlags REQUIRE_DEST_TAG = new AccountRootFlags(131072L);

        private AccountRootFlags(long value) {
            super(value);
        }

        public static AccountRootFlags of(long value) {
            return new AccountRootFlags(value);
        }

        public boolean lsfDefaultRipple() {
            return this.isSet(DEFAULT_RIPPLE);
        }

        public boolean lsfDepositAuth() {
            return this.isSet(DEPOSIT_AUTH);
        }

        public boolean lsfDisableMaster() {
            return this.isSet(DISABLE_MASTER);
        }

        public boolean lsfDisallowXrp() {
            return this.isSet(DISALLOW_XRP);
        }

        public boolean lsfGlobalFreeze() {
            return this.isSet(GLOBAL_FREEZE);
        }

        public boolean lsfNoFreeze() {
            return this.isSet(NO_FREEZE);
        }

        public boolean lsfPasswordSpent() {
            return this.isSet(PASSWORD_SPENT);
        }

        public boolean lsfRequireAuth() {
            return this.isSet(REQUIRE_AUTH);
        }

        public boolean lsfRequireDestTag() {
            return this.isSet(REQUIRE_DEST_TAG);
        }
    }

    public static class PaymentFlags
    extends TransactionFlags {
        public static final PaymentFlags UNSET = new PaymentFlags(0L);
        protected static final PaymentFlags NO_DIRECT_RIPPLE = new PaymentFlags(65536L);
        protected static final PaymentFlags PARTIAL_PAYMENT = new PaymentFlags(131072L);
        protected static final PaymentFlags LIMIT_QUALITY = new PaymentFlags(262144L);

        private PaymentFlags(long value) {
            super(value);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static PaymentFlags of(long value) {
            return new PaymentFlags(value);
        }

        private static PaymentFlags of(boolean tfFullyCanonicalSig, boolean tfNoDirectRipple, boolean tfPartialPayment, boolean tfLimitQuality) {
            return new PaymentFlags(PaymentFlags.of(tfFullyCanonicalSig ? TransactionFlags.FULLY_CANONICAL_SIG : UNSET, tfNoDirectRipple ? NO_DIRECT_RIPPLE : UNSET, tfPartialPayment ? PARTIAL_PAYMENT : UNSET, tfLimitQuality ? LIMIT_QUALITY : UNSET).getValue());
        }

        public boolean tfNoDirectRipple() {
            return this.isSet(NO_DIRECT_RIPPLE);
        }

        public boolean tfPartialPayment() {
            return this.isSet(PARTIAL_PAYMENT);
        }

        public boolean tfLimitQuality() {
            return this.isSet(LIMIT_QUALITY);
        }

        public static class Builder {
            private boolean tfFullyCanonicalSig = true;
            private boolean tfNoDirectRipple = false;
            private boolean tfPartialPayment = false;
            private boolean tfLimitQuality = false;

            public Builder tfFullyCanonicalSig(boolean tfFullyCanonicalSig) {
                this.tfFullyCanonicalSig = tfFullyCanonicalSig;
                return this;
            }

            public Builder tfNoDirectRipple(boolean tfNoDirectRipple) {
                this.tfNoDirectRipple = tfNoDirectRipple;
                return this;
            }

            public Builder tfPartialPayment(boolean tfPartialPayment) {
                this.tfPartialPayment = tfPartialPayment;
                return this;
            }

            public Builder tfLimitQuality(boolean tfLimitQuality) {
                this.tfLimitQuality = tfLimitQuality;
                return this;
            }

            public PaymentFlags build() {
                return PaymentFlags.of(this.tfFullyCanonicalSig, this.tfNoDirectRipple, this.tfPartialPayment, this.tfLimitQuality);
            }
        }
    }

    public static class TransactionFlags
    extends Flags {
        protected static final TransactionFlags FULLY_CANONICAL_SIG = new TransactionFlags(0x80000000L);

        private TransactionFlags(long value) {
            super(value);
        }

        public boolean tfFullyCanonicalSig() {
            return this.isSet(FULLY_CANONICAL_SIG);
        }

        public static class Builder {
            private boolean tfFullyCanonicalSig = true;

            public Builder tfFullyCanonicalSig(boolean tfFullyCanonicalSig) {
                this.tfFullyCanonicalSig = tfFullyCanonicalSig;
                return this;
            }

            public TransactionFlags build() {
                return new TransactionFlags(this.tfFullyCanonicalSig ? FULLY_CANONICAL_SIG.getValue() : UNSET.getValue());
            }
        }
    }
}

