/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.jackson.modules;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Optional;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.transactions.TransactionResult;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.TransactionMetadata;

public class TransactionResultDeserializer<T extends Transaction>
extends StdDeserializer<TransactionResult<T>> {
    protected TransactionResultDeserializer() {
        super(TransactionResult.class);
    }

    public TransactionResult<T> deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
        ObjectNode objectNode = (ObjectNode)objectMapper.readTree(jsonParser);
        JavaType javaType = objectMapper.getTypeFactory().constructType(new TypeReference<T>(){});
        Transaction transaction = (Transaction)objectMapper.convertValue((Object)objectNode, javaType);
        LedgerIndex ledgerIndex = objectNode.has("ledger_index") ? LedgerIndex.of(objectNode.get("ledger_index").asText()) : null;
        String status = objectNode.has("status") ? objectNode.get("status").asText() : null;
        boolean validated = objectNode.has("validated") && objectNode.get("validated").asBoolean();
        Optional<TransactionMetadata> metadata = this.getTransactionMetadata(objectMapper, objectNode);
        return TransactionResult.builder().transaction(transaction).ledgerIndex(Optional.ofNullable(ledgerIndex)).status(Optional.ofNullable(status)).validated(validated).metadata(metadata).build();
    }

    private Optional<TransactionMetadata> getTransactionMetadata(ObjectMapper objectMapper, ObjectNode objectNode) {
        if (objectNode.has("meta")) {
            return Optional.of(objectMapper.convertValue((Object)objectNode.get("meta"), TransactionMetadata.class));
        }
        return Optional.empty();
    }
}

