/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.AccountRootObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.SignerListObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountRootObject", generator="Immutables")
@Immutable
public final class ImmutableAccountRootObject
implements AccountRootObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final Address account;
    private final XrpCurrencyAmount balance;
    private final Flags.AccountRootFlags flags;
    private final UnsignedInteger ownerCount;
    private final Hash256 previousTransactionId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    private final UnsignedInteger sequence;
    @Nullable
    private final Hash256 accountTransactionId;
    @Nullable
    private final String domain;
    @Nullable
    private final String emailHash;
    @Nullable
    private final String messageKey;
    @Nullable
    private final Address regularKey;
    @Nullable
    private final UnsignedInteger tickSize;
    @Nullable
    private final UnsignedInteger transferRate;
    private final ImmutableList<SignerListObject> signerLists;
    private final Hash256 index;

    private ImmutableAccountRootObject(Address account, XrpCurrencyAmount balance, Flags.AccountRootFlags flags, UnsignedInteger ownerCount, Hash256 previousTransactionId, UnsignedInteger previousTransactionLedgerSequence, UnsignedInteger sequence, @Nullable Hash256 accountTransactionId, @Nullable String domain, @Nullable String emailHash, @Nullable String messageKey, @Nullable Address regularKey, @Nullable UnsignedInteger tickSize, @Nullable UnsignedInteger transferRate, ImmutableList<SignerListObject> signerLists, Hash256 index) {
        this.account = account;
        this.balance = balance;
        this.flags = flags;
        this.ownerCount = ownerCount;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.sequence = sequence;
        this.accountTransactionId = accountTransactionId;
        this.domain = domain;
        this.emailHash = emailHash;
        this.messageKey = messageKey;
        this.regularKey = regularKey;
        this.tickSize = tickSize;
        this.transferRate = transferRate;
        this.signerLists = signerLists;
        this.index = index;
        this.ledgerEntryType = Objects.requireNonNull(AccountRootObject.super.ledgerEntryType(), "ledgerEntryType");
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        return this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="Balance")
    public XrpCurrencyAmount balance() {
        return this.balance;
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags.AccountRootFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="OwnerCount")
    public UnsignedInteger ownerCount() {
        return this.ownerCount;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId() {
        return this.previousTransactionId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence() {
        return this.sequence;
    }

    @Override
    @JsonProperty(value="AccountTxnID")
    public Optional<Hash256> accountTransactionId() {
        return Optional.ofNullable(this.accountTransactionId);
    }

    @Override
    @JsonProperty(value="Domain")
    public Optional<String> domain() {
        return Optional.ofNullable(this.domain);
    }

    @Override
    @JsonProperty(value="EmailHash")
    public Optional<String> emailHash() {
        return Optional.ofNullable(this.emailHash);
    }

    @Override
    @JsonProperty(value="MessageKey")
    public Optional<String> messageKey() {
        return Optional.ofNullable(this.messageKey);
    }

    @Override
    @JsonProperty(value="RegularKey")
    public Optional<Address> regularKey() {
        return Optional.ofNullable(this.regularKey);
    }

    @Override
    @JsonProperty(value="TickSize")
    public Optional<UnsignedInteger> tickSize() {
        return Optional.ofNullable(this.tickSize);
    }

    @Override
    @JsonProperty(value="TransferRate")
    public Optional<UnsignedInteger> transferRate() {
        return Optional.ofNullable(this.transferRate);
    }

    @JsonProperty(value="signer_lists")
    public ImmutableList<SignerListObject> signerLists() {
        return this.signerLists;
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableAccountRootObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountRootObject(newValue, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withBalance(XrpCurrencyAmount value) {
        if (this.balance == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "balance");
        return new ImmutableAccountRootObject(this.account, newValue, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withFlags(Flags.AccountRootFlags value) {
        if (this.flags == value) {
            return this;
        }
        Flags.AccountRootFlags newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableAccountRootObject(this.account, this.balance, newValue, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withOwnerCount(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "ownerCount");
        if (this.ownerCount.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withPreviousTransactionId(Hash256 value) {
        if (this.previousTransactionId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, newValue, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, newValue, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (this.sequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withAccountTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "accountTransactionId");
        if (this.accountTransactionId == newValue) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, newValue, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withAccountTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.accountTransactionId == value) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, value, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withDomain(String value) {
        String newValue = Objects.requireNonNull(value, "domain");
        if (Objects.equals(this.domain, newValue)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, newValue, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withDomain(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.domain, value)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, value, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withEmailHash(String value) {
        String newValue = Objects.requireNonNull(value, "emailHash");
        if (Objects.equals(this.emailHash, newValue)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, newValue, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withEmailHash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.emailHash, value)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, value, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withMessageKey(String value) {
        String newValue = Objects.requireNonNull(value, "messageKey");
        if (Objects.equals(this.messageKey, newValue)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, newValue, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withMessageKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.messageKey, value)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, value, this.regularKey, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withRegularKey(Address value) {
        Address newValue = Objects.requireNonNull(value, "regularKey");
        if (this.regularKey == newValue) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, newValue, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withRegularKey(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.regularKey == value) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, value, this.tickSize, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withTickSize(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "tickSize");
        if (Objects.equals(this.tickSize, newValue)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, newValue, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withTickSize(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.tickSize, value)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, value, this.transferRate, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withTransferRate(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "transferRate");
        if (Objects.equals(this.transferRate, newValue)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, newValue, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withTransferRate(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.transferRate, value)) {
            return this;
        }
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, value, this.signerLists, this.index);
    }

    public final ImmutableAccountRootObject withSignerLists(SignerListObject ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, (ImmutableList<SignerListObject>)newValue, this.index);
    }

    public final ImmutableAccountRootObject withSignerLists(Iterable<? extends SignerListObject> elements) {
        if (this.signerLists == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, (ImmutableList<SignerListObject>)newValue, this.index);
    }

    public final ImmutableAccountRootObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountRootObject && this.equalTo((ImmutableAccountRootObject)another);
    }

    private boolean equalTo(ImmutableAccountRootObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.account.equals(another.account) && this.balance.equals(another.balance) && this.flags.equals(another.flags) && this.ownerCount.equals((Object)another.ownerCount) && this.previousTransactionId.equals(another.previousTransactionId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && this.sequence.equals((Object)another.sequence) && Objects.equals(this.accountTransactionId, another.accountTransactionId) && Objects.equals(this.domain, another.domain) && Objects.equals(this.emailHash, another.emailHash) && Objects.equals(this.messageKey, another.messageKey) && Objects.equals(this.regularKey, another.regularKey) && Objects.equals(this.tickSize, another.tickSize) && Objects.equals(this.transferRate, another.transferRate) && this.signerLists.equals(another.signerLists) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.balance.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.ownerCount.hashCode();
        h += (h << 5) + this.previousTransactionId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + this.sequence.hashCode();
        h += (h << 5) + Objects.hashCode(this.accountTransactionId);
        h += (h << 5) + Objects.hashCode(this.domain);
        h += (h << 5) + Objects.hashCode(this.emailHash);
        h += (h << 5) + Objects.hashCode(this.messageKey);
        h += (h << 5) + Objects.hashCode(this.regularKey);
        h += (h << 5) + Objects.hashCode(this.tickSize);
        h += (h << 5) + Objects.hashCode(this.transferRate);
        h += (h << 5) + this.signerLists.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountRootObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("account", (Object)this.account).add("balance", (Object)this.balance).add("flags", (Object)this.flags).add("ownerCount", (Object)this.ownerCount).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("sequence", (Object)this.sequence).add("accountTransactionId", (Object)this.accountTransactionId).add("domain", (Object)this.domain).add("emailHash", (Object)this.emailHash).add("messageKey", (Object)this.messageKey).add("regularKey", (Object)this.regularKey).add("tickSize", (Object)this.tickSize).add("transferRate", (Object)this.transferRate).add("signerLists", this.signerLists).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountRootObject fromJson(Json json) {
        Builder builder = ImmutableAccountRootObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.balance != null) {
            builder.balance(json.balance);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.ownerCount != null) {
            builder.ownerCount(json.ownerCount);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.accountTransactionId != null) {
            builder.accountTransactionId(json.accountTransactionId);
        }
        if (json.domain != null) {
            builder.domain(json.domain);
        }
        if (json.emailHash != null) {
            builder.emailHash(json.emailHash);
        }
        if (json.messageKey != null) {
            builder.messageKey(json.messageKey);
        }
        if (json.regularKey != null) {
            builder.regularKey(json.regularKey);
        }
        if (json.tickSize != null) {
            builder.tickSize(json.tickSize);
        }
        if (json.transferRate != null) {
            builder.transferRate(json.transferRate);
        }
        if (json.signerLists != null) {
            builder.addAllSignerLists(json.signerLists);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableAccountRootObject copyOf(AccountRootObject instance) {
        if (instance instanceof ImmutableAccountRootObject) {
            return (ImmutableAccountRootObject)instance;
        }
        return ImmutableAccountRootObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountRootObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_BALANCE = 2L;
        private static final long INIT_BIT_FLAGS = 4L;
        private static final long INIT_BIT_OWNER_COUNT = 8L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_ID = 16L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 32L;
        private static final long INIT_BIT_SEQUENCE = 64L;
        private static final long INIT_BIT_INDEX = 128L;
        private long initBits = 255L;
        @Nullable
        private Address account;
        @Nullable
        private XrpCurrencyAmount balance;
        @Nullable
        private Flags.AccountRootFlags flags;
        @Nullable
        private UnsignedInteger ownerCount;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private UnsignedInteger sequence;
        @Nullable
        private Hash256 accountTransactionId;
        @Nullable
        private String domain;
        @Nullable
        private String emailHash;
        @Nullable
        private String messageKey;
        @Nullable
        private Address regularKey;
        @Nullable
        private UnsignedInteger tickSize;
        @Nullable
        private UnsignedInteger transferRate;
        private ImmutableList.Builder<SignerListObject> signerLists = ImmutableList.builder();
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountRootObject instance) {
            Optional<UnsignedInteger> transferRateOptional;
            Optional<UnsignedInteger> tickSizeOptional;
            Optional<Address> regularKeyOptional;
            Optional<String> messageKeyOptional;
            Optional<String> emailHashOptional;
            Optional<String> domainOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.balance(instance.balance());
            this.flags(instance.flags());
            this.ownerCount(instance.ownerCount());
            this.previousTransactionId(instance.previousTransactionId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            this.sequence(instance.sequence());
            Optional<Hash256> accountTransactionIdOptional = instance.accountTransactionId();
            if (accountTransactionIdOptional.isPresent()) {
                this.accountTransactionId(accountTransactionIdOptional);
            }
            if ((domainOptional = instance.domain()).isPresent()) {
                this.domain(domainOptional);
            }
            if ((emailHashOptional = instance.emailHash()).isPresent()) {
                this.emailHash(emailHashOptional);
            }
            if ((messageKeyOptional = instance.messageKey()).isPresent()) {
                this.messageKey(messageKeyOptional);
            }
            if ((regularKeyOptional = instance.regularKey()).isPresent()) {
                this.regularKey(regularKeyOptional);
            }
            if ((tickSizeOptional = instance.tickSize()).isPresent()) {
                this.tickSize(tickSizeOptional);
            }
            if ((transferRateOptional = instance.transferRate()).isPresent()) {
                this.transferRate(transferRateOptional);
            }
            this.addAllSignerLists(instance.signerLists());
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Balance")
        @CanIgnoreReturnValue
        public final Builder balance(XrpCurrencyAmount balance) {
            this.balance = Objects.requireNonNull(balance, "balance");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(Flags.AccountRootFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="OwnerCount")
        @CanIgnoreReturnValue
        public final Builder ownerCount(UnsignedInteger ownerCount) {
            this.ownerCount = Objects.requireNonNull(ownerCount, "ownerCount");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Sequence")
        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Hash256 accountTransactionId) {
            this.accountTransactionId = Objects.requireNonNull(accountTransactionId, "accountTransactionId");
            return this;
        }

        @JsonProperty(value="AccountTxnID")
        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Optional<? extends Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder domain(String domain) {
            this.domain = Objects.requireNonNull(domain, "domain");
            return this;
        }

        @JsonProperty(value="Domain")
        @CanIgnoreReturnValue
        public final Builder domain(Optional<String> domain) {
            this.domain = domain.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder emailHash(String emailHash) {
            this.emailHash = Objects.requireNonNull(emailHash, "emailHash");
            return this;
        }

        @JsonProperty(value="EmailHash")
        @CanIgnoreReturnValue
        public final Builder emailHash(Optional<String> emailHash) {
            this.emailHash = emailHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messageKey(String messageKey) {
            this.messageKey = Objects.requireNonNull(messageKey, "messageKey");
            return this;
        }

        @JsonProperty(value="MessageKey")
        @CanIgnoreReturnValue
        public final Builder messageKey(Optional<String> messageKey) {
            this.messageKey = messageKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder regularKey(Address regularKey) {
            this.regularKey = Objects.requireNonNull(regularKey, "regularKey");
            return this;
        }

        @JsonProperty(value="RegularKey")
        @CanIgnoreReturnValue
        public final Builder regularKey(Optional<? extends Address> regularKey) {
            this.regularKey = regularKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tickSize(UnsignedInteger tickSize) {
            this.tickSize = Objects.requireNonNull(tickSize, "tickSize");
            return this;
        }

        @JsonProperty(value="TickSize")
        @CanIgnoreReturnValue
        public final Builder tickSize(Optional<? extends UnsignedInteger> tickSize) {
            this.tickSize = tickSize.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transferRate(UnsignedInteger transferRate) {
            this.transferRate = Objects.requireNonNull(transferRate, "transferRate");
            return this;
        }

        @JsonProperty(value="TransferRate")
        @CanIgnoreReturnValue
        public final Builder transferRate(Optional<? extends UnsignedInteger> transferRate) {
            this.transferRate = transferRate.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignerLists(SignerListObject element) {
            this.signerLists.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSignerLists(SignerListObject ... elements) {
            this.signerLists.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="signer_lists")
        @CanIgnoreReturnValue
        public final Builder signerLists(Iterable<? extends SignerListObject> elements) {
            this.signerLists = ImmutableList.builder();
            return this.addAllSignerLists(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSignerLists(Iterable<? extends SignerListObject> elements) {
            this.signerLists.addAll(elements);
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableAccountRootObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountRootObject(this.account, this.balance, this.flags, this.ownerCount, this.previousTransactionId, this.previousTransactionLedgerSequence, this.sequence, this.accountTransactionId, this.domain, this.emailHash, this.messageKey, this.regularKey, this.tickSize, this.transferRate, this.signerLists.build(), this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("balance");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("ownerCount");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("previousTransactionId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("sequence");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build AccountRootObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountRootObject", generator="Immutables")
    static final class Json
    implements AccountRootObject {
        @Nullable
        Address account;
        @Nullable
        XrpCurrencyAmount balance;
        @Nullable
        Flags.AccountRootFlags flags;
        @Nullable
        UnsignedInteger ownerCount;
        @Nullable
        Hash256 previousTransactionId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        UnsignedInteger sequence;
        @Nullable
        Optional<Hash256> accountTransactionId = Optional.empty();
        @Nullable
        Optional<String> domain = Optional.empty();
        @Nullable
        Optional<String> emailHash = Optional.empty();
        @Nullable
        Optional<String> messageKey = Optional.empty();
        @Nullable
        Optional<Address> regularKey = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> tickSize = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> transferRate = Optional.empty();
        @Nullable
        List<SignerListObject> signerLists = ImmutableList.of();
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="Balance")
        public void setBalance(XrpCurrencyAmount balance) {
            this.balance = balance;
        }

        @JsonProperty(value="Flags")
        public void setFlags(Flags.AccountRootFlags flags) {
            this.flags = flags;
        }

        @JsonProperty(value="OwnerCount")
        public void setOwnerCount(UnsignedInteger ownerCount) {
            this.ownerCount = ownerCount;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="Sequence")
        public void setSequence(UnsignedInteger sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="AccountTxnID")
        public void setAccountTransactionId(Optional<Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId;
        }

        @JsonProperty(value="Domain")
        public void setDomain(Optional<String> domain) {
            this.domain = domain;
        }

        @JsonProperty(value="EmailHash")
        public void setEmailHash(Optional<String> emailHash) {
            this.emailHash = emailHash;
        }

        @JsonProperty(value="MessageKey")
        public void setMessageKey(Optional<String> messageKey) {
            this.messageKey = messageKey;
        }

        @JsonProperty(value="RegularKey")
        public void setRegularKey(Optional<Address> regularKey) {
            this.regularKey = regularKey;
        }

        @JsonProperty(value="TickSize")
        public void setTickSize(Optional<UnsignedInteger> tickSize) {
            this.tickSize = tickSize;
        }

        @JsonProperty(value="TransferRate")
        public void setTransferRate(Optional<UnsignedInteger> transferRate) {
            this.transferRate = transferRate;
        }

        @JsonProperty(value="signer_lists")
        public void setSignerLists(List<SignerListObject> signerLists) {
            this.signerLists = signerLists;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount balance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Flags.AccountRootFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger ownerCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> accountTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> domain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> emailHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> messageKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> regularKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> tickSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> transferRate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SignerListObject> signerLists() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

