/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ripple.cryptoconditions.Condition;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.EscrowObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EscrowObject", generator="Immutables")
@Immutable
public final class ImmutableEscrowObject
implements EscrowObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final Address account;
    private final Address destination;
    private final XrpCurrencyAmount amount;
    @Nullable
    private final Condition condition;
    @Nullable
    private final UnsignedLong cancelAfter;
    @Nullable
    private final UnsignedLong finishAfter;
    private final transient Flags flags;
    @Nullable
    private final UnsignedInteger sourceTag;
    @Nullable
    private final UnsignedInteger destinationTag;
    @Nullable
    private final String ownerNode;
    @Nullable
    private final String destinationNode;
    @Nullable
    private final Hash256 previousTransactionId;
    @Nullable
    private final UnsignedInteger previousTransactionLedgerSequence;
    private final Hash256 index;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEscrowObject(Address account, Address destination, XrpCurrencyAmount amount, @Nullable Condition condition, @Nullable UnsignedLong cancelAfter, @Nullable UnsignedLong finishAfter, @Nullable UnsignedInteger sourceTag, @Nullable UnsignedInteger destinationTag, @Nullable String ownerNode, @Nullable String destinationNode, @Nullable Hash256 previousTransactionId, @Nullable UnsignedInteger previousTransactionLedgerSequence, Hash256 index) {
        this.account = account;
        this.destination = destination;
        this.amount = amount;
        this.condition = condition;
        this.cancelAfter = cancelAfter;
        this.finishAfter = finishAfter;
        this.sourceTag = sourceTag;
        this.destinationTag = destinationTag;
        this.ownerNode = ownerNode;
        this.destinationNode = destinationNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.index = index;
        this.ledgerEntryType = this.initShim.ledgerEntryType();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private LedgerObject.LedgerEntryType ledgerEntryTypeInitialize() {
        return EscrowObject.super.ledgerEntryType();
    }

    private Flags flagsInitialize() {
        return EscrowObject.super.flags();
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerEntryType() : this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="Destination")
    public Address destination() {
        return this.destination;
    }

    @Override
    @JsonProperty(value="Amount")
    public XrpCurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="Condition")
    public Optional<Condition> condition() {
        return Optional.ofNullable(this.condition);
    }

    @Override
    @JsonProperty(value="CancelAfter")
    public Optional<UnsignedLong> cancelAfter() {
        return Optional.ofNullable(this.cancelAfter);
    }

    @Override
    @JsonProperty(value="FinishAfter")
    public Optional<UnsignedLong> finishAfter() {
        return Optional.ofNullable(this.finishAfter);
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag() {
        return Optional.ofNullable(this.sourceTag);
    }

    @Override
    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag() {
        return Optional.ofNullable(this.destinationTag);
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public Optional<String> ownerNode() {
        return Optional.ofNullable(this.ownerNode);
    }

    @Override
    @JsonProperty(value="DestinationNode")
    public Optional<String> destinationNode() {
        return Optional.ofNullable(this.destinationNode);
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Optional<Hash256> previousTransactionId() {
        return Optional.ofNullable(this.previousTransactionId);
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public Optional<UnsignedInteger> previousTransactionLedgerSequence() {
        return Optional.ofNullable(this.previousTransactionLedgerSequence);
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableEscrowObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableEscrowObject(newValue, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withDestination(Address value) {
        if (this.destination == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableEscrowObject(this.account, newValue, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withAmount(XrpCurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutableEscrowObject(this.account, this.destination, newValue, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withCondition(Condition value) {
        Condition newValue = Objects.requireNonNull(value, "condition");
        if (this.condition == newValue) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, newValue, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withCondition(Optional<? extends Condition> optional) {
        Condition value = optional.orElse(null);
        if (this.condition == value) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, value, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withCancelAfter(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "cancelAfter");
        if (Objects.equals(this.cancelAfter, newValue)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, newValue, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withCancelAfter(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.cancelAfter, value)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, value, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withFinishAfter(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "finishAfter");
        if (Objects.equals(this.finishAfter, newValue)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, newValue, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withFinishAfter(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.finishAfter, value)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, value, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withSourceTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sourceTag");
        if (Objects.equals(this.sourceTag, newValue)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, newValue, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withSourceTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sourceTag, value)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, value, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withDestinationTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "destinationTag");
        if (Objects.equals(this.destinationTag, newValue)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, newValue, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withDestinationTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.destinationTag, value)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, value, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (Objects.equals(this.ownerNode, newValue)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, newValue, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withOwnerNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerNode, value)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, value, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withDestinationNode(String value) {
        String newValue = Objects.requireNonNull(value, "destinationNode");
        if (Objects.equals(this.destinationNode, newValue)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withDestinationNode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.destinationNode, value)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, value, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withPreviousTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        if (this.previousTransactionId == newValue) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, newValue, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withPreviousTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.previousTransactionId == value) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, value, this.previousTransactionLedgerSequence, this.index);
    }

    public final ImmutableEscrowObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (Objects.equals(this.previousTransactionLedgerSequence, newValue)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, newValue, this.index);
    }

    public final ImmutableEscrowObject withPreviousTransactionLedgerSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.previousTransactionLedgerSequence, value)) {
            return this;
        }
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, value, this.index);
    }

    public final ImmutableEscrowObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEscrowObject && this.equalTo((ImmutableEscrowObject)another);
    }

    private boolean equalTo(ImmutableEscrowObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.account.equals(another.account) && this.destination.equals(another.destination) && this.amount.equals(another.amount) && Objects.equals(this.condition, another.condition) && Objects.equals(this.cancelAfter, another.cancelAfter) && Objects.equals(this.finishAfter, another.finishAfter) && this.flags.equals(another.flags) && Objects.equals(this.sourceTag, another.sourceTag) && Objects.equals(this.destinationTag, another.destinationTag) && Objects.equals(this.ownerNode, another.ownerNode) && Objects.equals(this.destinationNode, another.destinationNode) && Objects.equals(this.previousTransactionId, another.previousTransactionId) && Objects.equals(this.previousTransactionLedgerSequence, another.previousTransactionLedgerSequence) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + Objects.hashCode(this.condition);
        h += (h << 5) + Objects.hashCode(this.cancelAfter);
        h += (h << 5) + Objects.hashCode(this.finishAfter);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceTag);
        h += (h << 5) + Objects.hashCode(this.destinationTag);
        h += (h << 5) + Objects.hashCode(this.ownerNode);
        h += (h << 5) + Objects.hashCode(this.destinationNode);
        h += (h << 5) + Objects.hashCode(this.previousTransactionId);
        h += (h << 5) + Objects.hashCode(this.previousTransactionLedgerSequence);
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EscrowObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("account", (Object)this.account).add("destination", (Object)this.destination).add("amount", (Object)this.amount).add("condition", (Object)this.condition).add("cancelAfter", (Object)this.cancelAfter).add("finishAfter", (Object)this.finishAfter).add("flags", (Object)this.flags).add("sourceTag", (Object)this.sourceTag).add("destinationTag", (Object)this.destinationTag).add("ownerNode", (Object)this.ownerNode).add("destinationNode", (Object)this.destinationNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEscrowObject fromJson(Json json) {
        Builder builder = ImmutableEscrowObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.condition != null) {
            builder.condition(json.condition);
        }
        if (json.cancelAfter != null) {
            builder.cancelAfter(json.cancelAfter);
        }
        if (json.finishAfter != null) {
            builder.finishAfter(json.finishAfter);
        }
        if (json.sourceTag != null) {
            builder.sourceTag(json.sourceTag);
        }
        if (json.destinationTag != null) {
            builder.destinationTag(json.destinationTag);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.destinationNode != null) {
            builder.destinationNode(json.destinationNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableEscrowObject copyOf(EscrowObject instance) {
        if (instance instanceof ImmutableEscrowObject) {
            return (ImmutableEscrowObject)instance;
        }
        return ImmutableEscrowObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EscrowObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_DESTINATION = 2L;
        private static final long INIT_BIT_AMOUNT = 4L;
        private static final long INIT_BIT_INDEX = 8L;
        private long initBits = 15L;
        @Nullable
        private Address account;
        @Nullable
        private Address destination;
        @Nullable
        private XrpCurrencyAmount amount;
        @Nullable
        private Condition condition;
        @Nullable
        private UnsignedLong cancelAfter;
        @Nullable
        private UnsignedLong finishAfter;
        @Nullable
        private UnsignedInteger sourceTag;
        @Nullable
        private UnsignedInteger destinationTag;
        @Nullable
        private String ownerNode;
        @Nullable
        private String destinationNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EscrowObject instance) {
            Optional<UnsignedInteger> previousTransactionLedgerSequenceOptional;
            Optional<Hash256> previousTransactionIdOptional;
            Optional<String> destinationNodeOptional;
            Optional<String> ownerNodeOptional;
            Optional<UnsignedInteger> destinationTagOptional;
            Optional<UnsignedInteger> sourceTagOptional;
            Optional<UnsignedLong> finishAfterOptional;
            Optional<UnsignedLong> cancelAfterOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.destination(instance.destination());
            this.amount(instance.amount());
            Optional<Condition> conditionOptional = instance.condition();
            if (conditionOptional.isPresent()) {
                this.condition(conditionOptional);
            }
            if ((cancelAfterOptional = instance.cancelAfter()).isPresent()) {
                this.cancelAfter(cancelAfterOptional);
            }
            if ((finishAfterOptional = instance.finishAfter()).isPresent()) {
                this.finishAfter(finishAfterOptional);
            }
            if ((sourceTagOptional = instance.sourceTag()).isPresent()) {
                this.sourceTag(sourceTagOptional);
            }
            if ((destinationTagOptional = instance.destinationTag()).isPresent()) {
                this.destinationTag(destinationTagOptional);
            }
            if ((ownerNodeOptional = instance.ownerNode()).isPresent()) {
                this.ownerNode(ownerNodeOptional);
            }
            if ((destinationNodeOptional = instance.destinationNode()).isPresent()) {
                this.destinationNode(destinationNodeOptional);
            }
            if ((previousTransactionIdOptional = instance.previousTransactionId()).isPresent()) {
                this.previousTransactionId(previousTransactionIdOptional);
            }
            if ((previousTransactionLedgerSequenceOptional = instance.previousTransactionLedgerSequence()).isPresent()) {
                this.previousTransactionLedgerSequence(previousTransactionLedgerSequenceOptional);
            }
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(XrpCurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder condition(Condition condition) {
            this.condition = Objects.requireNonNull(condition, "condition");
            return this;
        }

        @JsonProperty(value="Condition")
        @CanIgnoreReturnValue
        public final Builder condition(Optional<? extends Condition> condition) {
            this.condition = condition.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cancelAfter(UnsignedLong cancelAfter) {
            this.cancelAfter = Objects.requireNonNull(cancelAfter, "cancelAfter");
            return this;
        }

        @JsonProperty(value="CancelAfter")
        @CanIgnoreReturnValue
        public final Builder cancelAfter(Optional<? extends UnsignedLong> cancelAfter) {
            this.cancelAfter = cancelAfter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder finishAfter(UnsignedLong finishAfter) {
            this.finishAfter = Objects.requireNonNull(finishAfter, "finishAfter");
            return this;
        }

        @JsonProperty(value="FinishAfter")
        @CanIgnoreReturnValue
        public final Builder finishAfter(Optional<? extends UnsignedLong> finishAfter) {
            this.finishAfter = finishAfter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceTag(UnsignedInteger sourceTag) {
            this.sourceTag = Objects.requireNonNull(sourceTag, "sourceTag");
            return this;
        }

        @JsonProperty(value="SourceTag")
        @CanIgnoreReturnValue
        public final Builder sourceTag(Optional<? extends UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationTag(UnsignedInteger destinationTag) {
            this.destinationTag = Objects.requireNonNull(destinationTag, "destinationTag");
            return this;
        }

        @JsonProperty(value="DestinationTag")
        @CanIgnoreReturnValue
        public final Builder destinationTag(Optional<? extends UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationNode(String destinationNode) {
            this.destinationNode = Objects.requireNonNull(destinationNode, "destinationNode");
            return this;
        }

        @JsonProperty(value="DestinationNode")
        @CanIgnoreReturnValue
        public final Builder destinationNode(Optional<String> destinationNode) {
            this.destinationNode = destinationNode.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Optional<? extends Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(Optional<? extends UnsignedInteger> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence.orElse(null);
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableEscrowObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEscrowObject(this.account, this.destination, this.amount, this.condition, this.cancelAfter, this.finishAfter, this.sourceTag, this.destinationTag, this.ownerNode, this.destinationNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build EscrowObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EscrowObject", generator="Immutables")
    static final class Json
    implements EscrowObject {
        @Nullable
        Address account;
        @Nullable
        Address destination;
        @Nullable
        XrpCurrencyAmount amount;
        @Nullable
        Optional<Condition> condition = Optional.empty();
        @Nullable
        Optional<UnsignedLong> cancelAfter = Optional.empty();
        @Nullable
        Optional<UnsignedLong> finishAfter = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> sourceTag = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> destinationTag = Optional.empty();
        @Nullable
        Optional<String> ownerNode = Optional.empty();
        @Nullable
        Optional<String> destinationNode = Optional.empty();
        @Nullable
        Optional<Hash256> previousTransactionId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> previousTransactionLedgerSequence = Optional.empty();
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Address destination) {
            this.destination = destination;
        }

        @JsonProperty(value="Amount")
        public void setAmount(XrpCurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="Condition")
        public void setCondition(Optional<Condition> condition) {
            this.condition = condition;
        }

        @JsonProperty(value="CancelAfter")
        public void setCancelAfter(Optional<UnsignedLong> cancelAfter) {
            this.cancelAfter = cancelAfter;
        }

        @JsonProperty(value="FinishAfter")
        public void setFinishAfter(Optional<UnsignedLong> finishAfter) {
            this.finishAfter = finishAfter;
        }

        @JsonProperty(value="SourceTag")
        public void setSourceTag(Optional<UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag;
        }

        @JsonProperty(value="DestinationTag")
        public void setDestinationTag(Optional<UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(Optional<String> ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="DestinationNode")
        public void setDestinationNode(Optional<String> destinationNode) {
            this.destinationNode = destinationNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Optional<Hash256> previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(Optional<UnsignedInteger> previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Condition> condition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> cancelAfter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> finishAfter() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sourceTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> destinationTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> destinationNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="EscrowObject", generator="Immutables")
    private final class InitShim {
        private byte ledgerEntryTypeBuildStage = 0;
        private LedgerObject.LedgerEntryType ledgerEntryType;
        private byte flagsBuildStage = 0;
        private Flags flags;

        private InitShim() {
        }

        LedgerObject.LedgerEntryType ledgerEntryType() {
            if (this.ledgerEntryTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerEntryTypeBuildStage == 0) {
                this.ledgerEntryTypeBuildStage = (byte)-1;
                this.ledgerEntryType = Objects.requireNonNull(ImmutableEscrowObject.this.ledgerEntryTypeInitialize(), "ledgerEntryType");
                this.ledgerEntryTypeBuildStage = 1;
            }
            return this.ledgerEntryType;
        }

        Flags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutableEscrowObject.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerEntryTypeBuildStage == -1) {
                attributes.add("ledgerEntryType");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build EscrowObject, attribute initializers form cycle " + attributes;
        }
    }
}

