/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.transactions.TransactionResult;
import org.xrpl.xrpl4j.model.ledger.LedgerHeader;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LedgerHeader", generator="Immutables")
@Immutable
public final class ImmutableLedgerHeader
implements LedgerHeader {
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final Hash256 accountHash;
    @Nullable
    private final UnsignedLong closeTime;
    private final ZonedDateTime closeTimeHuman;
    private final boolean closed;
    private final Hash256 parentHash;
    @Nullable
    private final UnsignedLong parentCloseTime;
    @Nullable
    private final XrpCurrencyAmount totalCoins;
    @Nullable
    private final Hash256 transactionHash;
    private final ImmutableList<TransactionResult<? extends Transaction>> transactions;
    @Nullable
    private final UnsignedInteger closeTimeResolution;

    private ImmutableLedgerHeader(Builder builder) {
        this.ledgerIndex = builder.ledgerIndex;
        this.ledgerHash = builder.ledgerHash;
        this.accountHash = builder.accountHash;
        this.closeTime = builder.closeTime;
        this.closeTimeHuman = builder.closeTimeHuman;
        this.parentHash = builder.parentHash;
        this.parentCloseTime = builder.parentCloseTime;
        this.totalCoins = builder.totalCoins;
        this.transactionHash = builder.transactionHash;
        this.transactions = builder.transactions.build();
        this.closeTimeResolution = builder.closeTimeResolution;
        this.closed = builder.closedIsSet() ? builder.closed : LedgerHeader.super.closed();
    }

    private ImmutableLedgerHeader(LedgerIndex ledgerIndex, @Nullable Hash256 ledgerHash, @Nullable Hash256 accountHash, @Nullable UnsignedLong closeTime, ZonedDateTime closeTimeHuman, boolean closed, Hash256 parentHash, @Nullable UnsignedLong parentCloseTime, @Nullable XrpCurrencyAmount totalCoins, @Nullable Hash256 transactionHash, ImmutableList<TransactionResult<? extends Transaction>> transactions, @Nullable UnsignedInteger closeTimeResolution) {
        this.ledgerIndex = ledgerIndex;
        this.ledgerHash = ledgerHash;
        this.accountHash = accountHash;
        this.closeTime = closeTime;
        this.closeTimeHuman = closeTimeHuman;
        this.closed = closed;
        this.parentHash = parentHash;
        this.parentCloseTime = parentCloseTime;
        this.totalCoins = totalCoins;
        this.transactionHash = transactionHash;
        this.transactions = transactions;
        this.closeTimeResolution = closeTimeResolution;
    }

    @Override
    @JsonProperty(value="ledger_index")
    public LedgerIndex ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="ledger_hash")
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="account_hash")
    public Optional<Hash256> accountHash() {
        return Optional.ofNullable(this.accountHash);
    }

    @Override
    @JsonProperty(value="close_time")
    public Optional<UnsignedLong> closeTime() {
        return Optional.ofNullable(this.closeTime);
    }

    @Override
    @JsonProperty(value="close_time_human")
    @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSSSSS z", locale="en")
    public ZonedDateTime closeTimeHuman() {
        return this.closeTimeHuman;
    }

    @Override
    @JsonProperty(value="closed")
    public boolean closed() {
        return this.closed;
    }

    @Override
    @JsonProperty(value="parent_hash")
    public Hash256 parentHash() {
        return this.parentHash;
    }

    @Override
    @JsonProperty(value="parent_close_time")
    public Optional<UnsignedLong> parentCloseTime() {
        return Optional.ofNullable(this.parentCloseTime);
    }

    @Override
    @JsonProperty(value="total_coins")
    public Optional<XrpCurrencyAmount> totalCoins() {
        return Optional.ofNullable(this.totalCoins);
    }

    @Override
    @JsonProperty(value="transaction_hash")
    public Optional<Hash256> transactionHash() {
        return Optional.ofNullable(this.transactionHash);
    }

    @JsonProperty(value="transactions")
    public ImmutableList<TransactionResult<? extends Transaction>> transactions() {
        return this.transactions;
    }

    @Override
    @JsonProperty(value="close_time_resolution")
    public Optional<UnsignedInteger> closeTimeResolution() {
        return Optional.ofNullable(this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withLedgerIndex(LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        return new ImmutableLedgerHeader(newValue, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, newValue, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, value, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withAccountHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "accountHash");
        if (this.accountHash == newValue) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, newValue, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withAccountHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.accountHash == value) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, value, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withCloseTime(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "closeTime");
        if (Objects.equals(this.closeTime, newValue)) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, newValue, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withCloseTime(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.closeTime, value)) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, value, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withCloseTimeHuman(ZonedDateTime value) {
        if (this.closeTimeHuman == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "closeTimeHuman");
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, newValue, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withClosed(boolean value) {
        if (this.closed == value) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, value, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withParentHash(Hash256 value) {
        if (this.parentHash == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "parentHash");
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, newValue, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withParentCloseTime(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "parentCloseTime");
        if (Objects.equals(this.parentCloseTime, newValue)) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, newValue, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withParentCloseTime(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.parentCloseTime, value)) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, value, this.totalCoins, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withTotalCoins(XrpCurrencyAmount value) {
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "totalCoins");
        if (this.totalCoins == newValue) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, newValue, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withTotalCoins(Optional<? extends XrpCurrencyAmount> optional) {
        XrpCurrencyAmount value = optional.orElse(null);
        if (this.totalCoins == value) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, value, this.transactionHash, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withTransactionHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "transactionHash");
        if (this.transactionHash == newValue) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, newValue, this.transactions, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withTransactionHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.transactionHash == value) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, value, this.transactions, this.closeTimeResolution);
    }

    @SafeVarargs
    public final ImmutableLedgerHeader withTransactions(TransactionResult<? extends Transaction> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, (ImmutableList<TransactionResult<? extends Transaction>>)newValue, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withTransactions(Iterable<? extends TransactionResult<? extends Transaction>> elements) {
        if (this.transactions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, (ImmutableList<TransactionResult<? extends Transaction>>)newValue, this.closeTimeResolution);
    }

    public final ImmutableLedgerHeader withCloseTimeResolution(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "closeTimeResolution");
        if (Objects.equals(this.closeTimeResolution, newValue)) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, newValue);
    }

    public final ImmutableLedgerHeader withCloseTimeResolution(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.closeTimeResolution, value)) {
            return this;
        }
        return new ImmutableLedgerHeader(this.ledgerIndex, this.ledgerHash, this.accountHash, this.closeTime, this.closeTimeHuman, this.closed, this.parentHash, this.parentCloseTime, this.totalCoins, this.transactionHash, this.transactions, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLedgerHeader && this.equalTo((ImmutableLedgerHeader)another);
    }

    private boolean equalTo(ImmutableLedgerHeader another) {
        return this.ledgerIndex.equals(another.ledgerIndex) && Objects.equals(this.ledgerHash, another.ledgerHash) && Objects.equals(this.accountHash, another.accountHash) && Objects.equals(this.closeTime, another.closeTime) && this.closeTimeHuman.equals(another.closeTimeHuman) && this.closed == another.closed && this.parentHash.equals(another.parentHash) && Objects.equals(this.parentCloseTime, another.parentCloseTime) && Objects.equals(this.totalCoins, another.totalCoins) && Objects.equals(this.transactionHash, another.transactionHash) && this.transactions.equals(another.transactions) && Objects.equals(this.closeTimeResolution, another.closeTimeResolution);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerIndex.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + Objects.hashCode(this.accountHash);
        h += (h << 5) + Objects.hashCode(this.closeTime);
        h += (h << 5) + this.closeTimeHuman.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.closed);
        h += (h << 5) + this.parentHash.hashCode();
        h += (h << 5) + Objects.hashCode(this.parentCloseTime);
        h += (h << 5) + Objects.hashCode(this.totalCoins);
        h += (h << 5) + Objects.hashCode(this.transactionHash);
        h += (h << 5) + this.transactions.hashCode();
        h += (h << 5) + Objects.hashCode(this.closeTimeResolution);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LedgerHeader").omitNullValues().add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerHash", (Object)this.ledgerHash).add("accountHash", (Object)this.accountHash).add("closeTime", (Object)this.closeTime).add("closeTimeHuman", (Object)this.closeTimeHuman).add("closed", this.closed).add("parentHash", (Object)this.parentHash).add("parentCloseTime", (Object)this.parentCloseTime).add("totalCoins", (Object)this.totalCoins).add("transactionHash", (Object)this.transactionHash).add("transactions", this.transactions).add("closeTimeResolution", (Object)this.closeTimeResolution).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLedgerHeader fromJson(Json json) {
        Builder builder = ImmutableLedgerHeader.builder();
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.accountHash != null) {
            builder.accountHash(json.accountHash);
        }
        if (json.closeTime != null) {
            builder.closeTime(json.closeTime);
        }
        if (json.closeTimeHuman != null) {
            builder.closeTimeHuman(json.closeTimeHuman);
        }
        if (json.closedIsSet) {
            builder.closed(json.closed);
        }
        if (json.parentHash != null) {
            builder.parentHash(json.parentHash);
        }
        if (json.parentCloseTime != null) {
            builder.parentCloseTime(json.parentCloseTime);
        }
        if (json.totalCoins != null) {
            builder.totalCoins(json.totalCoins);
        }
        if (json.transactionHash != null) {
            builder.transactionHash(json.transactionHash);
        }
        if (json.transactions != null) {
            builder.addAllTransactions(json.transactions);
        }
        if (json.closeTimeResolution != null) {
            builder.closeTimeResolution(json.closeTimeResolution);
        }
        return builder.build();
    }

    public static ImmutableLedgerHeader copyOf(LedgerHeader instance) {
        if (instance instanceof ImmutableLedgerHeader) {
            return (ImmutableLedgerHeader)instance;
        }
        return ImmutableLedgerHeader.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LedgerHeader", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LEDGER_INDEX = 1L;
        private static final long INIT_BIT_CLOSE_TIME_HUMAN = 2L;
        private static final long INIT_BIT_PARENT_HASH = 4L;
        private static final long OPT_BIT_CLOSED = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private Hash256 accountHash;
        @Nullable
        private UnsignedLong closeTime;
        @Nullable
        private ZonedDateTime closeTimeHuman;
        private boolean closed;
        @Nullable
        private Hash256 parentHash;
        @Nullable
        private UnsignedLong parentCloseTime;
        @Nullable
        private XrpCurrencyAmount totalCoins;
        @Nullable
        private Hash256 transactionHash;
        private ImmutableList.Builder<TransactionResult<? extends Transaction>> transactions = ImmutableList.builder();
        @Nullable
        private UnsignedInteger closeTimeResolution;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LedgerHeader instance) {
            Optional<Hash256> transactionHashOptional;
            Optional<XrpCurrencyAmount> totalCoinsOptional;
            Optional<UnsignedLong> closeTimeOptional;
            Optional<Hash256> accountHashOptional;
            Objects.requireNonNull(instance, "instance");
            this.ledgerIndex(instance.ledgerIndex());
            Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
            if (ledgerHashOptional.isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            if ((accountHashOptional = instance.accountHash()).isPresent()) {
                this.accountHash(accountHashOptional);
            }
            if ((closeTimeOptional = instance.closeTime()).isPresent()) {
                this.closeTime(closeTimeOptional);
            }
            this.closeTimeHuman(instance.closeTimeHuman());
            this.closed(instance.closed());
            this.parentHash(instance.parentHash());
            Optional<UnsignedLong> parentCloseTimeOptional = instance.parentCloseTime();
            if (parentCloseTimeOptional.isPresent()) {
                this.parentCloseTime(parentCloseTimeOptional);
            }
            if ((totalCoinsOptional = instance.totalCoins()).isPresent()) {
                this.totalCoins(totalCoinsOptional);
            }
            if ((transactionHashOptional = instance.transactionHash()).isPresent()) {
                this.transactionHash(transactionHashOptional);
            }
            this.addAllTransactions(instance.transactions());
            Optional<UnsignedInteger> closeTimeResolutionOptional = instance.closeTimeResolution();
            if (closeTimeResolutionOptional.isPresent()) {
                this.closeTimeResolution(closeTimeResolutionOptional);
            }
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountHash(Hash256 accountHash) {
            this.accountHash = Objects.requireNonNull(accountHash, "accountHash");
            return this;
        }

        @JsonProperty(value="account_hash")
        @CanIgnoreReturnValue
        public final Builder accountHash(Optional<? extends Hash256> accountHash) {
            this.accountHash = accountHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closeTime(UnsignedLong closeTime) {
            this.closeTime = Objects.requireNonNull(closeTime, "closeTime");
            return this;
        }

        @JsonProperty(value="close_time")
        @CanIgnoreReturnValue
        public final Builder closeTime(Optional<? extends UnsignedLong> closeTime) {
            this.closeTime = closeTime.orElse(null);
            return this;
        }

        @JsonProperty(value="close_time_human")
        @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSSSSS z", locale="en")
        @CanIgnoreReturnValue
        public final Builder closeTimeHuman(ZonedDateTime closeTimeHuman) {
            this.closeTimeHuman = Objects.requireNonNull(closeTimeHuman, "closeTimeHuman");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="closed")
        @CanIgnoreReturnValue
        public final Builder closed(boolean closed) {
            this.closed = closed;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="parent_hash")
        @CanIgnoreReturnValue
        public final Builder parentHash(Hash256 parentHash) {
            this.parentHash = Objects.requireNonNull(parentHash, "parentHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentCloseTime(UnsignedLong parentCloseTime) {
            this.parentCloseTime = Objects.requireNonNull(parentCloseTime, "parentCloseTime");
            return this;
        }

        @JsonProperty(value="parent_close_time")
        @CanIgnoreReturnValue
        public final Builder parentCloseTime(Optional<? extends UnsignedLong> parentCloseTime) {
            this.parentCloseTime = parentCloseTime.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalCoins(XrpCurrencyAmount totalCoins) {
            this.totalCoins = Objects.requireNonNull(totalCoins, "totalCoins");
            return this;
        }

        @JsonProperty(value="total_coins")
        @CanIgnoreReturnValue
        public final Builder totalCoins(Optional<? extends XrpCurrencyAmount> totalCoins) {
            this.totalCoins = totalCoins.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionHash(Hash256 transactionHash) {
            this.transactionHash = Objects.requireNonNull(transactionHash, "transactionHash");
            return this;
        }

        @JsonProperty(value="transaction_hash")
        @CanIgnoreReturnValue
        public final Builder transactionHash(Optional<? extends Hash256> transactionHash) {
            this.transactionHash = transactionHash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTransactions(TransactionResult<? extends Transaction> element) {
            this.transactions.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTransactions(TransactionResult<? extends Transaction> ... elements) {
            this.transactions.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="transactions")
        @CanIgnoreReturnValue
        public final Builder transactions(Iterable<? extends TransactionResult<? extends Transaction>> elements) {
            this.transactions = ImmutableList.builder();
            return this.addAllTransactions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTransactions(Iterable<? extends TransactionResult<? extends Transaction>> elements) {
            this.transactions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closeTimeResolution(UnsignedInteger closeTimeResolution) {
            this.closeTimeResolution = Objects.requireNonNull(closeTimeResolution, "closeTimeResolution");
            return this;
        }

        @JsonProperty(value="close_time_resolution")
        @CanIgnoreReturnValue
        public final Builder closeTimeResolution(Optional<? extends UnsignedInteger> closeTimeResolution) {
            this.closeTimeResolution = closeTimeResolution.orElse(null);
            return this;
        }

        public ImmutableLedgerHeader build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLedgerHeader(this);
        }

        private boolean closedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ledgerIndex");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("closeTimeHuman");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("parentHash");
            }
            return "Cannot build LedgerHeader, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LedgerHeader", generator="Immutables")
    static final class Json
    implements LedgerHeader {
        @Nullable
        LedgerIndex ledgerIndex;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        Optional<Hash256> accountHash = Optional.empty();
        @Nullable
        Optional<UnsignedLong> closeTime = Optional.empty();
        @Nullable
        ZonedDateTime closeTimeHuman;
        boolean closed;
        boolean closedIsSet;
        @Nullable
        Hash256 parentHash;
        @Nullable
        Optional<UnsignedLong> parentCloseTime = Optional.empty();
        @Nullable
        Optional<XrpCurrencyAmount> totalCoins = Optional.empty();
        @Nullable
        Optional<Hash256> transactionHash = Optional.empty();
        @Nullable
        List<TransactionResult<? extends Transaction>> transactions = ImmutableList.of();
        @Nullable
        Optional<UnsignedInteger> closeTimeResolution = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="account_hash")
        public void setAccountHash(Optional<Hash256> accountHash) {
            this.accountHash = accountHash;
        }

        @JsonProperty(value="close_time")
        public void setCloseTime(Optional<UnsignedLong> closeTime) {
            this.closeTime = closeTime;
        }

        @JsonProperty(value="close_time_human")
        @JsonFormat(pattern="yyyy-MMM-dd HH:mm:ss.SSSSSSSSS z", locale="en")
        public void setCloseTimeHuman(ZonedDateTime closeTimeHuman) {
            this.closeTimeHuman = closeTimeHuman;
        }

        @JsonProperty(value="closed")
        public void setClosed(boolean closed) {
            this.closed = closed;
            this.closedIsSet = true;
        }

        @JsonProperty(value="parent_hash")
        public void setParentHash(Hash256 parentHash) {
            this.parentHash = parentHash;
        }

        @JsonProperty(value="parent_close_time")
        public void setParentCloseTime(Optional<UnsignedLong> parentCloseTime) {
            this.parentCloseTime = parentCloseTime;
        }

        @JsonProperty(value="total_coins")
        public void setTotalCoins(Optional<XrpCurrencyAmount> totalCoins) {
            this.totalCoins = totalCoins;
        }

        @JsonProperty(value="transaction_hash")
        public void setTransactionHash(Optional<Hash256> transactionHash) {
            this.transactionHash = transactionHash;
        }

        @JsonProperty(value="transactions")
        public void setTransactions(List<TransactionResult<? extends Transaction>> transactions) {
            this.transactions = transactions;
        }

        @JsonProperty(value="close_time_resolution")
        public void setCloseTimeResolution(Optional<UnsignedInteger> closeTimeResolution) {
            this.closeTimeResolution = closeTimeResolution;
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> accountHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> closeTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime closeTimeHuman() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean closed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 parentHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> parentCloseTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XrpCurrencyAmount> totalCoins() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> transactionHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<TransactionResult<? extends Transaction>> transactions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> closeTimeResolution() {
            throw new UnsupportedOperationException();
        }
    }
}

