/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.OfferObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OfferObject", generator="Immutables")
@Immutable
public final class ImmutableOfferObject
implements OfferObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final Address account;
    private final Flags.OfferFlags flags;
    private final UnsignedInteger sequence;
    private final CurrencyAmount takerPays;
    private final CurrencyAmount takerGets;
    private final Hash256 bookDirectory;
    private final String bookNode;
    private final String ownerNode;
    private final Hash256 previousTransactionId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    @Nullable
    private final UnsignedInteger expiration;
    private final Hash256 index;

    private ImmutableOfferObject(Address account, Flags.OfferFlags flags, UnsignedInteger sequence, CurrencyAmount takerPays, CurrencyAmount takerGets, Hash256 bookDirectory, String bookNode, String ownerNode, Hash256 previousTransactionId, UnsignedInteger previousTransactionLedgerSequence, @Nullable UnsignedInteger expiration, Hash256 index) {
        this.account = account;
        this.flags = flags;
        this.sequence = sequence;
        this.takerPays = takerPays;
        this.takerGets = takerGets;
        this.bookDirectory = bookDirectory;
        this.bookNode = bookNode;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.expiration = expiration;
        this.index = index;
        this.ledgerEntryType = Objects.requireNonNull(OfferObject.super.ledgerEntryType(), "ledgerEntryType");
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        return this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags.OfferFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence() {
        return this.sequence;
    }

    @Override
    @JsonProperty(value="TakerPays")
    public CurrencyAmount takerPays() {
        return this.takerPays;
    }

    @Override
    @JsonProperty(value="TakerGets")
    public CurrencyAmount takerGets() {
        return this.takerGets;
    }

    @Override
    @JsonProperty(value="BookDirectory")
    public Hash256 bookDirectory() {
        return this.bookDirectory;
    }

    @Override
    @JsonProperty(value="BookNode")
    public String bookNode() {
        return this.bookNode;
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public String ownerNode() {
        return this.ownerNode;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId() {
        return this.previousTransactionId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="Expiration")
    public Optional<UnsignedInteger> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutableOfferObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableOfferObject(newValue, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.index);
    }

    public final ImmutableOfferObject withFlags(Flags.OfferFlags value) {
        if (this.flags == value) {
            return this;
        }
        Flags.OfferFlags newValue = Objects.requireNonNull(value, "flags");
        return new ImmutableOfferObject(this.account, newValue, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.index);
    }

    public final ImmutableOfferObject withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (this.sequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOfferObject(this.account, this.flags, newValue, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.index);
    }

    public final ImmutableOfferObject withTakerPays(CurrencyAmount value) {
        if (this.takerPays == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "takerPays");
        return new ImmutableOfferObject(this.account, this.flags, this.sequence, newValue, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.index);
    }

    public final ImmutableOfferObject withTakerGets(CurrencyAmount value) {
        if (this.takerGets == value) {
            return this;
        }
        CurrencyAmount newValue = Objects.requireNonNull(value, "takerGets");
        return new ImmutableOfferObject(this.account, this.flags, this.sequence, this.takerPays, newValue, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.index);
    }

    public final ImmutableOfferObject withBookDirectory(Hash256 value) {
        if (this.bookDirectory == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "bookDirectory");
        return new ImmutableOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, newValue, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.index);
    }

    public final ImmutableOfferObject withBookNode(String value) {
        String newValue = Objects.requireNonNull(value, "bookNode");
        if (this.bookNode.equals(newValue)) {
            return this;
        }
        return new ImmutableOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.index);
    }

    public final ImmutableOfferObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (this.ownerNode.equals(newValue)) {
            return this;
        }
        return new ImmutableOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.index);
    }

    public final ImmutableOfferObject withPreviousTransactionId(Hash256 value) {
        if (this.previousTransactionId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        return new ImmutableOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, newValue, this.previousTransactionLedgerSequence, this.expiration, this.index);
    }

    public final ImmutableOfferObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, newValue, this.expiration, this.index);
    }

    public final ImmutableOfferObject withExpiration(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutableOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue, this.index);
    }

    public final ImmutableOfferObject withExpiration(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutableOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, value, this.index);
    }

    public final ImmutableOfferObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutableOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOfferObject && this.equalTo((ImmutableOfferObject)another);
    }

    private boolean equalTo(ImmutableOfferObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.account.equals(another.account) && this.flags.equals(another.flags) && this.sequence.equals((Object)another.sequence) && this.takerPays.equals(another.takerPays) && this.takerGets.equals(another.takerGets) && this.bookDirectory.equals(another.bookDirectory) && this.bookNode.equals(another.bookNode) && this.ownerNode.equals(another.ownerNode) && this.previousTransactionId.equals(another.previousTransactionId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && Objects.equals(this.expiration, another.expiration) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.sequence.hashCode();
        h += (h << 5) + this.takerPays.hashCode();
        h += (h << 5) + this.takerGets.hashCode();
        h += (h << 5) + this.bookDirectory.hashCode();
        h += (h << 5) + this.bookNode.hashCode();
        h += (h << 5) + this.ownerNode.hashCode();
        h += (h << 5) + this.previousTransactionId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + Objects.hashCode(this.expiration);
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OfferObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("account", (Object)this.account).add("flags", (Object)this.flags).add("sequence", (Object)this.sequence).add("takerPays", (Object)this.takerPays).add("takerGets", (Object)this.takerGets).add("bookDirectory", (Object)this.bookDirectory).add("bookNode", (Object)this.bookNode).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("expiration", (Object)this.expiration).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOfferObject fromJson(Json json) {
        Builder builder = ImmutableOfferObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.takerPays != null) {
            builder.takerPays(json.takerPays);
        }
        if (json.takerGets != null) {
            builder.takerGets(json.takerGets);
        }
        if (json.bookDirectory != null) {
            builder.bookDirectory(json.bookDirectory);
        }
        if (json.bookNode != null) {
            builder.bookNode(json.bookNode);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutableOfferObject copyOf(OfferObject instance) {
        if (instance instanceof ImmutableOfferObject) {
            return (ImmutableOfferObject)instance;
        }
        return ImmutableOfferObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OfferObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_FLAGS = 2L;
        private static final long INIT_BIT_SEQUENCE = 4L;
        private static final long INIT_BIT_TAKER_PAYS = 8L;
        private static final long INIT_BIT_TAKER_GETS = 16L;
        private static final long INIT_BIT_BOOK_DIRECTORY = 32L;
        private static final long INIT_BIT_BOOK_NODE = 64L;
        private static final long INIT_BIT_OWNER_NODE = 128L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_ID = 256L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 512L;
        private static final long INIT_BIT_INDEX = 1024L;
        private long initBits = 2047L;
        @Nullable
        private Address account;
        @Nullable
        private Flags.OfferFlags flags;
        @Nullable
        private UnsignedInteger sequence;
        @Nullable
        private CurrencyAmount takerPays;
        @Nullable
        private CurrencyAmount takerGets;
        @Nullable
        private Hash256 bookDirectory;
        @Nullable
        private String bookNode;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private UnsignedInteger expiration;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OfferObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.flags(instance.flags());
            this.sequence(instance.sequence());
            this.takerPays(instance.takerPays());
            this.takerGets(instance.takerGets());
            this.bookDirectory(instance.bookDirectory());
            this.bookNode(instance.bookNode());
            this.ownerNode(instance.ownerNode());
            this.previousTransactionId(instance.previousTransactionId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            Optional<UnsignedInteger> expirationOptional = instance.expiration();
            if (expirationOptional.isPresent()) {
                this.expiration(expirationOptional);
            }
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Flags")
        @CanIgnoreReturnValue
        public final Builder flags(Flags.OfferFlags flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Sequence")
        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="TakerPays")
        @CanIgnoreReturnValue
        public final Builder takerPays(CurrencyAmount takerPays) {
            this.takerPays = Objects.requireNonNull(takerPays, "takerPays");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="TakerGets")
        @CanIgnoreReturnValue
        public final Builder takerGets(CurrencyAmount takerGets) {
            this.takerGets = Objects.requireNonNull(takerGets, "takerGets");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="BookDirectory")
        @CanIgnoreReturnValue
        public final Builder bookDirectory(Hash256 bookDirectory) {
            this.bookDirectory = Objects.requireNonNull(bookDirectory, "bookDirectory");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="BookNode")
        @CanIgnoreReturnValue
        public final Builder bookNode(String bookNode) {
            this.bookNode = Objects.requireNonNull(bookNode, "bookNode");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedInteger expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="Expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedInteger> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public ImmutableOfferObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOfferObject(this.account, this.flags, this.sequence, this.takerPays, this.takerGets, this.bookDirectory, this.bookNode, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sequence");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("takerPays");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("takerGets");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("bookDirectory");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("bookNode");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("ownerNode");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("previousTransactionId");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build OfferObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OfferObject", generator="Immutables")
    static final class Json
    implements OfferObject {
        @Nullable
        Address account;
        @Nullable
        Flags.OfferFlags flags;
        @Nullable
        UnsignedInteger sequence;
        @Nullable
        CurrencyAmount takerPays;
        @Nullable
        CurrencyAmount takerGets;
        @Nullable
        Hash256 bookDirectory;
        @Nullable
        String bookNode;
        @Nullable
        String ownerNode;
        @Nullable
        Hash256 previousTransactionId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        Optional<UnsignedInteger> expiration = Optional.empty();
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="Flags")
        public void setFlags(Flags.OfferFlags flags) {
            this.flags = flags;
        }

        @JsonProperty(value="Sequence")
        public void setSequence(UnsignedInteger sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="TakerPays")
        public void setTakerPays(CurrencyAmount takerPays) {
            this.takerPays = takerPays;
        }

        @JsonProperty(value="TakerGets")
        public void setTakerGets(CurrencyAmount takerGets) {
            this.takerGets = takerGets;
        }

        @JsonProperty(value="BookDirectory")
        public void setBookDirectory(Hash256 bookDirectory) {
            this.bookDirectory = bookDirectory;
        }

        @JsonProperty(value="BookNode")
        public void setBookNode(String bookNode) {
            this.bookNode = bookNode;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(String ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="Expiration")
        public void setExpiration(Optional<UnsignedInteger> expiration) {
            this.expiration = expiration;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Flags.OfferFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount takerPays() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CurrencyAmount takerGets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 bookDirectory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String bookNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> expiration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }
}

