/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.ledger.PayChannelObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PayChannelObject", generator="Immutables")
@Immutable
public final class ImmutablePayChannelObject
implements PayChannelObject {
    private final transient LedgerObject.LedgerEntryType ledgerEntryType;
    private final transient Flags flags;
    private final Address account;
    private final Address destination;
    private final XrpCurrencyAmount amount;
    private final XrpCurrencyAmount balance;
    private final String publicKey;
    private final UnsignedLong settleDelay;
    private final String ownerNode;
    private final Hash256 previousTransactionId;
    private final UnsignedInteger previousTransactionLedgerSequence;
    @Nullable
    private final UnsignedLong expiration;
    @Nullable
    private final UnsignedLong cancelAfter;
    @Nullable
    private final UnsignedInteger sourceTag;
    @Nullable
    private final UnsignedInteger destinationTag;
    private final Hash256 index;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePayChannelObject(Address account, Address destination, XrpCurrencyAmount amount, XrpCurrencyAmount balance, String publicKey, UnsignedLong settleDelay, String ownerNode, Hash256 previousTransactionId, UnsignedInteger previousTransactionLedgerSequence, @Nullable UnsignedLong expiration, @Nullable UnsignedLong cancelAfter, @Nullable UnsignedInteger sourceTag, @Nullable UnsignedInteger destinationTag, Hash256 index) {
        this.account = account;
        this.destination = destination;
        this.amount = amount;
        this.balance = balance;
        this.publicKey = publicKey;
        this.settleDelay = settleDelay;
        this.ownerNode = ownerNode;
        this.previousTransactionId = previousTransactionId;
        this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        this.expiration = expiration;
        this.cancelAfter = cancelAfter;
        this.sourceTag = sourceTag;
        this.destinationTag = destinationTag;
        this.index = index;
        this.ledgerEntryType = this.initShim.ledgerEntryType();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private LedgerObject.LedgerEntryType ledgerEntryTypeInitialize() {
        return PayChannelObject.super.ledgerEntryType();
    }

    private Flags flagsInitialize() {
        return PayChannelObject.super.flags();
    }

    @Override
    @JsonProperty(value="LedgerEntryType")
    public LedgerObject.LedgerEntryType ledgerEntryType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerEntryType() : this.ledgerEntryType;
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="Destination")
    public Address destination() {
        return this.destination;
    }

    @Override
    @JsonProperty(value="Amount")
    public XrpCurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="Balance")
    public XrpCurrencyAmount balance() {
        return this.balance;
    }

    @Override
    @JsonProperty(value="PublicKey")
    public String publicKey() {
        return this.publicKey;
    }

    @Override
    @JsonProperty(value="SettleDelay")
    public UnsignedLong settleDelay() {
        return this.settleDelay;
    }

    @Override
    @JsonProperty(value="OwnerNode")
    public String ownerNode() {
        return this.ownerNode;
    }

    @Override
    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId() {
        return this.previousTransactionId;
    }

    @Override
    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence() {
        return this.previousTransactionLedgerSequence;
    }

    @Override
    @JsonProperty(value="Expiration")
    public Optional<UnsignedLong> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    @Override
    @JsonProperty(value="CancelAfter")
    public Optional<UnsignedLong> cancelAfter() {
        return Optional.ofNullable(this.cancelAfter);
    }

    @Override
    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag() {
        return Optional.ofNullable(this.sourceTag);
    }

    @Override
    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag() {
        return Optional.ofNullable(this.destinationTag);
    }

    @Override
    @JsonProperty(value="index")
    public Hash256 index() {
        return this.index;
    }

    public final ImmutablePayChannelObject withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutablePayChannelObject(newValue, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withDestination(Address value) {
        if (this.destination == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destination");
        return new ImmutablePayChannelObject(this.account, newValue, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withAmount(XrpCurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return new ImmutablePayChannelObject(this.account, this.destination, newValue, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withBalance(XrpCurrencyAmount value) {
        if (this.balance == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "balance");
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, newValue, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "publicKey");
        if (this.publicKey.equals(newValue)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, newValue, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withSettleDelay(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "settleDelay");
        if (this.settleDelay.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, newValue, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withOwnerNode(String value) {
        String newValue = Objects.requireNonNull(value, "ownerNode");
        if (this.ownerNode.equals(newValue)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, newValue, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withPreviousTransactionId(Hash256 value) {
        if (this.previousTransactionId == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "previousTransactionId");
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, newValue, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withPreviousTransactionLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "previousTransactionLedgerSequence");
        if (this.previousTransactionLedgerSequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, newValue, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withExpiration(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "expiration");
        if (Objects.equals(this.expiration, newValue)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, newValue, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withExpiration(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.expiration, value)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, value, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withCancelAfter(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "cancelAfter");
        if (Objects.equals(this.cancelAfter, newValue)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, newValue, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withCancelAfter(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.cancelAfter, value)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, value, this.sourceTag, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withSourceTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sourceTag");
        if (Objects.equals(this.sourceTag, newValue)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, newValue, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withSourceTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sourceTag, value)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, value, this.destinationTag, this.index);
    }

    public final ImmutablePayChannelObject withDestinationTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "destinationTag");
        if (Objects.equals(this.destinationTag, newValue)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, newValue, this.index);
    }

    public final ImmutablePayChannelObject withDestinationTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.destinationTag, value)) {
            return this;
        }
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, value, this.index);
    }

    public final ImmutablePayChannelObject withIndex(Hash256 value) {
        if (this.index == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "index");
        return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePayChannelObject && this.equalTo((ImmutablePayChannelObject)another);
    }

    private boolean equalTo(ImmutablePayChannelObject another) {
        return this.ledgerEntryType.equals((Object)another.ledgerEntryType) && this.flags.equals(another.flags) && this.account.equals(another.account) && this.destination.equals(another.destination) && this.amount.equals(another.amount) && this.balance.equals(another.balance) && this.publicKey.equals(another.publicKey) && this.settleDelay.equals((Object)another.settleDelay) && this.ownerNode.equals(another.ownerNode) && this.previousTransactionId.equals(another.previousTransactionId) && this.previousTransactionLedgerSequence.equals((Object)another.previousTransactionLedgerSequence) && Objects.equals(this.expiration, another.expiration) && Objects.equals(this.cancelAfter, another.cancelAfter) && Objects.equals(this.sourceTag, another.sourceTag) && Objects.equals(this.destinationTag, another.destinationTag) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.ledgerEntryType.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.balance.hashCode();
        h += (h << 5) + this.publicKey.hashCode();
        h += (h << 5) + this.settleDelay.hashCode();
        h += (h << 5) + this.ownerNode.hashCode();
        h += (h << 5) + this.previousTransactionId.hashCode();
        h += (h << 5) + this.previousTransactionLedgerSequence.hashCode();
        h += (h << 5) + Objects.hashCode(this.expiration);
        h += (h << 5) + Objects.hashCode(this.cancelAfter);
        h += (h << 5) + Objects.hashCode(this.sourceTag);
        h += (h << 5) + Objects.hashCode(this.destinationTag);
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PayChannelObject").omitNullValues().add("ledgerEntryType", (Object)this.ledgerEntryType).add("flags", (Object)this.flags).add("account", (Object)this.account).add("destination", (Object)this.destination).add("amount", (Object)this.amount).add("balance", (Object)this.balance).add("publicKey", (Object)this.publicKey).add("settleDelay", (Object)this.settleDelay).add("ownerNode", (Object)this.ownerNode).add("previousTransactionId", (Object)this.previousTransactionId).add("previousTransactionLedgerSequence", (Object)this.previousTransactionLedgerSequence).add("expiration", (Object)this.expiration).add("cancelAfter", (Object)this.cancelAfter).add("sourceTag", (Object)this.sourceTag).add("destinationTag", (Object)this.destinationTag).add("index", (Object)this.index).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePayChannelObject fromJson(Json json) {
        Builder builder = ImmutablePayChannelObject.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.balance != null) {
            builder.balance(json.balance);
        }
        if (json.publicKey != null) {
            builder.publicKey(json.publicKey);
        }
        if (json.settleDelay != null) {
            builder.settleDelay(json.settleDelay);
        }
        if (json.ownerNode != null) {
            builder.ownerNode(json.ownerNode);
        }
        if (json.previousTransactionId != null) {
            builder.previousTransactionId(json.previousTransactionId);
        }
        if (json.previousTransactionLedgerSequence != null) {
            builder.previousTransactionLedgerSequence(json.previousTransactionLedgerSequence);
        }
        if (json.expiration != null) {
            builder.expiration(json.expiration);
        }
        if (json.cancelAfter != null) {
            builder.cancelAfter(json.cancelAfter);
        }
        if (json.sourceTag != null) {
            builder.sourceTag(json.sourceTag);
        }
        if (json.destinationTag != null) {
            builder.destinationTag(json.destinationTag);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        return builder.build();
    }

    public static ImmutablePayChannelObject copyOf(PayChannelObject instance) {
        if (instance instanceof ImmutablePayChannelObject) {
            return (ImmutablePayChannelObject)instance;
        }
        return ImmutablePayChannelObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PayChannelObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_DESTINATION = 2L;
        private static final long INIT_BIT_AMOUNT = 4L;
        private static final long INIT_BIT_BALANCE = 8L;
        private static final long INIT_BIT_PUBLIC_KEY = 16L;
        private static final long INIT_BIT_SETTLE_DELAY = 32L;
        private static final long INIT_BIT_OWNER_NODE = 64L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_ID = 128L;
        private static final long INIT_BIT_PREVIOUS_TRANSACTION_LEDGER_SEQUENCE = 256L;
        private static final long INIT_BIT_INDEX = 512L;
        private long initBits = 1023L;
        @Nullable
        private Address account;
        @Nullable
        private Address destination;
        @Nullable
        private XrpCurrencyAmount amount;
        @Nullable
        private XrpCurrencyAmount balance;
        @Nullable
        private String publicKey;
        @Nullable
        private UnsignedLong settleDelay;
        @Nullable
        private String ownerNode;
        @Nullable
        private Hash256 previousTransactionId;
        @Nullable
        private UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        private UnsignedLong expiration;
        @Nullable
        private UnsignedLong cancelAfter;
        @Nullable
        private UnsignedInteger sourceTag;
        @Nullable
        private UnsignedInteger destinationTag;
        @Nullable
        private Hash256 index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PayChannelObject instance) {
            Optional<UnsignedInteger> destinationTagOptional;
            Optional<UnsignedInteger> sourceTagOptional;
            Optional<UnsignedLong> cancelAfterOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.destination(instance.destination());
            this.amount(instance.amount());
            this.balance(instance.balance());
            this.publicKey(instance.publicKey());
            this.settleDelay(instance.settleDelay());
            this.ownerNode(instance.ownerNode());
            this.previousTransactionId(instance.previousTransactionId());
            this.previousTransactionLedgerSequence(instance.previousTransactionLedgerSequence());
            Optional<UnsignedLong> expirationOptional = instance.expiration();
            if (expirationOptional.isPresent()) {
                this.expiration(expirationOptional);
            }
            if ((cancelAfterOptional = instance.cancelAfter()).isPresent()) {
                this.cancelAfter(cancelAfterOptional);
            }
            if ((sourceTagOptional = instance.sourceTag()).isPresent()) {
                this.sourceTag(sourceTagOptional);
            }
            if ((destinationTagOptional = instance.destinationTag()).isPresent()) {
                this.destinationTag(destinationTagOptional);
            }
            this.index(instance.index());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(XrpCurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Balance")
        @CanIgnoreReturnValue
        public final Builder balance(XrpCurrencyAmount balance) {
            this.balance = Objects.requireNonNull(balance, "balance");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="PublicKey")
        @CanIgnoreReturnValue
        public final Builder publicKey(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="SettleDelay")
        @CanIgnoreReturnValue
        public final Builder settleDelay(UnsignedLong settleDelay) {
            this.settleDelay = Objects.requireNonNull(settleDelay, "settleDelay");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="OwnerNode")
        @CanIgnoreReturnValue
        public final Builder ownerNode(String ownerNode) {
            this.ownerNode = Objects.requireNonNull(ownerNode, "ownerNode");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="PreviousTxnID")
        @CanIgnoreReturnValue
        public final Builder previousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = Objects.requireNonNull(previousTransactionId, "previousTransactionId");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        @CanIgnoreReturnValue
        public final Builder previousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = Objects.requireNonNull(previousTransactionLedgerSequence, "previousTransactionLedgerSequence");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiration(UnsignedLong expiration) {
            this.expiration = Objects.requireNonNull(expiration, "expiration");
            return this;
        }

        @JsonProperty(value="Expiration")
        @CanIgnoreReturnValue
        public final Builder expiration(Optional<? extends UnsignedLong> expiration) {
            this.expiration = expiration.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cancelAfter(UnsignedLong cancelAfter) {
            this.cancelAfter = Objects.requireNonNull(cancelAfter, "cancelAfter");
            return this;
        }

        @JsonProperty(value="CancelAfter")
        @CanIgnoreReturnValue
        public final Builder cancelAfter(Optional<? extends UnsignedLong> cancelAfter) {
            this.cancelAfter = cancelAfter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceTag(UnsignedInteger sourceTag) {
            this.sourceTag = Objects.requireNonNull(sourceTag, "sourceTag");
            return this;
        }

        @JsonProperty(value="SourceTag")
        @CanIgnoreReturnValue
        public final Builder sourceTag(Optional<? extends UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationTag(UnsignedInteger destinationTag) {
            this.destinationTag = Objects.requireNonNull(destinationTag, "destinationTag");
            return this;
        }

        @JsonProperty(value="DestinationTag")
        @CanIgnoreReturnValue
        public final Builder destinationTag(Optional<? extends UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag.orElse(null);
            return this;
        }

        @JsonProperty(value="index")
        @CanIgnoreReturnValue
        public final Builder index(Hash256 index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public ImmutablePayChannelObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePayChannelObject(this.account, this.destination, this.amount, this.balance, this.publicKey, this.settleDelay, this.ownerNode, this.previousTransactionId, this.previousTransactionLedgerSequence, this.expiration, this.cancelAfter, this.sourceTag, this.destinationTag, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("balance");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("publicKey");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("settleDelay");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("ownerNode");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("previousTransactionId");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("previousTransactionLedgerSequence");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build PayChannelObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PayChannelObject", generator="Immutables")
    static final class Json
    implements PayChannelObject {
        @Nullable
        Address account;
        @Nullable
        Address destination;
        @Nullable
        XrpCurrencyAmount amount;
        @Nullable
        XrpCurrencyAmount balance;
        @Nullable
        String publicKey;
        @Nullable
        UnsignedLong settleDelay;
        @Nullable
        String ownerNode;
        @Nullable
        Hash256 previousTransactionId;
        @Nullable
        UnsignedInteger previousTransactionLedgerSequence;
        @Nullable
        Optional<UnsignedLong> expiration = Optional.empty();
        @Nullable
        Optional<UnsignedLong> cancelAfter = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> sourceTag = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> destinationTag = Optional.empty();
        @Nullable
        Hash256 index;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Address destination) {
            this.destination = destination;
        }

        @JsonProperty(value="Amount")
        public void setAmount(XrpCurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="Balance")
        public void setBalance(XrpCurrencyAmount balance) {
            this.balance = balance;
        }

        @JsonProperty(value="PublicKey")
        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @JsonProperty(value="SettleDelay")
        public void setSettleDelay(UnsignedLong settleDelay) {
            this.settleDelay = settleDelay;
        }

        @JsonProperty(value="OwnerNode")
        public void setOwnerNode(String ownerNode) {
            this.ownerNode = ownerNode;
        }

        @JsonProperty(value="PreviousTxnID")
        public void setPreviousTransactionId(Hash256 previousTransactionId) {
            this.previousTransactionId = previousTransactionId;
        }

        @JsonProperty(value="PreviousTxnLgrSeq")
        public void setPreviousTransactionLedgerSequence(UnsignedInteger previousTransactionLedgerSequence) {
            this.previousTransactionLedgerSequence = previousTransactionLedgerSequence;
        }

        @JsonProperty(value="Expiration")
        public void setExpiration(Optional<UnsignedLong> expiration) {
            this.expiration = expiration;
        }

        @JsonProperty(value="CancelAfter")
        public void setCancelAfter(Optional<UnsignedLong> cancelAfter) {
            this.cancelAfter = cancelAfter;
        }

        @JsonProperty(value="SourceTag")
        public void setSourceTag(Optional<UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag;
        }

        @JsonProperty(value="DestinationTag")
        public void setDestinationTag(Optional<UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag;
        }

        @JsonProperty(value="index")
        public void setIndex(Hash256 index) {
            this.index = index;
        }

        @Override
        @JsonIgnore
        public LedgerObject.LedgerEntryType ledgerEntryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount balance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String publicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedLong settleDelay() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ownerNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 previousTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger previousTransactionLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> expiration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> cancelAfter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sourceTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> destinationTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 index() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="PayChannelObject", generator="Immutables")
    private final class InitShim {
        private byte ledgerEntryTypeBuildStage = 0;
        private LedgerObject.LedgerEntryType ledgerEntryType;
        private byte flagsBuildStage = 0;
        private Flags flags;

        private InitShim() {
        }

        LedgerObject.LedgerEntryType ledgerEntryType() {
            if (this.ledgerEntryTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerEntryTypeBuildStage == 0) {
                this.ledgerEntryTypeBuildStage = (byte)-1;
                this.ledgerEntryType = Objects.requireNonNull(ImmutablePayChannelObject.this.ledgerEntryTypeInitialize(), "ledgerEntryType");
                this.ledgerEntryTypeBuildStage = 1;
            }
            return this.ledgerEntryType;
        }

        Flags flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = Objects.requireNonNull(ImmutablePayChannelObject.this.flagsInitialize(), "flags");
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerEntryTypeBuildStage == -1) {
                attributes.add("ledgerEntryType");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build PayChannelObject, attribute initializers form cycle " + attributes;
        }
    }
}

