/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import org.xrpl.xrpl4j.model.ledger.ImmutableAccountRootObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableCheckObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableDepositPreAuthObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableEscrowObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableOfferObject;
import org.xrpl.xrpl4j.model.ledger.ImmutablePayChannelObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableRippleStateObject;
import org.xrpl.xrpl4j.model.ledger.ImmutableSignerListObject;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="LedgerEntryType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ImmutableAccountRootObject.class, name="AccountRoot"), @JsonSubTypes.Type(value=ImmutableCheckObject.class, name="Check"), @JsonSubTypes.Type(value=ImmutableDepositPreAuthObject.class, name="DepositPreauth"), @JsonSubTypes.Type(value=ImmutableEscrowObject.class, name="Escrow"), @JsonSubTypes.Type(value=ImmutableOfferObject.class, name="Offer"), @JsonSubTypes.Type(value=ImmutablePayChannelObject.class, name="PayChannel"), @JsonSubTypes.Type(value=ImmutableRippleStateObject.class, name="RippleState"), @JsonSubTypes.Type(value=ImmutableSignerListObject.class, name="SignerList")})
public interface LedgerObject {

    public static enum LedgerEntryType {
        ACCOUNT_ROOT("AccountRoot"),
        AMENDMENTS("Amendments"),
        CHECK("Check"),
        DEPOSIT_PRE_AUTH("DepositPreauth"),
        DIRECTORY_NODE("DirectoryNode"),
        ESCROW("Escrow"),
        FEE_SETTINGS("FeeSettings"),
        LEDGER_HASHES("LedgerHashes"),
        NEGATIVE_UNL("NegativeUNL"),
        OFFER("Offer"),
        PAY_CHANNEL("PayChannel"),
        RIPPLE_STATE("RippleState"),
        SIGNER_LIST("SignerList");

        private final String value;

        private LedgerEntryType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LedgerEntryType forValue(String value) {
            for (LedgerEntryType type : LedgerEntryType.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            throw new IllegalArgumentException("No matching LedgerEntryType enum value for String value " + value);
        }

        @JsonValue
        public String value() {
            return this.value;
        }
    }
}

