/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.ledger;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.ledger.ImmutableOfferObject;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableOfferObject.class)
@JsonDeserialize(as=ImmutableOfferObject.class)
@Value.Immutable
public interface OfferObject
extends LedgerObject {
    public static ImmutableOfferObject.Builder builder() {
        return ImmutableOfferObject.builder();
    }

    @JsonProperty(value="LedgerEntryType")
    @Value.Derived
    default public LedgerObject.LedgerEntryType ledgerEntryType() {
        return LedgerObject.LedgerEntryType.OFFER;
    }

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="Flags")
    public Flags.OfferFlags flags();

    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence();

    @JsonProperty(value="TakerPays")
    public CurrencyAmount takerPays();

    @JsonProperty(value="TakerGets")
    public CurrencyAmount takerGets();

    @JsonProperty(value="BookDirectory")
    public Hash256 bookDirectory();

    @JsonProperty(value="BookNode")
    public String bookNode();

    @JsonProperty(value="OwnerNode")
    public String ownerNode();

    @JsonProperty(value="PreviousTxnID")
    public Hash256 previousTransactionId();

    @JsonProperty(value="PreviousTxnLgrSeq")
    public UnsignedInteger previousTransactionLedgerSequence();

    @JsonProperty(value="Expiration")
    public Optional<UnsignedInteger> expiration();

    public Hash256 index();
}

