/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.ripple.cryptoconditions.Condition;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.ImmutableEscrowCreate;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@JsonSerialize(as=ImmutableEscrowCreate.class)
@JsonDeserialize(as=ImmutableEscrowCreate.class)
@Value.Immutable
public interface EscrowCreate
extends Transaction {
    public static ImmutableEscrowCreate.Builder builder() {
        return ImmutableEscrowCreate.builder();
    }

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags.TransactionFlags flags() {
        return new Flags.TransactionFlags.Builder().tfFullyCanonicalSig(true).build();
    }

    @JsonProperty(value="Amount")
    public XrpCurrencyAmount amount();

    @JsonProperty(value="Destination")
    public Address destination();

    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag();

    @JsonProperty(value="CancelAfter")
    public Optional<UnsignedLong> cancelAfter();

    @JsonProperty(value="FinishAfter")
    public Optional<UnsignedLong> finishAfter();

    @JsonProperty(value="Condition")
    public Optional<Condition> condition();

    @Value.Check
    default public void check() {
        if (this.cancelAfter().isPresent() && this.finishAfter().isPresent()) {
            Preconditions.checkState((this.finishAfter().get().compareTo(this.cancelAfter().get()) < 0 ? 1 : 0) != 0, (Object)"If both CancelAfter and FinishAfter are specified, the FinishAfter time must be before the CancelAfter time.");
        }
    }
}

