/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ripple.cryptoconditions.Condition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.EscrowCreate;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.MemoWrapper;
import org.xrpl.xrpl4j.model.transactions.SignerWrapper;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EscrowCreate", generator="Immutables")
@Immutable
public final class ImmutableEscrowCreate
implements EscrowCreate {
    private final Address account;
    private final XrpCurrencyAmount fee;
    private final UnsignedInteger sequence;
    @Nullable
    private final Hash256 accountTransactionId;
    @Nullable
    private final UnsignedInteger lastLedgerSequence;
    private final ImmutableList<MemoWrapper> memos;
    private final ImmutableList<SignerWrapper> signers;
    @Nullable
    private final UnsignedInteger sourceTag;
    @Nullable
    private final String signingPublicKey;
    @Nullable
    private final String transactionSignature;
    @Nullable
    private final UnsignedLong closeDate;
    @Nullable
    private final Hash256 hash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    private final transient Flags.TransactionFlags flags;
    private final XrpCurrencyAmount amount;
    private final Address destination;
    @Nullable
    private final UnsignedInteger destinationTag;
    @Nullable
    private final UnsignedLong cancelAfter;
    @Nullable
    private final UnsignedLong finishAfter;
    @Nullable
    private final Condition condition;

    private ImmutableEscrowCreate(Address account, XrpCurrencyAmount fee, UnsignedInteger sequence, @Nullable Hash256 accountTransactionId, @Nullable UnsignedInteger lastLedgerSequence, ImmutableList<MemoWrapper> memos, ImmutableList<SignerWrapper> signers, @Nullable UnsignedInteger sourceTag, @Nullable String signingPublicKey, @Nullable String transactionSignature, @Nullable UnsignedLong closeDate, @Nullable Hash256 hash, @Nullable LedgerIndex ledgerIndex, XrpCurrencyAmount amount, Address destination, @Nullable UnsignedInteger destinationTag, @Nullable UnsignedLong cancelAfter, @Nullable UnsignedLong finishAfter, @Nullable Condition condition) {
        this.account = account;
        this.fee = fee;
        this.sequence = sequence;
        this.accountTransactionId = accountTransactionId;
        this.lastLedgerSequence = lastLedgerSequence;
        this.memos = memos;
        this.signers = signers;
        this.sourceTag = sourceTag;
        this.signingPublicKey = signingPublicKey;
        this.transactionSignature = transactionSignature;
        this.closeDate = closeDate;
        this.hash = hash;
        this.ledgerIndex = ledgerIndex;
        this.amount = amount;
        this.destination = destination;
        this.destinationTag = destinationTag;
        this.cancelAfter = cancelAfter;
        this.finishAfter = finishAfter;
        this.condition = condition;
        this.flags = Objects.requireNonNull(EscrowCreate.super.flags(), "flags");
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="Fee")
    public XrpCurrencyAmount fee() {
        return this.fee;
    }

    @Override
    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence() {
        return this.sequence;
    }

    @Override
    @JsonProperty(value="AccountTxnID")
    public Optional<Hash256> accountTransactionId() {
        return Optional.ofNullable(this.accountTransactionId);
    }

    @Override
    @JsonProperty(value="LastLedgerSequence")
    public Optional<UnsignedInteger> lastLedgerSequence() {
        return Optional.ofNullable(this.lastLedgerSequence);
    }

    @JsonProperty(value="Memos")
    public ImmutableList<MemoWrapper> memos() {
        return this.memos;
    }

    @JsonProperty(value="Signers")
    public ImmutableList<SignerWrapper> signers() {
        return this.signers;
    }

    @Override
    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag() {
        return Optional.ofNullable(this.sourceTag);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="SigningPubKey")
    public Optional<String> signingPublicKey() {
        return Optional.ofNullable(this.signingPublicKey);
    }

    @Override
    @JsonProperty(value="TxnSignature")
    public Optional<String> transactionSignature() {
        return Optional.ofNullable(this.transactionSignature);
    }

    @Override
    @JsonProperty(value="date")
    public Optional<UnsignedLong> closeDate() {
        return Optional.ofNullable(this.closeDate);
    }

    @Override
    @JsonProperty(value="hash")
    public Optional<Hash256> hash() {
        return Optional.ofNullable(this.hash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags.TransactionFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Amount")
    public XrpCurrencyAmount amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="Destination")
    public Address destination() {
        return this.destination;
    }

    @Override
    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag() {
        return Optional.ofNullable(this.destinationTag);
    }

    @Override
    @JsonProperty(value="CancelAfter")
    public Optional<UnsignedLong> cancelAfter() {
        return Optional.ofNullable(this.cancelAfter);
    }

    @Override
    @JsonProperty(value="FinishAfter")
    public Optional<UnsignedLong> finishAfter() {
        return Optional.ofNullable(this.finishAfter);
    }

    @Override
    @JsonProperty(value="Condition")
    public Optional<Condition> condition() {
        return Optional.ofNullable(this.condition);
    }

    public final ImmutableEscrowCreate withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(newValue, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withFee(XrpCurrencyAmount value) {
        if (this.fee == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "fee");
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, newValue, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (this.sequence.equals((Object)newValue)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, newValue, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withAccountTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "accountTransactionId");
        if (this.accountTransactionId == newValue) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, newValue, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withAccountTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.accountTransactionId == value) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, value, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withLastLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "lastLedgerSequence");
        if (Objects.equals(this.lastLedgerSequence, newValue)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, newValue, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withLastLedgerSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.lastLedgerSequence, value)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, value, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withMemos(MemoWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, (ImmutableList<MemoWrapper>)newValue, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withMemos(Iterable<? extends MemoWrapper> elements) {
        if (this.memos == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, (ImmutableList<MemoWrapper>)newValue, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withSigners(SignerWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, (ImmutableList<SignerWrapper>)newValue, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withSigners(Iterable<? extends SignerWrapper> elements) {
        if (this.signers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, (ImmutableList<SignerWrapper>)newValue, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withSourceTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sourceTag");
        if (Objects.equals(this.sourceTag, newValue)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, newValue, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withSourceTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sourceTag, value)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, value, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withSigningPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "signingPublicKey");
        if (Objects.equals(this.signingPublicKey, newValue)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, newValue, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withSigningPublicKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.signingPublicKey, value)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, value, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withTransactionSignature(String value) {
        String newValue = Objects.requireNonNull(value, "transactionSignature");
        if (Objects.equals(this.transactionSignature, newValue)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, newValue, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withTransactionSignature(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.transactionSignature, value)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, value, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withCloseDate(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "closeDate");
        if (Objects.equals(this.closeDate, newValue)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, newValue, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withCloseDate(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.closeDate, value)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, value, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "hash");
        if (this.hash == newValue) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, newValue, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.hash == value) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, value, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, newValue, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, value, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withAmount(XrpCurrencyAmount value) {
        if (this.amount == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "amount");
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, newValue, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withDestination(Address value) {
        if (this.destination == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destination");
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, newValue, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withDestinationTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "destinationTag");
        if (Objects.equals(this.destinationTag, newValue)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, newValue, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withDestinationTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.destinationTag, value)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, value, this.cancelAfter, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withCancelAfter(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "cancelAfter");
        if (Objects.equals(this.cancelAfter, newValue)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, newValue, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withCancelAfter(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.cancelAfter, value)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, value, this.finishAfter, this.condition));
    }

    public final ImmutableEscrowCreate withFinishAfter(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "finishAfter");
        if (Objects.equals(this.finishAfter, newValue)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, newValue, this.condition));
    }

    public final ImmutableEscrowCreate withFinishAfter(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.finishAfter, value)) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, value, this.condition));
    }

    public final ImmutableEscrowCreate withCondition(Condition value) {
        Condition newValue = Objects.requireNonNull(value, "condition");
        if (this.condition == newValue) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, newValue));
    }

    public final ImmutableEscrowCreate withCondition(Optional<? extends Condition> optional) {
        Condition value = optional.orElse(null);
        if (this.condition == value) {
            return this;
        }
        return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEscrowCreate && this.equalTo((ImmutableEscrowCreate)another);
    }

    private boolean equalTo(ImmutableEscrowCreate another) {
        return this.account.equals(another.account) && this.fee.equals(another.fee) && this.sequence.equals((Object)another.sequence) && Objects.equals(this.accountTransactionId, another.accountTransactionId) && Objects.equals(this.lastLedgerSequence, another.lastLedgerSequence) && this.memos.equals(another.memos) && this.signers.equals(another.signers) && Objects.equals(this.sourceTag, another.sourceTag) && Objects.equals(this.signingPublicKey, another.signingPublicKey) && Objects.equals(this.transactionSignature, another.transactionSignature) && Objects.equals(this.closeDate, another.closeDate) && Objects.equals(this.hash, another.hash) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && this.flags.equals(another.flags) && this.amount.equals(another.amount) && this.destination.equals(another.destination) && Objects.equals(this.destinationTag, another.destinationTag) && Objects.equals(this.cancelAfter, another.cancelAfter) && Objects.equals(this.finishAfter, another.finishAfter) && Objects.equals(this.condition, another.condition);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.fee.hashCode();
        h += (h << 5) + this.sequence.hashCode();
        h += (h << 5) + Objects.hashCode(this.accountTransactionId);
        h += (h << 5) + Objects.hashCode(this.lastLedgerSequence);
        h += (h << 5) + this.memos.hashCode();
        h += (h << 5) + this.signers.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceTag);
        h += (h << 5) + Objects.hashCode(this.signingPublicKey);
        h += (h << 5) + Objects.hashCode(this.transactionSignature);
        h += (h << 5) + Objects.hashCode(this.closeDate);
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.amount.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + Objects.hashCode(this.destinationTag);
        h += (h << 5) + Objects.hashCode(this.cancelAfter);
        h += (h << 5) + Objects.hashCode(this.finishAfter);
        h += (h << 5) + Objects.hashCode(this.condition);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EscrowCreate").omitNullValues().add("account", (Object)this.account).add("fee", (Object)this.fee).add("sequence", (Object)this.sequence).add("accountTransactionId", (Object)this.accountTransactionId).add("lastLedgerSequence", (Object)this.lastLedgerSequence).add("memos", this.memos).add("signers", this.signers).add("sourceTag", (Object)this.sourceTag).add("signingPublicKey", (Object)this.signingPublicKey).add("transactionSignature", (Object)this.transactionSignature).add("closeDate", (Object)this.closeDate).add("hash", (Object)this.hash).add("ledgerIndex", (Object)this.ledgerIndex).add("flags", (Object)this.flags).add("amount", (Object)this.amount).add("destination", (Object)this.destination).add("destinationTag", (Object)this.destinationTag).add("cancelAfter", (Object)this.cancelAfter).add("finishAfter", (Object)this.finishAfter).add("condition", (Object)this.condition).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEscrowCreate fromJson(Json json) {
        Builder builder = ImmutableEscrowCreate.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.fee != null) {
            builder.fee(json.fee);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.accountTransactionId != null) {
            builder.accountTransactionId(json.accountTransactionId);
        }
        if (json.lastLedgerSequence != null) {
            builder.lastLedgerSequence(json.lastLedgerSequence);
        }
        if (json.memos != null) {
            builder.addAllMemos(json.memos);
        }
        if (json.signers != null) {
            builder.addAllSigners(json.signers);
        }
        if (json.sourceTag != null) {
            builder.sourceTag(json.sourceTag);
        }
        if (json.signingPublicKey != null) {
            builder.signingPublicKey(json.signingPublicKey);
        }
        if (json.transactionSignature != null) {
            builder.transactionSignature(json.transactionSignature);
        }
        if (json.closeDate != null) {
            builder.closeDate(json.closeDate);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.amount != null) {
            builder.amount(json.amount);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.destinationTag != null) {
            builder.destinationTag(json.destinationTag);
        }
        if (json.cancelAfter != null) {
            builder.cancelAfter(json.cancelAfter);
        }
        if (json.finishAfter != null) {
            builder.finishAfter(json.finishAfter);
        }
        if (json.condition != null) {
            builder.condition(json.condition);
        }
        return builder.build();
    }

    private static ImmutableEscrowCreate validate(ImmutableEscrowCreate instance) {
        instance.check();
        return instance;
    }

    public static ImmutableEscrowCreate copyOf(EscrowCreate instance) {
        if (instance instanceof ImmutableEscrowCreate) {
            return (ImmutableEscrowCreate)instance;
        }
        return ImmutableEscrowCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EscrowCreate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_FEE = 2L;
        private static final long INIT_BIT_SEQUENCE = 4L;
        private static final long INIT_BIT_AMOUNT = 8L;
        private static final long INIT_BIT_DESTINATION = 16L;
        private long initBits = 31L;
        @Nullable
        private Address account;
        @Nullable
        private XrpCurrencyAmount fee;
        @Nullable
        private UnsignedInteger sequence;
        @Nullable
        private Hash256 accountTransactionId;
        @Nullable
        private UnsignedInteger lastLedgerSequence;
        private ImmutableList.Builder<MemoWrapper> memos = ImmutableList.builder();
        private ImmutableList.Builder<SignerWrapper> signers = ImmutableList.builder();
        @Nullable
        private UnsignedInteger sourceTag;
        @Nullable
        private String signingPublicKey;
        @Nullable
        private String transactionSignature;
        @Nullable
        private UnsignedLong closeDate;
        @Nullable
        private Hash256 hash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private XrpCurrencyAmount amount;
        @Nullable
        private Address destination;
        @Nullable
        private UnsignedInteger destinationTag;
        @Nullable
        private UnsignedLong cancelAfter;
        @Nullable
        private UnsignedLong finishAfter;
        @Nullable
        private Condition condition;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EscrowCreate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Transaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Transaction instance;
            if (object instanceof EscrowCreate) {
                Optional<UnsignedLong> cancelAfterOptional;
                Optional<UnsignedInteger> destinationTagOptional;
                Optional<UnsignedLong> finishAfterOptional;
                instance = (EscrowCreate)object;
                this.destination(instance.destination());
                this.amount(instance.amount());
                Optional<Condition> conditionOptional = instance.condition();
                if (conditionOptional.isPresent()) {
                    this.condition(conditionOptional);
                }
                if ((finishAfterOptional = instance.finishAfter()).isPresent()) {
                    this.finishAfter(finishAfterOptional);
                }
                if ((destinationTagOptional = instance.destinationTag()).isPresent()) {
                    this.destinationTag(destinationTagOptional);
                }
                if ((cancelAfterOptional = instance.cancelAfter()).isPresent()) {
                    this.cancelAfter(cancelAfterOptional);
                }
            }
            if (object instanceof Transaction) {
                Optional<String> signingPublicKeyOptional;
                Optional<UnsignedInteger> sourceTagOptional;
                Optional<UnsignedLong> closeDateOptional;
                instance = (Transaction)object;
                Optional<Hash256> accountTransactionIdOptional = instance.accountTransactionId();
                if (accountTransactionIdOptional.isPresent()) {
                    this.accountTransactionId(accountTransactionIdOptional);
                }
                this.fee(instance.fee());
                Optional<UnsignedInteger> lastLedgerSequenceOptional = instance.lastLedgerSequence();
                if (lastLedgerSequenceOptional.isPresent()) {
                    this.lastLedgerSequence(lastLedgerSequenceOptional);
                }
                if ((closeDateOptional = instance.closeDate()).isPresent()) {
                    this.closeDate(closeDateOptional);
                }
                this.sequence(instance.sequence());
                this.addAllSigners(instance.signers());
                Optional<String> transactionSignatureOptional = instance.transactionSignature();
                if (transactionSignatureOptional.isPresent()) {
                    this.transactionSignature(transactionSignatureOptional);
                }
                this.addAllMemos(instance.memos());
                Optional<LedgerIndex> ledgerIndexOptional = instance.ledgerIndex();
                if (ledgerIndexOptional.isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                if ((sourceTagOptional = instance.sourceTag()).isPresent()) {
                    this.sourceTag(sourceTagOptional);
                }
                if ((signingPublicKeyOptional = instance.signingPublicKey()).isPresent()) {
                    this.signingPublicKey(signingPublicKeyOptional);
                }
                this.account(instance.account());
                Optional<Hash256> hashOptional = instance.hash();
                if (hashOptional.isPresent()) {
                    this.hash(hashOptional);
                }
            }
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Fee")
        @CanIgnoreReturnValue
        public final Builder fee(XrpCurrencyAmount fee) {
            this.fee = Objects.requireNonNull(fee, "fee");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Sequence")
        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Hash256 accountTransactionId) {
            this.accountTransactionId = Objects.requireNonNull(accountTransactionId, "accountTransactionId");
            return this;
        }

        @JsonProperty(value="AccountTxnID")
        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Optional<? extends Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastLedgerSequence(UnsignedInteger lastLedgerSequence) {
            this.lastLedgerSequence = Objects.requireNonNull(lastLedgerSequence, "lastLedgerSequence");
            return this;
        }

        @JsonProperty(value="LastLedgerSequence")
        @CanIgnoreReturnValue
        public final Builder lastLedgerSequence(Optional<? extends UnsignedInteger> lastLedgerSequence) {
            this.lastLedgerSequence = lastLedgerSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMemos(MemoWrapper element) {
            this.memos.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMemos(MemoWrapper ... elements) {
            this.memos.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Memos")
        @CanIgnoreReturnValue
        public final Builder memos(Iterable<? extends MemoWrapper> elements) {
            this.memos = ImmutableList.builder();
            return this.addAllMemos(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMemos(Iterable<? extends MemoWrapper> elements) {
            this.memos.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSigners(SignerWrapper element) {
            this.signers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSigners(SignerWrapper ... elements) {
            this.signers.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Signers")
        @CanIgnoreReturnValue
        public final Builder signers(Iterable<? extends SignerWrapper> elements) {
            this.signers = ImmutableList.builder();
            return this.addAllSigners(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSigners(Iterable<? extends SignerWrapper> elements) {
            this.signers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceTag(UnsignedInteger sourceTag) {
            this.sourceTag = Objects.requireNonNull(sourceTag, "sourceTag");
            return this;
        }

        @JsonProperty(value="SourceTag")
        @CanIgnoreReturnValue
        public final Builder sourceTag(Optional<? extends UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signingPublicKey(String signingPublicKey) {
            this.signingPublicKey = Objects.requireNonNull(signingPublicKey, "signingPublicKey");
            return this;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="SigningPubKey")
        @CanIgnoreReturnValue
        public final Builder signingPublicKey(Optional<String> signingPublicKey) {
            this.signingPublicKey = signingPublicKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionSignature(String transactionSignature) {
            this.transactionSignature = Objects.requireNonNull(transactionSignature, "transactionSignature");
            return this;
        }

        @JsonProperty(value="TxnSignature")
        @CanIgnoreReturnValue
        public final Builder transactionSignature(Optional<String> transactionSignature) {
            this.transactionSignature = transactionSignature.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closeDate(UnsignedLong closeDate) {
            this.closeDate = Objects.requireNonNull(closeDate, "closeDate");
            return this;
        }

        @JsonProperty(value="date")
        @CanIgnoreReturnValue
        public final Builder closeDate(Optional<? extends UnsignedLong> closeDate) {
            this.closeDate = closeDate.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(Hash256 hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(Optional<? extends Hash256> hash) {
            this.hash = hash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @JsonProperty(value="Amount")
        @CanIgnoreReturnValue
        public final Builder amount(XrpCurrencyAmount amount) {
            this.amount = Objects.requireNonNull(amount, "amount");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Destination")
        @CanIgnoreReturnValue
        public final Builder destination(Address destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationTag(UnsignedInteger destinationTag) {
            this.destinationTag = Objects.requireNonNull(destinationTag, "destinationTag");
            return this;
        }

        @JsonProperty(value="DestinationTag")
        @CanIgnoreReturnValue
        public final Builder destinationTag(Optional<? extends UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cancelAfter(UnsignedLong cancelAfter) {
            this.cancelAfter = Objects.requireNonNull(cancelAfter, "cancelAfter");
            return this;
        }

        @JsonProperty(value="CancelAfter")
        @CanIgnoreReturnValue
        public final Builder cancelAfter(Optional<? extends UnsignedLong> cancelAfter) {
            this.cancelAfter = cancelAfter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder finishAfter(UnsignedLong finishAfter) {
            this.finishAfter = Objects.requireNonNull(finishAfter, "finishAfter");
            return this;
        }

        @JsonProperty(value="FinishAfter")
        @CanIgnoreReturnValue
        public final Builder finishAfter(Optional<? extends UnsignedLong> finishAfter) {
            this.finishAfter = finishAfter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder condition(Condition condition) {
            this.condition = Objects.requireNonNull(condition, "condition");
            return this;
        }

        @JsonProperty(value="Condition")
        @CanIgnoreReturnValue
        public final Builder condition(Optional<? extends Condition> condition) {
            this.condition = condition.orElse(null);
            return this;
        }

        public ImmutableEscrowCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableEscrowCreate.validate(new ImmutableEscrowCreate(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos.build(), this.signers.build(), this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.amount, this.destination, this.destinationTag, this.cancelAfter, this.finishAfter, this.condition));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fee");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sequence");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("amount");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("destination");
            }
            return "Cannot build EscrowCreate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EscrowCreate", generator="Immutables")
    static final class Json
    implements EscrowCreate {
        @Nullable
        Address account;
        @Nullable
        XrpCurrencyAmount fee;
        @Nullable
        UnsignedInteger sequence;
        @Nullable
        Optional<Hash256> accountTransactionId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> lastLedgerSequence = Optional.empty();
        @Nullable
        List<MemoWrapper> memos = ImmutableList.of();
        @Nullable
        List<SignerWrapper> signers = ImmutableList.of();
        @Nullable
        Optional<UnsignedInteger> sourceTag = Optional.empty();
        @Nullable
        Optional<String> signingPublicKey = Optional.empty();
        @Nullable
        Optional<String> transactionSignature = Optional.empty();
        @Nullable
        Optional<UnsignedLong> closeDate = Optional.empty();
        @Nullable
        Optional<Hash256> hash = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        XrpCurrencyAmount amount;
        @Nullable
        Address destination;
        @Nullable
        Optional<UnsignedInteger> destinationTag = Optional.empty();
        @Nullable
        Optional<UnsignedLong> cancelAfter = Optional.empty();
        @Nullable
        Optional<UnsignedLong> finishAfter = Optional.empty();
        @Nullable
        Optional<Condition> condition = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="Fee")
        public void setFee(XrpCurrencyAmount fee) {
            this.fee = fee;
        }

        @JsonProperty(value="Sequence")
        public void setSequence(UnsignedInteger sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="AccountTxnID")
        public void setAccountTransactionId(Optional<Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId;
        }

        @JsonProperty(value="LastLedgerSequence")
        public void setLastLedgerSequence(Optional<UnsignedInteger> lastLedgerSequence) {
            this.lastLedgerSequence = lastLedgerSequence;
        }

        @JsonProperty(value="Memos")
        public void setMemos(List<MemoWrapper> memos) {
            this.memos = memos;
        }

        @JsonProperty(value="Signers")
        public void setSigners(List<SignerWrapper> signers) {
            this.signers = signers;
        }

        @JsonProperty(value="SourceTag")
        public void setSourceTag(Optional<UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="SigningPubKey")
        public void setSigningPublicKey(Optional<String> signingPublicKey) {
            this.signingPublicKey = signingPublicKey;
        }

        @JsonProperty(value="TxnSignature")
        public void setTransactionSignature(Optional<String> transactionSignature) {
            this.transactionSignature = transactionSignature;
        }

        @JsonProperty(value="date")
        public void setCloseDate(Optional<UnsignedLong> closeDate) {
            this.closeDate = closeDate;
        }

        @JsonProperty(value="hash")
        public void setHash(Optional<Hash256> hash) {
            this.hash = hash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="Amount")
        public void setAmount(XrpCurrencyAmount amount) {
            this.amount = amount;
        }

        @JsonProperty(value="Destination")
        public void setDestination(Address destination) {
            this.destination = destination;
        }

        @JsonProperty(value="DestinationTag")
        public void setDestinationTag(Optional<UnsignedInteger> destinationTag) {
            this.destinationTag = destinationTag;
        }

        @JsonProperty(value="CancelAfter")
        public void setCancelAfter(Optional<UnsignedLong> cancelAfter) {
            this.cancelAfter = cancelAfter;
        }

        @JsonProperty(value="FinishAfter")
        public void setFinishAfter(Optional<UnsignedLong> finishAfter) {
            this.finishAfter = finishAfter;
        }

        @JsonProperty(value="Condition")
        public void setCondition(Optional<Condition> condition) {
            this.condition = condition;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount fee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> accountTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> lastLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MemoWrapper> memos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SignerWrapper> signers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sourceTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> signingPublicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> transactionSignature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> closeDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> hash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags.TransactionFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> destinationTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> cancelAfter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> finishAfter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Condition> condition() {
            throw new UnsupportedOperationException();
        }
    }
}

