/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.MemoWrapper;
import org.xrpl.xrpl4j.model.transactions.SetRegularKey;
import org.xrpl.xrpl4j.model.transactions.SignerWrapper;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SetRegularKey", generator="Immutables")
@Immutable
public final class ImmutableSetRegularKey
implements SetRegularKey {
    private final Address account;
    private final XrpCurrencyAmount fee;
    private final UnsignedInteger sequence;
    @Nullable
    private final Hash256 accountTransactionId;
    @Nullable
    private final UnsignedInteger lastLedgerSequence;
    private final ImmutableList<MemoWrapper> memos;
    private final ImmutableList<SignerWrapper> signers;
    @Nullable
    private final UnsignedInteger sourceTag;
    @Nullable
    private final String signingPublicKey;
    @Nullable
    private final String transactionSignature;
    @Nullable
    private final UnsignedLong closeDate;
    @Nullable
    private final Hash256 hash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    private final transient Flags.TransactionFlags flags;
    @Nullable
    private final Address regularKey;

    private ImmutableSetRegularKey(Address account, XrpCurrencyAmount fee, UnsignedInteger sequence, @Nullable Hash256 accountTransactionId, @Nullable UnsignedInteger lastLedgerSequence, ImmutableList<MemoWrapper> memos, ImmutableList<SignerWrapper> signers, @Nullable UnsignedInteger sourceTag, @Nullable String signingPublicKey, @Nullable String transactionSignature, @Nullable UnsignedLong closeDate, @Nullable Hash256 hash, @Nullable LedgerIndex ledgerIndex, @Nullable Address regularKey) {
        this.account = account;
        this.fee = fee;
        this.sequence = sequence;
        this.accountTransactionId = accountTransactionId;
        this.lastLedgerSequence = lastLedgerSequence;
        this.memos = memos;
        this.signers = signers;
        this.sourceTag = sourceTag;
        this.signingPublicKey = signingPublicKey;
        this.transactionSignature = transactionSignature;
        this.closeDate = closeDate;
        this.hash = hash;
        this.ledgerIndex = ledgerIndex;
        this.regularKey = regularKey;
        this.flags = Objects.requireNonNull(SetRegularKey.super.flags(), "flags");
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="Fee")
    public XrpCurrencyAmount fee() {
        return this.fee;
    }

    @Override
    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence() {
        return this.sequence;
    }

    @Override
    @JsonProperty(value="AccountTxnID")
    public Optional<Hash256> accountTransactionId() {
        return Optional.ofNullable(this.accountTransactionId);
    }

    @Override
    @JsonProperty(value="LastLedgerSequence")
    public Optional<UnsignedInteger> lastLedgerSequence() {
        return Optional.ofNullable(this.lastLedgerSequence);
    }

    @JsonProperty(value="Memos")
    public ImmutableList<MemoWrapper> memos() {
        return this.memos;
    }

    @JsonProperty(value="Signers")
    public ImmutableList<SignerWrapper> signers() {
        return this.signers;
    }

    @Override
    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag() {
        return Optional.ofNullable(this.sourceTag);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="SigningPubKey")
    public Optional<String> signingPublicKey() {
        return Optional.ofNullable(this.signingPublicKey);
    }

    @Override
    @JsonProperty(value="TxnSignature")
    public Optional<String> transactionSignature() {
        return Optional.ofNullable(this.transactionSignature);
    }

    @Override
    @JsonProperty(value="date")
    public Optional<UnsignedLong> closeDate() {
        return Optional.ofNullable(this.closeDate);
    }

    @Override
    @JsonProperty(value="hash")
    public Optional<Hash256> hash() {
        return Optional.ofNullable(this.hash);
    }

    @Override
    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="Flags")
    public Flags.TransactionFlags flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="RegularKey")
    public Optional<Address> regularKey() {
        return Optional.ofNullable(this.regularKey);
    }

    public final ImmutableSetRegularKey withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableSetRegularKey(newValue, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withFee(XrpCurrencyAmount value) {
        if (this.fee == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "fee");
        return new ImmutableSetRegularKey(this.account, newValue, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sequence");
        if (this.sequence.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, newValue, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withAccountTransactionId(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "accountTransactionId");
        if (this.accountTransactionId == newValue) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, newValue, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withAccountTransactionId(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.accountTransactionId == value) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, value, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withLastLedgerSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "lastLedgerSequence");
        if (Objects.equals(this.lastLedgerSequence, newValue)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, newValue, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withLastLedgerSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.lastLedgerSequence, value)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, value, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withMemos(MemoWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, (ImmutableList<MemoWrapper>)newValue, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withMemos(Iterable<? extends MemoWrapper> elements) {
        if (this.memos == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, (ImmutableList<MemoWrapper>)newValue, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withSigners(SignerWrapper ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, (ImmutableList<SignerWrapper>)newValue, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withSigners(Iterable<? extends SignerWrapper> elements) {
        if (this.signers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, (ImmutableList<SignerWrapper>)newValue, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withSourceTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "sourceTag");
        if (Objects.equals(this.sourceTag, newValue)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, newValue, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withSourceTag(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.sourceTag, value)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, value, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withSigningPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "signingPublicKey");
        if (Objects.equals(this.signingPublicKey, newValue)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, newValue, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withSigningPublicKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.signingPublicKey, value)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, value, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withTransactionSignature(String value) {
        String newValue = Objects.requireNonNull(value, "transactionSignature");
        if (Objects.equals(this.transactionSignature, newValue)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, newValue, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withTransactionSignature(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.transactionSignature, value)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, value, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withCloseDate(UnsignedLong value) {
        UnsignedLong newValue = Objects.requireNonNull(value, "closeDate");
        if (Objects.equals(this.closeDate, newValue)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, newValue, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withCloseDate(Optional<? extends UnsignedLong> optional) {
        UnsignedLong value = optional.orElse(null);
        if (Objects.equals(this.closeDate, value)) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, value, this.hash, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "hash");
        if (this.hash == newValue) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, newValue, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.hash == value) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, value, this.ledgerIndex, this.regularKey);
    }

    public final ImmutableSetRegularKey withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, newValue, this.regularKey);
    }

    public final ImmutableSetRegularKey withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, value, this.regularKey);
    }

    public final ImmutableSetRegularKey withRegularKey(Address value) {
        Address newValue = Objects.requireNonNull(value, "regularKey");
        if (this.regularKey == newValue) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, newValue);
    }

    public final ImmutableSetRegularKey withRegularKey(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.regularKey == value) {
            return this;
        }
        return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos, this.signers, this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSetRegularKey && this.equalTo((ImmutableSetRegularKey)another);
    }

    private boolean equalTo(ImmutableSetRegularKey another) {
        return this.account.equals(another.account) && this.fee.equals(another.fee) && this.sequence.equals((Object)another.sequence) && Objects.equals(this.accountTransactionId, another.accountTransactionId) && Objects.equals(this.lastLedgerSequence, another.lastLedgerSequence) && this.memos.equals(another.memos) && this.signers.equals(another.signers) && Objects.equals(this.sourceTag, another.sourceTag) && Objects.equals(this.signingPublicKey, another.signingPublicKey) && Objects.equals(this.transactionSignature, another.transactionSignature) && Objects.equals(this.closeDate, another.closeDate) && Objects.equals(this.hash, another.hash) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && this.flags.equals(another.flags) && Objects.equals(this.regularKey, another.regularKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.fee.hashCode();
        h += (h << 5) + this.sequence.hashCode();
        h += (h << 5) + Objects.hashCode(this.accountTransactionId);
        h += (h << 5) + Objects.hashCode(this.lastLedgerSequence);
        h += (h << 5) + this.memos.hashCode();
        h += (h << 5) + this.signers.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceTag);
        h += (h << 5) + Objects.hashCode(this.signingPublicKey);
        h += (h << 5) + Objects.hashCode(this.transactionSignature);
        h += (h << 5) + Objects.hashCode(this.closeDate);
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + Objects.hashCode(this.regularKey);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SetRegularKey").omitNullValues().add("account", (Object)this.account).add("fee", (Object)this.fee).add("sequence", (Object)this.sequence).add("accountTransactionId", (Object)this.accountTransactionId).add("lastLedgerSequence", (Object)this.lastLedgerSequence).add("memos", this.memos).add("signers", this.signers).add("sourceTag", (Object)this.sourceTag).add("signingPublicKey", (Object)this.signingPublicKey).add("transactionSignature", (Object)this.transactionSignature).add("closeDate", (Object)this.closeDate).add("hash", (Object)this.hash).add("ledgerIndex", (Object)this.ledgerIndex).add("flags", (Object)this.flags).add("regularKey", (Object)this.regularKey).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSetRegularKey fromJson(Json json) {
        Builder builder = ImmutableSetRegularKey.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.fee != null) {
            builder.fee(json.fee);
        }
        if (json.sequence != null) {
            builder.sequence(json.sequence);
        }
        if (json.accountTransactionId != null) {
            builder.accountTransactionId(json.accountTransactionId);
        }
        if (json.lastLedgerSequence != null) {
            builder.lastLedgerSequence(json.lastLedgerSequence);
        }
        if (json.memos != null) {
            builder.addAllMemos(json.memos);
        }
        if (json.signers != null) {
            builder.addAllSigners(json.signers);
        }
        if (json.sourceTag != null) {
            builder.sourceTag(json.sourceTag);
        }
        if (json.signingPublicKey != null) {
            builder.signingPublicKey(json.signingPublicKey);
        }
        if (json.transactionSignature != null) {
            builder.transactionSignature(json.transactionSignature);
        }
        if (json.closeDate != null) {
            builder.closeDate(json.closeDate);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.regularKey != null) {
            builder.regularKey(json.regularKey);
        }
        return builder.build();
    }

    public static ImmutableSetRegularKey copyOf(SetRegularKey instance) {
        if (instance instanceof ImmutableSetRegularKey) {
            return (ImmutableSetRegularKey)instance;
        }
        return ImmutableSetRegularKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SetRegularKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_FEE = 2L;
        private static final long INIT_BIT_SEQUENCE = 4L;
        private long initBits = 7L;
        @Nullable
        private Address account;
        @Nullable
        private XrpCurrencyAmount fee;
        @Nullable
        private UnsignedInteger sequence;
        @Nullable
        private Hash256 accountTransactionId;
        @Nullable
        private UnsignedInteger lastLedgerSequence;
        private ImmutableList.Builder<MemoWrapper> memos = ImmutableList.builder();
        private ImmutableList.Builder<SignerWrapper> signers = ImmutableList.builder();
        @Nullable
        private UnsignedInteger sourceTag;
        @Nullable
        private String signingPublicKey;
        @Nullable
        private String transactionSignature;
        @Nullable
        private UnsignedLong closeDate;
        @Nullable
        private Hash256 hash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private Address regularKey;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Transaction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SetRegularKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<Address> regularKeyOptional;
            Transaction instance;
            if (object instanceof Transaction) {
                Optional<String> signingPublicKeyOptional;
                Optional<UnsignedInteger> sourceTagOptional;
                Optional<UnsignedLong> closeDateOptional;
                instance = (Transaction)object;
                Optional<Hash256> accountTransactionIdOptional = instance.accountTransactionId();
                if (accountTransactionIdOptional.isPresent()) {
                    this.accountTransactionId(accountTransactionIdOptional);
                }
                this.fee(instance.fee());
                Optional<UnsignedInteger> lastLedgerSequenceOptional = instance.lastLedgerSequence();
                if (lastLedgerSequenceOptional.isPresent()) {
                    this.lastLedgerSequence(lastLedgerSequenceOptional);
                }
                if ((closeDateOptional = instance.closeDate()).isPresent()) {
                    this.closeDate(closeDateOptional);
                }
                this.sequence(instance.sequence());
                this.addAllSigners(instance.signers());
                Optional<String> transactionSignatureOptional = instance.transactionSignature();
                if (transactionSignatureOptional.isPresent()) {
                    this.transactionSignature(transactionSignatureOptional);
                }
                this.addAllMemos(instance.memos());
                Optional<LedgerIndex> ledgerIndexOptional = instance.ledgerIndex();
                if (ledgerIndexOptional.isPresent()) {
                    this.ledgerIndex(ledgerIndexOptional);
                }
                if ((sourceTagOptional = instance.sourceTag()).isPresent()) {
                    this.sourceTag(sourceTagOptional);
                }
                if ((signingPublicKeyOptional = instance.signingPublicKey()).isPresent()) {
                    this.signingPublicKey(signingPublicKeyOptional);
                }
                this.account(instance.account());
                Optional<Hash256> hashOptional = instance.hash();
                if (hashOptional.isPresent()) {
                    this.hash(hashOptional);
                }
            }
            if (object instanceof SetRegularKey && (regularKeyOptional = (instance = (SetRegularKey)object).regularKey()).isPresent()) {
                this.regularKey(regularKeyOptional);
            }
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Fee")
        @CanIgnoreReturnValue
        public final Builder fee(XrpCurrencyAmount fee) {
            this.fee = Objects.requireNonNull(fee, "fee");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Sequence")
        @CanIgnoreReturnValue
        public final Builder sequence(UnsignedInteger sequence) {
            this.sequence = Objects.requireNonNull(sequence, "sequence");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Hash256 accountTransactionId) {
            this.accountTransactionId = Objects.requireNonNull(accountTransactionId, "accountTransactionId");
            return this;
        }

        @JsonProperty(value="AccountTxnID")
        @CanIgnoreReturnValue
        public final Builder accountTransactionId(Optional<? extends Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastLedgerSequence(UnsignedInteger lastLedgerSequence) {
            this.lastLedgerSequence = Objects.requireNonNull(lastLedgerSequence, "lastLedgerSequence");
            return this;
        }

        @JsonProperty(value="LastLedgerSequence")
        @CanIgnoreReturnValue
        public final Builder lastLedgerSequence(Optional<? extends UnsignedInteger> lastLedgerSequence) {
            this.lastLedgerSequence = lastLedgerSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMemos(MemoWrapper element) {
            this.memos.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMemos(MemoWrapper ... elements) {
            this.memos.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Memos")
        @CanIgnoreReturnValue
        public final Builder memos(Iterable<? extends MemoWrapper> elements) {
            this.memos = ImmutableList.builder();
            return this.addAllMemos(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMemos(Iterable<? extends MemoWrapper> elements) {
            this.memos.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSigners(SignerWrapper element) {
            this.signers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSigners(SignerWrapper ... elements) {
            this.signers.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Signers")
        @CanIgnoreReturnValue
        public final Builder signers(Iterable<? extends SignerWrapper> elements) {
            this.signers = ImmutableList.builder();
            return this.addAllSigners(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSigners(Iterable<? extends SignerWrapper> elements) {
            this.signers.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceTag(UnsignedInteger sourceTag) {
            this.sourceTag = Objects.requireNonNull(sourceTag, "sourceTag");
            return this;
        }

        @JsonProperty(value="SourceTag")
        @CanIgnoreReturnValue
        public final Builder sourceTag(Optional<? extends UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signingPublicKey(String signingPublicKey) {
            this.signingPublicKey = Objects.requireNonNull(signingPublicKey, "signingPublicKey");
            return this;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="SigningPubKey")
        @CanIgnoreReturnValue
        public final Builder signingPublicKey(Optional<String> signingPublicKey) {
            this.signingPublicKey = signingPublicKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transactionSignature(String transactionSignature) {
            this.transactionSignature = Objects.requireNonNull(transactionSignature, "transactionSignature");
            return this;
        }

        @JsonProperty(value="TxnSignature")
        @CanIgnoreReturnValue
        public final Builder transactionSignature(Optional<String> transactionSignature) {
            this.transactionSignature = transactionSignature.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closeDate(UnsignedLong closeDate) {
            this.closeDate = Objects.requireNonNull(closeDate, "closeDate");
            return this;
        }

        @JsonProperty(value="date")
        @CanIgnoreReturnValue
        public final Builder closeDate(Optional<? extends UnsignedLong> closeDate) {
            this.closeDate = closeDate.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(Hash256 hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(Optional<? extends Hash256> hash) {
            this.hash = hash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder regularKey(Address regularKey) {
            this.regularKey = Objects.requireNonNull(regularKey, "regularKey");
            return this;
        }

        @JsonProperty(value="RegularKey")
        @CanIgnoreReturnValue
        public final Builder regularKey(Optional<? extends Address> regularKey) {
            this.regularKey = regularKey.orElse(null);
            return this;
        }

        public ImmutableSetRegularKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSetRegularKey(this.account, this.fee, this.sequence, this.accountTransactionId, this.lastLedgerSequence, this.memos.build(), this.signers.build(), this.sourceTag, this.signingPublicKey, this.transactionSignature, this.closeDate, this.hash, this.ledgerIndex, this.regularKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fee");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sequence");
            }
            return "Cannot build SetRegularKey, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SetRegularKey", generator="Immutables")
    static final class Json
    implements SetRegularKey {
        @Nullable
        Address account;
        @Nullable
        XrpCurrencyAmount fee;
        @Nullable
        UnsignedInteger sequence;
        @Nullable
        Optional<Hash256> accountTransactionId = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> lastLedgerSequence = Optional.empty();
        @Nullable
        List<MemoWrapper> memos = ImmutableList.of();
        @Nullable
        List<SignerWrapper> signers = ImmutableList.of();
        @Nullable
        Optional<UnsignedInteger> sourceTag = Optional.empty();
        @Nullable
        Optional<String> signingPublicKey = Optional.empty();
        @Nullable
        Optional<String> transactionSignature = Optional.empty();
        @Nullable
        Optional<UnsignedLong> closeDate = Optional.empty();
        @Nullable
        Optional<Hash256> hash = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<Address> regularKey = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="Fee")
        public void setFee(XrpCurrencyAmount fee) {
            this.fee = fee;
        }

        @JsonProperty(value="Sequence")
        public void setSequence(UnsignedInteger sequence) {
            this.sequence = sequence;
        }

        @JsonProperty(value="AccountTxnID")
        public void setAccountTransactionId(Optional<Hash256> accountTransactionId) {
            this.accountTransactionId = accountTransactionId;
        }

        @JsonProperty(value="LastLedgerSequence")
        public void setLastLedgerSequence(Optional<UnsignedInteger> lastLedgerSequence) {
            this.lastLedgerSequence = lastLedgerSequence;
        }

        @JsonProperty(value="Memos")
        public void setMemos(List<MemoWrapper> memos) {
            this.memos = memos;
        }

        @JsonProperty(value="Signers")
        public void setSigners(List<SignerWrapper> signers) {
            this.signers = signers;
        }

        @JsonProperty(value="SourceTag")
        public void setSourceTag(Optional<UnsignedInteger> sourceTag) {
            this.sourceTag = sourceTag;
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonProperty(value="SigningPubKey")
        public void setSigningPublicKey(Optional<String> signingPublicKey) {
            this.signingPublicKey = signingPublicKey;
        }

        @JsonProperty(value="TxnSignature")
        public void setTransactionSignature(Optional<String> transactionSignature) {
            this.transactionSignature = transactionSignature;
        }

        @JsonProperty(value="date")
        public void setCloseDate(Optional<UnsignedLong> closeDate) {
            this.closeDate = closeDate;
        }

        @JsonProperty(value="hash")
        public void setHash(Optional<Hash256> hash) {
            this.hash = hash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="RegularKey")
        public void setRegularKey(Optional<Address> regularKey) {
            this.regularKey = regularKey;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount fee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger sequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> accountTransactionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> lastLedgerSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MemoWrapper> memos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SignerWrapper> signers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> sourceTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> signingPublicKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> transactionSignature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedLong> closeDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> hash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Flags.TransactionFlags flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> regularKey() {
            throw new UnsupportedOperationException();
        }
    }
}

