/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Signer;

@ParametersAreNonnullByDefault
@Deprecated
@CheckReturnValue
@Generated(from="Signer", generator="Immutables")
@Immutable
public final class ImmutableSigner
implements Signer {
    private final Address account;
    private final String transactionSignature;
    private final String signingPublicKey;

    private ImmutableSigner(Address account, String transactionSignature, String signingPublicKey) {
        this.account = account;
        this.transactionSignature = transactionSignature;
        this.signingPublicKey = signingPublicKey;
    }

    @Override
    @JsonProperty(value="Account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="TxnSignature")
    public String transactionSignature() {
        return this.transactionSignature;
    }

    @Override
    @JsonProperty(value="SigningPubKey")
    public String signingPublicKey() {
        return this.signingPublicKey;
    }

    public final ImmutableSigner withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableSigner(newValue, this.transactionSignature, this.signingPublicKey);
    }

    public final ImmutableSigner withTransactionSignature(String value) {
        String newValue = Objects.requireNonNull(value, "transactionSignature");
        if (this.transactionSignature.equals(newValue)) {
            return this;
        }
        return new ImmutableSigner(this.account, newValue, this.signingPublicKey);
    }

    public final ImmutableSigner withSigningPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "signingPublicKey");
        if (this.signingPublicKey.equals(newValue)) {
            return this;
        }
        return new ImmutableSigner(this.account, this.transactionSignature, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSigner && this.equalTo((ImmutableSigner)another);
    }

    private boolean equalTo(ImmutableSigner another) {
        return this.account.equals(another.account) && this.transactionSignature.equals(another.transactionSignature) && this.signingPublicKey.equals(another.signingPublicKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.transactionSignature.hashCode();
        h += (h << 5) + this.signingPublicKey.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Signer").omitNullValues().add("account", (Object)this.account).add("transactionSignature", (Object)this.transactionSignature).add("signingPublicKey", (Object)this.signingPublicKey).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSigner fromJson(Json json) {
        Builder builder = ImmutableSigner.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.transactionSignature != null) {
            builder.transactionSignature(json.transactionSignature);
        }
        if (json.signingPublicKey != null) {
            builder.signingPublicKey(json.signingPublicKey);
        }
        return builder.build();
    }

    public static ImmutableSigner copyOf(Signer instance) {
        if (instance instanceof ImmutableSigner) {
            return (ImmutableSigner)instance;
        }
        return ImmutableSigner.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Signer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_TRANSACTION_SIGNATURE = 2L;
        private static final long INIT_BIT_SIGNING_PUBLIC_KEY = 4L;
        private long initBits = 7L;
        @Nullable
        private Address account;
        @Nullable
        private String transactionSignature;
        @Nullable
        private String signingPublicKey;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Signer instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.transactionSignature(instance.transactionSignature());
            this.signingPublicKey(instance.signingPublicKey());
            return this;
        }

        @JsonProperty(value="Account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="TxnSignature")
        @CanIgnoreReturnValue
        public final Builder transactionSignature(String transactionSignature) {
            this.transactionSignature = Objects.requireNonNull(transactionSignature, "transactionSignature");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="SigningPubKey")
        @CanIgnoreReturnValue
        public final Builder signingPublicKey(String signingPublicKey) {
            this.signingPublicKey = Objects.requireNonNull(signingPublicKey, "signingPublicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSigner build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSigner(this.account, this.transactionSignature, this.signingPublicKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("transactionSignature");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("signingPublicKey");
            }
            return "Cannot build Signer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Signer", generator="Immutables")
    static final class Json
    implements Signer {
        @Nullable
        Address account;
        @Nullable
        String transactionSignature;
        @Nullable
        String signingPublicKey;

        Json() {
        }

        @JsonProperty(value="Account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="TxnSignature")
        public void setTransactionSignature(String transactionSignature) {
            this.transactionSignature = transactionSignature;
        }

        @JsonProperty(value="SigningPubKey")
        public void setSigningPublicKey(String signingPublicKey) {
            this.signingPublicKey = signingPublicKey;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String transactionSignature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String signingPublicKey() {
            throw new UnsupportedOperationException();
        }
    }
}

