/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.ledger.SignerListObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.ImmutableAccountDelete;
import org.xrpl.xrpl4j.model.transactions.ImmutableAccountSet;
import org.xrpl.xrpl4j.model.transactions.ImmutableCheckCancel;
import org.xrpl.xrpl4j.model.transactions.ImmutableCheckCash;
import org.xrpl.xrpl4j.model.transactions.ImmutableCheckCreate;
import org.xrpl.xrpl4j.model.transactions.ImmutableDepositPreAuth;
import org.xrpl.xrpl4j.model.transactions.ImmutableEscrowCancel;
import org.xrpl.xrpl4j.model.transactions.ImmutableEscrowCreate;
import org.xrpl.xrpl4j.model.transactions.ImmutableEscrowFinish;
import org.xrpl.xrpl4j.model.transactions.ImmutableOfferCancel;
import org.xrpl.xrpl4j.model.transactions.ImmutableOfferCreate;
import org.xrpl.xrpl4j.model.transactions.ImmutablePayment;
import org.xrpl.xrpl4j.model.transactions.ImmutablePaymentChannelClaim;
import org.xrpl.xrpl4j.model.transactions.ImmutablePaymentChannelCreate;
import org.xrpl.xrpl4j.model.transactions.ImmutablePaymentChannelFund;
import org.xrpl.xrpl4j.model.transactions.ImmutableSetRegularKey;
import org.xrpl.xrpl4j.model.transactions.ImmutableSignerListSet;
import org.xrpl.xrpl4j.model.transactions.ImmutableTrustSet;
import org.xrpl.xrpl4j.model.transactions.MemoWrapper;
import org.xrpl.xrpl4j.model.transactions.SignerWrapper;
import org.xrpl.xrpl4j.model.transactions.TransactionType;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

public interface Transaction {
    public static final long RIPPLE_EPOCH = 946684800L;
    public static final BiMap<Class<? extends Transaction>, TransactionType> typeMap = new ImmutableBiMap.Builder().put(ImmutableAccountSet.class, (Object)TransactionType.ACCOUNT_SET).put(ImmutableAccountDelete.class, (Object)TransactionType.ACCOUNT_DELETE).put(ImmutableCheckCancel.class, (Object)TransactionType.CHECK_CANCEL).put(ImmutableCheckCash.class, (Object)TransactionType.CHECK_CASH).put(ImmutableCheckCreate.class, (Object)TransactionType.CHECK_CREATE).put(ImmutableDepositPreAuth.class, (Object)TransactionType.DEPOSIT_PRE_AUTH).put(ImmutableEscrowCancel.class, (Object)TransactionType.ESCROW_CANCEL).put(ImmutableEscrowCreate.class, (Object)TransactionType.ESCROW_CREATE).put(ImmutableEscrowFinish.class, (Object)TransactionType.ESCROW_FINISH).put(ImmutableOfferCancel.class, (Object)TransactionType.OFFER_CANCEL).put(ImmutableOfferCreate.class, (Object)TransactionType.OFFER_CREATE).put(ImmutablePayment.class, (Object)TransactionType.PAYMENT).put(ImmutablePaymentChannelClaim.class, (Object)TransactionType.PAYMENT_CHANNEL_CLAIM).put(ImmutablePaymentChannelCreate.class, (Object)TransactionType.PAYMENT_CHANNEL_CREATE).put(ImmutablePaymentChannelFund.class, (Object)TransactionType.PAYMENT_CHANNEL_FUND).put(ImmutableSetRegularKey.class, (Object)TransactionType.SET_REGULAR_KEY).put(ImmutableSignerListSet.class, (Object)TransactionType.SIGNER_LIST_SET).put(ImmutableTrustSet.class, (Object)TransactionType.TRUST_SET).build();

    public static XrpCurrencyAmount computeMultiSigFee(XrpCurrencyAmount currentLedgerFeeDrops, SignerListObject signerList) {
        Objects.requireNonNull(currentLedgerFeeDrops);
        Objects.requireNonNull(signerList);
        return currentLedgerFeeDrops.times(XrpCurrencyAmount.of(UnsignedLong.valueOf((long)(signerList.signerEntries().size() + 1))));
    }

    @JsonProperty(value="Account")
    public Address account();

    @JsonProperty(value="TransactionType")
    default public TransactionType transactionType() {
        return (TransactionType)((Object)typeMap.get(this.getClass()));
    }

    @JsonProperty(value="Fee")
    public XrpCurrencyAmount fee();

    @JsonProperty(value="Sequence")
    public UnsignedInteger sequence();

    @JsonProperty(value="AccountTxnID")
    public Optional<Hash256> accountTransactionId();

    @JsonProperty(value="LastLedgerSequence")
    public Optional<UnsignedInteger> lastLedgerSequence();

    @JsonProperty(value="Memos")
    public List<MemoWrapper> memos();

    @JsonProperty(value="Signers")
    public List<SignerWrapper> signers();

    @JsonProperty(value="SourceTag")
    public Optional<UnsignedInteger> sourceTag();

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="SigningPubKey")
    public Optional<String> signingPublicKey();

    @JsonProperty(value="TxnSignature")
    public Optional<String> transactionSignature();

    @JsonProperty(value="date")
    public Optional<UnsignedLong> closeDate();

    @JsonIgnore
    @Value.Auxiliary
    default public Optional<ZonedDateTime> closeDateHuman() {
        return this.closeDate().map(secondsSinceRippleEpoch -> Instant.ofEpochSecond(946684800L + secondsSinceRippleEpoch.longValue()).atZone(ZoneId.of("UTC")));
    }

    public Optional<Hash256> hash();

    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex();
}

