/*
 * Decompiled with CFR 0.152.
 */
package ted.gun0912.clustering.clustering;

import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ted.gun0912.clustering.BaseBuilder;
import ted.gun0912.clustering.MarkerManager;
import ted.gun0912.clustering.TedMap;
import ted.gun0912.clustering.TedMarker;
import ted.gun0912.clustering.clustering.Cluster;
import ted.gun0912.clustering.clustering.TedClusterItem;
import ted.gun0912.clustering.clustering.algo.Algorithm;
import ted.gun0912.clustering.clustering.algo.NonHierarchicalDistanceBasedAlgorithm;
import ted.gun0912.clustering.clustering.algo.PreCachingAlgorithmDecorator;
import ted.gun0912.clustering.clustering.algo.ScreenBasedAlgorithm;
import ted.gun0912.clustering.clustering.algo.ScreenBasedAlgorithmAdapter;
import ted.gun0912.clustering.clustering.view.ClusterRenderer;
import ted.gun0912.clustering.geometry.TedCameraPosition;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u0003*\u0004\b\u0002\u0010\u0004*\u000e\b\u0003\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00070\u0006*\u0004\b\u0004\u0010\b*\u0004\b\u0005\u0010\u00072\u00020\t:\u0001AB1\u0012*\u0010\n\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00028\u0001\u00a2\u0006\u0002\u0010.J\u0014\u0010/\u001a\u00020,2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u000101J\u0006\u00102\u001a\u00020,J\u0006\u00103\u001a\u00020,J\u0016\u00104\u001a\u00020,2\f\u00105\u001a\b\u0012\u0004\u0012\u00020,06H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020*H\u0002J\u0010\u0010:\u001a\u00020,2\u0006\u00109\u001a\u00020*H\u0002J\u0017\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00028\u0003H\u0000\u00a2\u0006\u0004\b=\u0010>J\u0013\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00028\u0001\u00a2\u0006\u0002\u0010.J\u0014\u0010\u0011\u001a\u00020,2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019R4\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000e2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R'\u0010\u0013\u001a\u00180\u0014R\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u001c\u001a*0\u001dR&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u001e\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010 \u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R#\u0010$\u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R'\u0010'\u001a\u00180\u0014R\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0017R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lted/gun0912/clustering/clustering/ClusterManager;", "Clustering", "C", "Lted/gun0912/clustering/clustering/TedClusterItem;", "RealMarker", "Marker", "Lted/gun0912/clustering/TedMarker;", "ImageDescriptor", "Map", "", "builder", "Lted/gun0912/clustering/BaseBuilder;", "(Lted/gun0912/clustering/BaseBuilder;)V", "algorithm", "Lted/gun0912/clustering/clustering/algo/Algorithm;", "getAlgorithm", "()Lted/gun0912/clustering/clustering/algo/Algorithm;", "setAlgorithm", "(Lted/gun0912/clustering/clustering/algo/Algorithm;)V", "clusterMarkerMarkerCollection", "Lted/gun0912/clustering/MarkerManager$MarkerCollection;", "Lted/gun0912/clustering/MarkerManager;", "getClusterMarkerMarkerCollection", "()Lted/gun0912/clustering/MarkerManager$MarkerCollection;", "mAlgorithm", "Lted/gun0912/clustering/clustering/algo/ScreenBasedAlgorithm;", "mAlgorithmLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "mClusterTask", "Lted/gun0912/clustering/clustering/ClusterManager$ClusterTask;", "mRenderer", "Lted/gun0912/clustering/clustering/view/ClusterRenderer;", "map", "Lted/gun0912/clustering/TedMap;", "getMap", "()Lted/gun0912/clustering/TedMap;", "markerManager", "getMarkerManager", "()Lted/gun0912/clustering/MarkerManager;", "markerMarkerCollection", "getMarkerMarkerCollection", "previousCameraPosition", "Lted/gun0912/clustering/geometry/TedCameraPosition;", "addItem", "", "myItem", "(Lted/gun0912/clustering/clustering/TedClusterItem;)V", "addItems", "items", "", "clearItems", "cluster", "internalLockSafe", "action", "Lkotlin/Function0;", "isSameZoom", "", "cameraPosition", "onCameraIdle", "onMarkerClick", "marker", "onMarkerClick$tedclustering_release", "(Lted/gun0912/clustering/TedMarker;)V", "removeItem", "item", "ClusterTask", "tedclustering_release"})
public final class ClusterManager<Clustering, C extends TedClusterItem, RealMarker, Marker extends TedMarker<ImageDescriptor>, Map, ImageDescriptor> {
    @NotNull
    private final TedMap<RealMarker, Marker, ImageDescriptor> map;
    @NotNull
    private final MarkerManager<RealMarker, Marker, ImageDescriptor> markerManager;
    @NotNull
    private final MarkerManager.MarkerCollection markerMarkerCollection;
    @NotNull
    private final MarkerManager.MarkerCollection clusterMarkerMarkerCollection;
    @NotNull
    private ScreenBasedAlgorithm<C> mAlgorithm;
    @NotNull
    private final ReentrantReadWriteLock mAlgorithmLock;
    @NotNull
    private ClusterRenderer<Clustering, C, RealMarker, Marker, Map, ImageDescriptor> mRenderer;
    @Nullable
    private TedCameraPosition previousCameraPosition;
    @NotNull
    private ClusterTask mClusterTask;

    public ClusterManager(@NotNull BaseBuilder<Clustering, C, RealMarker, Marker, Map, ImageDescriptor> builder) {
        C it;
        boolean bl;
        boolean bl2;
        C c;
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.map = builder.getMap$tedclustering_release();
        this.markerManager = new MarkerManager<RealMarker, Marker, ImageDescriptor>(this.map);
        this.markerMarkerCollection = this.markerManager.newCollection();
        this.clusterMarkerMarkerCollection = this.markerManager.newCollection();
        this.mAlgorithm = new ScreenBasedAlgorithmAdapter(new PreCachingAlgorithmDecorator(new NonHierarchicalDistanceBasedAlgorithm()));
        this.mAlgorithmLock = new ReentrantReadWriteLock();
        this.mClusterTask = new ClusterTask();
        this.map.addOnCameraIdleListener((Function1<TedCameraPosition, Unit>)((Function1)new Function1<TedCameraPosition, Unit>(this){

            public final void invoke(@NotNull TedCameraPosition p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ClusterManager)this.receiver).onCameraIdle(p0);
            }
        }));
        this.mRenderer = new ClusterRenderer<Clustering, C, RealMarker, Marker, Map, ImageDescriptor>(builder, this);
        Object object = builder.getItem$tedclustering_release();
        if (object != null) {
            c = object;
            bl2 = false;
            bl = false;
            it = c;
            boolean bl3 = false;
            this.addItem(it);
        }
        object = builder.getItems$tedclustering_release();
        if (object != null) {
            c = object;
            bl2 = false;
            bl = false;
            it = c;
            boolean bl4 = false;
            this.addItems((Collection<? extends C>)it);
        }
    }

    @NotNull
    public final TedMap<RealMarker, Marker, ImageDescriptor> getMap() {
        return this.map;
    }

    @NotNull
    public final MarkerManager<RealMarker, Marker, ImageDescriptor> getMarkerManager() {
        return this.markerManager;
    }

    @NotNull
    public final MarkerManager.MarkerCollection getMarkerMarkerCollection() {
        return this.markerMarkerCollection;
    }

    @NotNull
    public final MarkerManager.MarkerCollection getClusterMarkerMarkerCollection() {
        return this.clusterMarkerMarkerCollection;
    }

    @Nullable
    public final Algorithm<C> getAlgorithm() {
        return this.mAlgorithm;
    }

    public final void setAlgorithm(@Nullable Algorithm<C> algorithm) {
        if (algorithm instanceof ScreenBasedAlgorithm) {
            this.setAlgorithm((ScreenBasedAlgorithm)algorithm);
        } else {
            Algorithm<C> algorithm2 = algorithm;
            Intrinsics.checkNotNull(algorithm2);
            this.setAlgorithm((ScreenBasedAlgorithm)new ScreenBasedAlgorithmAdapter<C>(algorithm2));
        }
    }

    public final void onMarkerClick$tedclustering_release(@NotNull Marker marker) {
        Intrinsics.checkNotNullParameter(marker, (String)"marker");
        this.markerManager.onMarkerClick(marker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAlgorithm(@NotNull ScreenBasedAlgorithm<C> algorithm) {
        Intrinsics.checkNotNullParameter(algorithm, (String)"algorithm");
        this.mAlgorithmLock.writeLock().lock();
        try {
            algorithm.addItems(this.mAlgorithm.getItems());
            this.mAlgorithm = algorithm;
        }
        finally {
            this.mAlgorithmLock.writeLock().unlock();
        }
        if (this.mAlgorithm.shouldReClusterOnMapMovement()) {
            this.mAlgorithm.onCameraChange(this.map.getCameraPosition());
        }
        this.cluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalLockSafe(Function0<Unit> action) {
        this.mAlgorithmLock.writeLock().lock();
        try {
            action.invoke();
        }
        catch (Exception e) {
            Log.e((String)"ted", (String)e.getLocalizedMessage());
        }
        finally {
            this.mAlgorithmLock.writeLock().unlock();
        }
    }

    public final void clearItems() {
        this.internalLockSafe((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ClusterManager<Clustering, C, RealMarker, Marker, Map, ImageDescriptor> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ClusterManager.access$getMAlgorithm$p(this.this$0).clearItems();
            }
        }));
    }

    public final void addItems(@NotNull Collection<? extends C> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.internalLockSafe((Function0<Unit>)((Function0)new Function0<Unit>(this, items){
            final /* synthetic */ ClusterManager<Clustering, C, RealMarker, Marker, Map, ImageDescriptor> this$0;
            final /* synthetic */ Collection<C> $items;
            {
                this.this$0 = $receiver;
                this.$items = $items;
                super(0);
            }

            public final void invoke() {
                ClusterManager.access$getMAlgorithm$p(this.this$0).addItems(this.$items);
            }
        }));
    }

    public final void addItem(@NotNull C myItem) {
        Intrinsics.checkNotNullParameter(myItem, (String)"myItem");
        this.internalLockSafe((Function0<Unit>)((Function0)new Function0<Unit>(this, myItem){
            final /* synthetic */ ClusterManager<Clustering, C, RealMarker, Marker, Map, ImageDescriptor> this$0;
            final /* synthetic */ C $myItem;
            {
                this.this$0 = $receiver;
                this.$myItem = $myItem;
                super(0);
            }

            public final void invoke() {
                ClusterManager.access$getMAlgorithm$p(this.this$0).addItem(this.$myItem);
            }
        }));
    }

    public final void removeItem(@NotNull C item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.internalLockSafe((Function0<Unit>)((Function0)new Function0<Unit>(this, item){
            final /* synthetic */ ClusterManager<Clustering, C, RealMarker, Marker, Map, ImageDescriptor> this$0;
            final /* synthetic */ C $item;
            {
                this.this$0 = $receiver;
                this.$item = $item;
                super(0);
            }

            public final void invoke() {
                ClusterManager.access$getMAlgorithm$p(this.this$0).removeItem(this.$item);
            }
        }));
    }

    public final void cluster() {
        this.internalLockSafe((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ClusterManager<Clustering, C, RealMarker, Marker, Map, ImageDescriptor> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ClusterManager.access$getMClusterTask$p(this.this$0).cancel(true);
                ClusterManager.access$setMClusterTask$p(this.this$0, this.this$0.new ClusterTask());
                double zoom = this.this$0.getMap().getCameraPosition().getZoom();
                if (Build.VERSION.SDK_INT < 11) {
                    Object[] objectArray = new Double[]{zoom};
                    ClusterManager.access$getMClusterTask$p(this.this$0).execute(objectArray);
                } else {
                    Object[] objectArray = new Double[]{zoom};
                    ClusterManager.access$getMClusterTask$p(this.this$0).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, objectArray);
                }
            }
        }));
    }

    private final void onCameraIdle(TedCameraPosition cameraPosition) {
        this.mAlgorithm.onCameraChange(cameraPosition);
        if (this.mAlgorithm.shouldReClusterOnMapMovement()) {
            this.cluster();
        } else if (!this.isSameZoom(cameraPosition)) {
            this.previousCameraPosition = cameraPosition;
            this.cluster();
        }
    }

    private final boolean isSameZoom(TedCameraPosition cameraPosition) {
        TedCameraPosition tedCameraPosition = this.previousCameraPosition;
        return Intrinsics.areEqual((Double)(tedCameraPosition == null ? null : Double.valueOf(tedCameraPosition.getZoom())), (double)cameraPosition.getZoom());
    }

    public static final /* synthetic */ ClusterTask access$getMClusterTask$p(ClusterManager $this) {
        return $this.mClusterTask;
    }

    public static final /* synthetic */ void access$setMClusterTask$p(ClusterManager $this, ClusterTask clusterTask) {
        $this.mClusterTask = clusterTask;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J1\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\u00042\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\t\"\u0004\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00050\u0004H\u0014\u00a8\u0006\u000e"}, d2={"Lted/gun0912/clustering/clustering/ClusterManager$ClusterTask;", "Landroid/os/AsyncTask;", "", "Ljava/lang/Void;", "", "Lted/gun0912/clustering/clustering/Cluster;", "(Lted/gun0912/clustering/clustering/ClusterManager;)V", "doInBackground", "zoom", "", "([Ljava/lang/Double;)Ljava/util/Set;", "onPostExecute", "", "clusters", "tedclustering_release"})
    private final class ClusterTask
    extends AsyncTask<Double, Void, Set<? extends Cluster<C>>> {
        public ClusterTask() {
            Intrinsics.checkNotNullParameter((Object)ClusterManager.this, (String)"this$0");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected Set<Cluster<C>> doInBackground(Double ... zoom) {
            Intrinsics.checkNotNullParameter((Object)zoom, (String)"zoom");
            ClusterManager.this.mAlgorithmLock.readLock().lock();
            try {
                ScreenBasedAlgorithm screenBasedAlgorithm = ClusterManager.this.mAlgorithm;
                Double d = zoom[0];
                Intrinsics.checkNotNull((Object)d);
                Set set = screenBasedAlgorithm.getClusters(d);
                return set;
            }
            finally {
                ClusterManager.this.mAlgorithmLock.readLock().unlock();
            }
        }

        protected void onPostExecute(@NotNull Set<? extends Cluster<C>> clusters) {
            Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
            ClusterManager.this.mRenderer.onClustersChanged$tedclustering_release(clusters);
        }
    }
}

