/*
 * Decompiled with CFR 0.152.
 */
package ted.gun0912.clustering.clustering.algo;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ted.gun0912.clustering.clustering.TedClusterItem;
import ted.gun0912.clustering.clustering.algo.NonHierarchicalDistanceBasedAlgorithm;
import ted.gun0912.clustering.clustering.algo.ScreenBasedAlgorithm;
import ted.gun0912.clustering.geometry.Bounds;
import ted.gun0912.clustering.geometry.Point;
import ted.gun0912.clustering.geometry.TedCameraPosition;
import ted.gun0912.clustering.geometry.TedLatLng;
import ted.gun0912.clustering.projection.SphericalMercatorProjection;
import ted.gun0912.clustering.quadtree.PointQuadTree;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001\u001eB\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ5\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lted/gun0912/clustering/clustering/algo/NonHierarchicalViewBasedAlgorithm;", "T", "Lted/gun0912/clustering/clustering/TedClusterItem;", "Lted/gun0912/clustering/clustering/algo/NonHierarchicalDistanceBasedAlgorithm;", "Lted/gun0912/clustering/clustering/algo/ScreenBasedAlgorithm;", "mViewWidth", "", "mViewHeight", "(II)V", "mMapCenter", "Lted/gun0912/clustering/geometry/TedLatLng;", "getClusteringItems", "", "Lted/gun0912/clustering/clustering/algo/NonHierarchicalDistanceBasedAlgorithm$QuadItem;", "quadTree", "Lted/gun0912/clustering/quadtree/PointQuadTree;", "discreteZoom", "getClusteringItems$tedclustering_release", "getVisibleBounds", "Lted/gun0912/clustering/geometry/Bounds;", "zoom", "onCameraChange", "", "tedCameraPosition", "Lted/gun0912/clustering/geometry/TedCameraPosition;", "shouldReClusterOnMapMovement", "", "updateViewSize", "width", "height", "Companion", "tedclustering_release"})
public final class NonHierarchicalViewBasedAlgorithm<T extends TedClusterItem>
extends NonHierarchicalDistanceBasedAlgorithm<T>
implements ScreenBasedAlgorithm<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mViewWidth;
    private int mViewHeight;
    @Nullable
    private TedLatLng mMapCenter;
    @NotNull
    private static final SphericalMercatorProjection PROJECTION = new SphericalMercatorProjection(1.0);

    public NonHierarchicalViewBasedAlgorithm(int mViewWidth, int mViewHeight) {
        this.mViewWidth = mViewWidth;
        this.mViewHeight = mViewHeight;
    }

    @Override
    public void onCameraChange(@NotNull TedCameraPosition tedCameraPosition) {
        Intrinsics.checkNotNullParameter((Object)tedCameraPosition, (String)"tedCameraPosition");
        this.mMapCenter = tedCameraPosition.getTarget();
    }

    @Override
    @NotNull
    public Collection<NonHierarchicalDistanceBasedAlgorithm.QuadItem<T>> getClusteringItems$tedclustering_release(@NotNull PointQuadTree<NonHierarchicalDistanceBasedAlgorithm.QuadItem<T>> quadTree, int discreteZoom) {
        Intrinsics.checkNotNullParameter(quadTree, (String)"quadTree");
        return quadTree.search(this.getVisibleBounds(discreteZoom));
    }

    @Override
    public boolean shouldReClusterOnMapMovement() {
        return true;
    }

    public final void updateViewSize(int width, int height) {
        this.mViewWidth = width;
        this.mViewHeight = height;
    }

    private final Bounds getVisibleBounds(int zoom) {
        if (this.mMapCenter == null) {
            return new Bounds(0.0, 0.0, 0.0, 0.0);
        }
        TedLatLng tedLatLng = this.mMapCenter;
        Intrinsics.checkNotNull((Object)tedLatLng);
        Point p = PROJECTION.toPoint(tedLatLng);
        double halfWidthSpan = (double)this.mViewWidth / Math.pow(2.0, zoom) / 256.0 / 2.0;
        double halfHeightSpan = (double)this.mViewHeight / Math.pow(2.0, zoom) / 256.0 / 2.0;
        return new Bounds(p.getX() - halfWidthSpan, p.getX() + halfWidthSpan, p.getY() - halfHeightSpan, p.getY() + halfHeightSpan);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lted/gun0912/clustering/clustering/algo/NonHierarchicalViewBasedAlgorithm$Companion;", "", "()V", "PROJECTION", "Lted/gun0912/clustering/projection/SphericalMercatorProjection;", "tedclustering_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

