/*
 * Decompiled with CFR 0.152.
 */
package ted.gun0912.clustering.clustering.algo;

import androidx.collection.LruCache;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ted.gun0912.clustering.clustering.Cluster;
import ted.gun0912.clustering.clustering.TedClusterItem;
import ted.gun0912.clustering.clustering.algo.Algorithm;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001$B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\r2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\r2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0015\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lted/gun0912/clustering/clustering/algo/PreCachingAlgorithmDecorator;", "T", "Lted/gun0912/clustering/clustering/TedClusterItem;", "Lted/gun0912/clustering/clustering/algo/Algorithm;", "mAlgorithm", "(Lted/gun0912/clustering/clustering/algo/Algorithm;)V", "items", "", "getItems", "()Ljava/util/Collection;", "mCache", "Landroidx/collection/LruCache;", "", "", "Lted/gun0912/clustering/clustering/Cluster;", "mCacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "maxDistance", "maxDistanceBetweenClusteredItems", "getMaxDistanceBetweenClusteredItems", "()I", "setMaxDistanceBetweenClusteredItems", "(I)V", "addItem", "", "item", "(Lted/gun0912/clustering/clustering/TedClusterItem;)V", "addItems", "clearCache", "clearItems", "getClusters", "zoom", "", "getClustersInternal", "discreteZoom", "removeItem", "PrecacheRunnable", "tedclustering_release"})
public final class PreCachingAlgorithmDecorator<T extends TedClusterItem>
implements Algorithm<T> {
    @NotNull
    private final Algorithm<T> mAlgorithm;
    @NotNull
    private final LruCache<Integer, Set<Cluster<T>>> mCache;
    @NotNull
    private final ReentrantReadWriteLock mCacheLock;

    public PreCachingAlgorithmDecorator(@NotNull Algorithm<T> mAlgorithm) {
        Intrinsics.checkNotNullParameter(mAlgorithm, (String)"mAlgorithm");
        this.mAlgorithm = mAlgorithm;
        this.mCache = new LruCache(5);
        this.mCacheLock = new ReentrantReadWriteLock();
    }

    @Override
    @NotNull
    public Collection<T> getItems() {
        return this.mAlgorithm.getItems();
    }

    @Override
    public int getMaxDistanceBetweenClusteredItems() {
        return this.mAlgorithm.getMaxDistanceBetweenClusteredItems();
    }

    @Override
    public void setMaxDistanceBetweenClusteredItems(int maxDistance) {
        this.mAlgorithm.setMaxDistanceBetweenClusteredItems(maxDistance);
        this.clearCache();
    }

    @Override
    public void addItem(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.mAlgorithm.addItem(item);
        this.clearCache();
    }

    @Override
    public void addItems(@NotNull Collection<? extends T> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.mAlgorithm.addItems(items);
        this.clearCache();
    }

    @Override
    public void clearItems() {
        this.mAlgorithm.clearItems();
        this.clearCache();
    }

    @Override
    public void removeItem(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.mAlgorithm.removeItem(item);
        this.clearCache();
    }

    private final void clearCache() {
        this.mCache.evictAll();
    }

    @Override
    @NotNull
    public Set<Cluster<T>> getClusters(double zoom) {
        int discreteZoom = (int)zoom;
        Set<Cluster<T>> results = this.getClustersInternal(discreteZoom);
        if (this.mCache.get((Object)(discreteZoom + 1)) == null) {
            new Thread(new PrecacheRunnable(discreteZoom + 1)).start();
        }
        if (this.mCache.get((Object)(discreteZoom - 1)) == null) {
            new Thread(new PrecacheRunnable(discreteZoom - 1)).start();
        }
        return results;
    }

    private final Set<Cluster<T>> getClustersInternal(int discreteZoom) {
        Set<Cluster<T>> results = null;
        this.mCacheLock.readLock().lock();
        results = (Set<Cluster<T>>)this.mCache.get((Object)discreteZoom);
        this.mCacheLock.readLock().unlock();
        if (results == null) {
            this.mCacheLock.writeLock().lock();
            results = (Set)this.mCache.get((Object)discreteZoom);
            if (results == null) {
                results = this.mAlgorithm.getClusters(discreteZoom);
                this.mCache.put((Object)discreteZoom, results);
            }
            this.mCacheLock.writeLock().unlock();
        }
        return results;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lted/gun0912/clustering/clustering/algo/PreCachingAlgorithmDecorator$PrecacheRunnable;", "Ljava/lang/Runnable;", "mZoom", "", "(Lted/gun0912/clustering/clustering/algo/PreCachingAlgorithmDecorator;I)V", "run", "", "tedclustering_release"})
    private final class PrecacheRunnable
    implements Runnable {
        private final int mZoom;

        public PrecacheRunnable(int mZoom) {
            Intrinsics.checkNotNullParameter((Object)PreCachingAlgorithmDecorator.this, (String)"this$0");
            this.mZoom = mZoom;
        }

        @Override
        public void run() {
            try {
                Thread.sleep((long)(Math.random() * (double)500 + (double)500));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PreCachingAlgorithmDecorator.this.getClustersInternal(this.mZoom);
        }
    }
}

