/*
 * Decompiled with CFR 0.152.
 */
package ted.gun0912.clustering.clustering.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.ColorInt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ted.gun0912.clustering.BaseBuilder;
import ted.gun0912.clustering.MarkerManager;
import ted.gun0912.clustering.R;
import ted.gun0912.clustering.TedMap;
import ted.gun0912.clustering.TedMarker;
import ted.gun0912.clustering.clustering.Cluster;
import ted.gun0912.clustering.clustering.ClusterManager;
import ted.gun0912.clustering.clustering.TedClusterItem;
import ted.gun0912.clustering.clustering.algo.Algorithm;
import ted.gun0912.clustering.geometry.Point;
import ted.gun0912.clustering.geometry.TedLatLng;
import ted.gun0912.clustering.geometry.TedLatLngBounds;
import ted.gun0912.clustering.projection.SphericalMercatorProjection;
import ted.gun0912.clustering.ui.IconGenerator;
import ted.gun0912.clustering.ui.SquareTextView;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u0000 O*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u0003*\u0004\b\u0002\u0010\u0004*\u000e\b\u0003\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00070\u0006*\u0004\b\u0004\u0010\b*\u0004\b\u0005\u0010\u00072\u00020\t:\bNOPQRSTUB]\u0012*\u0010\n\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000b\u0012*\u0010\f\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\r\u00a2\u0006\u0002\u0010\u000eJ\"\u0010-\u001a\u0004\u0018\u00010.2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u00020.\u0018\u0001002\u0006\u00101\u001a\u00020.H\u0002J\u0016\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015H\u0002J\u001c\u00105\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00152\f\u00106\u001a\b\u0012\u0004\u0012\u00028\u00050\u0006J\u0015\u00107\u001a\u0004\u0018\u00018\u00012\u0006\u00106\u001a\u00028\u0003\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u000203H\u0002J\u0010\u0010<\u001a\u0002032\u0006\u0010=\u001a\u000203H\u0003J\u0010\u0010>\u001a\u00020?2\u0006\u0010;\u001a\u000203H\u0002J\u0015\u0010@\u001a\u0004\u0018\u00018\u00032\u0006\u0010A\u001a\u00028\u0001\u00a2\u0006\u0002\u0010BJ\u001b\u0010@\u001a\u0004\u0018\u00018\u00032\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010H\u001a\u00020I2\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u00010\u00152\f\u00106\u001a\b\u0012\u0004\u0012\u00028\u00050\u0006H\u0002J!\u0010J\u001a\u00020I2\u0012\u0010K\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00150\u0018H\u0000\u00a2\u0006\u0002\bLJ\u0016\u0010M\u001a\u00020\u00102\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015H\u0002R2\u0010\n\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0013\u001a*\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0015\u0012\u0004\u0012\u00028\u00030\u0014j\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0015\u0012\u0004\u0012\u00028\u0003`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0015\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00050 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010!\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010#\u001a*\u0012\u0004\u0012\u00028\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00150\u0014j\u0014\u0012\u0004\u0012\u00028\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050&0%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010'\u001a*0(R&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010+\u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lted/gun0912/clustering/clustering/view/ClusterRenderer;", "Clustering", "T", "Lted/gun0912/clustering/clustering/TedClusterItem;", "RealMarker", "Marker", "Lted/gun0912/clustering/TedMarker;", "ImageDescriptor", "Map", "", "builder", "Lted/gun0912/clustering/BaseBuilder;", "mClusterManager", "Lted/gun0912/clustering/clustering/ClusterManager;", "(Lted/gun0912/clustering/BaseBuilder;Lted/gun0912/clustering/clustering/ClusterManager;)V", "clusterAnimation", "", "context", "Landroid/content/Context;", "mClusterToMarker", "Ljava/util/HashMap;", "Lted/gun0912/clustering/clustering/Cluster;", "Lkotlin/collections/HashMap;", "mClusters", "", "mColoredCircleBackground", "Landroid/graphics/drawable/ShapeDrawable;", "mDensity", "", "mIconGenerator", "Lted/gun0912/clustering/ui/IconGenerator;", "mIcons", "Landroid/util/SparseArray;", "mMarkerCache", "Lted/gun0912/clustering/clustering/view/ClusterRenderer$MarkerCache;", "mMarkerToCluster", "mMarkers", "", "Lted/gun0912/clustering/clustering/view/ClusterRenderer$MarkerWithPosition;", "mViewModifier", "Lted/gun0912/clustering/clustering/view/ClusterRenderer$ViewModifier;", "mZoom", "", "tedMap", "Lted/gun0912/clustering/TedMap;", "findClosestCluster", "Lted/gun0912/clustering/geometry/Point;", "markers", "", "point", "getBucket", "", "cluster", "getCluster", "tedMarker", "getClusterItem", "(Lted/gun0912/clustering/TedMarker;)Lted/gun0912/clustering/clustering/TedClusterItem;", "getDefaultCluster", "Landroid/graphics/Bitmap;", "bucket", "getDefaultClusterBackground", "clusterSize", "getDefaultClusterText", "", "getMarker", "clusterItem", "(Lted/gun0912/clustering/clustering/TedClusterItem;)Lted/gun0912/clustering/TedMarker;", "(Lted/gun0912/clustering/clustering/Cluster;)Lted/gun0912/clustering/TedMarker;", "makeClusterBackground", "Landroid/graphics/drawable/LayerDrawable;", "makeSquareTextView", "Lted/gun0912/clustering/ui/SquareTextView;", "onBeforeClusterRendered", "", "onClustersChanged", "clusters", "onClustersChanged$tedclustering_release", "shouldRenderAsCluster", "AnimationTask", "Companion", "CreateMarkerTask", "MarkerCache", "MarkerModifier", "MarkerWithPosition", "RenderTask", "ViewModifier", "tedclustering_release"})
public final class ClusterRenderer<Clustering, T extends TedClusterItem, RealMarker, Marker extends TedMarker<ImageDescriptor>, Map, ImageDescriptor> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseBuilder<Clustering, T, RealMarker, Marker, Map, ImageDescriptor> builder;
    @NotNull
    private final ClusterManager<Clustering, T, RealMarker, Marker, Map, ImageDescriptor> mClusterManager;
    @NotNull
    private final Context context;
    @NotNull
    private final TedMap<RealMarker, Marker, ImageDescriptor> tedMap;
    @NotNull
    private final IconGenerator mIconGenerator;
    private final float mDensity;
    private boolean clusterAnimation;
    @Nullable
    private ShapeDrawable mColoredCircleBackground;
    @NotNull
    private Set<MarkerWithPosition<Marker, ImageDescriptor>> mMarkers;
    @NotNull
    private final SparseArray<ImageDescriptor> mIcons;
    @NotNull
    private final MarkerCache<T, Marker, ImageDescriptor> mMarkerCache;
    @Nullable
    private Set<? extends Cluster<T>> mClusters;
    @NotNull
    private final HashMap<Marker, Cluster<T>> mMarkerToCluster;
    @NotNull
    private final HashMap<Cluster<T>, Marker> mClusterToMarker;
    private double mZoom;
    @NotNull
    private final ViewModifier mViewModifier;
    private static final boolean SHOULD_ANIMATE = Build.VERSION.SDK_INT >= 11;
    @NotNull
    private static final DecelerateInterpolator ANIMATION_INTERPOLATOR = new DecelerateInterpolator();

    public ClusterRenderer(@NotNull BaseBuilder<Clustering, T, RealMarker, Marker, Map, ImageDescriptor> builder, @NotNull ClusterManager<Clustering, T, RealMarker, Marker, Map, ImageDescriptor> mClusterManager) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter(mClusterManager, (String)"mClusterManager");
        this.builder = builder;
        this.mClusterManager = mClusterManager;
        this.context = this.builder.getContext$tedclustering_release();
        this.tedMap = this.builder.getMap$tedclustering_release();
        this.clusterAnimation = this.builder.getClusterAnimation$tedclustering_release();
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(\n            ConcurrentHashMap()\n        )");
        this.mMarkers = set;
        this.mIcons = new SparseArray();
        this.mMarkerCache = new MarkerCache();
        this.mMarkerToCluster = new HashMap();
        this.mClusterToMarker = new HashMap();
        this.mViewModifier = new ViewModifier();
        this.mDensity = this.context.getResources().getDisplayMetrics().density;
        this.mIconGenerator = new IconGenerator(this.context);
        this.mIconGenerator.setContentView((View)this.makeSquareTextView(this.context));
        this.mIconGenerator.setTextAppearance(R.style.amu_ClusterIcon_TextAppearance);
        this.mIconGenerator.setBackground((Drawable)this.makeClusterBackground());
        this.mClusterManager.getMarkerMarkerCollection().setOnMarkerClickListener((Function1)new Function1<Marker, Unit>(){

            public final void invoke(@NotNull Marker marker) {
                Function1 function1;
                Intrinsics.checkNotNullParameter(marker, (String)"marker");
                if (builder.getClickToCenter$tedclustering_release()) {
                    tedMap.moveToCenter(marker.getPosition());
                }
                if ((function1 = builder.getMarkerClickListener$tedclustering_release()) != null) {
                    function1.invoke(mMarkerCache.get(marker));
                }
            }
        });
        this.mClusterManager.getClusterMarkerMarkerCollection().setOnMarkerClickListener((Function1)new Function1<Marker, Unit>(){

            public final void invoke(@NotNull Marker marker) {
                Function1 function1;
                Intrinsics.checkNotNullParameter(marker, (String)"marker");
                if (builder.getClickToCenter$tedclustering_release()) {
                    tedMap.moveToCenter(marker.getPosition());
                }
                if ((function1 = builder.getClusterClickListener$tedclustering_release()) != null) {
                    Object v = mMarkerToCluster.get(marker);
                    Intrinsics.checkNotNull(v);
                    Object v2 = v;
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"mMarkerToCluster[marker]!!");
                    function1.invoke(v2);
                }
            }
        });
    }

    private final LayerDrawable makeClusterBackground() {
        this.mColoredCircleBackground = new ShapeDrawable((Shape)new OvalShape());
        ShapeDrawable outline = new ShapeDrawable((Shape)new OvalShape());
        outline.getPaint().setColor(-2130706433);
        Drawable[] drawableArray = new Drawable[2];
        drawableArray[0] = (Drawable)outline;
        ShapeDrawable shapeDrawable = this.mColoredCircleBackground;
        Intrinsics.checkNotNull((Object)shapeDrawable);
        drawableArray[1] = (Drawable)shapeDrawable;
        LayerDrawable background = new LayerDrawable(drawableArray);
        int strokeWidth = (int)(this.mDensity * (float)3);
        background.setLayerInset(1, strokeWidth, strokeWidth, strokeWidth, strokeWidth);
        return background;
    }

    private final SquareTextView makeSquareTextView(Context context) {
        SquareTextView squareTextView = new SquareTextView(context, null, 0, 6, null);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        squareTextView.setLayoutParams(layoutParams);
        squareTextView.setId(R.id.amu_text);
        int twelveDpi = (int)((float)12 * this.mDensity);
        squareTextView.setPadding(twelveDpi, twelveDpi, twelveDpi, twelveDpi);
        return squareTextView;
    }

    @ColorInt
    private final int getDefaultClusterBackground(int clusterSize) {
        float hueRange = 220.0f;
        float sizeRange = 300.0f;
        float size = Math.min((float)clusterSize, sizeRange);
        float hue = (sizeRange - size) * (sizeRange - size) / (sizeRange * sizeRange) * hueRange;
        float[] fArray = new float[]{hue, 1.0f, 0.6f};
        return Color.HSVToColor((float[])fArray);
    }

    private final String getDefaultClusterText(int bucket) {
        return bucket < this.builder.getClusterBuckets$tedclustering_release()[0] ? String.valueOf(bucket) : "" + bucket + '+';
    }

    private final int getBucket(Cluster<T> cluster2) {
        int[] buckets = this.builder.getClusterBuckets$tedclustering_release();
        int size = cluster2.getSize();
        if (size <= buckets[0]) {
            return size;
        }
        int n = 0;
        int n2 = buckets.length - 1;
        if (n < n2) {
            do {
                int i;
                if (size >= buckets[(i = n++) + 1]) continue;
                return buckets[i];
            } while (n < n2);
        }
        return buckets[buckets.length - 1];
    }

    private final boolean shouldRenderAsCluster(Cluster<T> cluster2) {
        return cluster2.getSize() > this.builder.getMinClusterSize$tedclustering_release();
    }

    public final void onClustersChanged$tedclustering_release(@NotNull Set<? extends Cluster<T>> clusters) {
        Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
        this.mViewModifier.queue(clusters);
    }

    private final Point findClosestCluster(List<Point> markers, Point point) {
        if (markers == null || markers.isEmpty()) {
            return null;
        }
        Algorithm<T> algorithm = this.mClusterManager.getAlgorithm();
        Intrinsics.checkNotNull(algorithm);
        int maxDistance = algorithm.getMaxDistanceBetweenClusteredItems();
        double minDistSquared = maxDistance * maxDistance;
        Point closest = null;
        for (Point candidate : markers) {
            double dist = ClusterRenderer.Companion.distanceSquared(candidate, point);
            if (!(dist < minDistSquared)) continue;
            closest = candidate;
            minDistSquared = dist;
        }
        return closest;
    }

    private final void onBeforeClusterRendered(Cluster<T> cluster2, TedMarker<ImageDescriptor> tedMarker) {
        int bucket = this.getBucket(cluster2);
        Object imageDescriptor = this.mIcons.get(bucket);
        if (imageDescriptor == null) {
            Bitmap bitmap;
            Function1<Cluster<T>, View> function1 = this.builder.getClusterMaker$tedclustering_release();
            if (function1 == null) {
                bitmap = null;
            } else {
                Function1<Cluster<T>, View> function12 = function1;
                boolean bl = false;
                boolean bl2 = false;
                Function1<Cluster<T>, View> it = function12;
                boolean bl3 = false;
                View view = (View)it.invoke(cluster2);
                bitmap = IconGenerator.Companion.makeIcon(view);
            }
            Bitmap bitmap2 = bitmap;
            Bitmap clusterBitmap = bitmap2 == null ? this.getDefaultCluster(bucket) : bitmap2;
            imageDescriptor = tedMarker.fromBitmap(clusterBitmap);
            this.mIcons.put(bucket, imageDescriptor);
        }
        Object object = imageDescriptor;
        Intrinsics.checkNotNull((Object)object);
        tedMarker.setImageDescriptor(object);
    }

    private final Bitmap getDefaultCluster(int bucket) {
        ShapeDrawable shapeDrawable = this.mColoredCircleBackground;
        Intrinsics.checkNotNull((Object)shapeDrawable);
        Function1<Integer, Integer> function1 = this.builder.getClusterBackground$tedclustering_release();
        Integer n = function1 == null ? null : (Integer)function1.invoke((Object)bucket);
        shapeDrawable.getPaint().setColor(n == null ? this.getDefaultClusterBackground(bucket) : n.intValue());
        Function1<Integer, String> function12 = this.builder.getClusterText$tedclustering_release();
        function1 = function12 == null ? null : (String)function12.invoke((Object)bucket);
        Function1<Integer, Integer> clusterText = function1 == null ? this.getDefaultClusterText(bucket) : function1;
        return this.mIconGenerator.makeIcon((CharSequence)clusterText);
    }

    @Nullable
    public final Marker getMarker(@NotNull T clusterItem) {
        Intrinsics.checkNotNullParameter(clusterItem, (String)"clusterItem");
        return (Marker)this.mMarkerCache.get(clusterItem);
    }

    @Nullable
    public final T getClusterItem(@NotNull Marker tedMarker) {
        Intrinsics.checkNotNullParameter(tedMarker, (String)"tedMarker");
        return (T)((TedClusterItem)this.mMarkerCache.get(tedMarker));
    }

    @Nullable
    public final Marker getMarker(@NotNull Cluster<T> cluster2) {
        Intrinsics.checkNotNullParameter(cluster2, (String)"cluster");
        return (Marker)((TedMarker)this.mClusterToMarker.get(cluster2));
    }

    @Nullable
    public final Cluster<T> getCluster(@NotNull TedMarker<ImageDescriptor> tedMarker) {
        Intrinsics.checkNotNullParameter(tedMarker, (String)"tedMarker");
        Map map = this.mMarkerToCluster;
        boolean bl = false;
        return (Cluster)map.get(tedMarker);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00120\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R8\u0010\u0006\u001a,\u0018\u00010\u0007R&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lted/gun0912/clustering/clustering/view/ClusterRenderer$ViewModifier;", "Landroid/os/Handler;", "(Lted/gun0912/clustering/clustering/view/ClusterRenderer;)V", "RUN_TASK", "", "TASK_FINISHED", "mNextClusters", "Lted/gun0912/clustering/clustering/view/ClusterRenderer$RenderTask;", "Lted/gun0912/clustering/clustering/view/ClusterRenderer;", "mViewModificationInProgress", "", "handleMessage", "", "msg", "Landroid/os/Message;", "queue", "clusters", "", "Lted/gun0912/clustering/clustering/Cluster;", "tedclustering_release"})
    @SuppressLint(value={"HandlerLeak"})
    private final class ViewModifier
    extends Handler {
        private boolean mViewModificationInProgress;
        @Nullable
        private RenderTask mNextClusters;
        private final int RUN_TASK;
        private final int TASK_FINISHED;

        public ViewModifier() {
            Intrinsics.checkNotNullParameter((Object)ClusterRenderer.this, (String)"this$0");
            this.TASK_FINISHED = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            if (msg.what == this.TASK_FINISHED) {
                this.mViewModificationInProgress = false;
                if (this.mNextClusters != null) {
                    this.sendEmptyMessage(this.RUN_TASK);
                }
                return;
            }
            this.removeMessages(this.RUN_TASK);
            if (this.mViewModificationInProgress) {
                return;
            }
            if (this.mNextClusters == null) {
                return;
            }
            RenderTask renderTask = null;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (this) {
                boolean bl3 = false;
                RenderTask renderTask2 = this.mNextClusters;
                if (renderTask2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type ted.gun0912.clustering.clustering.view.ClusterRenderer.RenderTask<Clustering of ted.gun0912.clustering.clustering.view.ClusterRenderer.ViewModifier.handleMessage$lambda-0, T of ted.gun0912.clustering.clustering.view.ClusterRenderer.ViewModifier.handleMessage$lambda-0, RealMarker of ted.gun0912.clustering.clustering.view.ClusterRenderer.ViewModifier.handleMessage$lambda-0, Marker of ted.gun0912.clustering.clustering.view.ClusterRenderer.ViewModifier.handleMessage$lambda-0, Map of ted.gun0912.clustering.clustering.view.ClusterRenderer.ViewModifier.handleMessage$lambda-0, ImageDescriptor of ted.gun0912.clustering.clustering.view.ClusterRenderer.ViewModifier.handleMessage$lambda-0>");
                }
                renderTask = renderTask2;
                this.mNextClusters = null;
                this.mViewModificationInProgress = true;
                Unit unit = Unit.INSTANCE;
            }
            renderTask.setCallback(() -> ViewModifier.handleMessage$lambda-1(this));
            renderTask.setMapZoom(ClusterRenderer.this.tedMap.getCameraPosition().getZoom());
            new Thread(renderTask).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void queue(@NotNull Set<? extends Cluster<T>> clusters) {
            Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
            ClusterRenderer clusterRenderer = ClusterRenderer.this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (this) {
                boolean bl3 = false;
                this.mNextClusters = clusterRenderer.new RenderTask(clusters);
                Unit unit = Unit.INSTANCE;
            }
            this.sendEmptyMessage(this.RUN_TASK);
        }

        private static final void handleMessage$lambda-1(ViewModifier this$0) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.sendEmptyMessage(this$0.TASK_FINISHED);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0017J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\nR \u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lted/gun0912/clustering/clustering/view/ClusterRenderer$RenderTask;", "Ljava/lang/Runnable;", "clusters", "", "Lted/gun0912/clustering/clustering/Cluster;", "(Lted/gun0912/clustering/clustering/view/ClusterRenderer;Ljava/util/Set;)V", "getClusters$tedclustering_release", "()Ljava/util/Set;", "mCallback", "mMapZoom", "", "mSphericalMercatorProjection", "Lted/gun0912/clustering/projection/SphericalMercatorProjection;", "run", "", "setCallback", "callback", "setMapZoom", "zoom", "tedclustering_release"})
    private final class RenderTask
    implements Runnable {
        @NotNull
        private final Set<Cluster<T>> clusters;
        @Nullable
        private Runnable mCallback;
        @Nullable
        private SphericalMercatorProjection mSphericalMercatorProjection;
        private double mMapZoom;

        public RenderTask(Set<? extends Cluster<T>> clusters) {
            Intrinsics.checkNotNullParameter((Object)ClusterRenderer.this, (String)"this$0");
            Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
            this.clusters = clusters;
        }

        @NotNull
        public final Set<Cluster<T>> getClusters$tedclustering_release() {
            return this.clusters;
        }

        public final void setCallback(@NotNull Runnable callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.mCallback = callback;
        }

        public final void setMapZoom(double zoom) {
            this.mMapZoom = zoom;
            this.mSphericalMercatorProjection = new SphericalMercatorProjection((double)256 * Math.pow(2.0, Math.min(zoom, ClusterRenderer.this.mZoom)));
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public void run() {
            TedLatLngBounds tedLatLngBounds;
            if (Intrinsics.areEqual(this.clusters, (Object)ClusterRenderer.this.mClusters)) {
                Runnable runnable = this.mCallback;
                Intrinsics.checkNotNull((Object)runnable);
                runnable.run();
                return;
            }
            MarkerModifier markerModifier = new MarkerModifier();
            double zoom = this.mMapZoom;
            boolean zoomingIn = zoom > ClusterRenderer.this.mZoom;
            double zoomDelta = zoom - ClusterRenderer.this.mZoom;
            Set markersToRemove = ClusterRenderer.this.mMarkers;
            try {
                tedLatLngBounds = ClusterRenderer.this.tedMap.getVisibleLatLngBounds();
            }
            catch (Exception e) {
                e.printStackTrace();
                tedLatLngBounds = new TedLatLngBounds(null, null, 3, null);
            }
            TedLatLngBounds visibleBounds = tedLatLngBounds;
            List existingClustersOnScreen = null;
            if (ClusterRenderer.this.mClusters != null && SHOULD_ANIMATE && ClusterRenderer.this.clusterAnimation) {
                existingClustersOnScreen = new ArrayList();
                Set set = ClusterRenderer.this.mClusters;
                Intrinsics.checkNotNull((Object)set);
                for (Object c : set) {
                    if (!ClusterRenderer.this.shouldRenderAsCluster((Cluster)c) || !visibleBounds.contains(c.getPosition())) continue;
                    SphericalMercatorProjection sphericalMercatorProjection = this.mSphericalMercatorProjection;
                    Intrinsics.checkNotNull((Object)sphericalMercatorProjection);
                    Point point = sphericalMercatorProjection.toPoint(c.getPosition());
                    ((ArrayList)existingClustersOnScreen).add(point);
                }
            }
            Set newMarkers = Collections.newSetFromMap(new ConcurrentHashMap());
            for (Cluster c : this.clusters) {
                boolean bl = visibleBounds.contains(c.getPosition());
                if (zoomingIn && bl && SHOULD_ANIMATE && ClusterRenderer.this.clusterAnimation) {
                    SphericalMercatorProjection sphericalMercatorProjection = this.mSphericalMercatorProjection;
                    Intrinsics.checkNotNull((Object)sphericalMercatorProjection);
                    Point point = sphericalMercatorProjection.toPoint(c.getPosition());
                    Point closest = ClusterRenderer.this.findClosestCluster(existingClustersOnScreen, point);
                    if (closest != null) {
                        SphericalMercatorProjection sphericalMercatorProjection2 = this.mSphericalMercatorProjection;
                        Intrinsics.checkNotNull((Object)sphericalMercatorProjection2);
                        TedLatLng animateTo = sphericalMercatorProjection2.toLatLng(closest);
                        Intrinsics.checkNotNullExpressionValue(newMarkers, (String)"newMarkers");
                        markerModifier.add(true, new CreateMarkerTask(c, newMarkers, animateTo));
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue(newMarkers, (String)"newMarkers");
                    markerModifier.add(true, new CreateMarkerTask(c, newMarkers, null));
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(newMarkers, (String)"newMarkers");
                markerModifier.add(bl, new CreateMarkerTask(c, newMarkers, null));
            }
            markerModifier.waitUntilFree();
            Intrinsics.checkNotNullExpressionValue(newMarkers, (String)"newMarkers");
            markersToRemove.removeAll(newMarkers);
            List newClustersOnScreen = null;
            if (SHOULD_ANIMATE && ClusterRenderer.this.clusterAnimation) {
                newClustersOnScreen = new ArrayList();
                for (Cluster cluster2 : this.clusters) {
                    if (!ClusterRenderer.this.shouldRenderAsCluster(cluster2) || !visibleBounds.contains(cluster2.getPosition())) continue;
                    SphericalMercatorProjection sphericalMercatorProjection = this.mSphericalMercatorProjection;
                    Intrinsics.checkNotNull((Object)sphericalMercatorProjection);
                    Point p = sphericalMercatorProjection.toPoint(cluster2.getPosition());
                    ((ArrayList)newClustersOnScreen).add(p);
                }
            }
            for (MarkerWithPosition markerWithPosition : markersToRemove) {
                boolean onScreen = visibleBounds.contains(markerWithPosition.getPosition());
                if (!zoomingIn && zoomDelta > -3.0 && onScreen && SHOULD_ANIMATE && ClusterRenderer.this.clusterAnimation) {
                    SphericalMercatorProjection sphericalMercatorProjection = this.mSphericalMercatorProjection;
                    Intrinsics.checkNotNull((Object)sphericalMercatorProjection);
                    Point point = sphericalMercatorProjection.toPoint(markerWithPosition.getPosition());
                    Point closest = ClusterRenderer.this.findClosestCluster(newClustersOnScreen, point);
                    if (closest != null) {
                        SphericalMercatorProjection sphericalMercatorProjection3 = this.mSphericalMercatorProjection;
                        Intrinsics.checkNotNull((Object)sphericalMercatorProjection3);
                        TedLatLng animateTo = sphericalMercatorProjection3.toLatLng(closest);
                        markerModifier.animateThenRemove(markerWithPosition, markerWithPosition.getPosition(), animateTo);
                        continue;
                    }
                    markerModifier.remove(true, markerWithPosition.getTedMarker());
                    continue;
                }
                markerModifier.remove(onScreen, markerWithPosition.getTedMarker());
            }
            markerModifier.waitUntilFree();
            ClusterRenderer.this.mMarkers = newMarkers;
            ClusterRenderer.this.mClusters = this.clusters;
            ClusterRenderer.this.mZoom = zoom;
            Runnable runnable = this.mCallback;
            Intrinsics.checkNotNull((Object)runnable);
            runnable.run();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0083\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J>\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2.\u0010\u001b\u001a*0\u0013R&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u0011J*\u0010\u001c\u001a\u00020\u00192\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 J,\u0010\"\u001a\u00020\u00192\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0007J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0019H\u0003J\b\u0010'\u001a\u00020\nH\u0016J\u001b\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010)\u001a\u00028\u0003\u00a2\u0006\u0002\u0010*J\u0015\u0010+\u001a\u00020\u00192\u0006\u0010)\u001a\u00028\u0003H\u0002\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u000e\u001a0\u0012,\u0012*0\u0010R&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0012\u001a0\u0012,\u0012*0\u0013R&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R<\u0010\u0015\u001a0\u0012,\u0012*0\u0013R&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lted/gun0912/clustering/clustering/view/ClusterRenderer$MarkerModifier;", "Landroid/os/Handler;", "Landroid/os/MessageQueue$IdleHandler;", "(Lted/gun0912/clustering/clustering/view/ClusterRenderer;)V", "BLANK", "", "busyCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "isBusy", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "mAnimationTasks", "Ljava/util/LinkedList;", "Lted/gun0912/clustering/clustering/view/ClusterRenderer$AnimationTask;", "Lted/gun0912/clustering/clustering/view/ClusterRenderer;", "mCreateMarkerTasks", "Lted/gun0912/clustering/clustering/view/ClusterRenderer$CreateMarkerTask;", "mListenerAdded", "mOnScreenCreateMarkerTasks", "mOnScreenRemoveMarkerTasks", "mRemoveMarkerTasks", "add", "", "priority", "c", "animate", "marker", "Lted/gun0912/clustering/clustering/view/ClusterRenderer$MarkerWithPosition;", "from", "Lted/gun0912/clustering/geometry/TedLatLng;", "to", "animateThenRemove", "handleMessage", "msg", "Landroid/os/Message;", "performNextTask", "queueIdle", "remove", "m", "(ZLted/gun0912/clustering/TedMarker;)V", "removeMarker", "(Lted/gun0912/clustering/TedMarker;)V", "waitUntilFree", "tedclustering_release"})
    @SuppressLint(value={"HandlerLeak"})
    private final class MarkerModifier
    extends Handler
    implements MessageQueue.IdleHandler {
        @NotNull
        private final ReentrantLock lock;
        private final Condition busyCondition;
        @NotNull
        private final LinkedList<CreateMarkerTask> mCreateMarkerTasks;
        @NotNull
        private final LinkedList<CreateMarkerTask> mOnScreenCreateMarkerTasks;
        @NotNull
        private final LinkedList<Marker> mRemoveMarkerTasks;
        @NotNull
        private final LinkedList<Marker> mOnScreenRemoveMarkerTasks;
        @NotNull
        private final LinkedList<AnimationTask> mAnimationTasks;
        private boolean mListenerAdded;
        private final int BLANK;

        public MarkerModifier() {
            Intrinsics.checkNotNullParameter((Object)ClusterRenderer.this, (String)"this$0");
            super(Looper.getMainLooper());
            this.lock = new ReentrantLock();
            this.busyCondition = this.lock.newCondition();
            this.mCreateMarkerTasks = new LinkedList();
            this.mOnScreenCreateMarkerTasks = new LinkedList();
            this.mRemoveMarkerTasks = new LinkedList();
            this.mOnScreenRemoveMarkerTasks = new LinkedList();
            this.mAnimationTasks = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isBusy() {
            try {
                this.lock.lock();
                boolean bl = !this.mCreateMarkerTasks.isEmpty() || !this.mOnScreenCreateMarkerTasks.isEmpty() || !this.mOnScreenRemoveMarkerTasks.isEmpty() || !this.mRemoveMarkerTasks.isEmpty() || !this.mAnimationTasks.isEmpty();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public final void add(boolean priority, @NotNull CreateMarkerTask c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            this.lock.lock();
            this.sendEmptyMessage(this.BLANK);
            if (priority) {
                this.mOnScreenCreateMarkerTasks.add(c);
            } else {
                this.mCreateMarkerTasks.add(c);
            }
            this.lock.unlock();
        }

        public final void remove(boolean priority, @NotNull Marker m) {
            Intrinsics.checkNotNullParameter(m, (String)"m");
            this.lock.lock();
            this.sendEmptyMessage(this.BLANK);
            if (priority) {
                this.mOnScreenRemoveMarkerTasks.add(m);
            } else {
                this.mRemoveMarkerTasks.add(m);
            }
            this.lock.unlock();
        }

        public final void animate(@NotNull MarkerWithPosition<Marker, ImageDescriptor> marker, @NotNull TedLatLng from, @NotNull TedLatLng to) {
            Intrinsics.checkNotNullParameter(marker, (String)"marker");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            this.lock.lock();
            this.mAnimationTasks.add(new AnimationTask(marker, from, to));
            this.lock.unlock();
        }

        @TargetApi(value=11)
        public final void animateThenRemove(@NotNull MarkerWithPosition<Marker, ImageDescriptor> marker, @NotNull TedLatLng from, @NotNull TedLatLng to) {
            Intrinsics.checkNotNullParameter(marker, (String)"marker");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            this.lock.lock();
            AnimationTask animationTask = new AnimationTask(marker, from, to);
            animationTask.removeOnAnimationComplete(ClusterRenderer.this.mClusterManager.getMarkerManager());
            this.mAnimationTasks.add(animationTask);
            this.lock.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            if (!this.mListenerAdded) {
                Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)this);
                this.mListenerAdded = true;
            }
            this.removeMessages(this.BLANK);
            this.lock.lock();
            try {
                int n = 0;
                do {
                    int i = n++;
                    this.performNextTask();
                } while (n <= 9);
                if (!this.isBusy()) {
                    this.mListenerAdded = false;
                    Looper.myQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
                    this.busyCondition.signalAll();
                } else {
                    this.sendEmptyMessageDelayed(this.BLANK, 10L);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @TargetApi(value=11)
        private final void performNextTask() {
            if (!this.mOnScreenRemoveMarkerTasks.isEmpty()) {
                Object Marker = this.mOnScreenRemoveMarkerTasks.poll();
                Intrinsics.checkNotNullExpressionValue(Marker, (String)"mOnScreenRemoveMarkerTasks.poll()");
                this.removeMarker((TedMarker)Marker);
            } else if (!this.mAnimationTasks.isEmpty()) {
                this.mAnimationTasks.poll().perform();
            } else if (!this.mOnScreenCreateMarkerTasks.isEmpty()) {
                this.mOnScreenCreateMarkerTasks.poll().perform(this);
            } else if (!this.mCreateMarkerTasks.isEmpty()) {
                this.mCreateMarkerTasks.poll().perform(this);
            } else if (!this.mRemoveMarkerTasks.isEmpty()) {
                Object Marker = this.mRemoveMarkerTasks.poll();
                Intrinsics.checkNotNullExpressionValue(Marker, (String)"mRemoveMarkerTasks.poll()");
                this.removeMarker((TedMarker)Marker);
            }
        }

        private final void removeMarker(Marker m) {
            Cluster cluster2 = (Cluster)ClusterRenderer.this.mMarkerToCluster.get(m);
            Map map = ClusterRenderer.this.mClusterToMarker;
            boolean bl = false;
            Map map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            TypeIntrinsics.asMutableMap((Object)map2).remove(cluster2);
            ClusterRenderer.this.mMarkerCache.remove(m);
            ClusterRenderer.this.mMarkerToCluster.remove(m);
            ClusterRenderer.this.mClusterManager.getMarkerManager().remove(m);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void waitUntilFree() {
            while (this.isBusy()) {
                this.sendEmptyMessage(this.BLANK);
                this.lock.lock();
                try {
                    if (!this.isBusy()) continue;
                    this.busyCondition.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        public boolean queueIdle() {
            this.sendEmptyMessage(this.BLANK);
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0006\u0010\u0001*\u000e\b\u0007\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00040\u0003*\u0004\b\b\u0010\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00028\u00062\u0006\u0010\f\u001a\u00028\u0007H\u0086\u0002\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000b\u001a\u0004\u0018\u00018\u00072\u0006\u0010\u000e\u001a\u00028\u0006H\u0086\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00028\u00062\u0006\u0010\f\u001a\u00028\u0007\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00112\u0006\u0010\f\u001a\u00028\u0007\u00a2\u0006\u0002\u0010\u0014R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u00070\bj\u000e\u0012\u0004\u0012\u00028\u0006\u0012\u0004\u0012\u00028\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00028\u0007\u0012\u0004\u0012\u00028\u00060\bj\u000e\u0012\u0004\u0012\u00028\u0007\u0012\u0004\u0012\u00028\u0006`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lted/gun0912/clustering/clustering/view/ClusterRenderer$MarkerCache;", "T", "Marker", "Lted/gun0912/clustering/TedMarker;", "ImageDescriptor", "", "()V", "mCache", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "mCacheReverse", "get", "m", "(Lted/gun0912/clustering/TedMarker;)Ljava/lang/Object;", "item", "(Ljava/lang/Object;)Lted/gun0912/clustering/TedMarker;", "put", "", "(Ljava/lang/Object;Lted/gun0912/clustering/TedMarker;)V", "remove", "(Lted/gun0912/clustering/TedMarker;)V", "tedclustering_release"})
    private static final class MarkerCache<T, Marker extends TedMarker<ImageDescriptor>, ImageDescriptor> {
        @NotNull
        private final HashMap<T, Marker> mCache = new HashMap();
        @NotNull
        private final HashMap<Marker, T> mCacheReverse = new HashMap();

        @Nullable
        public final Marker get(T item) {
            return (Marker)((TedMarker)this.mCache.get(item));
        }

        public final T get(@NotNull Marker m) {
            Intrinsics.checkNotNullParameter(m, (String)"m");
            T t = this.mCacheReverse.get(m);
            Intrinsics.checkNotNull(t);
            return t;
        }

        public final void put(T item, @NotNull Marker m) {
            Intrinsics.checkNotNullParameter(m, (String)"m");
            Map map = this.mCache;
            boolean bl = false;
            map.put(item, m);
            map = this.mCacheReverse;
            bl = false;
            map.put(m, item);
        }

        public final void remove(@NotNull Marker m) {
            Intrinsics.checkNotNullParameter(m, (String)"m");
            T item = this.mCacheReverse.get(m);
            this.mCacheReverse.remove(m);
            Map map = this.mCache;
            boolean bl = false;
            Map map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            TypeIntrinsics.asMutableMap((Object)map2).remove(item);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ6\u0010\n\u001a\u00020\u000b2.\u0010\f\u001a*0\rR&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000eR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lted/gun0912/clustering/clustering/view/ClusterRenderer$CreateMarkerTask;", "", "cluster", "Lted/gun0912/clustering/clustering/Cluster;", "newMarkers", "", "Lted/gun0912/clustering/clustering/view/ClusterRenderer$MarkerWithPosition;", "animateFrom", "Lted/gun0912/clustering/geometry/TedLatLng;", "(Lted/gun0912/clustering/clustering/view/ClusterRenderer;Lted/gun0912/clustering/clustering/Cluster;Ljava/util/Set;Lted/gun0912/clustering/geometry/TedLatLng;)V", "perform", "", "markerModifier", "Lted/gun0912/clustering/clustering/view/ClusterRenderer$MarkerModifier;", "Lted/gun0912/clustering/clustering/view/ClusterRenderer;", "tedclustering_release"})
    private final class CreateMarkerTask {
        @NotNull
        private final Cluster<T> cluster;
        @NotNull
        private final Set<MarkerWithPosition<Marker, ImageDescriptor>> newMarkers;
        @Nullable
        private final TedLatLng animateFrom;

        public CreateMarkerTask(@NotNull Cluster<T> cluster2, @Nullable Set<MarkerWithPosition<Marker, ImageDescriptor>> newMarkers, TedLatLng animateFrom) {
            Intrinsics.checkNotNullParameter((Object)ClusterRenderer.this, (String)"this$0");
            Intrinsics.checkNotNullParameter(cluster2, (String)"cluster");
            Intrinsics.checkNotNullParameter(newMarkers, (String)"newMarkers");
            this.cluster = cluster2;
            this.newMarkers = newMarkers;
            this.animateFrom = animateFrom;
        }

        public final void perform(@NotNull MarkerModifier markerModifier) {
            Function2 function2;
            Intrinsics.checkNotNullParameter((Object)((Object)markerModifier), (String)"markerModifier");
            if (!ClusterRenderer.this.shouldRenderAsCluster(this.cluster)) {
                for (TedClusterItem item : this.cluster.getItems()) {
                    Function2 function22;
                    Object marker = ClusterRenderer.this.mMarkerCache.get(item);
                    MarkerWithPosition markerWithPosition = null;
                    if (marker == null) {
                        Object markerOptions = ClusterRenderer.this.builder.getMarker(item);
                        ClusterRenderer.this.tedMap.addMarkerClickListener(markerOptions, (Function1)new Function1<Marker, Unit>(ClusterRenderer.this){
                            final /* synthetic */ ClusterRenderer<Clustering, T, RealMarker, Marker, Map, ImageDescriptor> this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Marker marker) {
                                Intrinsics.checkNotNullParameter(marker, (String)"marker");
                                ClusterRenderer.access$getMClusterManager$p(this.this$0).onMarkerClick$tedclustering_release(marker);
                            }
                        });
                        marker = ClusterRenderer.this.mClusterManager.getMarkerMarkerCollection().addMarker(markerOptions);
                        markerWithPosition = new MarkerWithPosition(marker);
                        ClusterRenderer.this.mMarkerCache.put(item, marker);
                        if (this.animateFrom != null) {
                            markerModifier.animate(markerWithPosition, this.animateFrom, item.getTedLatLng());
                        }
                    } else {
                        markerWithPosition = new MarkerWithPosition(marker);
                    }
                    if ((function22 = ClusterRenderer.this.builder.getMarkerAddedListener$tedclustering_release()) != null) {
                        function22.invoke((Object)item, marker);
                    }
                    this.newMarkers.add(markerWithPosition);
                }
                return;
            }
            TedMarker<Object> marker = (TedMarker)ClusterRenderer.this.mClusterToMarker.get(this.cluster);
            MarkerWithPosition markerWithPosition = null;
            if (marker == null) {
                Object defaultMarker = ClusterRenderer.this.tedMap.getMarker();
                Object object = this.animateFrom;
                defaultMarker.setPosition((TedLatLng)(object == null ? this.cluster.getPosition() : object));
                ClusterRenderer.this.onBeforeClusterRendered(this.cluster, defaultMarker);
                marker = ClusterRenderer.this.mClusterManager.getClusterMarkerMarkerCollection().addMarker(defaultMarker);
                object = ClusterRenderer.this.mMarkerToCluster;
                Cluster cluster2 = this.cluster;
                boolean bl = false;
                object.put(marker, cluster2);
                object = ClusterRenderer.this.mClusterToMarker;
                cluster2 = this.cluster;
                bl = false;
                object.put(cluster2, marker);
                markerWithPosition = new MarkerWithPosition(marker);
                if (this.animateFrom != null) {
                    markerModifier.animate(markerWithPosition, this.animateFrom, this.cluster.getPosition());
                }
            } else {
                markerWithPosition = new MarkerWithPosition(marker);
            }
            if ((function2 = ClusterRenderer.this.builder.getClusterAddedListener$tedclustering_release()) != null) {
                function2.invoke(this.cluster, (Object)marker);
            }
            this.newMarkers.add(markerWithPosition);
            ClusterRenderer.this.tedMap.addMarkerClickListener(marker, (Function1)new Function1<Marker, Unit>(ClusterRenderer.this){
                final /* synthetic */ ClusterRenderer<Clustering, T, RealMarker, Marker, Map, ImageDescriptor> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Marker marker) {
                    Intrinsics.checkNotNullParameter(marker, (String)"marker");
                    ClusterRenderer.access$getMClusterManager$p(this.this$0).onMarkerClick$tedclustering_release(marker);
                }
            });
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u0000*\u000e\b\u0006\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\u0004\b\u0007\u0010\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0006\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u00028\u0006\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lted/gun0912/clustering/clustering/view/ClusterRenderer$MarkerWithPosition;", "Marker", "Lted/gun0912/clustering/TedMarker;", "ImageDescriptor", "", "tedMarker", "(Lted/gun0912/clustering/TedMarker;)V", "position", "Lted/gun0912/clustering/geometry/TedLatLng;", "getPosition", "()Lted/gun0912/clustering/geometry/TedLatLng;", "setPosition", "(Lted/gun0912/clustering/geometry/TedLatLng;)V", "getTedMarker", "()Lted/gun0912/clustering/TedMarker;", "Lted/gun0912/clustering/TedMarker;", "equals", "", "other", "hashCode", "", "tedclustering_release"})
    private static final class MarkerWithPosition<Marker extends TedMarker<ImageDescriptor>, ImageDescriptor> {
        @NotNull
        private final Marker tedMarker;
        @NotNull
        private TedLatLng position;

        public MarkerWithPosition(@NotNull Marker tedMarker) {
            Intrinsics.checkNotNullParameter(tedMarker, (String)"tedMarker");
            this.tedMarker = tedMarker;
            this.position = this.tedMarker.getPosition();
        }

        @NotNull
        public final Marker getTedMarker() {
            return this.tedMarker;
        }

        @NotNull
        public final TedLatLng getPosition() {
            return this.position;
        }

        public final void setPosition(@NotNull TedLatLng tedLatLng) {
            Intrinsics.checkNotNullParameter((Object)tedLatLng, (String)"<set-?>");
            this.position = tedLatLng;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof MarkerWithPosition ? Intrinsics.areEqual(this.tedMarker, ((MarkerWithPosition)other).tedMarker) : false;
        }

        public int hashCode() {
            return this.tedMarker.hashCode();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\u0004\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0010J \u0010\u0017\u001a\u00020\u00102\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00028\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lted/gun0912/clustering/clustering/view/ClusterRenderer$AnimationTask;", "Landroid/animation/AnimatorListenerAdapter;", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "markerWithPosition", "Lted/gun0912/clustering/clustering/view/ClusterRenderer$MarkerWithPosition;", "from", "Lted/gun0912/clustering/geometry/TedLatLng;", "to", "(Lted/gun0912/clustering/clustering/view/ClusterRenderer;Lted/gun0912/clustering/clustering/view/ClusterRenderer$MarkerWithPosition;Lted/gun0912/clustering/geometry/TedLatLng;Lted/gun0912/clustering/geometry/TedLatLng;)V", "mMarkerManager", "Lted/gun0912/clustering/MarkerManager;", "mRemoveOnComplete", "", "tedMarker", "Lted/gun0912/clustering/TedMarker;", "onAnimationEnd", "", "animation", "Landroid/animation/Animator;", "onAnimationUpdate", "valueAnimator", "Landroid/animation/ValueAnimator;", "perform", "removeOnAnimationComplete", "markerManager", "tedclustering_release"})
    @TargetApi(value=12)
    private final class AnimationTask
    extends AnimatorListenerAdapter
    implements ValueAnimator.AnimatorUpdateListener {
        @NotNull
        private final MarkerWithPosition<Marker, ImageDescriptor> markerWithPosition;
        @NotNull
        private final TedLatLng from;
        @NotNull
        private final TedLatLng to;
        @NotNull
        private final Marker tedMarker;
        private boolean mRemoveOnComplete;
        private MarkerManager<RealMarker, Marker, ImageDescriptor> mMarkerManager;

        public AnimationTask(@NotNull MarkerWithPosition<Marker, ImageDescriptor> markerWithPosition, @NotNull TedLatLng from, TedLatLng to) {
            Intrinsics.checkNotNullParameter((Object)ClusterRenderer.this, (String)"this$0");
            Intrinsics.checkNotNullParameter(markerWithPosition, (String)"markerWithPosition");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            this.markerWithPosition = markerWithPosition;
            this.from = from;
            this.to = to;
            this.tedMarker = this.markerWithPosition.getTedMarker();
        }

        public final void perform() {
            float[] fArray = new float[]{0.0f, 1.0f};
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])fArray);
            valueAnimator.setInterpolator((TimeInterpolator)ANIMATION_INTERPOLATOR);
            valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            valueAnimator.addListener((Animator.AnimatorListener)this);
            valueAnimator.start();
        }

        public void onAnimationEnd(@NotNull Animator animation) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            if (this.mRemoveOnComplete) {
                Cluster cluster2 = (Cluster)ClusterRenderer.this.mMarkerToCluster.get(this.tedMarker);
                Object object = ClusterRenderer.this.mClusterToMarker;
                boolean bl = false;
                Map map = object;
                if (map == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
                }
                TypeIntrinsics.asMutableMap((Object)map).remove(cluster2);
                ClusterRenderer.this.mMarkerCache.remove(this.tedMarker);
                ClusterRenderer.this.mMarkerToCluster.remove(this.tedMarker);
                object = this.mMarkerManager;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mMarkerManager");
                    throw null;
                }
                ((MarkerManager)object).remove(this.tedMarker);
            }
            this.markerWithPosition.setPosition(this.to);
        }

        public final void removeOnAnimationComplete(@NotNull MarkerManager<RealMarker, Marker, ImageDescriptor> markerManager) {
            Intrinsics.checkNotNullParameter(markerManager, (String)"markerManager");
            this.mMarkerManager = markerManager;
            this.mRemoveOnComplete = true;
        }

        public void onAnimationUpdate(@NotNull ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)valueAnimator, (String)"valueAnimator");
            float fraction = valueAnimator.getAnimatedFraction();
            double lat = (this.to.getLatitude() - this.from.getLatitude()) * (double)fraction + this.from.getLatitude();
            double lngDelta = this.to.getLongitude() - this.from.getLongitude();
            if (Math.abs(lngDelta) > 180.0) {
                lngDelta -= Math.signum(lngDelta) * (double)360;
            }
            double lng = lngDelta * (double)fraction + this.from.getLongitude();
            this.tedMarker.setPosition(new TedLatLng(lat, lng));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lted/gun0912/clustering/clustering/view/ClusterRenderer$Companion;", "", "()V", "ANIMATION_INTERPOLATOR", "Landroid/view/animation/DecelerateInterpolator;", "SHOULD_ANIMATE", "", "distanceSquared", "", "a", "Lted/gun0912/clustering/geometry/Point;", "b", "tedclustering_release"})
    public static final class Companion {
        private Companion() {
        }

        private final double distanceSquared(Point a, Point b) {
            return (a.getX() - b.getX()) * (a.getX() - b.getX()) + (a.getY() - b.getY()) * (a.getY() - b.getY());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

