/*
 * Decompiled with CFR 0.152.
 */
package ted.gun0912.clustering.geometry;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ted.gun0912.clustering.geometry.Point;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002J&\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0019"}, d2={"Lted/gun0912/clustering/geometry/Bounds;", "", "minX", "", "maxX", "minY", "maxY", "(DDDD)V", "getMaxX", "()D", "getMaxY", "midX", "getMidX", "midY", "getMidY", "getMinX", "getMinY", "contains", "", "x", "y", "bounds", "point", "Lted/gun0912/clustering/geometry/Point;", "intersects", "tedclustering_release"})
public final class Bounds {
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private final double midX;
    private final double midY;

    public Bounds(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.midX = (this.minX + this.maxX) / (double)2;
        this.midY = (this.minY + this.maxY) / (double)2;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public final double getMidX() {
        return this.midX;
    }

    public final double getMidY() {
        return this.midY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(double x, double y) {
        double d = this.minX;
        if (!(x <= this.maxX)) return false;
        if (!(d <= x)) return false;
        boolean bl = true;
        if (!bl) return false;
        d = this.minY;
        if (!(y <= this.maxY)) return false;
        if (!(d <= y)) return false;
        return true;
    }

    public final boolean contains(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.contains(point.getX(), point.getY());
    }

    public final boolean intersects(double minX, double maxX, double minY, double maxY) {
        return minX < this.maxX && this.minX < maxX && minY < this.maxY && this.minY < maxY;
    }

    public final boolean intersects(@NotNull Bounds bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return this.intersects(bounds.minX, bounds.maxX, bounds.minY, bounds.maxY);
    }

    public final boolean contains(@NotNull Bounds bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return bounds.minX >= this.minX && bounds.maxX <= this.maxX && bounds.minY >= this.minY && bounds.maxY <= this.maxY;
    }
}

