/*
 * Decompiled with CFR 0.152.
 */
package ted.gun0912.clustering.projection;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ted.gun0912.clustering.geometry.Point;
import ted.gun0912.clustering.geometry.TedLatLng;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lted/gun0912/clustering/projection/SphericalMercatorProjection;", "", "mWorldWidth", "", "(D)V", "toLatLng", "Lted/gun0912/clustering/geometry/TedLatLng;", "point", "Lted/gun0912/clustering/geometry/Point;", "toPoint", "latLng", "tedclustering_release"})
public final class SphericalMercatorProjection {
    private final double mWorldWidth;

    public SphericalMercatorProjection(double mWorldWidth) {
        this.mWorldWidth = mWorldWidth;
    }

    @NotNull
    public final Point toPoint(@NotNull TedLatLng latLng) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        double x = latLng.getLongitude() / (double)360 + 0.5;
        double siny = Math.sin(Math.toRadians(latLng.getLatitude()));
        double y = 0.5 * Math.log((1.0 + siny) / (1.0 - siny)) / (Math.PI * -2) + 0.5;
        return new Point(x * this.mWorldWidth, y * this.mWorldWidth);
    }

    @NotNull
    public final TedLatLng toLatLng(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double x = point.getX() / this.mWorldWidth - 0.5;
        double lng = x * (double)360;
        double y = 0.5 - point.getY() / this.mWorldWidth;
        double lat = (double)90 - Math.toDegrees(Math.atan(Math.exp(-y * 2.0 * Math.PI)) * (double)2);
        return new TedLatLng(lat, lng);
    }
}

