/*
 * Decompiled with CFR 0.152.
 */
package ted.gun0912.clustering.quadtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ted.gun0912.clustering.geometry.Bounds;
import ted.gun0912.clustering.geometry.Point;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0004\b\u0000\u0018\u0000 (*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002()B'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB/\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u0017\b\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u0016J%\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010$\u001a\u00020\u000bJ\u001e\u0010\"\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0002J\b\u0010'\u001a\u00020\u0016H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lted/gun0912/clustering/quadtree/PointQuadTree;", "T", "Lted/gun0912/clustering/quadtree/PointQuadTree$Item;", "", "minX", "", "maxX", "minY", "maxY", "(DDDD)V", "bounds", "Lted/gun0912/clustering/geometry/Bounds;", "(Lted/gun0912/clustering/geometry/Bounds;)V", "depth", "", "(DDDDI)V", "(Lted/gun0912/clustering/geometry/Bounds;I)V", "childrenQuads", "", "items", "", "add", "", "item", "(Lted/gun0912/clustering/quadtree/PointQuadTree$Item;)V", "clear", "insert", "x", "y", "(DDLted/gun0912/clustering/quadtree/PointQuadTree$Item;)V", "remove", "", "(Lted/gun0912/clustering/quadtree/PointQuadTree$Item;)Z", "(DDLted/gun0912/clustering/quadtree/PointQuadTree$Item;)Z", "search", "", "searchBounds", "results", "", "split", "Companion", "Item", "tedclustering_release"})
public final class PointQuadTree<T extends Item> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Bounds bounds;
    private final int depth;
    @Nullable
    private Set<T> items;
    @Nullable
    private List<PointQuadTree<T>> childrenQuads;
    private static final int MAX_ELEMENTS = 50;
    private static final int MAX_DEPTH = 40;

    private PointQuadTree(Bounds bounds, int depth) {
        this.bounds = bounds;
        this.depth = depth;
    }

    public PointQuadTree(double minX, double maxX, double minY, double maxY) {
        this(new Bounds(minX, maxX, minY, maxY));
    }

    public PointQuadTree(@NotNull Bounds bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this(bounds, 0);
    }

    private PointQuadTree(double minX, double maxX, double minY, double maxY, int depth) {
        this(new Bounds(minX, maxX, minY, maxY), depth);
    }

    public final void add(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Point point = item.getPoint();
        boolean bl = false;
        boolean bl2 = false;
        Point $this$add_u24lambda_u2d0 = point;
        boolean bl3 = false;
        if (this.bounds.contains($this$add_u24lambda_u2d0.getX(), $this$add_u24lambda_u2d0.getY())) {
            this.insert($this$add_u24lambda_u2d0.getX(), $this$add_u24lambda_u2d0.getY(), item);
        }
    }

    private final void insert(double x, double y, T item) {
        if (this.childrenQuads != null) {
            if (y < this.bounds.getMidY()) {
                if (x < this.bounds.getMidX()) {
                    List<PointQuadTree<T>> list = this.childrenQuads;
                    Intrinsics.checkNotNull(list);
                    super.insert(x, y, item);
                } else {
                    List<PointQuadTree<T>> list = this.childrenQuads;
                    Intrinsics.checkNotNull(list);
                    super.insert(x, y, item);
                }
            } else if (x < this.bounds.getMidX()) {
                List<PointQuadTree<T>> list = this.childrenQuads;
                Intrinsics.checkNotNull(list);
                super.insert(x, y, item);
            } else {
                List<PointQuadTree<T>> list = this.childrenQuads;
                Intrinsics.checkNotNull(list);
                super.insert(x, y, item);
            }
            return;
        }
        Set<T> set = this.items;
        this.items = set == null ? (Set<T>)new HashSet() : set;
        set = this.items;
        if (set != null) {
            Set<T> set2 = set;
            boolean bl = false;
            boolean bl2 = false;
            Set<T> it = set2;
            boolean bl3 = false;
            it.add(item);
            if (it.size() > MAX_ELEMENTS && this.depth < MAX_DEPTH) {
                this.split();
            }
        }
    }

    private final void split() {
        this.childrenQuads = new ArrayList(4);
        List<PointQuadTree<T>> list = this.childrenQuads;
        Intrinsics.checkNotNull(list);
        list.add(new PointQuadTree<T>(this.bounds.getMinX(), this.bounds.getMidX(), this.bounds.getMinY(), this.bounds.getMidY(), this.depth + 1));
        List<PointQuadTree<T>> list2 = this.childrenQuads;
        Intrinsics.checkNotNull(list2);
        list2.add(new PointQuadTree<T>(this.bounds.getMidX(), this.bounds.getMaxX(), this.bounds.getMinY(), this.bounds.getMidY(), this.depth + 1));
        List<PointQuadTree<T>> list3 = this.childrenQuads;
        Intrinsics.checkNotNull(list3);
        list3.add(new PointQuadTree<T>(this.bounds.getMinX(), this.bounds.getMidX(), this.bounds.getMidY(), this.bounds.getMaxY(), this.depth + 1));
        List<PointQuadTree<T>> list4 = this.childrenQuads;
        Intrinsics.checkNotNull(list4);
        list4.add(new PointQuadTree<T>(this.bounds.getMidX(), this.bounds.getMaxX(), this.bounds.getMidY(), this.bounds.getMaxY(), this.depth + 1));
        Set<T> set = this.items;
        if (set != null) {
            Set<T> set2 = set;
            boolean bl = false;
            boolean bl2 = false;
            Set<T> it = set2;
            boolean bl3 = false;
            for (Item item : it) {
                this.insert(item.getPoint().getX(), item.getPoint().getY(), item);
            }
        }
        this.items = null;
    }

    public final boolean remove(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        Point point = item.getPoint();
        return this.bounds.contains(point.getX(), point.getY()) ? this.remove(point.getX(), point.getY(), item) : false;
    }

    private final boolean remove(double x, double y, T item) {
        boolean bl;
        if (this.childrenQuads != null) {
            if (y < this.bounds.getMidY()) {
                if (x < this.bounds.getMidX()) {
                    List<PointQuadTree<T>> list = this.childrenQuads;
                    Intrinsics.checkNotNull(list);
                    bl = super.remove(x, y, item);
                } else {
                    List<PointQuadTree<T>> list = this.childrenQuads;
                    Intrinsics.checkNotNull(list);
                    bl = super.remove(x, y, item);
                }
            } else if (x < this.bounds.getMidX()) {
                List<PointQuadTree<T>> list = this.childrenQuads;
                Intrinsics.checkNotNull(list);
                bl = super.remove(x, y, item);
            } else {
                List<PointQuadTree<T>> list = this.childrenQuads;
                Intrinsics.checkNotNull(list);
                bl = super.remove(x, y, item);
            }
        } else if (this.items == null) {
            bl = false;
        } else {
            Set<T> set = this.items;
            Intrinsics.checkNotNull(set);
            bl = set.remove(item);
        }
        return bl;
    }

    public final void clear() {
        this.childrenQuads = null;
        Set<T> set = this.items;
        if (set != null) {
            set.clear();
        }
    }

    @NotNull
    public final Collection<T> search(@NotNull Bounds searchBounds) {
        Intrinsics.checkNotNullParameter((Object)searchBounds, (String)"searchBounds");
        ArrayList results = new ArrayList();
        this.search(searchBounds, results);
        return results;
    }

    private final void search(Bounds searchBounds, Collection<T> results) {
        block6: {
            block5: {
                if (!this.bounds.intersects(searchBounds)) {
                    return;
                }
                if (this.childrenQuads == null) break block5;
                List<PointQuadTree<T>> list = this.childrenQuads;
                Intrinsics.checkNotNull(list);
                for (PointQuadTree<T> quad : list) {
                    super.search(searchBounds, results);
                }
                break block6;
            }
            if (this.items == null) break block6;
            if (searchBounds.contains(this.bounds)) {
                Set<T> set = this.items;
                Intrinsics.checkNotNull(set);
                results.addAll((Collection)set);
            } else {
                Set<T> set = this.items;
                Intrinsics.checkNotNull(set);
                for (Item item : set) {
                    if (!searchBounds.contains(item.getPoint())) continue;
                    results.add(item);
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lted/gun0912/clustering/quadtree/PointQuadTree$Item;", "", "point", "Lted/gun0912/clustering/geometry/Point;", "getPoint", "()Lted/gun0912/clustering/geometry/Point;", "tedclustering_release"})
    public static interface Item {
        @NotNull
        public Point getPoint();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lted/gun0912/clustering/quadtree/PointQuadTree$Companion;", "", "()V", "MAX_DEPTH", "", "MAX_ELEMENTS", "tedclustering_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

