/*
 * Decompiled with CFR 0.152.
 */
package ted.gun0912.clustering.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ted.gun0912.clustering.R;
import ted.gun0912.clustering.ui.BubbleDrawable;
import ted.gun0912.clustering.ui.RotationLayout;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ&\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\rJ\u000e\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u001cJ\u0016\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u001cJ\u000e\u0010&\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lted/gun0912/clustering/ui/IconGenerator;", "", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mAnchorU", "", "mAnchorV", "mBackground", "Lted/gun0912/clustering/ui/BubbleDrawable;", "mContainer", "Landroid/view/ViewGroup;", "mContentView", "Landroid/view/View;", "mRotationLayout", "Lted/gun0912/clustering/ui/RotationLayout;", "mTextView", "Landroid/widget/TextView;", "makeIcon", "Landroid/graphics/Bitmap;", "text", "", "setBackground", "", "background", "Landroid/graphics/drawable/Drawable;", "setColor", "color", "", "setContentPadding", "left", "top", "right", "bottom", "setContentView", "contentView", "setStyle", "style", "setTextAppearance", "context", "resId", "resid", "Companion", "tedclustering_release"})
public final class IconGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context mContext;
    @NotNull
    private final ViewGroup mContainer;
    @NotNull
    private final RotationLayout mRotationLayout;
    @Nullable
    private TextView mTextView;
    @Nullable
    private View mContentView;
    private final float mAnchorU;
    private final float mAnchorV;
    @NotNull
    private final BubbleDrawable mBackground;
    private static final int STYLE_DEFAULT = 1;
    private static final int STYLE_WHITE = 2;
    private static final int STYLE_RED = 3;
    private static final int STYLE_BLUE = 4;
    private static final int STYLE_GREEN = 5;
    private static final int STYLE_PURPLE = 6;
    private static final int STYLE_ORANGE = 7;

    public IconGenerator(@NotNull Context mContext) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.amu_text_bubble, null);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        this.mContainer = (ViewGroup)view;
        this.mAnchorU = 0.5f;
        this.mAnchorV = 1.0f;
        view = this.mContext.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"mContext.resources");
        this.mBackground = new BubbleDrawable((Resources)view);
        view = this.mContainer.getChildAt(0);
        if (view == null) {
            throw new NullPointerException("null cannot be cast to non-null type ted.gun0912.clustering.ui.RotationLayout");
        }
        this.mRotationLayout = (RotationLayout)view;
        this.mTextView = (TextView)this.mRotationLayout.findViewById(R.id.amu_text);
        this.mContentView = (View)this.mTextView;
        this.setStyle(STYLE_DEFAULT);
    }

    @NotNull
    public final Bitmap makeIcon(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.mTextView != null) {
            TextView textView = this.mTextView;
            Intrinsics.checkNotNull((Object)textView);
            textView.setText(text);
        }
        return Companion.makeIcon((View)this.mContainer);
    }

    public final void setContentView(@NotNull View contentView) {
        Intrinsics.checkNotNullParameter((Object)contentView, (String)"contentView");
        this.mRotationLayout.removeAllViews();
        this.mRotationLayout.addView(contentView);
        this.mContentView = contentView;
        View view = this.mRotationLayout.findViewById(R.id.amu_text);
        this.mTextView = view instanceof TextView ? (TextView)view : null;
    }

    public final void setTextAppearance(@NotNull Context context, int resId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.mTextView != null) {
            TextView textView = this.mTextView;
            Intrinsics.checkNotNull((Object)textView);
            textView.setTextAppearance(context, resId);
        }
    }

    public final void setTextAppearance(int resid) {
        this.setTextAppearance(this.mContext, resid);
    }

    public final void setStyle(int style2) {
        this.setColor(IconGenerator.Companion.getStyleColor(style2));
        this.setTextAppearance(this.mContext, IconGenerator.Companion.getTextStyle(style2));
    }

    public final void setColor(int color) {
        this.mBackground.setColor(color);
        this.setBackground(this.mBackground);
    }

    public final void setBackground(@Nullable Drawable background) {
        this.mContainer.setBackgroundDrawable(background);
        if (background != null) {
            Rect rect = new Rect();
            background.getPadding(rect);
            this.mContainer.setPadding(rect.left, rect.top, rect.right, rect.bottom);
        } else {
            this.mContainer.setPadding(0, 0, 0, 0);
        }
    }

    public final void setContentPadding(int left, int top, int right, int bottom) {
        View view = this.mContentView;
        Intrinsics.checkNotNull((Object)view);
        view.setPadding(left, top, right, bottom);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lted/gun0912/clustering/ui/IconGenerator$Companion;", "", "()V", "STYLE_BLUE", "", "getSTYLE_BLUE", "()I", "STYLE_DEFAULT", "getSTYLE_DEFAULT", "STYLE_GREEN", "getSTYLE_GREEN", "STYLE_ORANGE", "getSTYLE_ORANGE", "STYLE_PURPLE", "getSTYLE_PURPLE", "STYLE_RED", "getSTYLE_RED", "STYLE_WHITE", "getSTYLE_WHITE", "getStyleColor", "style", "getTextStyle", "makeIcon", "Landroid/graphics/Bitmap;", "view", "Landroid/view/View;", "tedclustering_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getSTYLE_DEFAULT() {
            return STYLE_DEFAULT;
        }

        public final int getSTYLE_WHITE() {
            return STYLE_WHITE;
        }

        public final int getSTYLE_RED() {
            return STYLE_RED;
        }

        public final int getSTYLE_BLUE() {
            return STYLE_BLUE;
        }

        public final int getSTYLE_GREEN() {
            return STYLE_GREEN;
        }

        public final int getSTYLE_PURPLE() {
            return STYLE_PURPLE;
        }

        public final int getSTYLE_ORANGE() {
            return STYLE_ORANGE;
        }

        private final int getStyleColor(int style) {
            int n = style;
            if (n == this.getSTYLE_DEFAULT() ? true : n == this.getSTYLE_WHITE()) {
                return -1;
            }
            if (n == this.getSTYLE_RED()) {
                return -3407872;
            }
            if (n == this.getSTYLE_BLUE()) {
                return -16737844;
            }
            if (n == this.getSTYLE_GREEN()) {
                return -10053376;
            }
            if (n == this.getSTYLE_PURPLE()) {
                return -6736948;
            }
            if (n == this.getSTYLE_ORANGE()) {
                return -30720;
            }
            return -1;
        }

        private final int getTextStyle(int style2) {
            int n = style2;
            if (n == this.getSTYLE_DEFAULT() ? true : n == this.getSTYLE_WHITE()) {
                return R.style.amu_Bubble_TextAppearance_Dark;
            }
            if ((((n == this.getSTYLE_RED() ? true : n == this.getSTYLE_BLUE()) ? true : n == this.getSTYLE_GREEN()) ? true : n == this.getSTYLE_PURPLE()) ? true : n == this.getSTYLE_ORANGE()) {
                return R.style.amu_Bubble_TextAppearance_Light;
            }
            return R.style.amu_Bubble_TextAppearance_Dark;
        }

        @NotNull
        public final Bitmap makeIcon(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            int measureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            view.measure(measureSpec, measureSpec);
            int measuredWidth = view.getMeasuredWidth();
            int measuredHeight = view.getMeasuredHeight();
            view.layout(0, 0, measuredWidth, measuredHeight);
            Bitmap r = Bitmap.createBitmap((int)measuredWidth, (int)measuredHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            r.eraseColor(0);
            Canvas canvas = new Canvas(r);
            view.draw(canvas);
            Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
            return r;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

