/*
 * Decompiled with CFR 0.152.
 */
package com.tedpark.tedonactivityresult.rx2;

import android.content.Context;
import android.content.Intent;
import com.gun0912.tedonactivityresult.ProxyActivity;
import com.gun0912.tedonactivityresult.listener.OnActivityResultListener;
import com.gun0912.tedonactivityresult.model.ActivityResult;
import io.reactivex.Single;
import io.reactivex.subjects.PublishSubject;

public final class TedRxOnActivityResult {
    public static Builder with(Context context) {
        return new Builder(context);
    }

    public static final class Builder {
        private final Context context;
        private final OnActivityResultListener listener;
        private final PublishSubject<ActivityResult> subject = PublishSubject.create();

        private Builder(Context context) {
            this.context = context;
            this.listener = new OnActivityResultListener(){

                public void onActivityResult(int resultCode, Intent data) {
                    Builder.this.subject.onNext((Object)new ActivityResult(resultCode, data));
                    Builder.this.subject.onComplete();
                }
            };
        }

        public Single<ActivityResult> startActivityForResult(Intent intent) {
            ProxyActivity.startActivityForResult((Context)this.context, (Intent)intent, (OnActivityResultListener)this.listener);
            return this.subject.singleOrError();
        }
    }
}

