/*
 * Decompiled with CFR 0.152.
 */
package com.gun0912.tedpermission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import java.util.ArrayList;
import java.util.List;

public abstract class TedPermissionBase {
    public static final int REQ_CODE_REQUEST_SETTING = 2000;
    private static final String PREFS_NAME_PERMISSION = "PREFS_NAME_PERMISSION";
    private static final String PREFS_IS_FIRST_REQUEST = "IS_FIRST_REQUEST";

    public static boolean isGranted(Context context, String ... permissions) {
        for (String permission2 : permissions) {
            if (!TedPermissionBase.isDenied(context, permission2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDenied(Context context, @NonNull String permission2) {
        return !TedPermissionBase.isGranted(context, permission2);
    }

    private static boolean isGranted(Context context, @NonNull String permission2) {
        if (permission2.equals("android.permission.SYSTEM_ALERT_WINDOW")) {
            if (Build.VERSION.SDK_INT >= 23) {
                return Settings.canDrawOverlays((Context)context);
            }
            return true;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public static List<String> getDeniedPermissions(Context context, String ... permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String permission2 : permissions) {
            if (!TedPermissionBase.isDenied(context, permission2)) continue;
            deniedPermissions.add(permission2);
        }
        return deniedPermissions;
    }

    public static boolean canRequestPermission(Activity activity, String ... permissions) {
        if (TedPermissionBase.isFirstRequest((Context)activity, permissions)) {
            return true;
        }
        for (String permission2 : permissions) {
            boolean showRationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2);
            if (!TedPermissionBase.isDenied((Context)activity, permission2) || showRationale) continue;
            return false;
        }
        return true;
    }

    private static boolean isFirstRequest(Context context, @NonNull String[] permissions) {
        for (String permission2 : permissions) {
            if (TedPermissionBase.isFirstRequest(context, permission2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFirstRequest(Context context, String permission2) {
        return TedPermissionBase.getSharedPreferences(context).getBoolean(TedPermissionBase.getPrefsNamePermission(permission2), true);
    }

    private static String getPrefsNamePermission(String permission2) {
        return "IS_FIRST_REQUEST_" + permission2;
    }

    private static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(PREFS_NAME_PERMISSION, 0);
    }

    public static void startSettingActivityForResult(Activity activity) {
        TedPermissionBase.startSettingActivityForResult(activity, 2000);
    }

    public static void startSettingActivityForResult(Activity activity, int requestCode) {
        activity.startActivityForResult(TedPermissionBase.getSettingIntent((Context)activity), requestCode);
    }

    public static Intent getSettingIntent(Context context) {
        return new Intent("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.parse((String)("package:" + context.getPackageName())));
    }

    public static void startSettingActivityForResult(Fragment fragment) {
        TedPermissionBase.startSettingActivityForResult(fragment, 2000);
    }

    public static void startSettingActivityForResult(Fragment fragment, int requestCode) {
        fragment.startActivityForResult(TedPermissionBase.getSettingIntent((Context)fragment.getActivity()), requestCode);
    }

    static void setFirstRequest(Context context, @NonNull String[] permissions) {
        for (String permission2 : permissions) {
            TedPermissionBase.setFirstRequest(context, permission2);
        }
    }

    private static void setFirstRequest(Context context, String permission2) {
        TedPermissionBase.getSharedPreferences(context).edit().putBoolean(TedPermissionBase.getPrefsNamePermission(permission2), false).apply();
    }
}

