/*
 * Decompiled with CFR 0.152.
 */
package com.gun0912.tedpermission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import com.gun0912.tedpermission.PermissionListener;
import com.gun0912.tedpermission.R;
import com.gun0912.tedpermission.TedPermission;
import com.gun0912.tedpermission.TedPermissionBase;
import com.gun0912.tedpermission.util.ObjectUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class TedPermissionActivity
extends AppCompatActivity {
    public static final int REQ_CODE_PERMISSION_REQUEST = 10;
    public static final int REQ_CODE_SYSTEM_ALERT_WINDOW_PERMISSION_REQUEST = 30;
    public static final int REQ_CODE_SYSTEM_ALERT_WINDOW_PERMISSION_REQUEST_SETTING = 31;
    public static final String EXTRA_PERMISSIONS = "permissions";
    public static final String EXTRA_RATIONALE_TITLE = "rationale_title";
    public static final String EXTRA_RATIONALE_MESSAGE = "rationale_message";
    public static final String EXTRA_DENY_TITLE = "deny_title";
    public static final String EXTRA_DENY_MESSAGE = "deny_message";
    public static final String EXTRA_PACKAGE_NAME = "package_name";
    public static final String EXTRA_SETTING_BUTTON = "setting_button";
    public static final String EXTRA_SETTING_BUTTON_TEXT = "setting_button_text";
    public static final String EXTRA_RATIONALE_CONFIRM_TEXT = "rationale_confirm_text";
    public static final String EXTRA_DENIED_DIALOG_CLOSE_TEXT = "denied_dialog_close_text";
    public static final String EXTRA_SCREEN_ORIENTATION = "screen_orientation";
    private static Deque<PermissionListener> permissionListenerStack;
    CharSequence rationaleTitle;
    CharSequence rationale_message;
    CharSequence denyTitle;
    CharSequence denyMessage;
    String[] permissions;
    String packageName;
    boolean hasSettingButton;
    String settingButtonText;
    String deniedCloseButtonText;
    String rationaleConfirmText;
    boolean isShownRationaleDialog;
    int requestedOrientation;

    public static void startActivity(Context context, Intent intent, PermissionListener listener) {
        if (permissionListenerStack == null) {
            permissionListenerStack = new ArrayDeque<PermissionListener>();
        }
        permissionListenerStack.push(listener);
        context.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.overridePendingTransition(0, 0);
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(16);
        this.setupFromSavedInstanceState(savedInstanceState);
        if (this.needWindowPermission()) {
            this.requestWindowPermission();
        } else {
            this.checkPermissions(false);
        }
        this.setRequestedOrientation(this.requestedOrientation);
    }

    private void setupFromSavedInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.permissions = savedInstanceState.getStringArray(EXTRA_PERMISSIONS);
            this.rationaleTitle = savedInstanceState.getCharSequence(EXTRA_RATIONALE_TITLE);
            this.rationale_message = savedInstanceState.getCharSequence(EXTRA_RATIONALE_MESSAGE);
            this.denyTitle = savedInstanceState.getCharSequence(EXTRA_DENY_TITLE);
            this.denyMessage = savedInstanceState.getCharSequence(EXTRA_DENY_MESSAGE);
            this.packageName = savedInstanceState.getString(EXTRA_PACKAGE_NAME);
            this.hasSettingButton = savedInstanceState.getBoolean(EXTRA_SETTING_BUTTON, true);
            this.rationaleConfirmText = savedInstanceState.getString(EXTRA_RATIONALE_CONFIRM_TEXT);
            this.deniedCloseButtonText = savedInstanceState.getString(EXTRA_DENIED_DIALOG_CLOSE_TEXT);
            this.settingButtonText = savedInstanceState.getString(EXTRA_SETTING_BUTTON_TEXT);
            this.requestedOrientation = savedInstanceState.getInt(EXTRA_SCREEN_ORIENTATION, -1);
        } else {
            Intent intent = this.getIntent();
            this.permissions = intent.getStringArrayExtra(EXTRA_PERMISSIONS);
            this.rationaleTitle = intent.getCharSequenceExtra(EXTRA_RATIONALE_TITLE);
            this.rationale_message = intent.getCharSequenceExtra(EXTRA_RATIONALE_MESSAGE);
            this.denyTitle = intent.getCharSequenceExtra(EXTRA_DENY_TITLE);
            this.denyMessage = intent.getCharSequenceExtra(EXTRA_DENY_MESSAGE);
            this.packageName = intent.getStringExtra(EXTRA_PACKAGE_NAME);
            this.hasSettingButton = intent.getBooleanExtra(EXTRA_SETTING_BUTTON, true);
            this.rationaleConfirmText = intent.getStringExtra(EXTRA_RATIONALE_CONFIRM_TEXT);
            this.deniedCloseButtonText = intent.getStringExtra(EXTRA_DENIED_DIALOG_CLOSE_TEXT);
            this.settingButtonText = intent.getStringExtra(EXTRA_SETTING_BUTTON_TEXT);
            this.requestedOrientation = intent.getIntExtra(EXTRA_SCREEN_ORIENTATION, -1);
        }
    }

    private boolean needWindowPermission() {
        for (String permission2 : this.permissions) {
            if (!permission2.equals("android.permission.SYSTEM_ALERT_WINDOW")) continue;
            return !this.hasWindowPermission();
        }
        return false;
    }

    @TargetApi(value=23)
    private boolean hasWindowPermission() {
        return Settings.canDrawOverlays((Context)this.getApplicationContext());
    }

    @TargetApi(value=23)
    private void requestWindowPermission() {
        Uri uri = Uri.fromParts((String)"package", (String)this.packageName, null);
        final Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", uri);
        if (!TextUtils.isEmpty((CharSequence)this.rationale_message)) {
            new AlertDialog.Builder((Context)this, R.style.Theme_AppCompat_Light_Dialog_Alert).setMessage(this.rationale_message).setCancelable(false).setNegativeButton((CharSequence)this.rationaleConfirmText, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    TedPermissionActivity.this.startActivityForResult(intent, 30);
                }
            }).show();
            this.isShownRationaleDialog = true;
        } else {
            this.startActivityForResult(intent, 30);
        }
    }

    private void checkPermissions(boolean fromOnActivityResult) {
        ArrayList<String> needPermissions = new ArrayList<String>();
        for (String permission2 : this.permissions) {
            if (permission2.equals("android.permission.SYSTEM_ALERT_WINDOW")) {
                if (this.hasWindowPermission()) continue;
                needPermissions.add(permission2);
                continue;
            }
            if (!TedPermissionBase.isDenied(permission2)) continue;
            needPermissions.add(permission2);
        }
        if (needPermissions.isEmpty()) {
            this.permissionResult(null);
        } else if (fromOnActivityResult) {
            this.permissionResult(needPermissions);
        } else if (needPermissions.size() == 1 && needPermissions.contains("android.permission.SYSTEM_ALERT_WINDOW")) {
            this.permissionResult(needPermissions);
        } else if (!this.isShownRationaleDialog && !TextUtils.isEmpty((CharSequence)this.rationale_message)) {
            this.showRationaleDialog(needPermissions);
        } else {
            this.requestPermissions(needPermissions);
        }
    }

    private void permissionResult(List<String> deniedPermissions) {
        Log.v((String)TedPermission.TAG, (String)("permissionResult(): " + deniedPermissions));
        this.finish();
        this.overridePendingTransition(0, 0);
        if (permissionListenerStack != null) {
            PermissionListener listener = permissionListenerStack.pop();
            if (ObjectUtils.isEmpty(deniedPermissions)) {
                listener.onPermissionGranted();
            } else {
                listener.onPermissionDenied(deniedPermissions);
            }
            if (permissionListenerStack.size() == 0) {
                permissionListenerStack = null;
            }
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    private void showRationaleDialog(final List<String> needPermissions) {
        new AlertDialog.Builder((Context)this, R.style.Theme_AppCompat_Light_Dialog_Alert).setTitle(this.rationaleTitle).setMessage(this.rationale_message).setCancelable(false).setNegativeButton((CharSequence)this.rationaleConfirmText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                TedPermissionActivity.this.requestPermissions(needPermissions);
            }
        }).show();
        this.isShownRationaleDialog = true;
    }

    public void requestPermissions(List<String> needPermissions) {
        ActivityCompat.requestPermissions((Activity)this, (String[])needPermissions.toArray(new String[needPermissions.size()]), (int)10);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putStringArray(EXTRA_PERMISSIONS, this.permissions);
        outState.putCharSequence(EXTRA_RATIONALE_TITLE, this.rationaleTitle);
        outState.putCharSequence(EXTRA_RATIONALE_MESSAGE, this.rationale_message);
        outState.putCharSequence(EXTRA_DENY_TITLE, this.denyTitle);
        outState.putCharSequence(EXTRA_DENY_MESSAGE, this.denyMessage);
        outState.putString(EXTRA_PACKAGE_NAME, this.packageName);
        outState.putBoolean(EXTRA_SETTING_BUTTON, this.hasSettingButton);
        outState.putString(EXTRA_DENIED_DIALOG_CLOSE_TEXT, this.deniedCloseButtonText);
        outState.putString(EXTRA_RATIONALE_CONFIRM_TEXT, this.rationaleConfirmText);
        outState.putString(EXTRA_SETTING_BUTTON_TEXT, this.settingButtonText);
        super.onSaveInstanceState(outState);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        List<String> deniedPermissions = TedPermissionBase.getDeniedPermissions(permissions);
        if (deniedPermissions.isEmpty()) {
            this.permissionResult(null);
        } else {
            this.showPermissionDenyDialog(deniedPermissions);
        }
    }

    public void showPermissionDenyDialog(final List<String> deniedPermissions) {
        if (TextUtils.isEmpty((CharSequence)this.denyMessage)) {
            this.permissionResult(deniedPermissions);
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, R.style.Theme_AppCompat_Light_Dialog_Alert);
        builder.setTitle(this.denyTitle).setMessage(this.denyMessage).setCancelable(false).setNegativeButton((CharSequence)this.deniedCloseButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                TedPermissionActivity.this.permissionResult(deniedPermissions);
            }
        });
        if (this.hasSettingButton) {
            if (TextUtils.isEmpty((CharSequence)this.settingButtonText)) {
                this.settingButtonText = this.getString(R.string.tedpermission_setting);
            }
            builder.setPositiveButton((CharSequence)this.settingButtonText, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    TedPermissionBase.startSettingActivityForResult((Activity)TedPermissionActivity.this);
                }
            });
        }
        builder.show();
    }

    public boolean shouldShowRequestPermissionRationale(List<String> needPermissions) {
        if (needPermissions == null) {
            return false;
        }
        for (String permission2 : needPermissions) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permission2)) continue;
            return false;
        }
        return true;
    }

    public void showWindowPermissionDenyDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this, R.style.Theme_AppCompat_Light_Dialog_Alert);
        builder.setMessage(this.denyMessage).setCancelable(false).setNegativeButton((CharSequence)this.deniedCloseButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                TedPermissionActivity.this.checkPermissions(false);
            }
        });
        if (this.hasSettingButton) {
            if (TextUtils.isEmpty((CharSequence)this.settingButtonText)) {
                this.settingButtonText = this.getString(R.string.tedpermission_setting);
            }
            builder.setPositiveButton((CharSequence)this.settingButtonText, new DialogInterface.OnClickListener(){

                @TargetApi(value=23)
                public void onClick(DialogInterface dialog, int which) {
                    Uri uri = Uri.fromParts((String)"package", (String)TedPermissionActivity.this.packageName, null);
                    Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", uri);
                    TedPermissionActivity.this.startActivityForResult(intent, 31);
                }
            });
        }
        builder.show();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 2000: {
                this.checkPermissions(true);
                break;
            }
            case 30: {
                if (!this.hasWindowPermission() && !TextUtils.isEmpty((CharSequence)this.denyMessage)) {
                    this.showWindowPermissionDenyDialog();
                    break;
                }
                this.checkPermissions(false);
                break;
            }
            case 31: {
                this.checkPermissions(false);
                break;
            }
            default: {
                super.onActivityResult(requestCode, resultCode, data);
            }
        }
    }
}

