/*
 * Decompiled with CFR 0.152.
 */
package com.gun0912.tedpermission;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.gun0912.tedpermission.provider.TedPermissionProvider;
import java.util.ArrayList;
import java.util.List;

public class TedPermissionUtil {
    public static final int REQ_CODE_REQUEST_SETTING = 2000;
    private static final String PREFS_NAME_PERMISSION = "PREFS_NAME_PERMISSION";
    private static final String PREFS_IS_FIRST_REQUEST = "IS_FIRST_REQUEST";
    @SuppressLint(value={"StaticFieldLeak"})
    private static final Context context = TedPermissionProvider.context;

    public static boolean isGranted(String ... permissions) {
        for (String permission2 : permissions) {
            if (!TedPermissionUtil.isDenied(permission2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDenied(@NonNull String permission2) {
        return !TedPermissionUtil.isGranted(permission2);
    }

    private static boolean isGranted(@NonNull String permission2) {
        if (permission2.equals("android.permission.SYSTEM_ALERT_WINDOW")) {
            if (Build.VERSION.SDK_INT >= 23) {
                return Settings.canDrawOverlays((Context)context);
            }
            return true;
        }
        if (permission2.equals("android.permission.READ_MEDIA_VIDEO") || permission2.equals("android.permission.READ_MEDIA_IMAGES")) {
            return TedPermissionUtil.isFullOrPartialAccessGranted(permission2);
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    private static boolean isFullOrPartialAccessGranted(@NonNull String permission2) {
        boolean isPartialAccessGranted = Build.VERSION.SDK_INT >= 34 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_MEDIA_VISUAL_USER_SELECTED") == 0;
        return isPartialAccessGranted || ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public static List<String> getDeniedPermissions(String ... permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String permission2 : permissions) {
            if (!TedPermissionUtil.isDenied(permission2)) continue;
            deniedPermissions.add(permission2);
        }
        return deniedPermissions;
    }

    public static boolean canRequestPermission(Activity activity, String ... permissions) {
        if (TedPermissionUtil.isFirstRequest(permissions)) {
            return true;
        }
        for (String permission2 : permissions) {
            boolean showRationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2);
            if (!TedPermissionUtil.isDenied(permission2) || showRationale) continue;
            return false;
        }
        return true;
    }

    private static boolean isFirstRequest(@NonNull String[] permissions) {
        for (String permission2 : permissions) {
            if (TedPermissionUtil.isFirstRequest(permission2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFirstRequest(String permission2) {
        return TedPermissionUtil.getSharedPreferences().getBoolean(TedPermissionUtil.getPrefsNamePermission(permission2), true);
    }

    private static String getPrefsNamePermission(String permission2) {
        return "IS_FIRST_REQUEST_" + permission2;
    }

    private static SharedPreferences getSharedPreferences() {
        return context.getSharedPreferences(PREFS_NAME_PERMISSION, 0);
    }

    public static void startSettingActivityForResult(Activity activity) {
        TedPermissionUtil.startSettingActivityForResult(activity, 2000);
    }

    public static void startSettingActivityForResult(Activity activity, int requestCode) {
        activity.startActivityForResult(TedPermissionUtil.getSettingIntent(), requestCode);
    }

    public static Intent getSettingIntent() {
        return new Intent("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.parse((String)("package:" + context.getPackageName())));
    }

    public static void startSettingActivityForResult(Fragment fragment) {
        TedPermissionUtil.startSettingActivityForResult(fragment, 2000);
    }

    public static void startSettingActivityForResult(Fragment fragment, int requestCode) {
        fragment.startActivityForResult(TedPermissionUtil.getSettingIntent(), requestCode);
    }

    static void setFirstRequest(@NonNull String[] permissions) {
        for (String permission2 : permissions) {
            TedPermissionUtil.setFirstRequest(permission2);
        }
    }

    private static void setFirstRequest(String permission2) {
        TedPermissionUtil.getSharedPreferences().edit().putBoolean(TedPermissionUtil.getPrefsNamePermission(permission2), false).apply();
    }
}

