/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.util;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0012\u001a\u0004\u0018\u00018\u00012\b\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u0004\u0018\u00018\u00012\b\u0010\u0013\u001a\u0004\u0018\u00018\u00002\b\u0010\u0016\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0017\u0010\u001a\u001a\u0004\u0018\u00018\u00012\b\u0010\u0013\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u001cJ\u0017\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010!\u001a\u00020\u0019J\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0005J\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010#J\b\u0010$\u001a\u00020%H\u0016R,\u0010\b\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Landroid/support/v4/util/LruCache;", "K", "V", "", "maxSize", "", "<init>", "(I)V", "map", "Lkotlin/collections/LinkedHashMap;", "Ljava/util/LinkedHashMap;", "Ljava/util/LinkedHashMap;", "size", "putCount", "createCount", "evictionCount", "hitCount", "missCount", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "trimToSize", "", "remove", "entryEvicted", "(Ljava/lang/Object;Ljava/lang/Object;)V", "create", "safeSizeOf", "(Ljava/lang/Object;Ljava/lang/Object;)I", "sizeOf", "evictAll", "snapshot", "", "toString", "", "tencent-map-compose_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\nandroid/support/v4/util/LruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
public final class LruCache<K, V> {
    @NotNull
    private final LinkedHashMap<K, V> map;
    private int size;
    private final int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;
    public static final int $stable = 8;

    public LruCache(int maxSize) {
        if (!(maxSize > 0)) {
            boolean bl = false;
            String string = "maxSize <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    @Nullable
    public final synchronized V get(@Nullable K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        V result2 = this.map.get(key);
        if (result2 != null) {
            int n = this.hitCount;
            this.hitCount = n + 1;
            return result2;
        }
        int n = this.missCount;
        this.missCount = n + 1;
        result2 = this.create(key);
        if (result2 != null) {
            n = this.createCount;
            this.createCount = n + 1;
            this.size += this.safeSizeOf(key, result2);
            ((Map)this.map).put(key, result2);
            this.trimToSize(this.maxSize);
        }
        return result2;
    }

    @Nullable
    public final synchronized V put(@Nullable K key, @Nullable V value) {
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        int n = this.putCount;
        this.putCount = n + 1;
        this.size += this.safeSizeOf(key, value);
        V previous = this.map.put(key, value);
        if (previous != null) {
            this.size -= this.safeSizeOf(key, previous);
        }
        this.trimToSize(this.maxSize);
        return previous;
    }

    private final void trimToSize(int maxSize) {
        while (this.size > maxSize && !this.map.isEmpty() && this.map.entrySet().iterator().next() != null) {
            Map.Entry<K, V> entry;
            K key = entry.getKey();
            V value = entry.getValue();
            this.map.remove(key);
            this.size -= this.safeSizeOf(key, value);
            int n = this.evictionCount;
            this.evictionCount = n + 1;
            this.entryEvicted(key, value);
        }
        if (!(this.size >= 0 && (!this.map.isEmpty() || this.size == 0))) {
            boolean bl = false;
            String string = this.getClass().getName() + ".sizeOf() is reporting inconsistent results!";
            throw new IllegalStateException(string.toString());
        }
    }

    @Nullable
    public final synchronized V remove(@Nullable K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        Object previous = this.map.remove(key);
        if (previous != null) {
            this.size -= this.safeSizeOf(key, previous);
        }
        return previous;
    }

    protected final void entryEvicted(K key, V value) {
    }

    @Nullable
    protected final V create(K key) {
        return null;
    }

    private final int safeSizeOf(K key, V value) {
        int result2 = this.sizeOf(key, value);
        if (!(result2 >= 0)) {
            boolean bl = false;
            String string = "Negative size: " + key + "=" + value;
            throw new IllegalStateException(string.toString());
        }
        return result2;
    }

    protected final int sizeOf(K key, V value) {
        return 1;
    }

    public final synchronized void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized int maxSize() {
        return this.maxSize;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int missCount() {
        return this.missCount;
    }

    public final synchronized int createCount() {
        return this.createCount;
    }

    public final synchronized int putCount() {
        return this.putCount;
    }

    public final synchronized int evictionCount() {
        return this.evictionCount;
    }

    @NotNull
    public final synchronized Map<K, V> snapshot() {
        return new LinkedHashMap(this.map);
    }

    @NotNull
    public synchronized String toString() {
        int accesses = this.hitCount + this.missCount;
        int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
        String string = "LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]";
        Object[] objectArray = new Object[]{this.maxSize, this.hitCount, this.missCount, hitPercent};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

