/*
 * Decompiled with CFR 0.152.
 */
package com.java3y.hades.starter.config;

import com.alibaba.nacos.api.annotation.NacosInjected;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.google.common.base.Throwables;
import com.java3y.hades.core.service.bootstrap.BaseHadesConfig;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NacosStarter
extends BaseHadesConfig
implements Listener {
    private static final Logger log = LoggerFactory.getLogger(NacosStarter.class);
    @NacosInjected
    private ConfigService configService;

    public void addListener() {
        try {
            this.configService.addListener(this.configProperties.getFileName(), this.configProperties.getGroupName(), (Listener)this);
            log.info("\u5206\u5e03\u5f0f\u914d\u7f6e\u4e2d\u5fc3\u914d\u7f6e[{}]\u76d1\u542c\u5668\u5df2\u542f\u52a8", (Object)this.configProperties.getFileName());
        }
        catch (Exception e) {
            log.error("HadesConfigService#refresh key:[{}] fail:{}", (Object)this.configProperties.getFileName(), (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public String getConfigValueByName(String fileName) {
        try {
            return this.configService.getConfig(fileName, this.configProperties.getGroupName(), 3000L);
        }
        catch (NacosException e) {
            log.error("HadesConfigService#getConfigValueByName key:[{}],fail:{}", (Object)fileName, (Object)Throwables.getStackTraceAsString((Throwable)e));
            return null;
        }
    }

    public void receiveConfigInfo(String mainConfig) {
        log.info("\u5206\u5e03\u5f0f\u914d\u7f6e\u4e2d\u5fc3\u76d1\u542c\u5230[{}]\u6570\u636e\u66f4\u65b0:{}", (Object)this.configProperties.getFileName(), (Object)mainConfig);
        this.bootstrap(mainConfig);
    }

    public Executor getExecutor() {
        return null;
    }
}

