/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.sse;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.util.Utils;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class SSEEventListener {
    private static final Logger log = Logger.getLogger(SSEEventListener.class.getName());
    private final Consumer<StreamingEventKind> eventHandler;
    private final Consumer<JSONRPCError> errorHandler;
    private final Runnable failureHandler;

    public SSEEventListener(Consumer<StreamingEventKind> eventHandler, Consumer<JSONRPCError> errorHandler, Runnable failureHandler) {
        this.eventHandler = eventHandler;
        this.errorHandler = errorHandler;
        this.failureHandler = failureHandler;
    }

    public void onMessage(String message, Future<Void> completableFuture) {
        try {
            this.handleMessage(Utils.OBJECT_MAPPER.readTree(message), completableFuture);
        }
        catch (JsonProcessingException e) {
            log.warning("Failed to parse JSON message: " + message);
        }
    }

    public void onError(Throwable throwable, Future<Void> future) {
        this.failureHandler.run();
        future.cancel(true);
    }

    private void handleMessage(JsonNode jsonNode, Future<Void> future) {
        block5: {
            try {
                if (jsonNode.has("error")) {
                    JSONRPCError error = (JSONRPCError)Utils.OBJECT_MAPPER.treeToValue((TreeNode)jsonNode.get("error"), JSONRPCError.class);
                    this.errorHandler.accept(error);
                    break block5;
                }
                if (jsonNode.has("result")) {
                    JsonNode result = jsonNode.path("result");
                    StreamingEventKind event = (StreamingEventKind)Utils.OBJECT_MAPPER.treeToValue((TreeNode)result, StreamingEventKind.class);
                    this.eventHandler.accept(event);
                    if (event instanceof TaskStatusUpdateEvent && ((TaskStatusUpdateEvent)event).isFinal()) {
                        future.cancel(true);
                    }
                    break block5;
                }
                throw new IllegalArgumentException("Unknown message type");
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

